/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CacheLockJoinDao;
import com.ustadmobile.lib.db.entities.CacheLockJoin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class CacheLockJoinDao_Impl
extends CacheLockJoinDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CacheLockJoin> __insertionAdapterOfCacheLockJoin;
    private final EntityDeletionOrUpdateAdapter<CacheLockJoin> __deletionAdapterOfCacheLockJoin;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLockIdAndStatus;

    public CacheLockJoinDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCacheLockJoin = new EntityInsertionAdapter<CacheLockJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CacheLockJoin` (`cljId`,`cljTableId`,`cljEntityUid`,`cljUrl`,`cljLockId`,`cljStatus`,`cljType`,`cljOiUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CacheLockJoin entity) {
                statement.bindLong(1, (long)entity.getCljId());
                statement.bindLong(2, (long)entity.getCljTableId());
                statement.bindLong(3, entity.getCljEntityUid());
                if (entity.getCljUrl() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getCljUrl());
                }
                statement.bindLong(5, entity.getCljLockId());
                statement.bindLong(6, (long)entity.getCljStatus());
                statement.bindLong(7, (long)entity.getCljType());
                statement.bindLong(8, entity.getCljOiUid());
            }
        };
        this.__deletionAdapterOfCacheLockJoin = new EntityDeletionOrUpdateAdapter<CacheLockJoin>(__db){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `CacheLockJoin` WHERE `cljId` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CacheLockJoin entity) {
                statement.bindLong(1, (long)entity.getCljId());
            }
        };
        this.__preparedStmtOfUpdateLockIdAndStatus = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CacheLockJoin\n           SET cljLockId = ?,\n               cljStatus = ?\n         WHERE cljId = ?   \n    ";
                return "\n        UPDATE CacheLockJoin\n           SET cljLockId = ?,\n               cljStatus = ?\n         WHERE cljId = ?   \n    ";
            }
        };
    }

    @Override
    public Object insertListAsync(final List<CacheLockJoin> list, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CacheLockJoinDao_Impl.this.__db.beginTransaction();
                try {
                    CacheLockJoinDao_Impl.this.__insertionAdapterOfCacheLockJoin.insert((Iterable)list);
                    CacheLockJoinDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CacheLockJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteListAsync(final List<CacheLockJoin> list, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CacheLockJoinDao_Impl.this.__db.beginTransaction();
                try {
                    CacheLockJoinDao_Impl.this.__deletionAdapterOfCacheLockJoin.handleMultiple((Iterable)list);
                    CacheLockJoinDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CacheLockJoinDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateLockIdAndStatus(final int uid, final long lockId, final int status, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = CacheLockJoinDao_Impl.this.__preparedStmtOfUpdateLockIdAndStatus.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, lockId);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)uid);
                try {
                    Unit unit;
                    CacheLockJoinDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        CacheLockJoinDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        CacheLockJoinDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    CacheLockJoinDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    CacheLockJoinDao_Impl.this.__preparedStmtOfUpdateLockIdAndStatus.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findPendingLocks(Continuation<? super List<CacheLockJoin>> $completion) {
        String _sql = "\n        SELECT CacheLockJoin.*\n          FROM CacheLockJoin\n         WHERE CacheLockJoin.cljStatus = 1 \n            OR CacheLockJoin.cljStatus = 3\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CacheLockJoin.*\n          FROM CacheLockJoin\n         WHERE CacheLockJoin.cljStatus = 1 \n            OR CacheLockJoin.cljStatus = 3\n    ", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CacheLockJoin>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CacheLockJoin> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CacheLockJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCljId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljId");
                    int _cursorIndexOfCljTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljTableId");
                    int _cursorIndexOfCljEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljEntityUid");
                    int _cursorIndexOfCljUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljUrl");
                    int _cursorIndexOfCljLockId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljLockId");
                    int _cursorIndexOfCljStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljStatus");
                    int _cursorIndexOfCljType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljType");
                    int _cursorIndexOfCljOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljOiUid");
                    ArrayList<CacheLockJoin> _result2 = new ArrayList<CacheLockJoin>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpCljId = _cursor.getInt(_cursorIndexOfCljId);
                        int _tmpCljTableId = _cursor.getInt(_cursorIndexOfCljTableId);
                        long _tmpCljEntityUid = _cursor.getLong(_cursorIndexOfCljEntityUid);
                        String _tmpCljUrl = _cursor.isNull(_cursorIndexOfCljUrl) ? null : _cursor.getString(_cursorIndexOfCljUrl);
                        long _tmpCljLockId = _cursor.getLong(_cursorIndexOfCljLockId);
                        int _tmpCljStatus = _cursor.getInt(_cursorIndexOfCljStatus);
                        int _tmpCljType = _cursor.getInt(_cursorIndexOfCljType);
                        long _tmpCljOiUid = _cursor.getLong(_cursorIndexOfCljOiUid);
                        CacheLockJoin _item = new CacheLockJoin(_tmpCljId, _tmpCljTableId, _tmpCljEntityUid, _tmpCljUrl, _tmpCljLockId, _tmpCljStatus, _tmpCljType, _tmpCljOiUid);
                        _result2.add(_item);
                    }
                    ArrayList<CacheLockJoin> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByTableIdAndEntityUid(int tableId, long entityUid, Continuation<? super List<CacheLockJoin>> $completion) {
        String _sql = "\n        SELECT CacheLockJoin.*\n          FROM CacheLockJoin\n         WHERE CacheLockJoin.cljTableId = ?\n           AND CacheLockJoin.cljEntityUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CacheLockJoin.*\n          FROM CacheLockJoin\n         WHERE CacheLockJoin.cljTableId = ?\n           AND CacheLockJoin.cljEntityUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)tableId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, entityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CacheLockJoin>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CacheLockJoin> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CacheLockJoinDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCljId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljId");
                    int _cursorIndexOfCljTableId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljTableId");
                    int _cursorIndexOfCljEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljEntityUid");
                    int _cursorIndexOfCljUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljUrl");
                    int _cursorIndexOfCljLockId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljLockId");
                    int _cursorIndexOfCljStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljStatus");
                    int _cursorIndexOfCljType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljType");
                    int _cursorIndexOfCljOiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cljOiUid");
                    ArrayList<CacheLockJoin> _result2 = new ArrayList<CacheLockJoin>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpCljId = _cursor.getInt(_cursorIndexOfCljId);
                        int _tmpCljTableId = _cursor.getInt(_cursorIndexOfCljTableId);
                        long _tmpCljEntityUid = _cursor.getLong(_cursorIndexOfCljEntityUid);
                        String _tmpCljUrl = _cursor.isNull(_cursorIndexOfCljUrl) ? null : _cursor.getString(_cursorIndexOfCljUrl);
                        long _tmpCljLockId = _cursor.getLong(_cursorIndexOfCljLockId);
                        int _tmpCljStatus = _cursor.getInt(_cursorIndexOfCljStatus);
                        int _tmpCljType = _cursor.getInt(_cursorIndexOfCljType);
                        long _tmpCljOiUid = _cursor.getLong(_cursorIndexOfCljOiUid);
                        CacheLockJoin _item = new CacheLockJoin(_tmpCljId, _tmpCljTableId, _tmpCljEntityUid, _tmpCljUrl, _tmpCljLockId, _tmpCljStatus, _tmpCljType, _tmpCljOiUid);
                        _result2.add(_item);
                    }
                    ArrayList<CacheLockJoin> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

