/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ContentEntryImportJobDao;
import com.ustadmobile.lib.db.composites.ContentEntryImportJobProgress;
import com.ustadmobile.lib.db.entities.ContentEntryImportJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class ContentEntryImportJobDao_Impl
extends ContentEntryImportJobDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContentEntryImportJob> __insertionAdapterOfContentEntryImportJob;
    private final SharedSQLiteStatement __preparedStmtOfUpdateItemStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateItemStatusAndError;
    private final SharedSQLiteStatement __preparedStmtOfUpdateErrorDismissed;
    private final SharedSQLiteStatement __preparedStmtOfUpdateItemProgress;

    public ContentEntryImportJobDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContentEntryImportJob = new EntityInsertionAdapter<ContentEntryImportJob>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ContentEntryImportJob` (`cjiUid`,`sourceUri`,`cjiOriginalFilename`,`cjiContentEntryUid`,`cjiParentContentEntryUid`,`cjiContentEntryVersion`,`cjiItemProgress`,`cjiItemTotal`,`cjiStatus`,`cjiRecursiveStatus`,`cjiPluginId`,`cjiParentCjiUid`,`cjiStartTime`,`cjiFinishTime`,`cjiContentDeletedOnCancellation`,`cjiCompressionLevel`,`cjiError`,`cjiErrorDismissed`,`cjiOwnerPersonUid`,`cjiParams`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ContentEntryImportJob entity) {
                statement.bindLong(1, entity.getCjiUid());
                if (entity.getSourceUri() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getSourceUri());
                }
                if (entity.getCjiOriginalFilename() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getCjiOriginalFilename());
                }
                statement.bindLong(4, entity.getCjiContentEntryUid());
                statement.bindLong(5, entity.getCjiParentContentEntryUid());
                statement.bindLong(6, entity.getCjiContentEntryVersion());
                statement.bindLong(7, entity.getCjiItemProgress());
                statement.bindLong(8, entity.getCjiItemTotal());
                statement.bindLong(9, (long)entity.getCjiStatus());
                statement.bindLong(10, (long)entity.getCjiRecursiveStatus());
                statement.bindLong(11, (long)entity.getCjiPluginId());
                statement.bindLong(12, entity.getCjiParentCjiUid());
                statement.bindLong(13, entity.getCjiStartTime());
                statement.bindLong(14, entity.getCjiFinishTime());
                int _tmp = entity.getCjiContentDeletedOnCancellation() ? 1 : 0;
                statement.bindLong(15, (long)_tmp);
                statement.bindLong(16, (long)entity.getCjiCompressionLevel());
                if (entity.getCjiError() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindString(17, entity.getCjiError());
                }
                int _tmp_1 = entity.getCjiErrorDismissed() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_1);
                statement.bindLong(19, entity.getCjiOwnerPersonUid());
                if (entity.getCjiParams() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindString(20, entity.getCjiParams());
                }
            }
        };
        this.__preparedStmtOfUpdateItemStatus = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ContentEntryImportJob \n           SET cjiStatus = ?\n         WHERE cjiUid= ?  \n    ";
                return "\n        UPDATE ContentEntryImportJob \n           SET cjiStatus = ?\n         WHERE cjiUid= ?  \n    ";
            }
        };
        this.__preparedStmtOfUpdateItemStatusAndError = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ContentEntryImportJob \n           SET cjiStatus = ?,\n               cjiError = ?\n         WHERE cjiUid= ?  \n    ";
                return "\n        UPDATE ContentEntryImportJob \n           SET cjiStatus = ?,\n               cjiError = ?\n         WHERE cjiUid= ?  \n    ";
            }
        };
        this.__preparedStmtOfUpdateErrorDismissed = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ContentEntryImportJob\n           SET cjiErrorDismissed = ?\n         WHERE cjiUid = ?  \n    ";
                return "\n        UPDATE ContentEntryImportJob\n           SET cjiErrorDismissed = ?\n         WHERE cjiUid = ?  \n    ";
            }
        };
        this.__preparedStmtOfUpdateItemProgress = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE ContentEntryImportJob\n           SET cjiItemProgress = ?,\n               cjiItemTotal = ?\n         WHERE cjiUid = ?     \n    ";
                return "\n        UPDATE ContentEntryImportJob\n           SET cjiItemProgress = ?,\n               cjiItemTotal = ?\n         WHERE cjiUid = ?     \n    ";
            }
        };
    }

    @Override
    public Object insertJobItem(final ContentEntryImportJob jobItem, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ContentEntryImportJobDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ContentEntryImportJobDao_Impl.this.__insertionAdapterOfContentEntryImportJob.insertAndReturnId((Object)jobItem);
                    ContentEntryImportJobDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateItemStatus(final long cjiUid, final int status, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateItemStatus.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, cjiUid);
                try {
                    Unit unit;
                    ContentEntryImportJobDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ContentEntryImportJobDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateItemStatus.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateItemStatusAndError(final long cjiUid, final int status, final String error, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateItemStatusAndError.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)status);
                _argIndex = 2;
                if (error == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, error);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, cjiUid);
                try {
                    Unit unit;
                    ContentEntryImportJobDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ContentEntryImportJobDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateItemStatusAndError.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateErrorDismissed(final long cjiUid, final boolean dismissed, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateErrorDismissed.acquire();
                int _argIndex = 1;
                int _tmp = dismissed ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, cjiUid);
                try {
                    Unit unit;
                    ContentEntryImportJobDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ContentEntryImportJobDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateErrorDismissed.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateItemProgress(final long cjiUid, final long cjiProgress, final long cjiTotal, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateItemProgress.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, cjiProgress);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, cjiTotal);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, cjiUid);
                try {
                    Unit unit;
                    ContentEntryImportJobDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        ContentEntryImportJobDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    ContentEntryImportJobDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    ContentEntryImportJobDao_Impl.this.__preparedStmtOfUpdateItemProgress.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long cjiUid, Continuation<? super ContentEntryImportJob> $completion) {
        String _sql = "\n        SELECT ContentEntryImportJob.*\n          FROM ContentEntryImportJob\n         WHERE cjiUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryImportJob.*\n          FROM ContentEntryImportJob\n         WHERE cjiUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, cjiUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ContentEntryImportJob>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ContentEntryImportJob call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryImportJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ContentEntryImportJob _result2;
                    int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiUid");
                    int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sourceUri");
                    int _cursorIndexOfCjiOriginalFilename = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiOriginalFilename");
                    int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiContentEntryUid");
                    int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiParentContentEntryUid");
                    int _cursorIndexOfCjiContentEntryVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiContentEntryVersion");
                    int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiItemProgress");
                    int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiItemTotal");
                    int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiStatus");
                    int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiRecursiveStatus");
                    int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiPluginId");
                    int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiParentCjiUid");
                    int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiStartTime");
                    int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiFinishTime");
                    int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiContentDeletedOnCancellation");
                    int _cursorIndexOfCjiCompressionLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiCompressionLevel");
                    int _cursorIndexOfCjiError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiError");
                    int _cursorIndexOfCjiErrorDismissed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiErrorDismissed");
                    int _cursorIndexOfCjiOwnerPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiOwnerPersonUid");
                    int _cursorIndexOfCjiParams = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cjiParams");
                    if (_cursor.moveToFirst()) {
                        long _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
                        String _tmpSourceUri = _cursor.isNull(_cursorIndexOfSourceUri) ? null : _cursor.getString(_cursorIndexOfSourceUri);
                        String _tmpCjiOriginalFilename = _cursor.isNull(_cursorIndexOfCjiOriginalFilename) ? null : _cursor.getString(_cursorIndexOfCjiOriginalFilename);
                        long _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
                        long _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
                        long _tmpCjiContentEntryVersion = _cursor.getLong(_cursorIndexOfCjiContentEntryVersion);
                        long _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
                        long _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
                        int _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
                        int _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
                        int _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
                        long _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
                        long _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
                        long _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
                        int _tmp = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
                        boolean _tmpCjiContentDeletedOnCancellation = _tmp != 0;
                        int _tmpCjiCompressionLevel = _cursor.getInt(_cursorIndexOfCjiCompressionLevel);
                        String _tmpCjiError = _cursor.isNull(_cursorIndexOfCjiError) ? null : _cursor.getString(_cursorIndexOfCjiError);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfCjiErrorDismissed);
                        boolean _tmpCjiErrorDismissed = _tmp_1 != 0;
                        long _tmpCjiOwnerPersonUid = _cursor.getLong(_cursorIndexOfCjiOwnerPersonUid);
                        String _tmpCjiParams = _cursor.isNull(_cursorIndexOfCjiParams) ? null : _cursor.getString(_cursorIndexOfCjiParams);
                        _result2 = new ContentEntryImportJob(_tmpCjiUid, _tmpSourceUri, _tmpCjiOriginalFilename, _tmpCjiContentEntryUid, _tmpCjiParentContentEntryUid, _tmpCjiContentEntryVersion, _tmpCjiItemProgress, _tmpCjiItemTotal, _tmpCjiStatus, _tmpCjiRecursiveStatus, _tmpCjiPluginId, _tmpCjiParentCjiUid, _tmpCjiStartTime, _tmpCjiFinishTime, _tmpCjiContentDeletedOnCancellation, _tmpCjiCompressionLevel, _tmpCjiError, _tmpCjiErrorDismissed, _tmpCjiOwnerPersonUid, _tmpCjiParams);
                    } else {
                        _result2 = null;
                    }
                    ContentEntryImportJob contentEntryImportJob = _result2;
                    return contentEntryImportJob;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findOwnerByUidAsync(long cjiUid, Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT COALESCE(\n               (SELECT ContentEntryImportJob.cjiOwnerPersonUid\n                  FROM ContentEntryImportJob\n                 WHERE ContentEntryImportJob.cjiUid = ?), 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(\n               (SELECT ContentEntryImportJob.cjiOwnerPersonUid\n                  FROM ContentEntryImportJob\n                 WHERE ContentEntryImportJob.cjiUid = ?), 0)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, cjiUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryImportJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<ContentEntryImportJobProgress>> findInProgressJobsByContentEntryUid(long contentEntryUid) {
        String _sql = "\n        SELECT ContentEntryImportJob.cjiUid,\n               ContentEntryImportJob.cjiItemProgress,\n               ContentEntryImportJob.cjiItemTotal,\n               ContentEntryImportJob.cjiStatus,\n               ContentEntryImportJob.cjiError,\n               ContentEntryImportJob.cjiOwnerPersonUid\n          FROM ContentEntryImportJob\n         WHERE ContentEntryImportJob.cjiContentEntryUid = ?\n           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryImportJob.cjiUid,\n               ContentEntryImportJob.cjiItemProgress,\n               ContentEntryImportJob.cjiItemTotal,\n               ContentEntryImportJob.cjiStatus,\n               ContentEntryImportJob.cjiError,\n               ContentEntryImportJob.cjiOwnerPersonUid\n          FROM ContentEntryImportJob\n         WHERE ContentEntryImportJob.cjiContentEntryUid = ?\n           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ContentEntryImportJob"}, (Callable)new Callable<List<ContentEntryImportJobProgress>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ContentEntryImportJobProgress> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryImportJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    boolean _cursorIndexOfCjiUid = false;
                    boolean _cursorIndexOfCjiItemProgress = true;
                    int _cursorIndexOfCjiItemTotal = 2;
                    int _cursorIndexOfCjiStatus = 3;
                    int _cursorIndexOfCjiError = 4;
                    int _cursorIndexOfCjiOwnerPersonUid = 5;
                    ArrayList<ContentEntryImportJobProgress> _result2 = new ArrayList<ContentEntryImportJobProgress>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCjiUid = _cursor.getLong(0);
                        long _tmpCjiItemProgress = _cursor.getLong(1);
                        long _tmpCjiItemTotal = _cursor.getLong(2);
                        int _tmpCjiStatus = _cursor.getInt(3);
                        String _tmpCjiError = _cursor.isNull(4) ? null : _cursor.getString(4);
                        long _tmpCjiOwnerPersonUid = _cursor.getLong(5);
                        ContentEntryImportJobProgress _item = new ContentEntryImportJobProgress(_tmpCjiUid, _tmpCjiItemProgress, _tmpCjiItemTotal, _tmpCjiStatus, _tmpCjiError, _tmpCjiOwnerPersonUid);
                        _result2.add(_item);
                    }
                    ArrayList<ContentEntryImportJobProgress> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findInProgressJobsByContentEntryUidAsync(long contentEntryUid, Continuation<? super List<ContentEntryImportJobProgress>> $completion) {
        String _sql = "\n        SELECT ContentEntryImportJob.cjiUid,\n               ContentEntryImportJob.cjiItemProgress,\n               ContentEntryImportJob.cjiItemTotal,\n               ContentEntryImportJob.cjiStatus,\n               ContentEntryImportJob.cjiError,\n               ContentEntryImportJob.cjiOwnerPersonUid\n          FROM ContentEntryImportJob\n         WHERE ContentEntryImportJob.cjiContentEntryUid = ?\n           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ContentEntryImportJob.cjiUid,\n               ContentEntryImportJob.cjiItemProgress,\n               ContentEntryImportJob.cjiItemTotal,\n               ContentEntryImportJob.cjiStatus,\n               ContentEntryImportJob.cjiError,\n               ContentEntryImportJob.cjiOwnerPersonUid\n          FROM ContentEntryImportJob\n         WHERE ContentEntryImportJob.cjiContentEntryUid = ?\n           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, contentEntryUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ContentEntryImportJobProgress>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ContentEntryImportJobProgress> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ContentEntryImportJobDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfCjiUid = false;
                    boolean _cursorIndexOfCjiItemProgress = true;
                    int _cursorIndexOfCjiItemTotal = 2;
                    int _cursorIndexOfCjiStatus = 3;
                    int _cursorIndexOfCjiError = 4;
                    int _cursorIndexOfCjiOwnerPersonUid = 5;
                    ArrayList<ContentEntryImportJobProgress> _result2 = new ArrayList<ContentEntryImportJobProgress>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCjiUid = _cursor.getLong(0);
                        long _tmpCjiItemProgress = _cursor.getLong(1);
                        long _tmpCjiItemTotal = _cursor.getLong(2);
                        int _tmpCjiStatus = _cursor.getInt(3);
                        String _tmpCjiError = _cursor.isNull(4) ? null : _cursor.getString(4);
                        long _tmpCjiOwnerPersonUid = _cursor.getLong(5);
                        ContentEntryImportJobProgress _item = new ContentEntryImportJobProgress(_tmpCjiUid, _tmpCjiItemProgress, _tmpCjiItemTotal, _tmpCjiStatus, _tmpCjiError, _tmpCjiOwnerPersonUid);
                        _result2.add(_item);
                    }
                    ArrayList<ContentEntryImportJobProgress> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

