/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Query;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.CourseAssignmentMarkAndMarkerName;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.AverageCourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentMark;
import com.ustadmobile.lib.db.entities.CourseAssignmentMarkWithPersonMarker;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH'J&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00052\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00052\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH'J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0017H'J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH'J \u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH'\u00a8\u0006\u001d"}, d2={"Lcom/ustadmobile/core/db/dao/CourseAssignmentMarkDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseAssignmentMark;", "()V", "checkNoSubmissionsMarked", "Lkotlinx/coroutines/flow/Flow;", "", "assignmentUid", "", "findNextSubmitterToMarkForAssignment", "submitterUid", "markerUid", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllMarksForSubmitterAsFlow", "", "Lcom/ustadmobile/lib/db/composites/CourseAssignmentMarkAndMarkerName;", "getAllMarksForSubmitterAsFlowMarkerPersons", "Lcom/ustadmobile/lib/db/composites/PersonAndPicture;", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllMarksForUserAsFlow", "accountPersonUid", "getAllMarksOfAssignmentForSubmitter", "Landroidx/paging/PagingSource;", "", "Lcom/ustadmobile/lib/db/entities/CourseAssignmentMarkWithPersonMarker;", "filter", "getMarkOfAssignmentForStudent", "getMarkOfAssignmentForSubmitterLiveData", "Lcom/ustadmobile/lib/db/entities/AverageCourseAssignmentMark;", "lib-database_debug"})
@Dao
public abstract class CourseAssignmentMarkDao
implements BaseDao<CourseAssignmentMark> {
    @Query(value="\n        SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentMark\n                       WHERE CourseAssignmentMark.camAssignmentUid = :assignmentUid\n                       LIMIT 1)\n    ")
    @NotNull
    public abstract Flow<Boolean> checkNoSubmissionsMarked(long var1);

    @Query(value="\n         WITH ScoreByMarker (averageScore, averagePenalty) AS (\n                 SELECT AVG(camMark), AVG(camPenalty)\n                   FROM courseAssignmentMark\n                        JOIN ClazzAssignment\n                        ON caUid = courseAssignmentMark.camAssignmentUid         \n                    AND camAssignmentUid = :assignmentUid\n                    AND camSubmitterUid = :submitterUid\n                  WHERE camLct = (SELECT MAX(mark.camLct) \n                                    FROM CourseAssignmentMark As mark\n                                    WHERE mark.camAssignmentUid = :assignmentUid\n                                     AND mark.camSubmitterUid = :submitterUid\n                                     AND (caMarkingType = 1\n                                       OR mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid))\n                )                       \n\n         SELECT COALESCE(averageScore, -1) AS averageScore, COALESCE(averagePenalty, -1) AS averagePenalty\n           FROM ScoreByMarker\n    ")
    @NotNull
    public abstract Flow<AverageCourseAssignmentMark> getMarkOfAssignmentForSubmitterLiveData(long var1, long var3);

    @Query(value="\n        SELECT CourseAssignmentMark.*,\n               Person.firstNames AS markerFirstNames,\n               Person.lastName AS markerLastName,\n               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n          FROM CourseAssignmentMark\n               LEFT JOIN Person\n                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n         WHERE (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    ) > 0\n           AND CourseAssignmentMark.camAssignmentUid = :assignmentUid\n           AND CourseAssignmentMark.camSubmitterUid = (\n        SELECT CASE\n                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) = 0\n                         THEN (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    )\n                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n                    WHEN (SELECT caGroupUid\n                            FROM ClazzAssignment\n                           WHERE caUid = :assignmentUid) != 0\n                          AND (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) = 0\n                          THEN 0\n                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n                    ELSE COALESCE(\n                          (SELECT CourseGroupMember.cgmGroupNumber\n                             FROM CourseGroupMember\n                            WHERE (\n        SELECT COALESCE(\n                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n                   FROM ClazzEnrolment\n                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n                        (SELECT ClazzAssignment.caClazzUid\n                           FROM ClazzAssignment\n                          WHERE ClazzAssignment.caUid = :assignmentUid)\n                  LIMIT 1), 0)\n    ) > 0\n                              AND CourseGroupMember.cgmSetUid = \n                                  (SELECT caGroupUid\n                                     FROM ClazzAssignment\n                                    WHERE caUid = :assignmentUid)\n                              AND CourseGroupMember.cgmPersonUid = :accountPersonUid\n                            LIMIT 1), -1)\n                    END\n    )\n      ORDER BY CourseAssignmentMark.camLct DESC    \n    ")
    @NotNull
    public abstract Flow<List<CourseAssignmentMarkAndMarkerName>> getAllMarksForUserAsFlow(long var1, long var3);

    @Query(value="\n        SELECT CourseAssignmentMark.*,\n               Person.firstNames AS markerFirstNames,\n               Person.lastName AS markerLastName,\n               PersonPicture.personPictureThumbnailUri AS markerPictureUri\n          FROM CourseAssignmentMark\n               LEFT JOIN Person\n                         ON Person.personUid = CourseAssignmentMark.camMarkerPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = CourseAssignmentMark.camMarkerPersonUid\n         WHERE CourseAssignmentMark.camAssignmentUid = :assignmentUid\n           AND CourseAssignmentMark.camSubmitterUid = :submitterUid\n      ORDER BY CourseAssignmentMark.camLct DESC                             \n    ")
    @NotNull
    public abstract Flow<List<CourseAssignmentMarkAndMarkerName>> getAllMarksForSubmitterAsFlow(long var1, long var3);

    @Query(value="\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE PersonUid IN\n               (SELECT CourseAssignmentMark.camMarkerPersonUid\n                  FROM CourseAssignmentMark\n                 WHERE CourseAssignmentMark.camAssignmentUid = :assignmentUid\n                   AND CourseAssignmentMark.camSubmitterUid = :submitterUid)\n    ")
    @Nullable
    public abstract Object getAllMarksForSubmitterAsFlowMarkerPersons(long var1, long var3, @NotNull Continuation<? super List<PersonAndPicture>> var5);

    @Query(value="\n          WITH ScoreByMarker AS (\n                 SELECT *\n                   FROM courseAssignmentMark    \n                  WHERE camAssignmentUid = :assignmentUid\n                    AND camSubmitterUid = :submitterUid\n                    AND (:filter = 0 OR camLct = (SELECT MAX(mark.camLct) \n                                    FROM CourseAssignmentMark As mark\n                                    WHERE mark.camAssignmentUid = :assignmentUid\n                                      AND mark.camSubmitterUid = :submitterUid\n                                      AND mark.camMarkerSubmitterUid = courseAssignmentMark.camMarkerSubmitterUid\n                                      ))                 \n                ORDER BY camLct DESC)    \n                \n          SELECT marker.*, ScoreByMarker.*, (ClazzAssignment.caGroupUid != 0) AS isGroup\n            FROM ScoreByMarker\n                 JOIN Person As marker\n                 ON Marker.personUid = ScoreByMarker.camMarkerPersonUid\n                 JOIN ClazzAssignment\n                 ON ClazzAssignment.caUid = :assignmentUid\n    ")
    @NotNull
    public abstract PagingSource<Integer, CourseAssignmentMarkWithPersonMarker> getAllMarksOfAssignmentForSubmitter(long var1, long var3, int var5);

    @Query(value="\n        SELECT * \n          FROM CourseAssignmentMark\n         WHERE camAssignmentUid = :assignmentUid\n           AND camSubmitterUid = :submitterUid\n      ORDER BY camLct DESC\n         LIMIT 1\n    ")
    @Nullable
    public abstract CourseAssignmentMark getMarkOfAssignmentForStudent(long var1, long var3);

    @Query(value="\n         SELECT COALESCE((\n            SELECT casSubmitterUid\n              FROM CourseAssignmentSubmission\n              \n                   JOIN ClazzAssignment\n                   ON ClazzAssignment.caUid = CourseAssignmentSubmission.casAssignmentUid\n              \n                   LEFT JOIN CourseAssignmentMark\n                   ON CourseAssignmentMark.camSubmitterUid = CourseAssignmentSubmission.casSubmitterUid\n                   AND CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid\n                   \n                   LEFT JOIN PeerReviewerAllocation\n                   ON praAssignmentUid = ClazzAssignment.caUid\n                   AND praToMarkerSubmitterUid = :submitterUid\n                   \n             WHERE CourseAssignmentSubmission.casSubmitterUid != :submitterUid\n               AND CourseAssignmentSubmission.casSubmitterUid != :markerUid\n               AND CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n               AND CourseAssignmentMark.camUid IS NULL\n               AND (ClazzAssignment.caMarkingType = 1 \n                    OR PeerReviewerAllocation.praMarkerSubmitterUid = :markerUid)\n          GROUP BY casSubmitterUid\n         LIMIT 1),0)\n    ")
    @Nullable
    public abstract Object findNextSubmitterToMarkForAssignment(long var1, long var3, long var5, @NotNull Continuation<? super Long> var7);
}

