/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.CourseGroupMemberDao;
import com.ustadmobile.lib.db.composites.CourseGroupMemberAndPerson;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.CourseGroupMember;
import com.ustadmobile.lib.db.entities.CourseGroupMemberAndName;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class CourseGroupMemberDao_Impl
extends CourseGroupMemberDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CourseGroupMember> __insertionAdapterOfCourseGroupMember;
    private final EntityInsertionAdapter<CourseGroupMember> __insertionAdapterOfCourseGroupMember_1;
    private final EntityDeletionOrUpdateAdapter<CourseGroupMember> __updateAdapterOfCourseGroupMember;

    public CourseGroupMemberDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCourseGroupMember = new EntityInsertionAdapter<CourseGroupMember>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CourseGroupMember` (`cgmUid`,`cgmSetUid`,`cgmGroupNumber`,`cgmPersonUid`,`cgmLct`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseGroupMember entity) {
                statement.bindLong(1, entity.getCgmUid());
                statement.bindLong(2, entity.getCgmSetUid());
                statement.bindLong(3, (long)entity.getCgmGroupNumber());
                statement.bindLong(4, entity.getCgmPersonUid());
                statement.bindLong(5, entity.getCgmLct());
            }
        };
        this.__insertionAdapterOfCourseGroupMember_1 = new EntityInsertionAdapter<CourseGroupMember>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `CourseGroupMember` (`cgmUid`,`cgmSetUid`,`cgmGroupNumber`,`cgmPersonUid`,`cgmLct`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseGroupMember entity) {
                statement.bindLong(1, entity.getCgmUid());
                statement.bindLong(2, entity.getCgmSetUid());
                statement.bindLong(3, (long)entity.getCgmGroupNumber());
                statement.bindLong(4, entity.getCgmPersonUid());
                statement.bindLong(5, entity.getCgmLct());
            }
        };
        this.__updateAdapterOfCourseGroupMember = new EntityDeletionOrUpdateAdapter<CourseGroupMember>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `CourseGroupMember` SET `cgmUid` = ?,`cgmSetUid` = ?,`cgmGroupNumber` = ?,`cgmPersonUid` = ?,`cgmLct` = ? WHERE `cgmUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CourseGroupMember entity) {
                statement.bindLong(1, entity.getCgmUid());
                statement.bindLong(2, entity.getCgmSetUid());
                statement.bindLong(3, (long)entity.getCgmGroupNumber());
                statement.bindLong(4, entity.getCgmPersonUid());
                statement.bindLong(5, entity.getCgmLct());
                statement.bindLong(6, entity.getCgmUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(CourseGroupMember entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfCourseGroupMember.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final CourseGroupMember entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CourseGroupMemberDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = CourseGroupMemberDao_Impl.this.__insertionAdapterOfCourseGroupMember.insertAndReturnId((Object)entity);
                    CourseGroupMemberDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    CourseGroupMemberDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends CourseGroupMember> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCourseGroupMember.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<CourseGroupMember> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseGroupMemberDao_Impl.this.__db.beginTransaction();
                try {
                    CourseGroupMemberDao_Impl.this.__insertionAdapterOfCourseGroupMember.insert((Iterable)entityList);
                    CourseGroupMemberDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseGroupMemberDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertListAsync(final List<CourseGroupMember> list, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseGroupMemberDao_Impl.this.__db.beginTransaction();
                try {
                    CourseGroupMemberDao_Impl.this.__insertionAdapterOfCourseGroupMember_1.insert((Iterable)list);
                    CourseGroupMemberDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseGroupMemberDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(CourseGroupMember entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCourseGroupMember.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateListAsync(final List<CourseGroupMember> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                CourseGroupMemberDao_Impl.this.__db.beginTransaction();
                try {
                    CourseGroupMemberDao_Impl.this.__updateAdapterOfCourseGroupMember.handleMultiple((Iterable)entityList);
                    CourseGroupMemberDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CourseGroupMemberDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByGroupSetUidAsync(long groupSetUid, Continuation<? super List<CourseGroupMember>> $completion) {
        String _sql = "\n        SELECT CourseGroupMember.*\n          FROM CourseGroupMember\n         WHERE cgmSetUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseGroupMember.*\n          FROM CourseGroupMember\n         WHERE cgmSetUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, groupSetUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseGroupMember>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseGroupMember> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmUid");
                    int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmSetUid");
                    int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmGroupNumber");
                    int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmPersonUid");
                    int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmLct");
                    ArrayList<CourseGroupMember> _result2 = new ArrayList<CourseGroupMember>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
                        long _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
                        int _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
                        long _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
                        long _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
                        CourseGroupMember _item = new CourseGroupMember(_tmpCgmUid, _tmpCgmSetUid, _tmpCgmGroupNumber, _tmpCgmPersonUid, _tmpCgmLct);
                        _result2.add(_item);
                    }
                    ArrayList<CourseGroupMember> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByPersonUid(long groupSetUid, long studentUid, Continuation<? super CourseGroupMember> $completion) {
        String _sql = "\n        SELECT * \n          FROM CourseGroupMember\n         WHERE cgmPersonUid = ? \n          AND cgmSetUid = ?\n         LIMIT 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM CourseGroupMember\n         WHERE cgmPersonUid = ? \n          AND cgmSetUid = ?\n         LIMIT 1\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, studentUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, groupSetUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CourseGroupMember>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CourseGroupMember call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CourseGroupMember _result2;
                    int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmUid");
                    int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmSetUid");
                    int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmGroupNumber");
                    int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmPersonUid");
                    int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmLct");
                    if (_cursor.moveToFirst()) {
                        long _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
                        long _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
                        int _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
                        long _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
                        long _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
                        _result2 = new CourseGroupMember(_tmpCgmUid, _tmpCgmSetUid, _tmpCgmGroupNumber, _tmpCgmPersonUid, _tmpCgmLct);
                    } else {
                        _result2 = null;
                    }
                    CourseGroupMember courseGroupMember = _result2;
                    return courseGroupMember;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByCourseGroupSetAndClazz(long cgsUid, long clazzUid, long time, int activeFilter, long accountPersonUid, Continuation<? super List<CourseGroupMemberAndName>> $completion) {
        String _sql = "\n        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n                     (? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n                FROM ClazzEnrolment\n               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    \n                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n        --Consolidate and removes any duplicates\n             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n                    ORDER BY AllEnrollmentsInner.isActive DESC\n                       LIMIT 1) AS isActive\n                FROM AllEnrollmentsAndActiveStatus)\n        \n        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n               Person.personUid,\n               CourseGroupMember.*,\n               PersonPicture.*,\n               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM EnrolledStudentPersonUids\n               JOIN Person\n                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid  \n               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n               LEFT JOIN CourseGroupMember\n                         ON CourseGroupMember.cgmUid = \n                            (SELECT CourseGroupMember.cgmUid\n                               FROM CourseGroupMember\n                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n                                AND CourseGroupMember.cgmSetUid = ? \n                           ORDER BY CourseGroupMember.cgmLct DESC        \n                              LIMIT 1)\n         WHERE (? = 0 OR ? = EnrolledStudentPersonUids.isActive)  \n               /* \n                * Begin permission check -  must have course view members permission, or active \n                * user must be in the same group \n                */ \n            AND (\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )\n                  OR EXISTS(\n                     SELECT 1\n                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = ?\n                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n                 )\n      ORDER BY Person.firstNames, Person.lastName ASC\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n                     (? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n                FROM ClazzEnrolment\n               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    \n                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n        --Consolidate and removes any duplicates\n             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n                    ORDER BY AllEnrollmentsInner.isActive DESC\n                       LIMIT 1) AS isActive\n                FROM AllEnrollmentsAndActiveStatus)\n        \n        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n               Person.personUid,\n               CourseGroupMember.*,\n               PersonPicture.*,\n               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM EnrolledStudentPersonUids\n               JOIN Person\n                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid  \n               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n               LEFT JOIN CourseGroupMember\n                         ON CourseGroupMember.cgmUid = \n                            (SELECT CourseGroupMember.cgmUid\n                               FROM CourseGroupMember\n                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n                                AND CourseGroupMember.cgmSetUid = ? \n                           ORDER BY CourseGroupMember.cgmLct DESC        \n                              LIMIT 1)\n         WHERE (? = 0 OR ? = EnrolledStudentPersonUids.isActive)  \n               /* \n                * Begin permission check -  must have course view members permission, or active \n                * user must be in the same group \n                */ \n            AND (\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )\n                  OR EXISTS(\n                     SELECT 1\n                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = ?\n                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n                 )\n      ORDER BY Person.firstNames, Person.lastName ASC\n    ", (int)14);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, time);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, cgsUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, cgsUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, (long)activeFilter);
        _argIndex = 7;
        _statement.bindLong(_argIndex, (long)activeFilter);
        _argIndex = 8;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseGroupMemberAndName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseGroupMemberAndName> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmUid");
                    int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmSetUid");
                    int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmGroupNumber");
                    int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmPersonUid");
                    int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmLct");
                    int _cursorIndexOfEnrolmentIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enrolmentIsActive");
                    int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pictureUri");
                    ArrayList<CourseGroupMemberAndName> _result2 = new ArrayList<CourseGroupMemberAndName>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseGroupMember _tmpCgm;
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfEnrolmentIsActive);
                        boolean _tmpEnrolmentIsActive = _tmp != 0;
                        String _tmpPictureUri = _cursor.isNull(_cursorIndexOfPictureUri) ? null : _cursor.getString(_cursorIndexOfPictureUri);
                        if (!(_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
                            long _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
                            long _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
                            int _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
                            long _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
                            long _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
                            _tmpCgm = new CourseGroupMember(_tmpCgmUid, _tmpCgmSetUid, _tmpCgmGroupNumber, _tmpCgmPersonUid, _tmpCgmLct);
                        } else {
                            _tmpCgm = null;
                        }
                        CourseGroupMemberAndName _item = new CourseGroupMemberAndName(_tmpCgm, _tmpName, _tmpPersonUid, _tmpEnrolmentIsActive, _tmpPictureUri);
                        _result2.add(_item);
                    }
                    ArrayList<CourseGroupMemberAndName> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<CourseGroupMemberAndName>> findByCourseGroupSetAndClazzAsFlow(long cgsUid, long clazzUid, long time, int activeFilter, long accountPersonUid) {
        String _sql = "\n        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n                     (? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n                FROM ClazzEnrolment\n               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    \n                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n        --Consolidate and removes any duplicates\n             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n                    ORDER BY AllEnrollmentsInner.isActive DESC\n                       LIMIT 1) AS isActive\n                FROM AllEnrollmentsAndActiveStatus)\n        \n        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n               Person.personUid,\n               CourseGroupMember.*,\n               PersonPicture.*,\n               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM EnrolledStudentPersonUids\n               JOIN Person\n                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid  \n               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n               LEFT JOIN CourseGroupMember\n                         ON CourseGroupMember.cgmUid = \n                            (SELECT CourseGroupMember.cgmUid\n                               FROM CourseGroupMember\n                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n                                AND CourseGroupMember.cgmSetUid = ? \n                           ORDER BY CourseGroupMember.cgmLct DESC        \n                              LIMIT 1)\n         WHERE (? = 0 OR ? = EnrolledStudentPersonUids.isActive)  \n               /* \n                * Begin permission check -  must have course view members permission, or active \n                * user must be in the same group \n                */ \n            AND (\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )\n                  OR EXISTS(\n                     SELECT 1\n                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = ?\n                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n                 )\n      ORDER BY Person.firstNames, Person.lastName ASC\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        --First get a list of all enrolments - this may contains duplicates for students who leave and re-enrol\n        WITH AllEnrollmentsAndActiveStatus(enrolledPersonUid, isActive) AS \n             (SELECT ClazzEnrolment.clazzEnrolmentPersonUid AS enrolledPersonUid,\n                     (? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) AS isActive\n                FROM ClazzEnrolment\n               WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    \n                 AND ClazzEnrolment.clazzEnrolmentRole = 1000),\n        --Consolidate and removes any duplicates\n             EnrolledStudentPersonUids(enrolledPersonUid, isActive) AS\n             (SELECT DISTINCT AllEnrollmentsAndActiveStatus.enrolledPersonUid,\n                     (SELECT CAST(AllEnrollmentsInner.isActive AS INTEGER)\n                        FROM AllEnrollmentsAndActiveStatus AllEnrollmentsInner\n                       WHERE AllEnrollmentsInner.enrolledPersonUid = AllEnrollmentsAndActiveStatus.enrolledPersonUid\n                    ORDER BY AllEnrollmentsInner.isActive DESC\n                       LIMIT 1) AS isActive\n                FROM AllEnrollmentsAndActiveStatus)\n        \n        -- Now create a list with each students name, the coursegroupmember object if any and active status        \n        SELECT (Person.firstNames || ' ' || Person.lastName) AS name,\n               Person.personUid,\n               CourseGroupMember.*,\n               PersonPicture.*,\n               EnrolledStudentPersonUids.isActive AS enrolmentIsActive,\n               PersonPicture.personPictureThumbnailUri AS pictureUri\n          FROM EnrolledStudentPersonUids\n               JOIN Person\n                    ON Person.personUid = EnrolledStudentPersonUids.enrolledPersonUid \n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid  \n               -- LEFT JOIN will use the most recent member in case of duplicate assignments eg if      \n               LEFT JOIN CourseGroupMember\n                         ON CourseGroupMember.cgmUid = \n                            (SELECT CourseGroupMember.cgmUid\n                               FROM CourseGroupMember\n                              WHERE CourseGroupMember.cgmPersonUid = EnrolledStudentPersonUids.enrolledPersonUid\n                                AND CourseGroupMember.cgmSetUid = ? \n                           ORDER BY CourseGroupMember.cgmLct DESC        \n                              LIMIT 1)\n         WHERE (? = 0 OR ? = EnrolledStudentPersonUids.isActive)  \n               /* \n                * Begin permission check -  must have course view members permission, or active \n                * user must be in the same group \n                */ \n            AND (\n                    ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )\n                  OR EXISTS(\n                     SELECT 1\n                       FROM CourseGroupMember _CourseGroupMemberForActivePerson\n                      WHERE _CourseGroupMemberForActivePerson.cgmPersonUid = ?\n                        AND _CourseGroupMemberForActivePerson.cgmGroupNumber = CourseGroupMember.cgmGroupNumber)     \n                 )\n      ORDER BY Person.firstNames, Person.lastName ASC\n    ", (int)14);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, time);
        _argIndex = 2;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, cgsUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, cgsUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, (long)activeFilter);
        _argIndex = 7;
        _statement.bindLong(_argIndex, (long)activeFilter);
        _argIndex = 8;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 14;
        _statement.bindLong(_argIndex, accountPersonUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"ClazzEnrolment", "CourseGroupSet", "Person", "PersonPicture", "CourseGroupMember", "Clazz", "CoursePermission", "SystemPermission"}, (Callable)new Callable<List<CourseGroupMemberAndName>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseGroupMemberAndName> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmUid");
                    int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmSetUid");
                    int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmGroupNumber");
                    int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmPersonUid");
                    int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmLct");
                    int _cursorIndexOfEnrolmentIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enrolmentIsActive");
                    int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pictureUri");
                    ArrayList<CourseGroupMemberAndName> _result2 = new ArrayList<CourseGroupMemberAndName>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CourseGroupMember _tmpCgm;
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfEnrolmentIsActive);
                        boolean _tmpEnrolmentIsActive = _tmp != 0;
                        String _tmpPictureUri = _cursor.isNull(_cursorIndexOfPictureUri) ? null : _cursor.getString(_cursorIndexOfPictureUri);
                        if (!(_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
                            long _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
                            long _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
                            int _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
                            long _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
                            long _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
                            _tmpCgm = new CourseGroupMember(_tmpCgmUid, _tmpCgmSetUid, _tmpCgmGroupNumber, _tmpCgmPersonUid, _tmpCgmLct);
                        } else {
                            _tmpCgm = null;
                        }
                        CourseGroupMemberAndName _item = new CourseGroupMemberAndName(_tmpCgm, _tmpName, _tmpPersonUid, _tmpEnrolmentIsActive, _tmpPictureUri);
                        _result2.add(_item);
                    }
                    ArrayList<CourseGroupMemberAndName> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findByCourseGroupSetAndClazzAsFlowPersons(long clazzUid, long cgsUid, Continuation<? super List<PersonAndPicture>> $completion) {
        String _sql = "\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    )\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, PersonPicture.*\n          FROM Person\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = Person.personUid\n         WHERE Person.personUid IN\n               (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    )\n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, cgsUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<PersonAndPicture>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<PersonAndPicture> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    ArrayList<PersonAndPicture> _result2 = new ArrayList<PersonAndPicture>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        PersonPicture _tmpPicture;
                        Person _tmpPerson;
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_1 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                            long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                            long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                            String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                            String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                            int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                            int _tmp_2 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                            boolean _tmpPersonPictureActive = _tmp_2 != 0;
                            _tmpPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                        } else {
                            _tmpPicture = null;
                        }
                        PersonAndPicture _item = new PersonAndPicture(_tmpPerson, _tmpPicture);
                        _result2.add(_item);
                    }
                    ArrayList<PersonAndPicture> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByCourseGroupSetAndClazzAsFlowEnrolments(long clazzUid, long cgsUid, Continuation<? super List<? extends ClazzEnrolment>> $completion) {
        String _sql = "\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ClazzEnrolment.*\n          FROM ClazzEnrolment\n         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = \n        CASE(?)\n                         WHEN 0 THEN \n                                (SELECT CourseGroupSet.cgsClazzUid\n                                   FROM CourseGroupSet\n                                  WHERE CourseGroupSet.cgsUid = ?)\n                         ELSE ?\n                     END\n    \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, cgsUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, clazzUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ClazzEnrolment>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<ClazzEnrolment> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentUid");
                    int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentPersonUid");
                    int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentClazzUid");
                    int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateJoined");
                    int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentDateLeft");
                    int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentRole");
                    int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentAttendancePercentage");
                    int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentActive");
                    int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLeavingReasonUid");
                    int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentOutcome");
                    int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLocalChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentMasterChangeSeqNum");
                    int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLastChangedBy");
                    int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clazzEnrolmentLct");
                    ArrayList<ClazzEnrolment> _result2 = new ArrayList<ClazzEnrolment>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ClazzEnrolment _item = new ClazzEnrolment();
                        long _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                        _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                        long _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                        _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                        long _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                        _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                        long _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                        _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                        long _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                        _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                        int _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                        _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                        float _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                        _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                        int _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                        boolean _tmpClazzEnrolmentActive = _tmp != 0;
                        _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                        long _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                        _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                        int _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                        _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                        long _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                        _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                        long _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                        _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                        int _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                        _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                        long _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                        _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
                        _result2.add(_item);
                    }
                    ArrayList<ClazzEnrolment> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByCourseGroupSetAndGroupNumAsync(long courseGroupSetUid, int groupNum, long clazzUid, long assignmentUid, long accountPersonUid, Continuation<? super List<CourseGroupMemberAndPerson>> $completion) {
        String _sql = "\n        SELECT CourseGroupMember.*, Person.*\n          FROM CourseGroupMember\n               JOIN Person \n                    ON Person.personUid = CourseGroupMember.cgmPersonUid\n         WHERE (    CourseGroupMember.cgmSetUid = ?\n                AND CourseGroupMember.cgmGroupNumber = ?)\n           AND (    /* Grant permission where the active person is in the group */ \n                    EXISTS(SELECT 1\n                             FROM CourseGroupMember CourseGroupMemberInternal\n                            WHERE CourseGroupMemberInternal.cgmSetUid = ?\n                              AND CourseGroupMemberInternal.cgmPersonUid = ?)\n                    /* Grant permission where the activepersonuid is in a group assigned to mark this group */\n                 OR EXISTS(SELECT 1\n                             FROM PeerReviewerAllocation\n                            WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                              AND PeerReviewerAllocation.praMarkerSubmitterUid = ?\n                              AND EXISTS(SELECT 1\n                                           FROM CourseGroupMember CourseGroupMemberInternal\n                                          WHERE CourseGroupMemberInternal.cgmSetUid = PeerReviewerAllocation.praMarkerSubmitterUid\n                                            AND CourseGroupMemberInternal.cgmPersonUid = ?)) \n                    /* Grant permission where the active person has the select person permission for the class */                        \n                 OR ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )    \n               )\n               \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CourseGroupMember.*, Person.*\n          FROM CourseGroupMember\n               JOIN Person \n                    ON Person.personUid = CourseGroupMember.cgmPersonUid\n         WHERE (    CourseGroupMember.cgmSetUid = ?\n                AND CourseGroupMember.cgmGroupNumber = ?)\n           AND (    /* Grant permission where the active person is in the group */ \n                    EXISTS(SELECT 1\n                             FROM CourseGroupMember CourseGroupMemberInternal\n                            WHERE CourseGroupMemberInternal.cgmSetUid = ?\n                              AND CourseGroupMemberInternal.cgmPersonUid = ?)\n                    /* Grant permission where the activepersonuid is in a group assigned to mark this group */\n                 OR EXISTS(SELECT 1\n                             FROM PeerReviewerAllocation\n                            WHERE PeerReviewerAllocation.praAssignmentUid = ?\n                              AND PeerReviewerAllocation.praMarkerSubmitterUid = ?\n                              AND EXISTS(SELECT 1\n                                           FROM CourseGroupMember CourseGroupMemberInternal\n                                          WHERE CourseGroupMemberInternal.cgmSetUid = PeerReviewerAllocation.praMarkerSubmitterUid\n                                            AND CourseGroupMemberInternal.cgmPersonUid = ?)) \n                    /* Grant permission where the active person has the select person permission for the class */                        \n                 OR ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = ?\n                           AND (CoursePermission.cpToPersonUid = ? \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         8192\n                     \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = ?\n                           AND (SystemPermission.spPermissionsFlag & \n     8192\n                     \n        ) > 0)\n               )\n    )    \n               )\n               \n    ", (int)13);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, courseGroupSetUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)groupNum);
        _argIndex = 3;
        _statement.bindLong(_argIndex, courseGroupSetUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, assignmentUid);
        _argIndex = 6;
        _statement.bindLong(_argIndex, (long)groupNum);
        _argIndex = 7;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 8;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 9;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 10;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 11;
        _statement.bindLong(_argIndex, clazzUid);
        _argIndex = 12;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 13;
        _statement.bindLong(_argIndex, accountPersonUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<CourseGroupMemberAndPerson>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<CourseGroupMemberAndPerson> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CourseGroupMemberDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmUid");
                    int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmSetUid");
                    int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmGroupNumber");
                    int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmPersonUid");
                    int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cgmLct");
                    int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personUid");
                    int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"username");
                    int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstNames");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"emailAddr");
                    int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phoneNum");
                    int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gender");
                    int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
                    int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateOfBirth");
                    int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personAddress");
                    int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personOrgId");
                    int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personGroupUid");
                    int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLct");
                    int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personCountry");
                    int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personType");
                    int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personMasterChangeSeqNum");
                    int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLocalChangeSeqNum");
                    int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personLastChangedBy");
                    int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"admin");
                    int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personNotes");
                    int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherName");
                    int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fatherNumber");
                    int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherName");
                    int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"motherNum");
                    ArrayList<CourseGroupMemberAndPerson> _result2 = new ArrayList<CourseGroupMemberAndPerson>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Person _tmpPerson;
                        CourseGroupMember _tmpCourseGroupMember;
                        if (!(_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
                            long _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
                            long _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
                            int _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
                            long _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
                            long _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
                            _tmpCourseGroupMember = new CourseGroupMember(_tmpCgmUid, _tmpCgmSetUid, _tmpCgmGroupNumber, _tmpCgmPersonUid, _tmpCgmLct);
                        } else {
                            _tmpCourseGroupMember = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
                            long _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
                            String _tmpUsername = _cursor.isNull(_cursorIndexOfUsername) ? null : _cursor.getString(_cursorIndexOfUsername);
                            String _tmpFirstNames = _cursor.isNull(_cursorIndexOfFirstNames) ? null : _cursor.getString(_cursorIndexOfFirstNames);
                            String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                            String _tmpEmailAddr = _cursor.isNull(_cursorIndexOfEmailAddr) ? null : _cursor.getString(_cursorIndexOfEmailAddr);
                            String _tmpPhoneNum = _cursor.isNull(_cursorIndexOfPhoneNum) ? null : _cursor.getString(_cursorIndexOfPhoneNum);
                            int _tmpGender = _cursor.getInt(_cursorIndexOfGender);
                            int _tmp = _cursor.getInt(_cursorIndexOfActive);
                            boolean _tmpActive = _tmp != 0;
                            long _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
                            String _tmpPersonAddress = _cursor.isNull(_cursorIndexOfPersonAddress) ? null : _cursor.getString(_cursorIndexOfPersonAddress);
                            String _tmpPersonOrgId = _cursor.isNull(_cursorIndexOfPersonOrgId) ? null : _cursor.getString(_cursorIndexOfPersonOrgId);
                            long _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
                            long _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
                            String _tmpPersonCountry = _cursor.isNull(_cursorIndexOfPersonCountry) ? null : _cursor.getString(_cursorIndexOfPersonCountry);
                            int _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
                            long _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                            long _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                            int _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                            int _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
                            boolean _tmpAdmin = _tmp_1 != 0;
                            String _tmpPersonNotes = _cursor.isNull(_cursorIndexOfPersonNotes) ? null : _cursor.getString(_cursorIndexOfPersonNotes);
                            String _tmpFatherName = _cursor.isNull(_cursorIndexOfFatherName) ? null : _cursor.getString(_cursorIndexOfFatherName);
                            String _tmpFatherNumber = _cursor.isNull(_cursorIndexOfFatherNumber) ? null : _cursor.getString(_cursorIndexOfFatherNumber);
                            String _tmpMotherName = _cursor.isNull(_cursorIndexOfMotherName) ? null : _cursor.getString(_cursorIndexOfMotherName);
                            String _tmpMotherNum = _cursor.isNull(_cursorIndexOfMotherNum) ? null : _cursor.getString(_cursorIndexOfMotherNum);
                            _tmpPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                        } else {
                            _tmpPerson = null;
                        }
                        CourseGroupMemberAndPerson _item = new CourseGroupMemberAndPerson(_tmpCourseGroupMember, _tmpPerson);
                        _result2.add(_item);
                    }
                    ArrayList<CourseGroupMemberAndPerson> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

