/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.ExternalAppPermissionDao;
import com.ustadmobile.lib.db.entities.ExternalAppPermission;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class ExternalAppPermissionDao_Impl
extends ExternalAppPermissionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ExternalAppPermission> __insertionAdapterOfExternalAppPermission;

    public ExternalAppPermissionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfExternalAppPermission = new EntityInsertionAdapter<ExternalAppPermission>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `ExternalAppPermission` (`eapUid`,`eapPersonUid`,`eapPackageId`,`eapStartTime`,`eapExpireTime`,`eapAuthToken`,`eapAndroidAccountName`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull ExternalAppPermission entity) {
                statement.bindLong(1, (long)entity.getEapUid());
                statement.bindLong(2, entity.getEapPersonUid());
                if (entity.getEapPackageId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getEapPackageId());
                }
                statement.bindLong(4, entity.getEapStartTime());
                statement.bindLong(5, entity.getEapExpireTime());
                if (entity.getEapAuthToken() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getEapAuthToken());
                }
                if (entity.getEapAndroidAccountName() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindString(7, entity.getEapAndroidAccountName());
                }
            }
        };
    }

    @Override
    public Object insertAsync(final ExternalAppPermission externalAppPermission, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                ExternalAppPermissionDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = ExternalAppPermissionDao_Impl.this.__insertionAdapterOfExternalAppPermission.insertAndReturnId((Object)externalAppPermission);
                    ExternalAppPermissionDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    ExternalAppPermissionDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object getGrantedAuthToken(String packageId, long personUid, long currentTime, Continuation<? super String> $completion) {
        String _sql = "\n        SELECT ExternalAppPermission.eapAuthToken\n          FROM ExternalAppPermission\n         WHERE ExternalAppPermission.eapPackageId = ?\n           AND ExternalAppPermission.eapPersonUid = ?\n           AND ? BETWEEN ExternalAppPermission.eapStartTime AND ExternalAppPermission.eapExpireTime\n         LIMIT 1  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT ExternalAppPermission.eapAuthToken\n          FROM ExternalAppPermission\n         WHERE ExternalAppPermission.eapPackageId = ?\n           AND ExternalAppPermission.eapPersonUid = ?\n           AND ? BETWEEN ExternalAppPermission.eapStartTime AND ExternalAppPermission.eapExpireTime\n         LIMIT 1  \n    ", (int)3);
        int _argIndex = 1;
        _statement.bindString(_argIndex, packageId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, personUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, currentTime);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public String call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ExternalAppPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    String _result2 = _cursor.moveToFirst() ? (_cursor.isNull(0) ? null : _cursor.getString(0)) : null;
                    String string = _result2;
                    return string;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getExternalAccessPermissionByUid(int eapUid, Continuation<? super ExternalAppPermission> $completion) {
        String _sql = "\n        SELECT *\n          FROM ExternalAppPermission\n         WHERE eapUid = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT *\n          FROM ExternalAppPermission\n         WHERE eapUid = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)eapUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ExternalAppPermission>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public ExternalAppPermission call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ExternalAppPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ExternalAppPermission _result2;
                    int _cursorIndexOfEapUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eapUid");
                    int _cursorIndexOfEapPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eapPersonUid");
                    int _cursorIndexOfEapPackageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eapPackageId");
                    int _cursorIndexOfEapStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eapStartTime");
                    int _cursorIndexOfEapExpireTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eapExpireTime");
                    int _cursorIndexOfEapAuthToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eapAuthToken");
                    int _cursorIndexOfEapAndroidAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eapAndroidAccountName");
                    if (_cursor.moveToFirst()) {
                        int _tmpEapUid = _cursor.getInt(_cursorIndexOfEapUid);
                        long _tmpEapPersonUid = _cursor.getLong(_cursorIndexOfEapPersonUid);
                        String _tmpEapPackageId = _cursor.isNull(_cursorIndexOfEapPackageId) ? null : _cursor.getString(_cursorIndexOfEapPackageId);
                        long _tmpEapStartTime = _cursor.getLong(_cursorIndexOfEapStartTime);
                        long _tmpEapExpireTime = _cursor.getLong(_cursorIndexOfEapExpireTime);
                        String _tmpEapAuthToken = _cursor.isNull(_cursorIndexOfEapAuthToken) ? null : _cursor.getString(_cursorIndexOfEapAuthToken);
                        String _tmpEapAndroidAccountName = _cursor.isNull(_cursorIndexOfEapAndroidAccountName) ? null : _cursor.getString(_cursorIndexOfEapAndroidAccountName);
                        _result2 = new ExternalAppPermission(_tmpEapUid, _tmpEapPersonUid, _tmpEapPackageId, _tmpEapStartTime, _tmpEapExpireTime, _tmpEapAuthToken, _tmpEapAndroidAccountName);
                    } else {
                        _result2 = null;
                    }
                    ExternalAppPermission externalAppPermission = _result2;
                    return externalAppPermission;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getPersonUidByAuthToken(String token, long currentTime, Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT COALESCE(\n               (SELECT eapPersonUid\n                  FROM ExternalAppPermission\n                 WHERE eapAuthToken = ?\n                   AND ? BETWEEN eapStartTime AND eapExpireTime\n               ),\n               0)    \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT COALESCE(\n               (SELECT eapPersonUid\n                  FROM ExternalAppPermission\n                 WHERE eapAuthToken = ?\n                   AND ? BETWEEN eapStartTime AND eapExpireTime\n               ),\n               0)    \n    ", (int)2);
        int _argIndex = 1;
        _statement.bindString(_argIndex, token);
        _argIndex = 2;
        _statement.bindLong(_argIndex, currentTime);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Long call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ExternalAppPermissionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Long _result2;
                    if (_cursor.moveToFirst()) {
                        long _tmp = _cursor.getLong(0);
                        _result2 = _tmp;
                    } else {
                        _result2 = 0L;
                    }
                    Long l = _result2;
                    return l;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

