/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.PersonPictureDao;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class PersonPictureDao_Impl
extends PersonPictureDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PersonPicture> __insertionAdapterOfPersonPicture;
    private final EntityInsertionAdapter<PersonPicture> __insertionAdapterOfPersonPicture_1;
    private final EntityDeletionOrUpdateAdapter<PersonPicture> __updateAdapterOfPersonPicture;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUri;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLct;
    private final SharedSQLiteStatement __preparedStmtOfUpdateTransferJobItemEtag;

    public PersonPictureDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPersonPicture = new EntityInsertionAdapter<PersonPicture>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `PersonPicture` (`personPictureUid`,`personPictureLct`,`personPictureUri`,`personPictureThumbnailUri`,`fileSize`,`personPictureActive`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonPicture entity) {
                statement.bindLong(1, entity.getPersonPictureUid());
                statement.bindLong(2, entity.getPersonPictureLct());
                if (entity.getPersonPictureUri() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getPersonPictureUri());
                }
                if (entity.getPersonPictureThumbnailUri() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getPersonPictureThumbnailUri());
                }
                statement.bindLong(5, (long)entity.getFileSize());
                int _tmp = entity.getPersonPictureActive() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
            }
        };
        this.__insertionAdapterOfPersonPicture_1 = new EntityInsertionAdapter<PersonPicture>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `PersonPicture` (`personPictureUid`,`personPictureLct`,`personPictureUri`,`personPictureThumbnailUri`,`fileSize`,`personPictureActive`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonPicture entity) {
                statement.bindLong(1, entity.getPersonPictureUid());
                statement.bindLong(2, entity.getPersonPictureLct());
                if (entity.getPersonPictureUri() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getPersonPictureUri());
                }
                if (entity.getPersonPictureThumbnailUri() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getPersonPictureThumbnailUri());
                }
                statement.bindLong(5, (long)entity.getFileSize());
                int _tmp = entity.getPersonPictureActive() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
            }
        };
        this.__updateAdapterOfPersonPicture = new EntityDeletionOrUpdateAdapter<PersonPicture>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `PersonPicture` SET `personPictureUid` = ?,`personPictureLct` = ?,`personPictureUri` = ?,`personPictureThumbnailUri` = ?,`fileSize` = ?,`personPictureActive` = ? WHERE `personPictureUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull PersonPicture entity) {
                statement.bindLong(1, entity.getPersonPictureUid());
                statement.bindLong(2, entity.getPersonPictureLct());
                if (entity.getPersonPictureUri() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getPersonPictureUri());
                }
                if (entity.getPersonPictureThumbnailUri() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getPersonPictureThumbnailUri());
                }
                statement.bindLong(5, (long)entity.getFileSize());
                int _tmp = entity.getPersonPictureActive() ? 1 : 0;
                statement.bindLong(6, (long)_tmp);
                statement.bindLong(7, entity.getPersonPictureUid());
            }
        };
        this.__preparedStmtOfUpdateUri = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE PersonPicture\n           SET personPictureUri = ?,\n               personPictureThumbnailUri = ?,\n               personPictureLct = ?\n         WHERE personPictureUid = ?      \n    ";
                return "\n        UPDATE PersonPicture\n           SET personPictureUri = ?,\n               personPictureThumbnailUri = ?,\n               personPictureLct = ?\n         WHERE personPictureUid = ?      \n    ";
            }
        };
        this.__preparedStmtOfUpdateLct = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE PersonPicture\n           SET personPictureLct = ?\n         WHERE personPictureUid = ?   \n    ";
                return "\n        UPDATE PersonPicture\n           SET personPictureLct = ?\n         WHERE personPictureUid = ?   \n    ";
            }
        };
        this.__preparedStmtOfUpdateTransferJobItemEtag = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJobItem\n           SET tjiEntityEtag = \n               (SELECT personPictureLct\n                  FROM PersonPicture\n                 WHERE personPictureUid = ?)\n         WHERE tjiUid = ?      \n    ";
                return "\n        UPDATE TransferJobItem\n           SET tjiEntityEtag = \n               (SELECT personPictureLct\n                  FROM PersonPicture\n                 WHERE personPictureUid = ?)\n         WHERE tjiUid = ?      \n    ";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(PersonPicture entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfPersonPicture.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final PersonPicture entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                PersonPictureDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = PersonPictureDao_Impl.this.__insertionAdapterOfPersonPicture.insertAndReturnId((Object)entity);
                    PersonPictureDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    PersonPictureDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends PersonPicture> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPersonPicture.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object upsert(final PersonPicture personPicture, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PersonPictureDao_Impl.this.__db.beginTransaction();
                try {
                    PersonPictureDao_Impl.this.__insertionAdapterOfPersonPicture_1.insert((Object)personPicture);
                    PersonPictureDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PersonPictureDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void update(PersonPicture entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPersonPicture.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final PersonPicture personPicture, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                PersonPictureDao_Impl.this.__db.beginTransaction();
                try {
                    PersonPictureDao_Impl.this.__updateAdapterOfPersonPicture.handle((Object)personPicture);
                    PersonPictureDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PersonPictureDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateUri(final long uid, final String uri, final String thumbnailUri, final long time, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PersonPictureDao_Impl.this.__preparedStmtOfUpdateUri.acquire();
                int _argIndex = 1;
                if (uri == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, uri);
                }
                _argIndex = 2;
                if (thumbnailUri == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, thumbnailUri);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, time);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, uid);
                try {
                    Unit unit;
                    PersonPictureDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        PersonPictureDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        PersonPictureDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PersonPictureDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    PersonPictureDao_Impl.this.__preparedStmtOfUpdateUri.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateLct(final long uid, final long time, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PersonPictureDao_Impl.this.__preparedStmtOfUpdateLct.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, time);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, uid);
                try {
                    Unit unit;
                    PersonPictureDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        PersonPictureDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        PersonPictureDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PersonPictureDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    PersonPictureDao_Impl.this.__preparedStmtOfUpdateLct.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object updateTransferJobItemEtag(final long entityUid, final int transferJobItemUid, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PersonPictureDao_Impl.this.__preparedStmtOfUpdateTransferJobItemEtag.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, entityUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)transferJobItemUid);
                try {
                    Unit unit;
                    PersonPictureDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        PersonPictureDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        PersonPictureDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    PersonPictureDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    PersonPictureDao_Impl.this.__preparedStmtOfUpdateTransferJobItemEtag.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByPersonUidAsync(long personUid, Continuation<? super PersonPicture> $completion) {
        String _sql = "\n        SELECT * \n          FROM PersonPicture \n         WHERE personPictureUid = ?\n           AND CAST(personPictureActive AS INTEGER) = 1\n         ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM PersonPicture \n         WHERE personPictureUid = ?\n           AND CAST(personPictureActive AS INTEGER) = 1\n         ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<PersonPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonPicture call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)PersonPictureDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    PersonPicture _result2;
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp != 0;
                        _result2 = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _result2 = null;
                    }
                    PersonPicture personPicture = _result2;
                    return personPicture;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<PersonPicture> findByPersonUidLive(long personUid) {
        String _sql = "\n         SELECT * \n           FROM PersonPicture \n          WHERE personPictureUid = ? \n          ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n         SELECT * \n           FROM PersonPicture \n          WHERE personPictureUid = ? \n          ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"PersonPicture"}, (Callable)new Callable<PersonPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonPicture call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonPictureDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PersonPicture _result2;
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp != 0;
                        _result2 = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _result2 = null;
                    }
                    PersonPicture personPicture = _result2;
                    return personPicture;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<PersonPicture> findByPersonUidAsFlow(long personUid) {
        String _sql = "\n        SELECT * \n          FROM PersonPicture \n         WHERE personPictureUid = ?\n          AND CAST(personPictureActive AS INTEGER) = 1\n        LIMIT 1\n        ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * \n          FROM PersonPicture \n         WHERE personPictureUid = ?\n          AND CAST(personPictureActive AS INTEGER) = 1\n        LIMIT 1\n        ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, personUid);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"PersonPicture"}, (Callable)new Callable<PersonPicture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public PersonPicture call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PersonPictureDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PersonPicture _result2;
                    int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUid");
                    int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureLct");
                    int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureUri");
                    int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureThumbnailUri");
                    int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fileSize");
                    int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"personPictureActive");
                    if (_cursor.moveToFirst()) {
                        long _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = _cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp = _cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp != 0;
                        _result2 = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _result2 = null;
                    }
                    PersonPicture personPicture = _result2;
                    return personPicture;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

