/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.SiteTermsDao;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.SiteTerms;
import com.ustadmobile.lib.db.entities.SiteTermsWithLanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class SiteTermsDao_Impl
extends SiteTermsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SiteTerms> __insertionAdapterOfSiteTerms;
    private final EntityInsertionAdapter<SiteTerms> __insertionAdapterOfSiteTerms_1;
    private final EntityDeletionOrUpdateAdapter<SiteTerms> __updateAdapterOfSiteTerms;
    private final SharedSQLiteStatement __preparedStmtOfUpdateActiveByUid;

    public SiteTermsDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSiteTerms = new EntityInsertionAdapter<SiteTerms>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `SiteTerms` (`sTermsUid`,`termsHtml`,`sTermsLang`,`sTermsLangUid`,`sTermsActive`,`sTermsLastChangedBy`,`sTermsPrimaryCsn`,`sTermsLocalCsn`,`sTermsLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull SiteTerms entity) {
                statement.bindLong(1, entity.getSTermsUid());
                if (entity.getTermsHtml() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getTermsHtml());
                }
                if (entity.getSTermsLang() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getSTermsLang());
                }
                statement.bindLong(4, entity.getSTermsLangUid());
                int _tmp = entity.getSTermsActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                statement.bindLong(6, (long)entity.getSTermsLastChangedBy());
                statement.bindLong(7, entity.getSTermsPrimaryCsn());
                statement.bindLong(8, entity.getSTermsLocalCsn());
                statement.bindLong(9, entity.getSTermsLct());
            }
        };
        this.__insertionAdapterOfSiteTerms_1 = new EntityInsertionAdapter<SiteTerms>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `SiteTerms` (`sTermsUid`,`termsHtml`,`sTermsLang`,`sTermsLangUid`,`sTermsActive`,`sTermsLastChangedBy`,`sTermsPrimaryCsn`,`sTermsLocalCsn`,`sTermsLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull SiteTerms entity) {
                statement.bindLong(1, entity.getSTermsUid());
                if (entity.getTermsHtml() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getTermsHtml());
                }
                if (entity.getSTermsLang() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getSTermsLang());
                }
                statement.bindLong(4, entity.getSTermsLangUid());
                int _tmp = entity.getSTermsActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                statement.bindLong(6, (long)entity.getSTermsLastChangedBy());
                statement.bindLong(7, entity.getSTermsPrimaryCsn());
                statement.bindLong(8, entity.getSTermsLocalCsn());
                statement.bindLong(9, entity.getSTermsLct());
            }
        };
        this.__updateAdapterOfSiteTerms = new EntityDeletionOrUpdateAdapter<SiteTerms>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `SiteTerms` SET `sTermsUid` = ?,`termsHtml` = ?,`sTermsLang` = ?,`sTermsLangUid` = ?,`sTermsActive` = ?,`sTermsLastChangedBy` = ?,`sTermsPrimaryCsn` = ?,`sTermsLocalCsn` = ?,`sTermsLct` = ? WHERE `sTermsUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull SiteTerms entity) {
                statement.bindLong(1, entity.getSTermsUid());
                if (entity.getTermsHtml() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getTermsHtml());
                }
                if (entity.getSTermsLang() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getSTermsLang());
                }
                statement.bindLong(4, entity.getSTermsLangUid());
                int _tmp = entity.getSTermsActive() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
                statement.bindLong(6, (long)entity.getSTermsLastChangedBy());
                statement.bindLong(7, entity.getSTermsPrimaryCsn());
                statement.bindLong(8, entity.getSTermsLocalCsn());
                statement.bindLong(9, entity.getSTermsLct());
                statement.bindLong(10, entity.getSTermsUid());
            }
        };
        this.__preparedStmtOfUpdateActiveByUid = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE SiteTerms \n           SET sTermsActive = ?,\n               sTermsLct = ?\n         WHERE sTermsUid = ?\n        ";
                return "\n        UPDATE SiteTerms \n           SET sTermsActive = ?,\n               sTermsLct = ?\n         WHERE sTermsUid = ?\n        ";
            }
        };
    }

    @Override
    public Object insertListAsync(final List<? extends SiteTerms> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                SiteTermsDao_Impl.this.__db.beginTransaction();
                try {
                    SiteTermsDao_Impl.this.__insertionAdapterOfSiteTerms.insert((Iterable)entityList);
                    SiteTermsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SiteTermsDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object insertAsync(final SiteTerms siteTerms, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                SiteTermsDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = SiteTermsDao_Impl.this.__insertionAdapterOfSiteTerms.insertAndReturnId((Object)siteTerms);
                    SiteTermsDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    SiteTermsDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object upsertList(final List<? extends SiteTerms> termList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                SiteTermsDao_Impl.this.__db.beginTransaction();
                try {
                    SiteTermsDao_Impl.this.__insertionAdapterOfSiteTerms_1.insert((Iterable)termList);
                    SiteTermsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SiteTermsDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateListAsync(final List<? extends SiteTerms> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                SiteTermsDao_Impl.this.__db.beginTransaction();
                try {
                    SiteTermsDao_Impl.this.__updateAdapterOfSiteTerms.handleMultiple((Iterable)entityList);
                    SiteTermsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SiteTermsDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object updateActiveByUid(final long sTermsUid, final boolean active, final long changeTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = SiteTermsDao_Impl.this.__preparedStmtOfUpdateActiveByUid.acquire();
                int _argIndex = 1;
                int _tmp = active ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, changeTime);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, sTermsUid);
                try {
                    Unit unit;
                    SiteTermsDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        SiteTermsDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        SiteTermsDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    SiteTermsDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    SiteTermsDao_Impl.this.__preparedStmtOfUpdateActiveByUid.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findSiteTerms(String langCode, Continuation<? super SiteTerms> $completion) {
        String _sql = "\n        SELECT * FROM SiteTerms WHERE sTermsUid = coalesce(\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = ? LIMIT 1),\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = 'en' LIMIT 1),\n            0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT * FROM SiteTerms WHERE sTermsUid = coalesce(\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = ? LIMIT 1),\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = 'en' LIMIT 1),\n            0)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, langCode);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<SiteTerms>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public SiteTerms call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteTermsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SiteTerms _result2;
                    int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsUid");
                    int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"termsHtml");
                    int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLang");
                    int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLangUid");
                    int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsActive");
                    int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLastChangedBy");
                    int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsPrimaryCsn");
                    int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLocalCsn");
                    int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new SiteTerms();
                        long _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
                        _result2.setSTermsUid(_tmpSTermsUid);
                        String _tmpTermsHtml = _cursor.isNull(_cursorIndexOfTermsHtml) ? null : _cursor.getString(_cursorIndexOfTermsHtml);
                        _result2.setTermsHtml(_tmpTermsHtml);
                        String _tmpSTermsLang = _cursor.isNull(_cursorIndexOfSTermsLang) ? null : _cursor.getString(_cursorIndexOfSTermsLang);
                        _result2.setSTermsLang(_tmpSTermsLang);
                        long _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
                        _result2.setSTermsLangUid(_tmpSTermsLangUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
                        boolean _tmpSTermsActive = _tmp != 0;
                        _result2.setSTermsActive(_tmpSTermsActive);
                        int _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
                        _result2.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
                        long _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
                        _result2.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
                        long _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
                        _result2.setSTermsLocalCsn(_tmpSTermsLocalCsn);
                        long _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
                        _result2.setSTermsLct(_tmpSTermsLct);
                    } else {
                        _result2 = null;
                    }
                    SiteTerms siteTerms = _result2;
                    return siteTerms;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByUidAsync(long uid, Continuation<? super SiteTerms> $completion) {
        String _sql = "SELECT * FROM SiteTerms WHERE sTermsUid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SiteTerms WHERE sTermsUid = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, uid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<SiteTerms>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public SiteTerms call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteTermsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SiteTerms _result2;
                    int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsUid");
                    int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"termsHtml");
                    int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLang");
                    int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLangUid");
                    int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsActive");
                    int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLastChangedBy");
                    int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsPrimaryCsn");
                    int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLocalCsn");
                    int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new SiteTerms();
                        long _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
                        _result2.setSTermsUid(_tmpSTermsUid);
                        String _tmpTermsHtml = _cursor.isNull(_cursorIndexOfTermsHtml) ? null : _cursor.getString(_cursorIndexOfTermsHtml);
                        _result2.setTermsHtml(_tmpTermsHtml);
                        String _tmpSTermsLang = _cursor.isNull(_cursorIndexOfSTermsLang) ? null : _cursor.getString(_cursorIndexOfSTermsLang);
                        _result2.setSTermsLang(_tmpSTermsLang);
                        long _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
                        _result2.setSTermsLangUid(_tmpSTermsLangUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
                        boolean _tmpSTermsActive = _tmp != 0;
                        _result2.setSTermsActive(_tmpSTermsActive);
                        int _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
                        _result2.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
                        long _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
                        _result2.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
                        long _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
                        _result2.setSTermsLocalCsn(_tmpSTermsLocalCsn);
                        long _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
                        _result2.setSTermsLct(_tmpSTermsLct);
                    } else {
                        _result2 = null;
                    }
                    SiteTerms siteTerms = _result2;
                    return siteTerms;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<SiteTerms>> findAllTermsAsListFlow(int activeOnly) {
        String _sql = "\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE ? = 0 \n            OR CAST(sTermsActive AS INTEGER) = 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE ? = 0 \n            OR CAST(sTermsActive AS INTEGER) = 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)activeOnly);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"SiteTerms"}, (Callable)new Callable<List<SiteTerms>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<SiteTerms> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SiteTermsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsUid");
                    int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"termsHtml");
                    int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLang");
                    int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLangUid");
                    int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsActive");
                    int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLastChangedBy");
                    int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsPrimaryCsn");
                    int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLocalCsn");
                    int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLct");
                    ArrayList<SiteTerms> _result2 = new ArrayList<SiteTerms>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        SiteTerms _item = new SiteTerms();
                        long _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
                        _item.setSTermsUid(_tmpSTermsUid);
                        String _tmpTermsHtml = _cursor.isNull(_cursorIndexOfTermsHtml) ? null : _cursor.getString(_cursorIndexOfTermsHtml);
                        _item.setTermsHtml(_tmpTermsHtml);
                        String _tmpSTermsLang = _cursor.isNull(_cursorIndexOfSTermsLang) ? null : _cursor.getString(_cursorIndexOfSTermsLang);
                        _item.setSTermsLang(_tmpSTermsLang);
                        long _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
                        _item.setSTermsLangUid(_tmpSTermsLangUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
                        boolean _tmpSTermsActive = _tmp != 0;
                        _item.setSTermsActive(_tmpSTermsActive);
                        int _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
                        _item.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
                        long _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
                        _item.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
                        long _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
                        _item.setSTermsLocalCsn(_tmpSTermsLocalCsn);
                        long _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
                        _item.setSTermsLct(_tmpSTermsLct);
                        _result2.add(_item);
                    }
                    ArrayList<SiteTerms> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object findAllTerms(int activeOnly, Continuation<? super List<? extends SiteTerms>> $completion) {
        String _sql = "\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE ? = 0 \n            OR CAST(sTermsActive AS INTEGER) = 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE ? = 0 \n            OR CAST(sTermsActive AS INTEGER) = 1\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)activeOnly);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<SiteTerms>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<SiteTerms> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteTermsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsUid");
                    int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"termsHtml");
                    int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLang");
                    int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLangUid");
                    int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsActive");
                    int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLastChangedBy");
                    int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsPrimaryCsn");
                    int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLocalCsn");
                    int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLct");
                    ArrayList<SiteTerms> _result2 = new ArrayList<SiteTerms>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        SiteTerms _item = new SiteTerms();
                        long _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
                        _item.setSTermsUid(_tmpSTermsUid);
                        String _tmpTermsHtml = _cursor.isNull(_cursorIndexOfTermsHtml) ? null : _cursor.getString(_cursorIndexOfTermsHtml);
                        _item.setTermsHtml(_tmpTermsHtml);
                        String _tmpSTermsLang = _cursor.isNull(_cursorIndexOfSTermsLang) ? null : _cursor.getString(_cursorIndexOfSTermsLang);
                        _item.setSTermsLang(_tmpSTermsLang);
                        long _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
                        _item.setSTermsLangUid(_tmpSTermsLangUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
                        boolean _tmpSTermsActive = _tmp != 0;
                        _item.setSTermsActive(_tmpSTermsActive);
                        int _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
                        _item.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
                        long _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
                        _item.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
                        long _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
                        _item.setSTermsLocalCsn(_tmpSTermsLocalCsn);
                        long _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
                        _item.setSTermsLct(_tmpSTermsLct);
                        _result2.add(_item);
                    }
                    ArrayList<SiteTerms> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAllWithLanguageAsList(Continuation<? super List<SiteTermsWithLanguage>> $completion) {
        String _sql = "SELECT SiteTerms.*, Language.*\n        FROM SiteTerms\n        LEFT JOIN Language ON SiteTerms.sTermsLangUid = Language.langUid\n        WHERE CAST(sTermsActive AS INTEGER) = 1\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT SiteTerms.*, Language.*\n        FROM SiteTerms\n        LEFT JOIN Language ON SiteTerms.sTermsLangUid = Language.langUid\n        WHERE CAST(sTermsActive AS INTEGER) = 1\n    ", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<SiteTermsWithLanguage>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<SiteTermsWithLanguage> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteTermsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsUid");
                    int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"termsHtml");
                    int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLang");
                    int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLangUid");
                    int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsActive");
                    int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLastChangedBy");
                    int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsPrimaryCsn");
                    int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLocalCsn");
                    int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLct");
                    int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
                    int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
                    int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
                    int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
                    int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
                    int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
                    int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
                    int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
                    int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
                    ArrayList<SiteTermsWithLanguage> _result2 = new ArrayList<SiteTermsWithLanguage>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Language _tmpStLanguage;
                        if (!(_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
                            _tmpStLanguage = new Language();
                            long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                            _tmpStLanguage.setLangUid(_tmpLangUid);
                            String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                            _tmpStLanguage.setName(_tmpName);
                            String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                            _tmpStLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
                            String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                            _tmpStLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
                            String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                            _tmpStLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
                            String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                            _tmpStLanguage.setLanguage_Type(_tmpLanguage_Type);
                            int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                            boolean _tmpLanguageActive = _tmp != 0;
                            _tmpStLanguage.setLanguageActive(_tmpLanguageActive);
                            long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                            _tmpStLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                            long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                            _tmpStLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                            int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                            _tmpStLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
                            long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                            _tmpStLanguage.setLangLct(_tmpLangLct);
                        } else {
                            _tmpStLanguage = null;
                        }
                        SiteTermsWithLanguage _item = new SiteTermsWithLanguage();
                        long _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
                        _item.setSTermsUid(_tmpSTermsUid);
                        String _tmpTermsHtml = _cursor.isNull(_cursorIndexOfTermsHtml) ? null : _cursor.getString(_cursorIndexOfTermsHtml);
                        _item.setTermsHtml(_tmpTermsHtml);
                        String _tmpSTermsLang = _cursor.isNull(_cursorIndexOfSTermsLang) ? null : _cursor.getString(_cursorIndexOfSTermsLang);
                        _item.setSTermsLang(_tmpSTermsLang);
                        long _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
                        _item.setSTermsLangUid(_tmpSTermsLangUid);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSTermsActive);
                        boolean _tmpSTermsActive = _tmp_1 != 0;
                        _item.setSTermsActive(_tmpSTermsActive);
                        int _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
                        _item.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
                        long _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
                        _item.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
                        long _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
                        _item.setSTermsLocalCsn(_tmpSTermsLocalCsn);
                        long _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
                        _item.setSTermsLct(_tmpSTermsLct);
                        _item.setStLanguage(_tmpStLanguage);
                        _result2.add(_item);
                    }
                    ArrayList<SiteTermsWithLanguage> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findAvailableSiteTermLanguages(int active, Continuation<? super List<String>> $completion) {
        String _sql = "\n        SELECT SiteTerms.sTermsLang\n          FROM SiteTerms\n         WHERE CAST(SiteTerms.sTermsActive AS INTEGER) = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SiteTerms.sTermsLang\n          FROM SiteTerms\n         WHERE CAST(SiteTerms.sTermsActive AS INTEGER) = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)active);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<String> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteTermsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ArrayList<String> _result2 = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                        _result2.add(_item);
                    }
                    ArrayList<String> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findLatestByLanguage(String lang, Continuation<? super SiteTerms> $completion) {
        String _sql = "\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE SiteTerms.sTermsLang = ?\n           AND CAST(SiteTerms.sTermsActive AS INTEGER) = 1\n      ORDER BY SiteTerms.sTermsLct DESC\n         LIMIT 1     \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SiteTerms.*\n          FROM SiteTerms\n         WHERE SiteTerms.sTermsLang = ?\n           AND CAST(SiteTerms.sTermsActive AS INTEGER) = 1\n      ORDER BY SiteTerms.sTermsLct DESC\n         LIMIT 1     \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, lang);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<SiteTerms>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public SiteTerms call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SiteTermsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SiteTerms _result2;
                    int _cursorIndexOfSTermsUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsUid");
                    int _cursorIndexOfTermsHtml = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"termsHtml");
                    int _cursorIndexOfSTermsLang = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLang");
                    int _cursorIndexOfSTermsLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLangUid");
                    int _cursorIndexOfSTermsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsActive");
                    int _cursorIndexOfSTermsLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLastChangedBy");
                    int _cursorIndexOfSTermsPrimaryCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsPrimaryCsn");
                    int _cursorIndexOfSTermsLocalCsn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLocalCsn");
                    int _cursorIndexOfSTermsLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sTermsLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new SiteTerms();
                        long _tmpSTermsUid = _cursor.getLong(_cursorIndexOfSTermsUid);
                        _result2.setSTermsUid(_tmpSTermsUid);
                        String _tmpTermsHtml = _cursor.isNull(_cursorIndexOfTermsHtml) ? null : _cursor.getString(_cursorIndexOfTermsHtml);
                        _result2.setTermsHtml(_tmpTermsHtml);
                        String _tmpSTermsLang = _cursor.isNull(_cursorIndexOfSTermsLang) ? null : _cursor.getString(_cursorIndexOfSTermsLang);
                        _result2.setSTermsLang(_tmpSTermsLang);
                        long _tmpSTermsLangUid = _cursor.getLong(_cursorIndexOfSTermsLangUid);
                        _result2.setSTermsLangUid(_tmpSTermsLangUid);
                        int _tmp = _cursor.getInt(_cursorIndexOfSTermsActive);
                        boolean _tmpSTermsActive = _tmp != 0;
                        _result2.setSTermsActive(_tmpSTermsActive);
                        int _tmpSTermsLastChangedBy = _cursor.getInt(_cursorIndexOfSTermsLastChangedBy);
                        _result2.setSTermsLastChangedBy(_tmpSTermsLastChangedBy);
                        long _tmpSTermsPrimaryCsn = _cursor.getLong(_cursorIndexOfSTermsPrimaryCsn);
                        _result2.setSTermsPrimaryCsn(_tmpSTermsPrimaryCsn);
                        long _tmpSTermsLocalCsn = _cursor.getLong(_cursorIndexOfSTermsLocalCsn);
                        _result2.setSTermsLocalCsn(_tmpSTermsLocalCsn);
                        long _tmpSTermsLct = _cursor.getLong(_cursorIndexOfSTermsLct);
                        _result2.setSTermsLct(_tmpSTermsLct);
                    } else {
                        _result2 = null;
                    }
                    SiteTerms siteTerms = _result2;
                    return siteTerms;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

