/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.CharStringCommand$Type1KeyWord;
import org.apache.fontbox.cff.CharStringCommand$Type2KeyWord;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.type1.Type1CharStringReader;

public class Type2CharString
extends Type1CharString {
    private float defWidthX = 0.0f;
    private float nominalWidthX = 0.0f;
    private int pathCount = 0;
    private final int gid;

    public Type2CharString(Type1CharStringReader type1CharStringReader, String string, String string2, int n, List<Object> list, int n2, int n3) {
        super(type1CharStringReader, string, string2);
        this.gid = n;
        this.defWidthX = n2;
        this.nominalWidthX = n3;
        this.convertType1ToType2(list);
    }

    public int getGID() {
        return this.gid;
    }

    private void convertType1ToType2(List<Object> list) {
        this.pathCount = 0;
        ArrayList arrayList = new ArrayList();
        list.forEach(list2 -> {
            if (list2 instanceof CharStringCommand) {
                list2 = this.convertType2Command(arrayList, (CharStringCommand)((Object)list2));
                arrayList.clear();
                arrayList.addAll(list2);
                return;
            }
            arrayList.add((Number)((Object)list2));
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private List<Number> convertType2Command(List<Number> list, CharStringCommand list2) {
        CharStringCommand$Type2KeyWord charStringCommand$Type2KeyWord = ((CharStringCommand)((Object)list2)).getType2KeyWord();
        if (charStringCommand$Type2KeyWord == null) {
            this.addCommand(list, (CharStringCommand)((Object)list2));
            return Collections.emptyList();
        }
        switch (charStringCommand$Type2KeyWord) {
            case HSTEM: 
            case HSTEMHM: 
            case VSTEM: 
            case VSTEMHM: 
            case HINTMASK: 
            case CNTRMASK: {
                List<Number> list3 = list;
                list = this.clearStack(list3, list3.size() % 2 != 0);
                this.expandStemHints(list, charStringCommand$Type2KeyWord == CharStringCommand$Type2KeyWord.HSTEM || charStringCommand$Type2KeyWord == CharStringCommand$Type2KeyWord.HSTEMHM);
                return Collections.emptyList();
            }
            case HMOVETO: 
            case VMOVETO: {
                List<Number> list4 = list;
                list = this.clearStack(list4, list4.size() > 1);
                this.markPath();
                break;
            }
            case RLINETO: {
                this.addCommandList(Type2CharString.split(list, 2), (CharStringCommand)((Object)list2));
                return Collections.emptyList();
            }
            case HLINETO: 
            case VLINETO: {
                this.addAlternatingLine(list, charStringCommand$Type2KeyWord == CharStringCommand$Type2KeyWord.HLINETO);
                return Collections.emptyList();
            }
            case RRCURVETO: {
                this.addCommandList(Type2CharString.split(list, 6), (CharStringCommand)((Object)list2));
                return Collections.emptyList();
            }
            case ENDCHAR: {
                List<Number> list5 = list;
                list = this.clearStack(list5, list5.size() == 5 || list.size() == 1);
                this.closeCharString2Path();
                if (list.size() == 4) {
                    list.add(0, 0);
                    this.addCommand(list, CharStringCommand.getInstance(12, 6));
                    return Collections.emptyList();
                }
                this.addCommand(list, (CharStringCommand)((Object)list2));
                return Collections.emptyList();
            }
            case RMOVETO: {
                List<Number> list6 = list;
                list = this.clearStack(list6, list6.size() > 2);
                this.markPath();
                break;
            }
            case HVCURVETO: 
            case VHCURVETO: {
                this.addAlternatingCurve(list, charStringCommand$Type2KeyWord == CharStringCommand$Type2KeyWord.HVCURVETO);
                return Collections.emptyList();
            }
            case HFLEX: {
                if (list.size() < 7) return Collections.emptyList();
                list2 = Arrays.asList(list.get(0), 0, list.get(1), list.get(2), list.get(3), 0);
                List<Number> list7 = Arrays.asList(list.get(4), 0, list.get(5), Float.valueOf(-list.get(2).floatValue()), list.get(6), 0);
                this.addCommandList(Arrays.asList(list2, list7), CharStringCommand.COMMAND_RRCURVETO);
                return Collections.emptyList();
            }
            case FLEX: {
                list2 = list.subList(0, 6);
                List<Number> list8 = list.subList(6, 12);
                this.addCommandList(Arrays.asList(list2, list8), CharStringCommand.COMMAND_RRCURVETO);
                return Collections.emptyList();
            }
            case HFLEX1: {
                if (list.size() < 9) return Collections.emptyList();
                list2 = Arrays.asList(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), 0);
                List<Number> list9 = Arrays.asList(list.get(5), 0, list.get(6), list.get(7), list.get(8), 0);
                this.addCommandList(Arrays.asList(list2, list9), CharStringCommand.COMMAND_RRCURVETO);
                return Collections.emptyList();
            }
            case FLEX1: {
                void var3_9;
                int n = 0;
                boolean bl = false;
                for (int i = 0; i < 5; n += list.get(i << 1).intValue(), var3_9 += list.get((i << 1) + 1).intValue(), ++i) {
                }
                List<Number> list10 = list.subList(0, 6);
                boolean bl2 = Math.abs(n) > Math.abs((int)var3_9);
                list = Arrays.asList(list.get(6), list.get(7), list.get(8), list.get(9), bl2 ? (Number)list.get(10) : (Number)(-n), bl2 ? (Number)((int)(-var3_9)) : (Number)list.get(10));
                this.addCommandList(Arrays.asList(list10, list), CharStringCommand.COMMAND_RRCURVETO);
                return Collections.emptyList();
            }
            case RCURVELINE: {
                if (list.size() < 2) return Collections.emptyList();
                this.addCommandList(Type2CharString.split(list.subList(0, list.size() - 2), 6), CharStringCommand.COMMAND_RRCURVETO);
                List<Number> list11 = list;
                this.addCommand(list11.subList(list11.size() - 2, list.size()), CharStringCommand.COMMAND_RLINETO);
                return Collections.emptyList();
            }
            case RLINECURVE: {
                if (list.size() < 6) return Collections.emptyList();
                this.addCommandList(Type2CharString.split(list.subList(0, list.size() - 6), 2), CharStringCommand.COMMAND_RLINETO);
                List<Number> list12 = list;
                this.addCommand(list12.subList(list12.size() - 6, list.size()), CharStringCommand.COMMAND_RRCURVETO);
                return Collections.emptyList();
            }
            case HHCURVETO: 
            case VVCURVETO: {
                this.addCurve(list, charStringCommand$Type2KeyWord == CharStringCommand$Type2KeyWord.HHCURVETO);
                return Collections.emptyList();
            }
        }
        this.addCommand(list, (CharStringCommand)((Object)list2));
        return Collections.emptyList();
    }

    private List<Number> clearStack(List<Number> list, boolean bl) {
        if (this.isSequenceEmpty()) {
            if (bl) {
                this.addCommand(Arrays.asList(0, Float.valueOf(list.get(0).floatValue() + this.nominalWidthX)), CharStringCommand.COMMAND_HSBW);
                list = list.subList(1, list.size());
            } else {
                this.addCommand(Arrays.asList(0, Float.valueOf(this.defWidthX)), CharStringCommand.COMMAND_HSBW);
            }
        }
        return list;
    }

    private void expandStemHints(List<Number> list, boolean bl) {
    }

    private void markPath() {
        if (this.pathCount > 0) {
            this.closeCharString2Path();
        }
        ++this.pathCount;
    }

    private void closeCharString2Path() {
        CharStringCommand charStringCommand = this.pathCount > 0 ? (CharStringCommand)this.getLastSequenceEntry() : null;
        if (charStringCommand != null && charStringCommand.getType1KeyWord() != CharStringCommand$Type1KeyWord.CLOSEPATH) {
            this.addCommand(Collections.emptyList(), CharStringCommand.COMMAND_CLOSEPATH);
        }
    }

    private void addAlternatingLine(List<Number> list, boolean bl) {
        while (!list.isEmpty()) {
            this.addCommand(list.subList(0, 1), bl ? CharStringCommand.COMMAND_HLINETO : CharStringCommand.COMMAND_VLINETO);
            list = list.subList(1, list.size());
            bl = !bl;
        }
    }

    private void addAlternatingCurve(List<Number> list, boolean bl) {
        while (list.size() >= 4) {
            Number number;
            int n;
            Number[] numberArray;
            Number[] numberArray2;
            Type2CharString type2CharString;
            boolean bl2;
            boolean bl3 = bl2 = list.size() == 5;
            if (bl) {
                type2CharString = this;
                Number[] numberArray3 = new Number[6];
                numberArray3[0] = list.get(0);
                numberArray3[1] = 0;
                numberArray3[2] = list.get(1);
                numberArray3[3] = list.get(2);
                numberArray3[4] = bl2 ? (Number)list.get(4) : (Number)0;
                numberArray2 = numberArray3;
                numberArray = numberArray3;
                n = 5;
                number = list.get(3);
            } else {
                type2CharString = this;
                Number[] numberArray4 = new Number[6];
                numberArray4[0] = 0;
                numberArray4[1] = list.get(0);
                numberArray4[2] = list.get(1);
                numberArray4[3] = list.get(2);
                numberArray4[4] = list.get(3);
                numberArray2 = numberArray4;
                numberArray = numberArray4;
                n = 5;
                number = bl2 ? (Number)list.get(4) : (Number)0;
            }
            numberArray2[n] = number;
            type2CharString.addCommand(Arrays.asList(numberArray), CharStringCommand.COMMAND_RRCURVETO);
            list = list.subList(bl2 ? 5 : 4, list.size());
            bl = !bl;
        }
    }

    private void addCurve(List<Number> list, boolean bl) {
        while (list.size() >= 4) {
            boolean bl2;
            boolean bl3 = bl2 = list.size() % 4 == 1;
            if (bl) {
                this.addCommand(Arrays.asList(list.get(bl2 ? 1 : 0), bl2 ? (Number)list.get(0) : (Number)0, list.get(bl2 ? 2 : 1), list.get(bl2 ? 3 : 2), list.get(bl2 ? 4 : 3), 0), CharStringCommand.COMMAND_RRCURVETO);
            } else {
                this.addCommand(Arrays.asList(bl2 ? (Number)list.get(0) : (Number)0, list.get(bl2 ? 1 : 0), list.get(bl2 ? 2 : 1), list.get(bl2 ? 3 : 2), 0, list.get(bl2 ? 4 : 3)), CharStringCommand.COMMAND_RRCURVETO);
            }
            list = list.subList(bl2 ? 5 : 4, list.size());
        }
    }

    private void addCommandList(List<List<Number>> list2, CharStringCommand charStringCommand) {
        list2.forEach(list -> this.addCommand((List<Number>)list, charStringCommand));
    }

    private static <E> List<List<E>> split(List<E> list, int n) {
        int n2 = list.size() / n;
        ArrayList<List<List<E>>> arrayList = new ArrayList<List<List<E>>>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(list.subList(i * n, (i + 1) * n));
        }
        return arrayList;
    }
}

