/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.TransferJobErrorDao;
import com.ustadmobile.lib.db.entities.TransferJobError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class TransferJobErrorDao_Impl
extends TransferJobErrorDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TransferJobError> __insertionAdapterOfTransferJobError;
    private final SharedSQLiteStatement __preparedStmtOfDismissErrorByJobId;

    public TransferJobErrorDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTransferJobError = new EntityInsertionAdapter<TransferJobError>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `TransferJobError` (`tjeId`,`tjeTjUid`,`tjeTime`,`tjeErrorStr`,`tjeDismissed`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull TransferJobError entity) {
                statement.bindLong(1, (long)entity.getTjeId());
                statement.bindLong(2, (long)entity.getTjeTjUid());
                statement.bindLong(3, entity.getTjeTime());
                if (entity.getTjeErrorStr() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getTjeErrorStr());
                }
                int _tmp = entity.getTjeDismissed() ? 1 : 0;
                statement.bindLong(5, (long)_tmp);
            }
        };
        this.__preparedStmtOfDismissErrorByJobId = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE TransferJobError\n           SET tjeDismissed = ?\n         WHERE TransferJobError.tjeTjUid = ?  \n    ";
                return "\n        UPDATE TransferJobError\n           SET tjeDismissed = ?\n         WHERE TransferJobError.tjeTjUid = ?  \n    ";
            }
        };
    }

    @Override
    public Object insertAsync(final TransferJobError error, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                TransferJobErrorDao_Impl.this.__db.beginTransaction();
                try {
                    TransferJobErrorDao_Impl.this.__insertionAdapterOfTransferJobError.insert((Object)error);
                    TransferJobErrorDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TransferJobErrorDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object dismissErrorByJobId(final int jobUid, final boolean dismissed, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TransferJobErrorDao_Impl.this.__preparedStmtOfDismissErrorByJobId.acquire();
                int _argIndex = 1;
                int _tmp = dismissed ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)jobUid);
                try {
                    Unit unit;
                    TransferJobErrorDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        TransferJobErrorDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        TransferJobErrorDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    TransferJobErrorDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    TransferJobErrorDao_Impl.this.__preparedStmtOfDismissErrorByJobId.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByJobId(int jobUid, Continuation<? super List<TransferJobError>> $completion) {
        String _sql = "\n        SELECT TransferJobError.*\n          FROM TransferJobError\n         WHERE TransferJobError.tjeTjUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT TransferJobError.*\n          FROM TransferJobError\n         WHERE TransferJobError.tjeTjUid = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)jobUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<TransferJobError>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<TransferJobError> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TransferJobErrorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfTjeId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjeId");
                    int _cursorIndexOfTjeTjUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjeTjUid");
                    int _cursorIndexOfTjeTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjeTime");
                    int _cursorIndexOfTjeErrorStr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjeErrorStr");
                    int _cursorIndexOfTjeDismissed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tjeDismissed");
                    ArrayList<TransferJobError> _result2 = new ArrayList<TransferJobError>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpTjeId = _cursor.getInt(_cursorIndexOfTjeId);
                        int _tmpTjeTjUid = _cursor.getInt(_cursorIndexOfTjeTjUid);
                        long _tmpTjeTime = _cursor.getLong(_cursorIndexOfTjeTime);
                        String _tmpTjeErrorStr = _cursor.isNull(_cursorIndexOfTjeErrorStr) ? null : _cursor.getString(_cursorIndexOfTjeErrorStr);
                        int _tmp = _cursor.getInt(_cursorIndexOfTjeDismissed);
                        boolean _tmpTjeDismissed = _tmp != 0;
                        TransferJobError _item = new TransferJobError(_tmpTjeId, _tmpTjeTjUid, _tmpTjeTime, _tmpTjeErrorStr, _tmpTjeDismissed);
                        _result2.add(_item);
                    }
                    ArrayList<TransferJobError> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

