/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.StateEntityDao;
import com.ustadmobile.lib.db.composites.xapi.StateIdAndLastModified;
import com.ustadmobile.lib.db.entities.xapi.StateEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class StateEntityDao_Impl
extends StateEntityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<StateEntity> __insertionAdapterOfStateEntity;

    public StateEntityDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfStateEntity = new EntityInsertionAdapter<StateEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `StateEntity` (`seActorUid`,`seHash`,`seActivityUid`,`seStateId`,`seLastMod`,`seTimeStored`,`seContentType`,`seCompressed`,`seContent`,`seDeleted`,`seRegistrationHi`,`seRegistrationLo`,`seH5PPreloaded`,`seH5PSubContentId`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull StateEntity entity) {
                statement.bindLong(1, entity.getSeActorUid());
                statement.bindLong(2, entity.getSeHash());
                statement.bindLong(3, entity.getSeActivityUid());
                statement.bindString(4, entity.getSeStateId());
                statement.bindLong(5, entity.getSeLastMod());
                statement.bindLong(6, entity.getSeTimeStored());
                statement.bindString(7, entity.getSeContentType());
                statement.bindLong(8, (long)entity.getSeCompressed());
                statement.bindString(9, entity.getSeContent());
                int _tmp = entity.getSeDeleted() ? 1 : 0;
                statement.bindLong(10, (long)_tmp);
                if (entity.getSeRegistrationHi() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindLong(11, entity.getSeRegistrationHi().longValue());
                }
                if (entity.getSeRegistrationLo() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindLong(12, entity.getSeRegistrationLo().longValue());
                }
                int _tmp_1 = entity.getSeH5PPreloaded() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_1);
                if (entity.getSeH5PSubContentId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindString(14, entity.getSeH5PSubContentId());
                }
            }
        };
    }

    @Override
    public Object upsertAsync(final List<StateEntity> stateEntities, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                StateEntityDao_Impl.this.__db.beginTransaction();
                try {
                    StateEntityDao_Impl.this.__insertionAdapterOfStateEntity.insert((Iterable)stateEntities);
                    StateEntityDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    StateEntityDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByActorAndHash(long accountPersonUid, long actorUid, long seHash, boolean includeDeleted, Continuation<? super StateEntity> $completion) {
        String _sql = "\n        SELECT StateEntity.*\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seHash = ?\n           AND (   CAST(? AS INTEGER) = 1 \n                OR CAST(StateEntity.seDeleted AS INTEGER) = 0)\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StateEntity.*\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seHash = ?\n           AND (   CAST(? AS INTEGER) = 1 \n                OR CAST(StateEntity.seDeleted AS INTEGER) = 0)\n    ", (int)5);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, seHash);
        _argIndex = 5;
        int _tmp = includeDeleted ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<StateEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public StateEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StateEntityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    StateEntity _result2;
                    int _cursorIndexOfSeActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seActorUid");
                    int _cursorIndexOfSeHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seHash");
                    int _cursorIndexOfSeActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seActivityUid");
                    int _cursorIndexOfSeStateId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seStateId");
                    int _cursorIndexOfSeLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seLastMod");
                    int _cursorIndexOfSeTimeStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seTimeStored");
                    int _cursorIndexOfSeContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seContentType");
                    int _cursorIndexOfSeCompressed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seCompressed");
                    int _cursorIndexOfSeContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seContent");
                    int _cursorIndexOfSeDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seDeleted");
                    int _cursorIndexOfSeRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seRegistrationHi");
                    int _cursorIndexOfSeRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seRegistrationLo");
                    int _cursorIndexOfSeH5PPreloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seH5PPreloaded");
                    int _cursorIndexOfSeH5PSubContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seH5PSubContentId");
                    if (_cursor.moveToFirst()) {
                        long _tmpSeActorUid = _cursor.getLong(_cursorIndexOfSeActorUid);
                        long _tmpSeHash = _cursor.getLong(_cursorIndexOfSeHash);
                        long _tmpSeActivityUid = _cursor.getLong(_cursorIndexOfSeActivityUid);
                        String _tmpSeStateId = _cursor.getString(_cursorIndexOfSeStateId);
                        long _tmpSeLastMod = _cursor.getLong(_cursorIndexOfSeLastMod);
                        long _tmpSeTimeStored = _cursor.getLong(_cursorIndexOfSeTimeStored);
                        String _tmpSeContentType = _cursor.getString(_cursorIndexOfSeContentType);
                        int _tmpSeCompressed = _cursor.getInt(_cursorIndexOfSeCompressed);
                        String _tmpSeContent = _cursor.getString(_cursorIndexOfSeContent);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSeDeleted);
                        boolean _tmpSeDeleted = _tmp_1 != 0;
                        Long _tmpSeRegistrationHi = _cursor.isNull(_cursorIndexOfSeRegistrationHi) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfSeRegistrationHi));
                        Long _tmpSeRegistrationLo = _cursor.isNull(_cursorIndexOfSeRegistrationLo) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfSeRegistrationLo));
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfSeH5PPreloaded);
                        boolean _tmpSeH5PPreloaded = _tmp_2 != 0;
                        String _tmpSeH5PSubContentId = _cursor.isNull(_cursorIndexOfSeH5PSubContentId) ? null : _cursor.getString(_cursorIndexOfSeH5PSubContentId);
                        _result2 = new StateEntity(_tmpSeActorUid, _tmpSeHash, _tmpSeActivityUid, _tmpSeStateId, _tmpSeLastMod, _tmpSeTimeStored, _tmpSeContentType, _tmpSeCompressed, _tmpSeContent, _tmpSeDeleted, _tmpSeRegistrationHi, _tmpSeRegistrationLo, _tmpSeH5PPreloaded, _tmpSeH5PSubContentId);
                    } else {
                        _result2 = null;
                    }
                    StateEntity stateEntity = _result2;
                    return stateEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object findByAgentAndActivity(long accountPersonUid, long actorUid, long seActivityUid, Long registrationUuidHi, Long registrationUuidLo, long modifiedSince, Continuation<? super List<StateEntity>> $completion) {
        String _sql = "\n        SELECT StateEntity.*\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seActivityUid = ?\n           AND (? = 0 OR StateEntity.seLastMod > ?)\n           AND ((    ? IS NULL\n                 AND StateEntity.seRegistrationHi IS NULL\n                 AND ? IS NULL \n                 AND StateEntity.seRegistrationLo IS NULL)\n             OR (    StateEntity.seRegistrationHi = ? \n                 AND StateEntity.seRegistrationLo = ?))\n           AND StateEntity.seStateId IS NOT NULL  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StateEntity.*\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seActivityUid = ?\n           AND (? = 0 OR StateEntity.seLastMod > ?)\n           AND ((    ? IS NULL\n                 AND StateEntity.seRegistrationHi IS NULL\n                 AND ? IS NULL \n                 AND StateEntity.seRegistrationLo IS NULL)\n             OR (    StateEntity.seRegistrationHi = ? \n                 AND StateEntity.seRegistrationLo = ?))\n           AND StateEntity.seStateId IS NOT NULL  \n    ", (int)10);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, seActivityUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, modifiedSince);
        _argIndex = 6;
        _statement.bindLong(_argIndex, modifiedSince);
        _argIndex = 7;
        if (registrationUuidHi == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidHi.longValue());
        }
        _argIndex = 8;
        if (registrationUuidLo == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidLo.longValue());
        }
        _argIndex = 9;
        if (registrationUuidHi == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidHi.longValue());
        }
        _argIndex = 10;
        if (registrationUuidLo == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidLo.longValue());
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StateEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StateEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StateEntityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSeActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seActorUid");
                    int _cursorIndexOfSeHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seHash");
                    int _cursorIndexOfSeActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seActivityUid");
                    int _cursorIndexOfSeStateId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seStateId");
                    int _cursorIndexOfSeLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seLastMod");
                    int _cursorIndexOfSeTimeStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seTimeStored");
                    int _cursorIndexOfSeContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seContentType");
                    int _cursorIndexOfSeCompressed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seCompressed");
                    int _cursorIndexOfSeContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seContent");
                    int _cursorIndexOfSeDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seDeleted");
                    int _cursorIndexOfSeRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seRegistrationHi");
                    int _cursorIndexOfSeRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seRegistrationLo");
                    int _cursorIndexOfSeH5PPreloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seH5PPreloaded");
                    int _cursorIndexOfSeH5PSubContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seH5PSubContentId");
                    ArrayList<StateEntity> _result2 = new ArrayList<StateEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpSeActorUid = _cursor.getLong(_cursorIndexOfSeActorUid);
                        long _tmpSeHash = _cursor.getLong(_cursorIndexOfSeHash);
                        long _tmpSeActivityUid = _cursor.getLong(_cursorIndexOfSeActivityUid);
                        String _tmpSeStateId = _cursor.getString(_cursorIndexOfSeStateId);
                        long _tmpSeLastMod = _cursor.getLong(_cursorIndexOfSeLastMod);
                        long _tmpSeTimeStored = _cursor.getLong(_cursorIndexOfSeTimeStored);
                        String _tmpSeContentType = _cursor.getString(_cursorIndexOfSeContentType);
                        int _tmpSeCompressed = _cursor.getInt(_cursorIndexOfSeCompressed);
                        String _tmpSeContent = _cursor.getString(_cursorIndexOfSeContent);
                        int _tmp = _cursor.getInt(_cursorIndexOfSeDeleted);
                        boolean _tmpSeDeleted = _tmp != 0;
                        Long _tmpSeRegistrationHi = _cursor.isNull(_cursorIndexOfSeRegistrationHi) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfSeRegistrationHi));
                        Long _tmpSeRegistrationLo = _cursor.isNull(_cursorIndexOfSeRegistrationLo) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfSeRegistrationLo));
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSeH5PPreloaded);
                        boolean _tmpSeH5PPreloaded = _tmp_1 != 0;
                        String _tmpSeH5PSubContentId = _cursor.isNull(_cursorIndexOfSeH5PSubContentId) ? null : _cursor.getString(_cursorIndexOfSeH5PSubContentId);
                        StateEntity _item = new StateEntity(_tmpSeActorUid, _tmpSeHash, _tmpSeActivityUid, _tmpSeStateId, _tmpSeLastMod, _tmpSeTimeStored, _tmpSeContentType, _tmpSeCompressed, _tmpSeContent, _tmpSeDeleted, _tmpSeRegistrationHi, _tmpSeRegistrationLo, _tmpSeH5PPreloaded, _tmpSeH5PSubContentId);
                        _result2.add(_item);
                    }
                    ArrayList<StateEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getStateIds(long accountPersonUid, long actorUid, long seActivityUid, Long registrationUuidHi, Long registrationUuidLo, long modifiedSince, Continuation<? super List<StateIdAndLastModified>> $completion) {
        String _sql = "\n        SELECT StateEntity.seStateId, StateEntity.seLastMod\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seActivityUid = ?\n           AND (? = 0 OR StateEntity.seLastMod > ?)\n           AND ((    ? IS NULL\n                 AND StateEntity.seRegistrationHi IS NULL\n                 AND ? IS NULL \n                 AND StateEntity.seRegistrationLo IS NULL)\n             OR (    StateEntity.seRegistrationHi = ? \n                 AND StateEntity.seRegistrationLo = ?))\n           AND StateEntity.seStateId IS NOT NULL \n           AND CAST(StateEntity.seDeleted AS INTEGER) = 0      \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StateEntity.seStateId, StateEntity.seLastMod\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seActivityUid = ?\n           AND (? = 0 OR StateEntity.seLastMod > ?)\n           AND ((    ? IS NULL\n                 AND StateEntity.seRegistrationHi IS NULL\n                 AND ? IS NULL \n                 AND StateEntity.seRegistrationLo IS NULL)\n             OR (    StateEntity.seRegistrationHi = ? \n                 AND StateEntity.seRegistrationLo = ?))\n           AND StateEntity.seStateId IS NOT NULL \n           AND CAST(StateEntity.seDeleted AS INTEGER) = 0      \n    ", (int)10);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, seActivityUid);
        _argIndex = 5;
        _statement.bindLong(_argIndex, modifiedSince);
        _argIndex = 6;
        _statement.bindLong(_argIndex, modifiedSince);
        _argIndex = 7;
        if (registrationUuidHi == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidHi.longValue());
        }
        _argIndex = 8;
        if (registrationUuidLo == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidLo.longValue());
        }
        _argIndex = 9;
        if (registrationUuidHi == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidHi.longValue());
        }
        _argIndex = 10;
        if (registrationUuidLo == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidLo.longValue());
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StateIdAndLastModified>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StateIdAndLastModified> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StateEntityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfSeStateId = false;
                    boolean _cursorIndexOfSeLastMod = true;
                    ArrayList<StateIdAndLastModified> _result2 = new ArrayList<StateIdAndLastModified>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpSeStateId = _cursor.getString(0);
                        long _tmpSeLastMod = _cursor.getLong(1);
                        StateIdAndLastModified _item = new StateIdAndLastModified(_tmpSeStateId, _tmpSeLastMod);
                        _result2.add(_item);
                    }
                    ArrayList<StateIdAndLastModified> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object getH5PPreload(long accountPersonUid, long actorUid, long seActivityUid, Long registrationUuidHi, Long registrationUuidLo, Continuation<? super List<StateEntity>> $completion) {
        String _sql = "\n        SELECT StateEntity.*\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seActivityUid = ? \n           AND ((    ? IS NULL\n                 AND StateEntity.seRegistrationHi IS NULL\n                 AND ? IS NULL \n                 AND StateEntity.seRegistrationLo IS NULL)\n             OR (    StateEntity.seRegistrationHi = ? \n                 AND StateEntity.seRegistrationLo = ?))\n           AND StateEntity.seH5PSubContentId IS NOT NULL      \n           AND CAST(StateEntity.seH5PPreloaded AS INTEGER) = 1      \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StateEntity.*\n          FROM StateEntity\n         WHERE (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = ?) = ?\n           AND seActorUid = ?\n           AND seActivityUid = ? \n           AND ((    ? IS NULL\n                 AND StateEntity.seRegistrationHi IS NULL\n                 AND ? IS NULL \n                 AND StateEntity.seRegistrationLo IS NULL)\n             OR (    StateEntity.seRegistrationHi = ? \n                 AND StateEntity.seRegistrationLo = ?))\n           AND StateEntity.seH5PSubContentId IS NOT NULL      \n           AND CAST(StateEntity.seH5PPreloaded AS INTEGER) = 1      \n    ", (int)8);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, actorUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, seActivityUid);
        _argIndex = 5;
        if (registrationUuidHi == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidHi.longValue());
        }
        _argIndex = 6;
        if (registrationUuidLo == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidLo.longValue());
        }
        _argIndex = 7;
        if (registrationUuidHi == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidHi.longValue());
        }
        _argIndex = 8;
        if (registrationUuidLo == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, registrationUuidLo.longValue());
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StateEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StateEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StateEntityDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfSeActorUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seActorUid");
                    int _cursorIndexOfSeHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seHash");
                    int _cursorIndexOfSeActivityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seActivityUid");
                    int _cursorIndexOfSeStateId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seStateId");
                    int _cursorIndexOfSeLastMod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seLastMod");
                    int _cursorIndexOfSeTimeStored = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seTimeStored");
                    int _cursorIndexOfSeContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seContentType");
                    int _cursorIndexOfSeCompressed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seCompressed");
                    int _cursorIndexOfSeContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seContent");
                    int _cursorIndexOfSeDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seDeleted");
                    int _cursorIndexOfSeRegistrationHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seRegistrationHi");
                    int _cursorIndexOfSeRegistrationLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seRegistrationLo");
                    int _cursorIndexOfSeH5PPreloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seH5PPreloaded");
                    int _cursorIndexOfSeH5PSubContentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"seH5PSubContentId");
                    ArrayList<StateEntity> _result2 = new ArrayList<StateEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpSeActorUid = _cursor.getLong(_cursorIndexOfSeActorUid);
                        long _tmpSeHash = _cursor.getLong(_cursorIndexOfSeHash);
                        long _tmpSeActivityUid = _cursor.getLong(_cursorIndexOfSeActivityUid);
                        String _tmpSeStateId = _cursor.getString(_cursorIndexOfSeStateId);
                        long _tmpSeLastMod = _cursor.getLong(_cursorIndexOfSeLastMod);
                        long _tmpSeTimeStored = _cursor.getLong(_cursorIndexOfSeTimeStored);
                        String _tmpSeContentType = _cursor.getString(_cursorIndexOfSeContentType);
                        int _tmpSeCompressed = _cursor.getInt(_cursorIndexOfSeCompressed);
                        String _tmpSeContent = _cursor.getString(_cursorIndexOfSeContent);
                        int _tmp = _cursor.getInt(_cursorIndexOfSeDeleted);
                        boolean _tmpSeDeleted = _tmp != 0;
                        Long _tmpSeRegistrationHi = _cursor.isNull(_cursorIndexOfSeRegistrationHi) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfSeRegistrationHi));
                        Long _tmpSeRegistrationLo = _cursor.isNull(_cursorIndexOfSeRegistrationLo) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfSeRegistrationLo));
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfSeH5PPreloaded);
                        boolean _tmpSeH5PPreloaded = _tmp_1 != 0;
                        String _tmpSeH5PSubContentId = _cursor.isNull(_cursorIndexOfSeH5PSubContentId) ? null : _cursor.getString(_cursorIndexOfSeH5PSubContentId);
                        StateEntity _item = new StateEntity(_tmpSeActorUid, _tmpSeHash, _tmpSeActivityUid, _tmpSeStateId, _tmpSeLastMod, _tmpSeTimeStored, _tmpSeContentType, _tmpSeCompressed, _tmpSeContent, _tmpSeDeleted, _tmpSeRegistrationHi, _tmpSeRegistrationLo, _tmpSeH5PPreloaded, _tmpSeH5PSubContentId);
                        _result2.add(_item);
                    }
                    ArrayList<StateEntity> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

