/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.RawQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import com.ustadmobile.lib.db.composites.BlockStatus;
import com.ustadmobile.lib.db.composites.xapi.StatementEntityAndRelated;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.StatementEntityAndDisplayDetails;
import com.ustadmobile.lib.db.entities.StatementReportData;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import com.ustadmobile.lib.db.entities.xapi.StatementEntity;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\t\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u0013J2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\t\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\nJ2\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00040\u00172\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\t\u001a\u00020\u0007H'J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u00a7@\u00a2\u0006\u0002\u0010\u001cJh\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u00a7@\u00a2\u0006\u0002\u0010'J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u000fJ,\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u0013J$\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u000fJ \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u0002000/2\n\u00101\u001a\u000602j\u0002`3H'J\u0010\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0017H'J\n\u00105\u001a\u0004\u0018\u000106H'J \u00107\u001a\b\u0012\u0004\u0012\u0002080\u00042\n\u00101\u001a\u000602j\u0002`3H\u00a7@\u00a2\u0006\u0002\u00109J$\u0010:\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u00a7@\u00a2\u0006\u0002\u0010>\u00a8\u0006?"}, d2={"Lcom/ustadmobile/core/db/dao/xapi/StatementDao;", "", "()V", "findActorEntitiesForStudentInClazzByUidList", "", "Lcom/ustadmobile/lib/db/entities/xapi/ActorEntity;", "clazzUid", "", "studentPersonUids", "accountPersonUid", "(JLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findById", "Lcom/ustadmobile/lib/db/entities/xapi/StatementEntity;", "statementIdHi", "statementIdLo", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findResumableRegistration", "activityUid", "actorUid", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findStatusForStudentsInClazz", "Lcom/ustadmobile/lib/db/composites/BlockStatus;", "findStatusForStudentsInClazzAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findStatusForStudentsInClazzByUidList", "Lcom/ustadmobile/lib/db/composites/xapi/StatementEntityAndRelated;", "completionOrProgressTrueVal", "", "(JLjava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findStatusForStudentsInClazzStatements", "roleId", "", "sortOrder", "searchText", "", "filter", "currentTime", "studentsLimit", "studentsOffset", "(JIILjava/lang/String;IJJIIZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findStatusStatementByParentContentEntryUid", "parentUid", "findStatusStatementsByContentEntryUid", "contentEntryUid", "courseBlockUid", "findStatusStatementsForStudentByClazzUid", "getListResults", "Landroidx/paging/PagingSource;", "Lcom/ustadmobile/lib/db/entities/StatementEntityAndDisplayDetails;", "query", "Landroidx/sqlite/db/SupportSQLiteQuery;", "Lcom/ustadmobile/door/DoorQuery;", "getOneStatement", "getPerson", "Lcom/ustadmobile/lib/db/entities/Person;", "getResults", "Lcom/ustadmobile/lib/db/entities/StatementReportData;", "(Landroidx/sqlite/db/SupportSQLiteQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStatements", "insertOrIgnoreListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_release"})
@Dao
public abstract class StatementDao {
    @Insert(entity=Object.class, onConflict=5)
    @Nullable
    public abstract Object insertOrIgnoreListAsync(@NotNull List<StatementEntity> var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT * From StatementEntity LIMIT 1")
    @NotNull
    public abstract Flow<StatementEntity> getOneStatement();

    @RawQuery(observedEntities={})
    @Nullable
    public abstract Object getResults(@NotNull SupportSQLiteQuery var1, @NotNull Continuation<? super List<StatementReportData>> var2);

    @RawQuery(observedEntities={StatementEntity.class, Person.class})
    @NotNull
    public abstract PagingSource<Integer, StatementEntityAndDisplayDetails> getListResults(@NotNull SupportSQLiteQuery var1);

    @Query(value="SELECT * FROM PERSON LIMIT 1")
    @Nullable
    public abstract Person getPerson();

    @Query(value="\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE (    (:statementIdHi = 0 AND :statementIdLo = 0) \n                 OR (statementIdHi = :statementIdHi AND statementIdLo = :statementIdLo))\n                  \n    ")
    @Nullable
    public abstract Object getStatements(long var1, long var3, @NotNull Continuation<? super List<StatementEntity>> var5);

    @Query(value="\n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE statementIdHi = :statementIdHi \n           AND statementIdLo = :statementIdLo       \n    ")
    @Nullable
    public abstract Object findById(long var1, long var3, @NotNull Continuation<? super StatementEntity> var5);

    @Query(value="\n        SELECT StatementEntity.*\n               \n            \n          FROM StatementEntity\n         WHERE StatementEntity.statementActorPersonUid = :accountPersonUid\n           AND StatementEntity.statementContentEntryUid = :contentEntryUid\n           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n           AND (:courseBlockUid = 0 OR StatementEntity.statementCbUid = :courseBlockUid)\n    \n        AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))\n        \n        \n    \n    ")
    @Nullable
    public abstract Object findStatusStatementsByContentEntryUid(long var1, long var3, long var5, @NotNull Continuation<? super List<StatementEntity>> var7);

    @Query(value="\n        SELECT StatementEntity.*\n               \n        FROM StatementEntity\n       WHERE StatementEntity.statementActorPersonUid = :accountPersonUid\n         AND StatementEntity.statementContentEntryUid IN (\n             SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n               FROM ContentEntryParentChildJoin\n              WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid)\n         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n         AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n              OR (StatementEntity.extensionProgress IS NOT NULL))     \n    \n    ")
    @Nullable
    public abstract Object findStatusStatementByParentContentEntryUid(long var1, long var3, @NotNull Continuation<? super List<StatementEntity>> var5);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n            SELECT :accountPersonUid AS personUid\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        SELECT StatementEntity.*\n               \n               FROM StatementEntity\n              WHERE (\n        (SELECT EXISTS(\n                SELECT 1\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n    )\n                AND StatementEntity.statementActorUid IN (\n                    SELECT ActorUidsForPersonUid.actorUid\n                      FROM ActorUidsForPersonUid)\n                AND StatementEntity.statementClazzUid = :clazzUid\n                AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n                      OR (StatementEntity.extensionProgress IS NOT NULL))\n    \n    ")
    @Nullable
    public abstract Object findStatusStatementsForStudentByClazzUid(long var1, long var3, @NotNull Continuation<? super List<StatementEntity>> var5);

    @Query(value="\n        -- Get the PersonUids for those that are within the current page as per studentsLimit and \n        -- studentsOffset\n        WITH \n        PersonUids(personUid) AS (\n            SELECT CourseMember.personUid \n              FROM (SELECT Person.*,\n                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n            \n                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n            \n                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n                              FROM ClazzEnrolment \n                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                               AND ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive\n                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n                             LIMIT 1) AS enrolmentRole\n                      FROM Person\n                     WHERE Person.personUid IN \n                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n                              FROM ClazzEnrolment \n                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                               AND ClazzEnrolment.clazzEnrolmentActive \n                               AND ClazzEnrolment.clazzEnrolmentRole = :roleId \n                               AND (:filter != 1 \n                                     OR (:currentTime \n                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n                       /* Begin permission check */\n                       AND (\n                               ((\n             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n             (COALESCE(\n                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n                             FROM Clazz _Clazz_Permission\n                            WHERE _Clazz_Permission.clazzUid = :clazzUid), 0) = :accountPersonUid)\n              /* \n              If there is a CoursePermission entity that is for the course as per the clazzUid\n              parameter that is granted to the person directly or to the enrolmentRole that the \n              person has in the course, then permission is granted.\n              */              \n              OR EXISTS(SELECT CoursePermission.cpUid\n                          FROM CoursePermission\n                               \n        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n                        ON CoursePermission.cpToEnrolmentRole != 0\n                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n                           (SELECT COALESCE(\n                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = :accountPersonUid\n                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n                                     LIMIT 1), 0))\n    \n                         WHERE CoursePermission.cpClazzUid = :clazzUid\n                           AND (CoursePermission.cpToPersonUid = :accountPersonUid \n                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n                           AND (CoursePermission.cpPermissionsFlag & \n         128\n                                \n        ) > 0)\n              OR EXISTS(SELECT SystemPermission.spUid\n                          FROM SystemPermission\n                         WHERE SystemPermission.spToPersonUid = :accountPersonUid\n                           AND (SystemPermission.spPermissionsFlag & \n     128\n                                \n        ) > 0)\n               )\n    )\n                            OR Person.personUid = :accountPersonUid\n                           )  \n                       /* End permission check */                   \n                       AND Person.firstNames || ' ' || Person.lastName LIKE :searchText\n                   GROUP BY Person.personUid) AS CourseMember\n          ORDER BY CASE(:sortOrder)\n                    WHEN 1 THEN CourseMember.firstNames\n                    WHEN 3 THEN CourseMember.lastName\n                    ELSE ''\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 2 THEN CourseMember.firstNames\n                    WHEN 4 THEN CourseMember.lastName\n                    ELSE ''\n                END DESC,\n                CASE(:sortOrder)\n                    WHEN 7 THEN CourseMember.earliestJoinDate\n                    WHEN 9 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END ASC,\n                CASE(:sortOrder)\n                    WHEN 8 THEN CourseMember.earliestJoinDate\n                    WHEN 10 THEN CourseMember.latestDateLeft\n                    ELSE 0\n                END DESC\n             LIMIT :studentsLimit\n            OFFSET :studentsOffset   \n         )\n    ,\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n\n        \n        -- Fetch all statements that could be completion or progress for the Gradebook report\n        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*\n          FROM StatementEntity\n               JOIN ActorEntity\n                    ON ActorEntity.actorUid = StatementEntity.statementActorUid\n               LEFT JOIN GroupMemberActorJoin\n                    ON ActorEntity.actorObjectType = 2\n                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                       AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                           SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                             FROM ActorUidsForPersonUid)\n         WHERE StatementEntity.statementClazzUid = :clazzUid\n           AND StatementEntity.completionOrProgress = :completionOrProgressTrueVal\n           AND StatementEntity.statementActorUid IN (\n               SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                 FROM ActorUidsForPersonUid) \n           AND (      StatementEntity.resultScoreScaled IS NOT NULL\n                   OR StatementEntity.resultCompletion IS NOT NULL\n                   OR StatementEntity.resultSuccess IS NOT NULL\n                   OR StatementEntity.extensionProgress IS NOT NULL \n               )\n    \n    ")
    @Nullable
    public abstract Object findStatusForStudentsInClazzStatements(long var1, int var3, int var4, @Nullable String var5, int var6, long var7, long var9, int var11, int var12, boolean var13, @NotNull Continuation<? super List<StatementEntityAndRelated>> var14);

    public static /* synthetic */ Object findStatusForStudentsInClazzStatements$default(StatementDao statementDao, long l, int n, int n2, String string, int n3, long l2, long l3, int n4, int n5, boolean bl, Continuation continuation, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findStatusForStudentsInClazzStatements");
        }
        if ((n6 & 8) != 0) {
            string = "%";
        }
        return statementDao.findStatusForStudentsInClazzStatements(l, n, n2, string, n3, l2, l3, n4, n5, bl, (Continuation<? super List<StatementEntityAndRelated>>)continuation);
    }

    @Query(value="\n        WITH PersonUids(personUid) AS (\n            SELECT Person.personUid\n              FROM Person\n             WHERE Person.personUid IN (:studentPersonUids) \n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        \n        -- Fetch all statements that could be completion or progress for the Gradebook report\n        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*\n          FROM StatementEntity\n               JOIN ActorEntity\n                    ON ActorEntity.actorUid = StatementEntity.statementActorUid\n               LEFT JOIN GroupMemberActorJoin\n                    ON ActorEntity.actorObjectType = 2\n                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                       AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                           SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                             FROM ActorUidsForPersonUid)\n         WHERE StatementEntity.statementClazzUid = :clazzUid\n           AND StatementEntity.completionOrProgress = :completionOrProgressTrueVal\n           AND StatementEntity.statementActorUid IN (\n               SELECT DISTINCT ActorUidsForPersonUid.actorUid\n                 FROM ActorUidsForPersonUid) \n           AND (      StatementEntity.resultScoreScaled IS NOT NULL\n                   OR StatementEntity.resultCompletion IS NOT NULL\n                   OR StatementEntity.resultSuccess IS NOT NULL\n                   OR StatementEntity.extensionProgress IS NOT NULL \n               )\n    \n    ")
    @Nullable
    public abstract Object findStatusForStudentsInClazzByUidList(long var1, @NotNull List<Long> var3, boolean var4, @NotNull Continuation<? super List<StatementEntityAndRelated>> var5);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n            SELECT Person.personUid\n              FROM Person\n             WHERE Person.personUid IN (:studentPersonUids) \n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    \n        \n        SELECT ActorEntity.*\n          FROM ActorEntity\n         WHERE ActorEntity.actorPersonUid IN \n               (SELECT PersonUids.personUid\n                  FROM PersonUids)\n           AND :clazzUid = :clazzUid\n           AND :accountPersonUid = :accountPersonUid\n    ")
    @Nullable
    public abstract Object findActorEntitiesForStudentInClazzByUidList(long var1, @NotNull List<Long> var3, long var4, @NotNull Continuation<? super List<ActorEntity>> var6);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n             SELECT Person.personUid\n               FROM Person\n              WHERE Person.personUid IN (:studentPersonUids)\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    ,\n        \n        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (\n             SELECT Person.personUid AS personUid,\n                    CourseBlock.cbUid AS cbUid,\n                    CourseBlock.cbType AS cbType,\n                    ClazzAssignment.caMarkingType AS caMarkingType\n               FROM Person\n                    JOIN CourseBlock\n                         ON CourseBlock.cbClazzUid = :clazzUid\n                    LEFT JOIN ClazzAssignment\n                         ON CourseBlock.cbType = 103\n                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     \n              WHERE Person.personUid IN (:studentPersonUids)       \n        )\n        \n        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,\n               PersonUidsAndCourseBlocks.cbUid AS sCbUid,\n               (SELECT MAX(StatementEntity.extensionProgress)\n                  FROM StatementEntity\n                       \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                 WHERE \n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n     \n               ) AS sProgress,\n               (SELECT EXISTS(\n                       SELECT 1\n                         FROM StatementEntity\n                              \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                        WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n               )) AS sIsCompleted,\n               (SELECT CASE\n                       /*If there is a statement marked as success, then count as successful even if\n                        *there were subsequent failed attempts\n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n                                   )                           \n                       ) THEN 1\n                       /*If there are no statements marked as success, however there are statements marekd as fail,\n                        *then count as fail \n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n                                   )                           \n                       ) THEN 0\n                       /* Else there is no known success/fail result*/\n                       ELSE NULL\n                       END\n               ) AS sIsSuccess,\n               -- See ClazzGradebookScreen for info on which score is selected\n               (SELECT CASE\n                       -- When there is a peer marked assignment, take the average of the latest distinct ...\n                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103\n                              AND PersonUidsAndCourseBlocks.caMarkingType = 2\n                            ) \n                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                     AND StatementEntity.timestamp = (\n                                         SELECT MAX(StatementEntity_Inner.timestamp)\n                                           FROM StatementEntity StatementEntity_Inner\n                                                \n       JOIN ActorEntity ActorEntity_Inner\n            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid\n       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner\n            ON ActorEntity_Inner.actorObjectType = 2\n               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                          WHERE (\n            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity_Inner.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)\n                                   LIMIT 1)\n                       -- When an assignment, but not peer marked, then the latest score     \n                       WHEN PersonUidsAndCourseBlocks.cbType = 103\n                            THEN (SELECT StatementEntity.resultScoreScaled\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                ORDER BY StatementEntity.timestamp DESC\n                                   LIMIT 1)\n                       -- else the best score accomplished so far            \n                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) \n                               FROM StatementEntity\n                                    \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                              WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    ))            \n                       END\n               ) AS sScoreScaled\n          FROM PersonUidsAndCourseBlocks\n         WHERE :accountPersonUid = :accountPersonUid \n    ")
    @Nullable
    public abstract Object findStatusForStudentsInClazz(long var1, @NotNull List<Long> var3, long var4, @NotNull Continuation<? super List<BlockStatus>> var6);

    @Query(value="\n        WITH PersonUids(personUid) AS (\n             SELECT Person.personUid\n               FROM Person\n              WHERE Person.personUid IN (:studentPersonUids)\n        ),\n        \n        \n        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n             SELECT ActorEntity.actorUid AS actorUid, \n                    ActorEntity.actorPersonUid AS actorPersonUid\n               FROM ActorEntity\n              WHERE ActorEntity.actorPersonUid IN\n                    (SELECT PersonUids.personUid\n                       FROM PersonUids)           \n        ),\n        \n        -- Add in group actor uids\n        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid     \n              UNION \n             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n               FROM AgentActorUidsForPersonUid\n                    JOIN GroupMemberActorJoin \n                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n        )\n    ,\n        \n        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (\n             SELECT Person.personUid AS personUid,\n                    CourseBlock.cbUid AS cbUid,\n                    CourseBlock.cbType AS cbType,\n                    ClazzAssignment.caMarkingType AS caMarkingType\n               FROM Person\n                    JOIN CourseBlock\n                         ON CourseBlock.cbClazzUid = :clazzUid\n                    LEFT JOIN ClazzAssignment\n                         ON CourseBlock.cbType = 103\n                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     \n              WHERE Person.personUid IN (:studentPersonUids)       \n        )\n        \n        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,\n               PersonUidsAndCourseBlocks.cbUid AS sCbUid,\n               (SELECT MAX(StatementEntity.extensionProgress)\n                  FROM StatementEntity\n                       \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                 WHERE \n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n     \n               ) AS sProgress,\n               (SELECT EXISTS(\n                       SELECT 1\n                         FROM StatementEntity\n                              \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                        WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n               )) AS sIsCompleted,\n               (SELECT CASE\n                       /*If there is a statement marked as success, then count as successful even if\n                        *there were subsequent failed attempts\n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n                                   )                           \n                       ) THEN 1\n                       /*If there are no statements marked as success, however there are statements marekd as fail,\n                        *then count as fail \n                        */\n                       WHEN (\n                            SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                           \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                    WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n                                   )                           \n                       ) THEN 0\n                       /* Else there is no known success/fail result*/\n                       ELSE NULL\n                       END\n               ) AS sIsSuccess,\n               -- See ClazzGradebookScreen for info on which score is selected\n               (SELECT CASE\n                       -- When there is a peer marked assignment, take the average of the latest distinct ...\n                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103\n                              AND PersonUidsAndCourseBlocks.caMarkingType = 2\n                            ) \n                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                     AND StatementEntity.timestamp = (\n                                         SELECT MAX(StatementEntity_Inner.timestamp)\n                                           FROM StatementEntity StatementEntity_Inner\n                                                \n       JOIN ActorEntity ActorEntity_Inner\n            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid\n       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner\n            ON ActorEntity_Inner.actorObjectType = 2\n               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                          WHERE (\n            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity_Inner.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)\n                                   LIMIT 1)\n                       -- When an assignment, but not peer marked, then the latest score     \n                       WHEN PersonUidsAndCourseBlocks.cbType = 103\n                            THEN (SELECT StatementEntity.resultScoreScaled\n                                    FROM StatementEntity\n                                         \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                                   WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    )\n                                ORDER BY StatementEntity.timestamp DESC\n                                   LIMIT 1)\n                       -- else the best score accomplished so far            \n                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) \n                               FROM StatementEntity\n                                    \n       JOIN ActorEntity\n            ON ActorEntity.actorUid = StatementEntity.statementActorUid\n       LEFT JOIN GroupMemberActorJoin\n            ON ActorEntity.actorObjectType = 2\n               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (\n                   SELECT GroupMemberActorJoin.gmajGroupActorUid, \n                          GroupMemberActorJoin.gmajMemberActorUid\n                     FROM GroupMemberActorJoin\n                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n                      AND GroupMemberActorJoin.gmajMemberActorUid IN (\n                          SELECT ActorUidsForPersonUid.actorUid\n                            FROM ActorUidsForPersonUid\n                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))\n    \n                              WHERE (\n            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid\n        AND StatementEntity.statementActorUid IN (\n            SELECT ActorUidsForPersonUid.actorUid\n              FROM ActorUidsForPersonUid\n             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  \n                   \n    ))            \n                       END\n               ) AS sScoreScaled\n          FROM PersonUidsAndCourseBlocks\n         WHERE :accountPersonUid = :accountPersonUid \n    ")
    @NotNull
    public abstract Flow<List<BlockStatus>> findStatusForStudentsInClazzAsFlow(long var1, @NotNull List<Long> var3, long var4);

    @Query(value="\n        WITH MostRecentRegistration(statementIdHi, statementIdLo, contextRegistrationHi, contextRegistrationLo) AS (\n             SELECT StatementEntity.statementIdHi, StatementEntity.contextRegistrationLo,\n                    StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n               FROM StatementEntity\n              WHERE StatementEntity.statementActorUid = :actorUid\n                AND StatementEntity.statementObjectUid1 = :activityUid\n                AND StatementEntity.contextRegistrationHi != 0\n           ORDER BY StatementEntity.timestamp DESC\n              LIMIT 1\n        )\n        \n        SELECT StatementEntity.*\n          FROM StatementEntity\n         WHERE StatementEntity.statementIdHi = (SELECT statementIdHi FROM MostRecentRegistration)\n           AND StatementEntity.statementIdLo = (SELECT statementIdLo FROM MostRecentRegistration)\n           AND NOT EXISTS(\n                   SELECT 1\n                     FROM StatementEntity StatementEntity_Inner\n                    WHERE StatementEntity_Inner.statementActorUid = :actorUid\n                      AND StatementEntity_Inner.statementObjectUid1 = :activityUid\n                      AND StatementEntity_Inner.contextRegistrationHi = (SELECT contextRegistrationHi FROM MostRecentRegistration)\n                      AND StatementEntity_Inner.contextRegistrationLo = (SELECT contextRegistrationLo FROM MostRecentRegistration)\n                      AND CAST(StatementEntity_Inner.completionOrProgress AS INTEGER) = 1\n                      AND (     StatementEntity_Inner.resultCompletion IS NOT NULL \n                            AND CAST(StatementEntity_Inner.resultCompletion AS INTEGER) = 1)\n                     )\n           AND :accountPersonUid IN \n               (SELECT ActorEntity.actorPersonUid\n                  FROM ActorEntity\n                 WHERE ActorEntity.actorUid = :actorUid)          \n                     \n    ")
    @Nullable
    public abstract Object findResumableRegistration(long var1, long var3, long var5, @NotNull Continuation<? super StatementEntity> var7);
}

