/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.lib.db.entities.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class LanguageDao_Impl
extends LanguageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Language> __insertionAdapterOfLanguage;
    private final EntityInsertionAdapter<Language> __insertionAdapterOfLanguage_1;
    private final EntityDeletionOrUpdateAdapter<Language> __updateAdapterOfLanguage;

    public LanguageDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLanguage = new EntityInsertionAdapter<Language>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Language` (`langUid`,`name`,`iso_639_1_standard`,`iso_639_2_standard`,`iso_639_3_standard`,`Language_Type`,`languageActive`,`langLocalChangeSeqNum`,`langMasterChangeSeqNum`,`langLastChangedBy`,`langLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Language entity) {
                statement.bindLong(1, entity.getLangUid());
                if (entity.getName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getName());
                }
                if (entity.getIso_639_1_standard() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getIso_639_1_standard());
                }
                if (entity.getIso_639_2_standard() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getIso_639_2_standard());
                }
                if (entity.getIso_639_3_standard() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getIso_639_3_standard());
                }
                if (entity.getLanguage_Type() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getLanguage_Type());
                }
                int _tmp = entity.getLanguageActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getLangLocalChangeSeqNum());
                statement.bindLong(9, entity.getLangMasterChangeSeqNum());
                statement.bindLong(10, (long)entity.getLangLastChangedBy());
                statement.bindLong(11, entity.getLangLct());
            }
        };
        this.__insertionAdapterOfLanguage_1 = new EntityInsertionAdapter<Language>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `Language` (`langUid`,`name`,`iso_639_1_standard`,`iso_639_2_standard`,`iso_639_3_standard`,`Language_Type`,`languageActive`,`langLocalChangeSeqNum`,`langMasterChangeSeqNum`,`langLastChangedBy`,`langLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Language entity) {
                statement.bindLong(1, entity.getLangUid());
                if (entity.getName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getName());
                }
                if (entity.getIso_639_1_standard() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getIso_639_1_standard());
                }
                if (entity.getIso_639_2_standard() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getIso_639_2_standard());
                }
                if (entity.getIso_639_3_standard() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getIso_639_3_standard());
                }
                if (entity.getLanguage_Type() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getLanguage_Type());
                }
                int _tmp = entity.getLanguageActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getLangLocalChangeSeqNum());
                statement.bindLong(9, entity.getLangMasterChangeSeqNum());
                statement.bindLong(10, (long)entity.getLangLastChangedBy());
                statement.bindLong(11, entity.getLangLct());
            }
        };
        this.__updateAdapterOfLanguage = new EntityDeletionOrUpdateAdapter<Language>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `Language` SET `langUid` = ?,`name` = ?,`iso_639_1_standard` = ?,`iso_639_2_standard` = ?,`iso_639_3_standard` = ?,`Language_Type` = ?,`languageActive` = ?,`langLocalChangeSeqNum` = ?,`langMasterChangeSeqNum` = ?,`langLastChangedBy` = ?,`langLct` = ? WHERE `langUid` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Language entity) {
                statement.bindLong(1, entity.getLangUid());
                if (entity.getName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getName());
                }
                if (entity.getIso_639_1_standard() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getIso_639_1_standard());
                }
                if (entity.getIso_639_2_standard() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getIso_639_2_standard());
                }
                if (entity.getIso_639_3_standard() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getIso_639_3_standard());
                }
                if (entity.getLanguage_Type() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindString(6, entity.getLanguage_Type());
                }
                int _tmp = entity.getLanguageActive() ? 1 : 0;
                statement.bindLong(7, (long)_tmp);
                statement.bindLong(8, entity.getLangLocalChangeSeqNum());
                statement.bindLong(9, entity.getLangMasterChangeSeqNum());
                statement.bindLong(10, (long)entity.getLangLastChangedBy());
                statement.bindLong(11, entity.getLangLct());
                statement.bindLong(12, entity.getLangUid());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Language entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result2 = this.__insertionAdapterOfLanguage.insertAndReturnId((Object)entity);
            this.__db.setTransactionSuccessful();
            long l = _result2;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertAsync(final Language entity, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                LanguageDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result2 = LanguageDao_Impl.this.__insertionAdapterOfLanguage.insertAndReturnId((Object)entity);
                    LanguageDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result2;
                    return l;
                }
                finally {
                    LanguageDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<? extends Language> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLanguage.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object insertListAsync(final List<Language> languageList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                LanguageDao_Impl.this.__db.beginTransaction();
                try {
                    LanguageDao_Impl.this.__insertionAdapterOfLanguage.insert((Iterable)languageList);
                    LanguageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    LanguageDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void replaceList(List<Language> entityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLanguage_1.insert(entityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Language entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfLanguage.handle((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object updateAsync(final Language entity, Continuation<? super Integer> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            @NonNull
            public Integer call() throws Exception {
                int _total = 0;
                LanguageDao_Impl.this.__db.beginTransaction();
                try {
                    LanguageDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += LanguageDao_Impl.this.__updateAdapterOfLanguage.handle((Object)entity);
                    return n;
                }
                finally {
                    LanguageDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, Language> findLanguagesAsSource(int sortOrder, String searchText) {
        String _sql = "\n        SELECT Language.* \n        FROM Language\n        WHERE name LIKE ?\n        ORDER BY CASE(?)\n            WHEN 1 THEN Language.name \n            WHEN 3 THEN Language.iso_639_1_standard \n            WHEN 5 THEN Language.iso_639_2_standard \n            ELSE ''\n        END ASC,\n        CASE(?)\n            WHEN 2 THEN Language.name \n            WHEN 4 THEN Language.iso_639_1_standard \n            WHEN 6 THEN Language.iso_639_2_standard \n            ELSE ''\n        END DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Language.* \n        FROM Language\n        WHERE name LIKE ?\n        ORDER BY CASE(?)\n            WHEN 1 THEN Language.name \n            WHEN 3 THEN Language.iso_639_1_standard \n            WHEN 5 THEN Language.iso_639_2_standard \n            ELSE ''\n        END ASC,\n        CASE(?)\n            WHEN 2 THEN Language.name \n            WHEN 4 THEN Language.iso_639_1_standard \n            WHEN 6 THEN Language.iso_639_2_standard \n            ELSE ''\n        END DESC\n    ", (int)3);
        int _argIndex = 1;
        _statement.bindString(_argIndex, searchText);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)sortOrder);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)sortOrder);
        return new LimitOffsetPagingSource<Language>(_statement, this.__db, new String[]{"Language"}){

            @NonNull
            protected List<Language> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"langUid");
                int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"name");
                int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"iso_639_1_standard");
                int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"iso_639_2_standard");
                int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"iso_639_3_standard");
                int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"Language_Type");
                int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"languageActive");
                int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"langLocalChangeSeqNum");
                int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"langMasterChangeSeqNum");
                int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"langLastChangedBy");
                int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"langLct");
                ArrayList<Language> _result2 = new ArrayList<Language>(cursor.getCount());
                while (cursor.moveToNext()) {
                    Language _item = new Language();
                    long _tmpLangUid = cursor.getLong(_cursorIndexOfLangUid);
                    _item.setLangUid(_tmpLangUid);
                    String _tmpName = cursor.isNull(_cursorIndexOfName) ? null : cursor.getString(_cursorIndexOfName);
                    _item.setName(_tmpName);
                    String _tmpIso_639_1_standard = cursor.isNull(_cursorIndexOfIso6391Standard) ? null : cursor.getString(_cursorIndexOfIso6391Standard);
                    _item.setIso_639_1_standard(_tmpIso_639_1_standard);
                    String _tmpIso_639_2_standard = cursor.isNull(_cursorIndexOfIso6392Standard) ? null : cursor.getString(_cursorIndexOfIso6392Standard);
                    _item.setIso_639_2_standard(_tmpIso_639_2_standard);
                    String _tmpIso_639_3_standard = cursor.isNull(_cursorIndexOfIso6393Standard) ? null : cursor.getString(_cursorIndexOfIso6393Standard);
                    _item.setIso_639_3_standard(_tmpIso_639_3_standard);
                    String _tmpLanguage_Type = cursor.isNull(_cursorIndexOfLanguageType) ? null : cursor.getString(_cursorIndexOfLanguageType);
                    _item.setLanguage_Type(_tmpLanguage_Type);
                    int _tmp = cursor.getInt(_cursorIndexOfLanguageActive);
                    boolean _tmpLanguageActive = _tmp != 0;
                    _item.setLanguageActive(_tmpLanguageActive);
                    long _tmpLangLocalChangeSeqNum = cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                    _item.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                    long _tmpLangMasterChangeSeqNum = cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                    _item.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                    int _tmpLangLastChangedBy = cursor.getInt(_cursorIndexOfLangLastChangedBy);
                    _item.setLangLastChangedBy(_tmpLangLastChangedBy);
                    long _tmpLangLct = cursor.getLong(_cursorIndexOfLangLct);
                    _item.setLangLct(_tmpLangLct);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Language> findLanguagesList() {
        String _sql = "SELECT * FROM Language";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Language", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
            int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
            int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
            int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
            int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
            int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
            int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
            int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
            int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
            ArrayList<Language> _result2 = new ArrayList<Language>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Language _item = new Language();
                long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                _item.setLangUid(_tmpLangUid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                _item.setIso_639_1_standard(_tmpIso_639_1_standard);
                String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                _item.setIso_639_2_standard(_tmpIso_639_2_standard);
                String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                _item.setIso_639_3_standard(_tmpIso_639_3_standard);
                String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                _item.setLanguage_Type(_tmpLanguage_Type);
                int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                boolean _tmpLanguageActive = _tmp != 0;
                _item.setLanguageActive(_tmpLanguageActive);
                long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                _item.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                _item.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                _item.setLangLastChangedBy(_tmpLangLastChangedBy);
                long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                _item.setLangLct(_tmpLangLct);
                _result2.add(_item);
            }
            ArrayList<Language> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language findByName(String name) {
        String _sql = "SELECT * FROM Language WHERE name = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Language WHERE name = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, name);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Language _result2;
            int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
            int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
            int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
            int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
            int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
            int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
            int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
            int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
            int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
            if (_cursor.moveToFirst()) {
                _result2 = new Language();
                long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                _result2.setLangUid(_tmpLangUid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result2.setName(_tmpName);
                String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                _result2.setIso_639_1_standard(_tmpIso_639_1_standard);
                String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                _result2.setIso_639_2_standard(_tmpIso_639_2_standard);
                String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                _result2.setIso_639_3_standard(_tmpIso_639_3_standard);
                String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                _result2.setLanguage_Type(_tmpLanguage_Type);
                int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                boolean _tmpLanguageActive = _tmp != 0;
                _result2.setLanguageActive(_tmpLanguageActive);
                long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                _result2.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                _result2.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                _result2.setLangLastChangedBy(_tmpLangLastChangedBy);
                long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                _result2.setLangLct(_tmpLangLct);
            } else {
                _result2 = null;
            }
            Language language = _result2;
            return language;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language findByTwoCode(String langCode) {
        String _sql = "SELECT * FROM Language WHERE iso_639_1_standard = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Language WHERE iso_639_1_standard = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, langCode);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Language _result2;
            int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
            int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
            int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
            int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
            int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
            int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
            int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
            int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
            int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
            if (_cursor.moveToFirst()) {
                _result2 = new Language();
                long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                _result2.setLangUid(_tmpLangUid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result2.setName(_tmpName);
                String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                _result2.setIso_639_1_standard(_tmpIso_639_1_standard);
                String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                _result2.setIso_639_2_standard(_tmpIso_639_2_standard);
                String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                _result2.setIso_639_3_standard(_tmpIso_639_3_standard);
                String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                _result2.setLanguage_Type(_tmpLanguage_Type);
                int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                boolean _tmpLanguageActive = _tmp != 0;
                _result2.setLanguageActive(_tmpLanguageActive);
                long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                _result2.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                _result2.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                _result2.setLangLastChangedBy(_tmpLangLastChangedBy);
                long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                _result2.setLangLct(_tmpLangLct);
            } else {
                _result2 = null;
            }
            Language language = _result2;
            return language;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByTwoCodeAsync(String langCode, Continuation<? super Language> $completion) {
        String _sql = "SELECT * FROM Language WHERE iso_639_1_standard = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Language WHERE iso_639_1_standard = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, langCode);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Language>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Language call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)LanguageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Language _result2;
                    int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
                    int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
                    int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
                    int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
                    int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
                    int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
                    int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
                    int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
                    int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Language();
                        long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                        _result2.setLangUid(_tmpLangUid);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result2.setName(_tmpName);
                        String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                        _result2.setIso_639_1_standard(_tmpIso_639_1_standard);
                        String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                        _result2.setIso_639_2_standard(_tmpIso_639_2_standard);
                        String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                        _result2.setIso_639_3_standard(_tmpIso_639_3_standard);
                        String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                        _result2.setLanguage_Type(_tmpLanguage_Type);
                        int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                        boolean _tmpLanguageActive = _tmp != 0;
                        _result2.setLanguageActive(_tmpLanguageActive);
                        long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                        _result2.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                        long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                        _result2.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                        int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                        _result2.setLangLastChangedBy(_tmpLangLastChangedBy);
                        long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                        _result2.setLangLct(_tmpLangLct);
                    } else {
                        _result2 = null;
                    }
                    Language language = _result2;
                    return language;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language findByThreeCode(String langCode) {
        String _sql = "SELECT * FROM LANGUAGE WHERE iso_639_3_standard = ? OR iso_639_2_standard = ? LIMIT 1 ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM LANGUAGE WHERE iso_639_3_standard = ? OR iso_639_2_standard = ? LIMIT 1 ", (int)2);
        int _argIndex = 1;
        _statement.bindString(_argIndex, langCode);
        _argIndex = 2;
        _statement.bindString(_argIndex, langCode);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Language _result2;
            int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
            int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
            int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
            int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
            int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
            int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
            int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
            int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
            int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
            if (_cursor.moveToFirst()) {
                _result2 = new Language();
                long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                _result2.setLangUid(_tmpLangUid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result2.setName(_tmpName);
                String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                _result2.setIso_639_1_standard(_tmpIso_639_1_standard);
                String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                _result2.setIso_639_2_standard(_tmpIso_639_2_standard);
                String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                _result2.setIso_639_3_standard(_tmpIso_639_3_standard);
                String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                _result2.setLanguage_Type(_tmpLanguage_Type);
                int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                boolean _tmpLanguageActive = _tmp != 0;
                _result2.setLanguageActive(_tmpLanguageActive);
                long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                _result2.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                _result2.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                _result2.setLangLastChangedBy(_tmpLangLastChangedBy);
                long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                _result2.setLangLct(_tmpLangLct);
            } else {
                _result2 = null;
            }
            Language language = _result2;
            return language;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int totalLanguageCount() {
        String _sql = "SELECT COUNT(*) FROM LANGUAGE";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM LANGUAGE", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result2 = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result2;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language findByUid(long primaryLanguageUid) {
        String _sql = "SELECT *  FROM LANGUAGE where langUid = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT *  FROM LANGUAGE where langUid = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, primaryLanguageUid);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Language _result2;
            int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
            int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
            int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
            int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
            int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
            int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
            int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
            int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
            int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
            if (_cursor.moveToFirst()) {
                _result2 = new Language();
                long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                _result2.setLangUid(_tmpLangUid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result2.setName(_tmpName);
                String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                _result2.setIso_639_1_standard(_tmpIso_639_1_standard);
                String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                _result2.setIso_639_2_standard(_tmpIso_639_2_standard);
                String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                _result2.setIso_639_3_standard(_tmpIso_639_3_standard);
                String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                _result2.setLanguage_Type(_tmpLanguage_Type);
                int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                boolean _tmpLanguageActive = _tmp != 0;
                _result2.setLanguageActive(_tmpLanguageActive);
                long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                _result2.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                _result2.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                _result2.setLangLastChangedBy(_tmpLangLastChangedBy);
                long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                _result2.setLangLct(_tmpLangLct);
            } else {
                _result2 = null;
            }
            Language language = _result2;
            return language;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object findByUidAsync(long primaryLanguageUid, Continuation<? super Language> $completion) {
        String _sql = "SELECT *  FROM LANGUAGE where langUid = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT *  FROM LANGUAGE where langUid = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, primaryLanguageUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Language>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public Language call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)LanguageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Language _result2;
                    int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
                    int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
                    int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
                    int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
                    int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
                    int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
                    int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
                    int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
                    int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
                    if (_cursor.moveToFirst()) {
                        _result2 = new Language();
                        long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                        _result2.setLangUid(_tmpLangUid);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result2.setName(_tmpName);
                        String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                        _result2.setIso_639_1_standard(_tmpIso_639_1_standard);
                        String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                        _result2.setIso_639_2_standard(_tmpIso_639_2_standard);
                        String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                        _result2.setIso_639_3_standard(_tmpIso_639_3_standard);
                        String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                        _result2.setLanguage_Type(_tmpLanguage_Type);
                        int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                        boolean _tmpLanguageActive = _tmp != 0;
                        _result2.setLanguageActive(_tmpLanguageActive);
                        long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                        _result2.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                        long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                        _result2.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                        int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                        _result2.setLangLastChangedBy(_tmpLangLastChangedBy);
                        long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                        _result2.setLangLct(_tmpLangLct);
                    } else {
                        _result2 = null;
                    }
                    Language language = _result2;
                    return language;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<List<Language>> findAllLanguageLive() {
        String _sql = "SELECT * FROM LANGUAGE";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM LANGUAGE", (int)0);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"LANGUAGE"}, (Callable)new Callable<List<Language>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Language> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)LanguageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langUid");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_1_standard");
                    int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_2_standard");
                    int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iso_639_3_standard");
                    int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"Language_Type");
                    int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"languageActive");
                    int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLocalChangeSeqNum");
                    int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langMasterChangeSeqNum");
                    int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLastChangedBy");
                    int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"langLct");
                    ArrayList<Language> _result2 = new ArrayList<Language>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Language _item = new Language();
                        long _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
                        _item.setLangUid(_tmpLangUid);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _item.setName(_tmpName);
                        String _tmpIso_639_1_standard = _cursor.isNull(_cursorIndexOfIso6391Standard) ? null : _cursor.getString(_cursorIndexOfIso6391Standard);
                        _item.setIso_639_1_standard(_tmpIso_639_1_standard);
                        String _tmpIso_639_2_standard = _cursor.isNull(_cursorIndexOfIso6392Standard) ? null : _cursor.getString(_cursorIndexOfIso6392Standard);
                        _item.setIso_639_2_standard(_tmpIso_639_2_standard);
                        String _tmpIso_639_3_standard = _cursor.isNull(_cursorIndexOfIso6393Standard) ? null : _cursor.getString(_cursorIndexOfIso6393Standard);
                        _item.setIso_639_3_standard(_tmpIso_639_3_standard);
                        String _tmpLanguage_Type = _cursor.isNull(_cursorIndexOfLanguageType) ? null : _cursor.getString(_cursorIndexOfLanguageType);
                        _item.setLanguage_Type(_tmpLanguage_Type);
                        int _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
                        boolean _tmpLanguageActive = _tmp != 0;
                        _item.setLanguageActive(_tmpLanguageActive);
                        long _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
                        _item.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
                        long _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
                        _item.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
                        int _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
                        _item.setLangLastChangedBy(_tmpLangLastChangedBy);
                        long _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
                        _item.setLangLct(_tmpLangLct);
                        _result2.add(_item);
                    }
                    ArrayList<Language> arrayList = _result2;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> findByUidList(List<Long> uidList) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT langUid FROM LANGUAGE WHERE langUid IN (");
        int _inputSize = uidList.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : uidList) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<Long> _result2 = new ArrayList<Long>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Long _item_1 = _cursor.getLong(0);
                _result2.add(_item_1);
            }
            ArrayList<Long> arrayList = _result2;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Object toggleVisibilityLanguage(final boolean toggleVisibility, final List<Long> selectedItem, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("\n");
                _stringBuilder.append("        UPDATE Language ");
                _stringBuilder.append("\n");
                _stringBuilder.append("           SET languageActive = ");
                _stringBuilder.append("?");
                _stringBuilder.append(", ");
                _stringBuilder.append("\n");
                _stringBuilder.append("               langLct = ");
                _stringBuilder.append("?");
                _stringBuilder.append("\n");
                _stringBuilder.append("         WHERE langUid IN (");
                int _inputSize = selectedItem.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = LanguageDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                int _tmp = toggleVisibility ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                Unit unit = selectedItem.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                LanguageDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    LanguageDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    LanguageDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

