package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.ClazzEnrolmentAndPerson;
import com.ustadmobile.lib.db.composites.ClazzEnrolmentAndPersonDetailDetails;
import com.ustadmobile.lib.db.composites.CourseNameAndPersonName;
import com.ustadmobile.lib.db.composites.PersonAndClazzMemberListDetails;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithClazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithLeavingReason;
import com.ustadmobile.lib.db.entities.ClazzEnrolmentWithPerson;
import com.ustadmobile.lib.db.entities.CourseTerminology;
import com.ustadmobile.lib.db.entities.LeavingReason;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzEnrolmentDao_Impl extends ClazzEnrolmentDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzEnrolment> __insertionAdapterOfClazzEnrolment;

  private final EntityDeletionOrUpdateAdapter<ClazzEnrolment> __updateAdapterOfClazzEnrolment;

  private final SharedSQLiteStatement __preparedStmtOfUpdateDateLeftByUid;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzEnrolmentRole;

  public ClazzEnrolmentDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzEnrolment = new EntityInsertionAdapter<ClazzEnrolment>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ClazzEnrolment` (`clazzEnrolmentUid`,`clazzEnrolmentPersonUid`,`clazzEnrolmentClazzUid`,`clazzEnrolmentDateJoined`,`clazzEnrolmentDateLeft`,`clazzEnrolmentRole`,`clazzEnrolmentAttendancePercentage`,`clazzEnrolmentActive`,`clazzEnrolmentLeavingReasonUid`,`clazzEnrolmentOutcome`,`clazzEnrolmentLocalChangeSeqNum`,`clazzEnrolmentMasterChangeSeqNum`,`clazzEnrolmentLastChangedBy`,`clazzEnrolmentLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzEnrolment entity) {
        statement.bindLong(1, entity.getClazzEnrolmentUid());
        statement.bindLong(2, entity.getClazzEnrolmentPersonUid());
        statement.bindLong(3, entity.getClazzEnrolmentClazzUid());
        statement.bindLong(4, entity.getClazzEnrolmentDateJoined());
        statement.bindLong(5, entity.getClazzEnrolmentDateLeft());
        statement.bindLong(6, entity.getClazzEnrolmentRole());
        statement.bindDouble(7, entity.getClazzEnrolmentAttendancePercentage());
        final int _tmp = entity.getClazzEnrolmentActive() ? 1 : 0;
        statement.bindLong(8, _tmp);
        statement.bindLong(9, entity.getClazzEnrolmentLeavingReasonUid());
        statement.bindLong(10, entity.getClazzEnrolmentOutcome());
        statement.bindLong(11, entity.getClazzEnrolmentLocalChangeSeqNum());
        statement.bindLong(12, entity.getClazzEnrolmentMasterChangeSeqNum());
        statement.bindLong(13, entity.getClazzEnrolmentLastChangedBy());
        statement.bindLong(14, entity.getClazzEnrolmentLct());
      }
    };
    this.__updateAdapterOfClazzEnrolment = new EntityDeletionOrUpdateAdapter<ClazzEnrolment>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ClazzEnrolment` SET `clazzEnrolmentUid` = ?,`clazzEnrolmentPersonUid` = ?,`clazzEnrolmentClazzUid` = ?,`clazzEnrolmentDateJoined` = ?,`clazzEnrolmentDateLeft` = ?,`clazzEnrolmentRole` = ?,`clazzEnrolmentAttendancePercentage` = ?,`clazzEnrolmentActive` = ?,`clazzEnrolmentLeavingReasonUid` = ?,`clazzEnrolmentOutcome` = ?,`clazzEnrolmentLocalChangeSeqNum` = ?,`clazzEnrolmentMasterChangeSeqNum` = ?,`clazzEnrolmentLastChangedBy` = ?,`clazzEnrolmentLct` = ? WHERE `clazzEnrolmentUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ClazzEnrolment entity) {
        statement.bindLong(1, entity.getClazzEnrolmentUid());
        statement.bindLong(2, entity.getClazzEnrolmentPersonUid());
        statement.bindLong(3, entity.getClazzEnrolmentClazzUid());
        statement.bindLong(4, entity.getClazzEnrolmentDateJoined());
        statement.bindLong(5, entity.getClazzEnrolmentDateLeft());
        statement.bindLong(6, entity.getClazzEnrolmentRole());
        statement.bindDouble(7, entity.getClazzEnrolmentAttendancePercentage());
        final int _tmp = entity.getClazzEnrolmentActive() ? 1 : 0;
        statement.bindLong(8, _tmp);
        statement.bindLong(9, entity.getClazzEnrolmentLeavingReasonUid());
        statement.bindLong(10, entity.getClazzEnrolmentOutcome());
        statement.bindLong(11, entity.getClazzEnrolmentLocalChangeSeqNum());
        statement.bindLong(12, entity.getClazzEnrolmentMasterChangeSeqNum());
        statement.bindLong(13, entity.getClazzEnrolmentLastChangedBy());
        statement.bindLong(14, entity.getClazzEnrolmentLct());
        statement.bindLong(15, entity.getClazzEnrolmentUid());
      }
    };
    this.__preparedStmtOfUpdateDateLeftByUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzEnrolment \n"
                + "          SET clazzEnrolmentDateLeft = ?,\n"
                + "              clazzEnrolmentLct = ?\n"
                + "        WHERE clazzEnrolmentUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzEnrolment \n"
                + "          SET clazzEnrolmentActive = ?,\n"
                + "              clazzEnrolmentLct = ?\n"
                + "        WHERE clazzEnrolmentUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateClazzEnrolmentRole = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "            UPDATE ClazzEnrolment \n"
                + "               SET clazzEnrolmentRole = ?,\n"
                + "                   clazzEnrolmentLct = ?      \n"
                + "             -- Avoid potential for duplicate approvals if user was previously refused      \n"
                + "             WHERE clazzEnrolmentUid = COALESCE( \n"
                + "                    (SELECT clazzEnrolmentUid\n"
                + "                       FROM ClazzEnrolment\n"
                + "                      WHERE clazzEnrolmentPersonUid = ? \n"
                + "                            AND clazzEnrolmentClazzUid = ?\n"
                + "                            AND clazzEnrolmentRole = ?\n"
                + "                            AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n"
                + "                      LIMIT 1), 0)";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzEnrolment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfClazzEnrolment.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzEnrolment entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfClazzEnrolment.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ClazzEnrolment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzEnrolment.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertListAsync(final List<? extends ClazzEnrolment> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzEnrolment.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ClazzEnrolment entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzEnrolment.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ClazzEnrolment entity,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfClazzEnrolment.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateDateLeftByUid(final long clazzEnrolmentUid, final long endDate,
      final long updateTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateDateLeftByUid.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, endDate);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, clazzEnrolmentUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateDateLeftByUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public int updateClazzEnrolmentActiveForClazzEnrolment(final long clazzEnrolmentUid,
      final boolean enrolled, final long timeChanged) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment.acquire();
    int _argIndex = 1;
    final int _tmp = enrolled ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, timeChanged);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, clazzEnrolmentUid);
    try {
      __db.beginTransaction();
      try {
        final int _result = _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateClazzEnrolmentActiveForClazzEnrolment.release(_stmt);
    }
  }

  @Override
  public Object updateClazzEnrolmentRole(final long personUid, final long clazzUid,
      final int newRole, final int oldRole, final long updateTime,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzEnrolmentRole.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newRole);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, clazzUid);
        _argIndex = 5;
        _stmt.bindLong(_argIndex, oldRole);
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateClazzEnrolmentRole.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<ClazzEnrolmentWithLeavingReason>> findAllEnrolmentsByPersonAndClazzUid(
      final long personUid, final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*, LeavingReason.*, \n"
            + "               COALESCE(Clazz.clazzTimeZone, 'UTC') as timeZone\n"
            + "          FROM ClazzEnrolment \n"
            + "               LEFT JOIN LeavingReason \n"
            + "                         ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n"
            + "               LEFT JOIN Clazz \n"
            + "                         ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "         WHERE clazzEnrolmentPersonUid = ? \n"
            + "           AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "           AND clazzEnrolmentClazzUid = ? \n"
            + "      ORDER BY clazzEnrolmentDateLeft DESC\n"
            + "           ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment", "LeavingReason",
        "Clazz"}, new Callable<List<ClazzEnrolmentWithLeavingReason>>() {
      @Override
      @NonNull
      public List<ClazzEnrolmentWithLeavingReason> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "timeZone");
          final List<ClazzEnrolmentWithLeavingReason> _result = new ArrayList<ClazzEnrolmentWithLeavingReason>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolmentWithLeavingReason _item;
            final LeavingReason _tmpLeavingReason;
            if (!(_cursor.isNull(_cursorIndexOfLeavingReasonUid) && _cursor.isNull(_cursorIndexOfLeavingReasonTitle) && _cursor.isNull(_cursorIndexOfLeavingReasonMCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonLCB) && _cursor.isNull(_cursorIndexOfLeavingReasonLct))) {
              _tmpLeavingReason = new LeavingReason();
              final long _tmpLeavingReasonUid;
              _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
              _tmpLeavingReason.setLeavingReasonUid(_tmpLeavingReasonUid);
              final String _tmpLeavingReasonTitle;
              if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
                _tmpLeavingReasonTitle = null;
              } else {
                _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
              }
              _tmpLeavingReason.setLeavingReasonTitle(_tmpLeavingReasonTitle);
              final long _tmpLeavingReasonMCSN;
              _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
              _tmpLeavingReason.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
              final long _tmpLeavingReasonCSN;
              _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
              _tmpLeavingReason.setLeavingReasonCSN(_tmpLeavingReasonCSN);
              final int _tmpLeavingReasonLCB;
              _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
              _tmpLeavingReason.setLeavingReasonLCB(_tmpLeavingReasonLCB);
              final long _tmpLeavingReasonLct;
              _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
              _tmpLeavingReason.setLeavingReasonLct(_tmpLeavingReasonLct);
            } else {
              _tmpLeavingReason = null;
            }
            _item = new ClazzEnrolmentWithLeavingReason();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            final String _tmpTimeZone;
            if (_cursor.isNull(_cursorIndexOfTimeZone)) {
              _tmpTimeZone = null;
            } else {
              _tmpTimeZone = _cursor.getString(_cursorIndexOfTimeZone);
            }
            _item.setTimeZone(_tmpTimeZone);
            _item.setLeavingReason(_tmpLeavingReason);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findEnrolmentWithLeavingReason(final long enrolmentUid,
      final Continuation<? super ClazzEnrolmentWithLeavingReason> $completion) {
    final String _sql = "\n"
            + "            SELECT ClazzEnrolment.*, \n"
            + "                   LeavingReason.*,\n"
            + "                   COALESCE(Clazz.clazzTimeZone, 'UTC') AS timeZone\n"
            + "              FROM ClazzEnrolment \n"
            + "                   LEFT JOIN LeavingReason \n"
            + "                             ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n"
            + "                   LEFT JOIN Clazz \n"
            + "                             ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "             WHERE ClazzEnrolment.clazzEnrolmentUid = ?\n"
            + "             ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, enrolmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzEnrolmentWithLeavingReason>() {
      @Override
      @Nullable
      public ClazzEnrolmentWithLeavingReason call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final int _cursorIndexOfTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "timeZone");
          final ClazzEnrolmentWithLeavingReason _result;
          if (_cursor.moveToFirst()) {
            final LeavingReason _tmpLeavingReason;
            if (!(_cursor.isNull(_cursorIndexOfLeavingReasonUid) && _cursor.isNull(_cursorIndexOfLeavingReasonTitle) && _cursor.isNull(_cursorIndexOfLeavingReasonMCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonCSN) && _cursor.isNull(_cursorIndexOfLeavingReasonLCB) && _cursor.isNull(_cursorIndexOfLeavingReasonLct))) {
              _tmpLeavingReason = new LeavingReason();
              final long _tmpLeavingReasonUid;
              _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
              _tmpLeavingReason.setLeavingReasonUid(_tmpLeavingReasonUid);
              final String _tmpLeavingReasonTitle;
              if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
                _tmpLeavingReasonTitle = null;
              } else {
                _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
              }
              _tmpLeavingReason.setLeavingReasonTitle(_tmpLeavingReasonTitle);
              final long _tmpLeavingReasonMCSN;
              _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
              _tmpLeavingReason.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
              final long _tmpLeavingReasonCSN;
              _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
              _tmpLeavingReason.setLeavingReasonCSN(_tmpLeavingReasonCSN);
              final int _tmpLeavingReasonLCB;
              _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
              _tmpLeavingReason.setLeavingReasonLCB(_tmpLeavingReasonLCB);
              final long _tmpLeavingReasonLct;
              _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
              _tmpLeavingReason.setLeavingReasonLct(_tmpLeavingReasonLct);
            } else {
              _tmpLeavingReason = null;
            }
            _result = new ClazzEnrolmentWithLeavingReason();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _result.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _result.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _result.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _result.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _result.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _result.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _result.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _result.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _result.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _result.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _result.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _result.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _result.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _result.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            final String _tmpTimeZone;
            if (_cursor.isNull(_cursorIndexOfTimeZone)) {
              _tmpTimeZone = null;
            } else {
              _tmpTimeZone = _cursor.getString(_cursorIndexOfTimeZone);
            }
            _result.setTimeZone(_tmpTimeZone);
            _result.setLeavingReason(_tmpLeavingReason);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<ClazzEnrolmentAndPersonDetailDetails>> findAllClazzesByPersonWithClazz(
      final long accountPersonUid, final long otherPersonUid) {
    final String _sql = "\n"
            + "               /* List of all CoursePermissions that are granted to the person as per accountPersonUid */\n"
            + "          WITH CoursePermissionsForAccountPerson AS (\n"
            + "               \n"
            + "        /* Get CoursePermissions given to the active user based on their enrolment role*/\n"
            + "        SELECT CoursePermission.*\n"
            + "          FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n"
            + "               JOIN CoursePermission \n"
            + "                    ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n"
            + "                   AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n"
            + "         WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n"
            + "         UNION\n"
            + "        /* Get ClazzUids where the active user can view members based a grant directly to them */\n"
            + "        SELECT CoursePermission.*\n"
            + "          FROM CoursePermission\n"
            + "         WHERE CoursePermission.cpToPersonUid  = ?\n"
            + "    ),\n"
            + "               /* Check if CoursePermission for accountPersonUid grants view permission */\n"
            + "               CanViewPersonUidViaCoursePermission(personUid) AS (\n"
            + "                    SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                      FROM CoursePermissionsForAccountPerson\n"
            + "                           JOIN ClazzEnrolment \n"
            + "                                ON (CoursePermissionsForAccountPerson.cpPermissionsFlag & 8192) > 0\n"
            + "                               AND ClazzEnrolment.clazzEnrolmentClazzUid = CoursePermissionsForAccountPerson.cpClazzUid  \n"
            + "                     WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?         \n"
            + "               )     \n"
            + "        SELECT ClazzEnrolment.*,\n"
            + "               Clazz.*,\n"
            + "               CourseTerminology.*\n"
            + "          FROM ClazzEnrolment\n"
            + "               JOIN Clazz \n"
            + "                    ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "               LEFT JOIN CourseTerminology\n"
            + "                    ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "         WHERE (? != 0 AND ? != 0)\n"
            + "           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "               /* Check that accountPersonUid has permission to see otherPerson */\n"
            + "           AND (    (SELECT ? = ?)\n"
            + "                 OR (SELECT \n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "     \n"
            + "                            8192\n"
            + "                            \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    )\n"
            + "                 OR (SELECT ? IN \n"
            + "                             (SELECT CanViewPersonUidViaCoursePermission.personUid\n"
            + "                                 FROM CanViewPersonUidViaCoursePermission))           \n"
            + "               ) \n"
            + "              /* Check that accountPersonUid has permission to see related Clazz */\n"
            + "          AND (     (SELECT ? = ?)\n"
            + "                 OR (SELECT \n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "     \n"
            + "                            1\n"
            + "                            \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    )\n"
            + "                 OR (EXISTS(SELECT 1\n"
            + "                              FROM CoursePermissionsForAccountPerson\n"
            + "                             WHERE CoursePermissionsForAccountPerson.cpClazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "                               AND (CoursePermissionsForAccountPerson.cpPermissionsFlag & 1) > 0)) \n"
            + "               )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 15);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment",
        "CoursePermission", "Clazz", "CourseTerminology",
        "SystemPermission"}, new Callable<List<ClazzEnrolmentAndPersonDetailDetails>>() {
      @Override
      @NonNull
      public List<ClazzEnrolmentAndPersonDetailDetails> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final List<ClazzEnrolmentAndPersonDetailDetails> _result = new ArrayList<ClazzEnrolmentAndPersonDetailDetails>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolmentAndPersonDetailDetails _item;
            final ClazzEnrolment _tmpEnrolment;
            if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct))) {
              _tmpEnrolment = new ClazzEnrolment();
              final long _tmpClazzEnrolmentUid;
              _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
              _tmpEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
              final long _tmpClazzEnrolmentPersonUid;
              _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
              _tmpEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
              final long _tmpClazzEnrolmentClazzUid;
              _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
              _tmpEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
              final long _tmpClazzEnrolmentDateJoined;
              _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
              _tmpEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
              final long _tmpClazzEnrolmentDateLeft;
              _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
              _tmpEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
              final int _tmpClazzEnrolmentRole;
              _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
              _tmpEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
              final float _tmpClazzEnrolmentAttendancePercentage;
              _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
              _tmpEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
              final boolean _tmpClazzEnrolmentActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
              _tmpClazzEnrolmentActive = _tmp != 0;
              _tmpEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
              final long _tmpClazzEnrolmentLeavingReasonUid;
              _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
              _tmpEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
              final int _tmpClazzEnrolmentOutcome;
              _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
              _tmpEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
              final long _tmpClazzEnrolmentLocalChangeSeqNum;
              _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
              _tmpEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
              final long _tmpClazzEnrolmentMasterChangeSeqNum;
              _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
              _tmpEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
              final int _tmpClazzEnrolmentLastChangedBy;
              _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
              _tmpEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
              final long _tmpClazzEnrolmentLct;
              _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
              _tmpEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            } else {
              _tmpEnrolment = null;
            }
            final Clazz _tmpClazz;
            if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
              _tmpClazz = new Clazz();
              final long _tmpClazzUid;
              _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
              _tmpClazz.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (_cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
              }
              _tmpClazz.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
              }
              _tmpClazz.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp_1 != 0;
              _tmpClazz.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
              _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
              _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
              _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
              _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
              _tmpClazz.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (_cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
              }
              _tmpClazz.setClazzCode(_tmpClazzCode);
              final long _tmpClazzOwnerPersonUid;
              _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
              _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            } else {
              _tmpClazz = null;
            }
            final CourseTerminology _tmpCourseTerminology;
            if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
              _tmpCourseTerminology = new CourseTerminology();
              final long _tmpCtUid;
              _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
              _tmpCourseTerminology.setCtUid(_tmpCtUid);
              final String _tmpCtTitle;
              if (_cursor.isNull(_cursorIndexOfCtTitle)) {
                _tmpCtTitle = null;
              } else {
                _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
              }
              _tmpCourseTerminology.setCtTitle(_tmpCtTitle);
              final String _tmpCtTerminology;
              if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
                _tmpCtTerminology = null;
              } else {
                _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
              }
              _tmpCourseTerminology.setCtTerminology(_tmpCtTerminology);
              final long _tmpCtLct;
              _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
              _tmpCourseTerminology.setCtLct(_tmpCtLct);
            } else {
              _tmpCourseTerminology = null;
            }
            _item = new ClazzEnrolmentAndPersonDetailDetails(_tmpEnrolment,_tmpClazz,_tmpCourseTerminology);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<ClazzEnrolment>> findAllByPersonUid(final long personUid) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment"}, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findAllClazzesByPersonWithClazzAsListAsync(final long personUid,
      final Continuation<? super List<? extends ClazzEnrolmentWithClazz>> $completion) {
    final String _sql = "SELECT ClazzEnrolment.*, Clazz.* \n"
            + "        FROM ClazzEnrolment \n"
            + "        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ? \n"
            + "        AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolmentWithClazz>>() {
      @Override
      @NonNull
      public List<ClazzEnrolmentWithClazz> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final List<ClazzEnrolmentWithClazz> _result = new ArrayList<ClazzEnrolmentWithClazz>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolmentWithClazz _item;
            final Clazz _tmpClazz;
            if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
              _tmpClazz = new Clazz();
              final long _tmpClazzUid;
              _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
              _tmpClazz.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (_cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
              }
              _tmpClazz.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
              }
              _tmpClazz.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp != 0;
              _tmpClazz.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
              _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
              _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
              _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
              _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
              _tmpClazz.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (_cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
              }
              _tmpClazz.setClazzCode(_tmpClazzCode);
              final long _tmpClazzOwnerPersonUid;
              _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
              _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            } else {
              _tmpClazz = null;
            }
            _item = new ClazzEnrolmentWithClazz();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp_1 != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _item.setClazz(_tmpClazz);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getAllClazzEnrolledAtTimeAsync(final long clazzUid, final long date,
      final int roleFilter, final long personUidFilter,
      final Continuation<? super List<ClazzEnrolmentWithPerson>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*, Person.*\n"
            + "          FROM ClazzEnrolment\n"
            + "                LEFT JOIN Person \n"
            + "                          ON ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "              AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "              AND ClazzEnrolment.clazzEnrolmentDateLeft\n"
            + "              AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n"
            + "              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentRole = ?)\n"
            + "              AND (? = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, date);
    _argIndex = 3;
    _statement.bindLong(_argIndex, roleFilter);
    _argIndex = 4;
    _statement.bindLong(_argIndex, roleFilter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, personUidFilter);
    _argIndex = 6;
    _statement.bindLong(_argIndex, personUidFilter);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolmentWithPerson>>() {
      @Override
      @NonNull
      public List<ClazzEnrolmentWithPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final List<ClazzEnrolmentWithPerson> _result = new ArrayList<ClazzEnrolmentWithPerson>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolmentWithPerson _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            _item = new ClazzEnrolmentWithPerson();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp_2 != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getAllEnrolmentsAtTimeByClazzAndPerson(final long clazzUid,
      final long accountPersonUid, final long time,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "           AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                         AND ClazzEnrolment.clazzEnrolmentDateLeft\n"
            + "           AND ClazzEnrolment.clazzEnrolmentActive              \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, time);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUid(final long uid, final Continuation<? super ClazzEnrolment> $completion) {
    final String _sql = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzEnrolment>() {
      @Override
      @Nullable
      public ClazzEnrolment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final ClazzEnrolment _result;
          if (_cursor.moveToFirst()) {
            _result = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _result.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _result.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _result.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _result.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _result.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _result.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _result.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _result.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _result.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _result.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _result.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _result.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _result.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _result.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<ClazzEnrolment> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment"}, new Callable<ClazzEnrolment>() {
      @Override
      @Nullable
      public ClazzEnrolment call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final ClazzEnrolment _result;
          if (_cursor.moveToFirst()) {
            _result = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _result.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _result.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _result.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _result.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _result.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _result.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _result.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _result.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _result.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _result.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _result.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _result.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _result.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _result.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public PagingSource<Integer, PersonAndClazzMemberListDetails> findByClazzUidAndRole(
      final long clazzUid, final int roleId, final int sortOrder, final String searchText,
      final int filter, final long accountPersonUid, final long currentTime,
      final long permission) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM (SELECT Person.*, PersonPicture.*,\n"
            + "                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n"
            + "        \n"
            + "                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n"
            + "        \n"
            + "                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "                         LIMIT 1) AS enrolmentRole\n"
            + "                  FROM Person\n"
            + "                       LEFT JOIN PersonPicture\n"
            + "                                 ON PersonPicture.personPictureUid = Person.personUid\n"
            + "                 WHERE Person.personUid IN \n"
            + "                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentRole = ? \n"
            + "                           AND (? != 1 \n"
            + "                                 OR (? \n"
            + "                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n"
            + "                   /* Begin permission check */\n"
            + "                   AND (\n"
            + "                           (\n"
            + "         (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "    )\n"
            + "                        OR Person.personUid = ?\n"
            + "                       )  \n"
            + "                   /* End permission check */                   \n"
            + "                   AND Person.firstNames || ' ' || Person.lastName LIKE ?\n"
            + "               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n"
            + "      ORDER BY CASE(?)\n"
            + "                WHEN 1 THEN CourseMember.firstNames\n"
            + "                WHEN 3 THEN CourseMember.lastName\n"
            + "                ELSE ''\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 2 THEN CourseMember.firstNames\n"
            + "                WHEN 4 THEN CourseMember.lastName\n"
            + "                ELSE ''\n"
            + "            END DESC,\n"
            + "            CASE(?)\n"
            + "                WHEN 7 THEN CourseMember.earliestJoinDate\n"
            + "                WHEN 9 THEN CourseMember.latestDateLeft\n"
            + "                ELSE 0\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 8 THEN CourseMember.earliestJoinDate\n"
            + "                WHEN 10 THEN CourseMember.latestDateLeft\n"
            + "                ELSE 0\n"
            + "            END DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 19);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 4;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 16;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 17;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 18;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 19;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<PersonAndClazzMemberListDetails>(_statement, __db, "ClazzEnrolment", "Person", "PersonPicture", "Clazz", "CoursePermission", "SystemPermission") {
      @Override
      @NonNull
      protected List<PersonAndClazzMemberListDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
        final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUid");
        final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureLct");
        final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUri");
        final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureThumbnailUri");
        final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
        final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureActive");
        final int _cursorIndexOfEarliestJoinDate = CursorUtil.getColumnIndexOrThrow(cursor, "earliestJoinDate");
        final int _cursorIndexOfLatestDateLeft = CursorUtil.getColumnIndexOrThrow(cursor, "latestDateLeft");
        final int _cursorIndexOfEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "enrolmentRole");
        final List<PersonAndClazzMemberListDetails> _result = new ArrayList<PersonAndClazzMemberListDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final PersonAndClazzMemberListDetails _item;
          final long _tmpEarliestJoinDate;
          _tmpEarliestJoinDate = cursor.getLong(_cursorIndexOfEarliestJoinDate);
          final long _tmpLatestDateLeft;
          _tmpLatestDateLeft = cursor.getLong(_cursorIndexOfLatestDateLeft);
          final int _tmpEnrolmentRole;
          _tmpEnrolmentRole = cursor.getInt(_cursorIndexOfEnrolmentRole);
          final Person _tmpPerson;
          if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
            final long _tmpPersonUid;
            _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            final String _tmpPersonNotes;
            if (cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
            }
            _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpPerson = null;
          }
          final PersonPicture _tmpPersonPicture;
          if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp_2 != 0;
            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _tmpPersonPicture = null;
          }
          _item = new PersonAndClazzMemberListDetails(_tmpPerson,_tmpPersonPicture,_tmpEarliestJoinDate,_tmpLatestDateLeft,_tmpEnrolmentRole);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public PagingSource<Integer, PersonAndClazzMemberListDetails> findByClazzUidAndRoleForGradebook(
      final long clazzUid, final int roleId, final int sortOrder, final String searchText,
      final int filter, final long accountPersonUid, final long currentTime) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM (SELECT Person.*, PersonPicture.*,\n"
            + "                       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n"
            + "        \n"
            + "                       (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n"
            + "        \n"
            + "                       (SELECT ClazzEnrolment.clazzEnrolmentRole \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "                         LIMIT 1) AS enrolmentRole\n"
            + "                  FROM Person\n"
            + "                       LEFT JOIN PersonPicture\n"
            + "                                 ON PersonPicture.personPictureUid = Person.personUid\n"
            + "                       --Dummy join so that invalidations of the StatementEntity table will trigger\n"
            + "                       -- PagingSource invalidation of ClazzGradebookPagingSource\n"
            + "                       LEFT JOIN StatementEntity\n"
            + "                                 ON StatementEntity.statementIdHi = 0 \n"
            + "                                    AND StatementEntity.statementIdLo = 0\n"
            + "                       LEFT JOIN ActorEntity\n"
            + "                                 ON ActorEntity.actorUid = 0\n"
            + "                 WHERE Person.personUid IN \n"
            + "                       (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                          FROM ClazzEnrolment \n"
            + "                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentRole = ? \n"
            + "                           AND (? != 1 \n"
            + "                                 OR (? \n"
            + "                                      BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                                      AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n"
            + "                   /* Begin permission check */\n"
            + "                   AND (\n"
            + "                           ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                            \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                            \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "                        OR Person.personUid = ?\n"
            + "                       )  \n"
            + "                   /* End permission check */                   \n"
            + "                   AND Person.firstNames || ' ' || Person.lastName LIKE ?\n"
            + "               GROUP BY Person.personUid, PersonPicture.personPictureUid) AS CourseMember\n"
            + "      ORDER BY CASE(?)\n"
            + "                WHEN 1 THEN CourseMember.firstNames\n"
            + "                WHEN 3 THEN CourseMember.lastName\n"
            + "                ELSE ''\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 2 THEN CourseMember.firstNames\n"
            + "                WHEN 4 THEN CourseMember.lastName\n"
            + "                ELSE ''\n"
            + "            END DESC,\n"
            + "            CASE(?)\n"
            + "                WHEN 7 THEN CourseMember.earliestJoinDate\n"
            + "                WHEN 9 THEN CourseMember.latestDateLeft\n"
            + "                ELSE 0\n"
            + "            END ASC,\n"
            + "            CASE(?)\n"
            + "                WHEN 8 THEN CourseMember.earliestJoinDate\n"
            + "                WHEN 10 THEN CourseMember.latestDateLeft\n"
            + "                ELSE 0\n"
            + "            END DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 17);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 4;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 14;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 15;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 16;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 17;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<PersonAndClazzMemberListDetails>(_statement, __db, "ClazzEnrolment", "Person", "PersonPicture", "StatementEntity", "ActorEntity", "Clazz", "CoursePermission", "SystemPermission") {
      @Override
      @NonNull
      protected List<PersonAndClazzMemberListDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(cursor, "active");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(cursor, "motherNum");
        final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUid");
        final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureLct");
        final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureUri");
        final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureThumbnailUri");
        final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
        final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(cursor, "personPictureActive");
        final int _cursorIndexOfEarliestJoinDate = CursorUtil.getColumnIndexOrThrow(cursor, "earliestJoinDate");
        final int _cursorIndexOfLatestDateLeft = CursorUtil.getColumnIndexOrThrow(cursor, "latestDateLeft");
        final int _cursorIndexOfEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "enrolmentRole");
        final List<PersonAndClazzMemberListDetails> _result = new ArrayList<PersonAndClazzMemberListDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final PersonAndClazzMemberListDetails _item;
          final long _tmpEarliestJoinDate;
          _tmpEarliestJoinDate = cursor.getLong(_cursorIndexOfEarliestJoinDate);
          final long _tmpLatestDateLeft;
          _tmpLatestDateLeft = cursor.getLong(_cursorIndexOfLatestDateLeft);
          final int _tmpEnrolmentRole;
          _tmpEnrolmentRole = cursor.getInt(_cursorIndexOfEnrolmentRole);
          final Person _tmpPerson;
          if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
            final long _tmpPersonUid;
            _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            final String _tmpPersonNotes;
            if (cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
            }
            _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpPerson = null;
          }
          final PersonPicture _tmpPersonPicture;
          if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
            final long _tmpPersonPictureUid;
            _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
            final long _tmpPersonPictureLct;
            _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
            final String _tmpPersonPictureUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureUri)) {
              _tmpPersonPictureUri = null;
            } else {
              _tmpPersonPictureUri = cursor.getString(_cursorIndexOfPersonPictureUri);
            }
            final String _tmpPersonPictureThumbnailUri;
            if (cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
              _tmpPersonPictureThumbnailUri = null;
            } else {
              _tmpPersonPictureThumbnailUri = cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
            }
            final int _tmpFileSize;
            _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
            final boolean _tmpPersonPictureActive;
            final int _tmp_2;
            _tmp_2 = cursor.getInt(_cursorIndexOfPersonPictureActive);
            _tmpPersonPictureActive = _tmp_2 != 0;
            _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
          } else {
            _tmpPersonPicture = null;
          }
          _item = new PersonAndClazzMemberListDetails(_tmpPerson,_tmpPersonPicture,_tmpEarliestJoinDate,_tmpLatestDateLeft,_tmpEnrolmentRole);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findActorEntitiesForGradebook(final long clazzUid, final int roleId,
      final int sortOrder, final String searchText, final int filter, final long accountPersonUid,
      final long currentTime, final int studentsLimit, final int studentsOffset,
      final Continuation<? super List<ActorEntity>> $completion) {
    final String _sql = "\n"
            + "          WITH \n"
            + "        PersonUids(personUid) AS (\n"
            + "            SELECT CourseMember.personUid \n"
            + "              FROM (SELECT Person.*,\n"
            + "                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n"
            + "            \n"
            + "                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n"
            + "            \n"
            + "                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "                             LIMIT 1) AS enrolmentRole\n"
            + "                      FROM Person\n"
            + "                     WHERE Person.personUid IN \n"
            + "                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n"
            + "                               AND (? != 1 \n"
            + "                                     OR (? \n"
            + "                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n"
            + "                       /* Begin permission check */\n"
            + "                       AND (\n"
            + "                               ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                                \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                                \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "                            OR Person.personUid = ?\n"
            + "                           )  \n"
            + "                       /* End permission check */                   \n"
            + "                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n"
            + "                   GROUP BY Person.personUid) AS CourseMember\n"
            + "          ORDER BY CASE(?)\n"
            + "                    WHEN 1 THEN CourseMember.firstNames\n"
            + "                    WHEN 3 THEN CourseMember.lastName\n"
            + "                    ELSE ''\n"
            + "                END ASC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 2 THEN CourseMember.firstNames\n"
            + "                    WHEN 4 THEN CourseMember.lastName\n"
            + "                    ELSE ''\n"
            + "                END DESC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 7 THEN CourseMember.earliestJoinDate\n"
            + "                    WHEN 9 THEN CourseMember.latestDateLeft\n"
            + "                    ELSE 0\n"
            + "                END ASC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 8 THEN CourseMember.earliestJoinDate\n"
            + "                    WHEN 10 THEN CourseMember.latestDateLeft\n"
            + "                    ELSE 0\n"
            + "                END DESC\n"
            + "             LIMIT ?\n"
            + "            OFFSET ?   \n"
            + "         )\n"
            + "    \n"
            + "          \n"
            + "        \n"
            + "        SELECT ActorEntity.*\n"
            + "          FROM ActorEntity\n"
            + "         WHERE ActorEntity.actorPersonUid IN \n"
            + "               (SELECT PersonUids.personUid\n"
            + "                  FROM PersonUids)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 19);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 4;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 14;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 15;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 16;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 17;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 18;
    _statement.bindLong(_argIndex, studentsLimit);
    _argIndex = 19;
    _statement.bindLong(_argIndex, studentsOffset);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ActorEntity>>() {
      @Override
      @NonNull
      public List<ActorEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorUid");
          final int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorPersonUid");
          final int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorName");
          final int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox");
          final int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox_sha1sum");
          final int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorOpenid");
          final int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountName");
          final int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountHomePage");
          final int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "actorEtag");
          final int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actorLct");
          final int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "actorObjectType");
          final List<ActorEntity> _result = new ArrayList<ActorEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ActorEntity _item;
            final long _tmpActorUid;
            _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
            final long _tmpActorPersonUid;
            _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
            final String _tmpActorName;
            if (_cursor.isNull(_cursorIndexOfActorName)) {
              _tmpActorName = null;
            } else {
              _tmpActorName = _cursor.getString(_cursorIndexOfActorName);
            }
            final String _tmpActorMbox;
            if (_cursor.isNull(_cursorIndexOfActorMbox)) {
              _tmpActorMbox = null;
            } else {
              _tmpActorMbox = _cursor.getString(_cursorIndexOfActorMbox);
            }
            final String _tmpActorMbox_sha1sum;
            if (_cursor.isNull(_cursorIndexOfActorMboxSha1sum)) {
              _tmpActorMbox_sha1sum = null;
            } else {
              _tmpActorMbox_sha1sum = _cursor.getString(_cursorIndexOfActorMboxSha1sum);
            }
            final String _tmpActorOpenid;
            if (_cursor.isNull(_cursorIndexOfActorOpenid)) {
              _tmpActorOpenid = null;
            } else {
              _tmpActorOpenid = _cursor.getString(_cursorIndexOfActorOpenid);
            }
            final String _tmpActorAccountName;
            if (_cursor.isNull(_cursorIndexOfActorAccountName)) {
              _tmpActorAccountName = null;
            } else {
              _tmpActorAccountName = _cursor.getString(_cursorIndexOfActorAccountName);
            }
            final String _tmpActorAccountHomePage;
            if (_cursor.isNull(_cursorIndexOfActorAccountHomePage)) {
              _tmpActorAccountHomePage = null;
            } else {
              _tmpActorAccountHomePage = _cursor.getString(_cursorIndexOfActorAccountHomePage);
            }
            final long _tmpActorEtag;
            _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
            final long _tmpActorLct;
            _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
            final int _tmpActorObjectType;
            _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
            _item = new ActorEntity(_tmpActorUid,_tmpActorPersonUid,_tmpActorName,_tmpActorMbox,_tmpActorMbox_sha1sum,_tmpActorOpenid,_tmpActorAccountName,_tmpActorAccountHomePage,_tmpActorEtag,_tmpActorLct,_tmpActorObjectType);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findEnrolmentsAndPersonByClazzUidWithPermissionCheck(final long clazzUid,
      final long accountPersonUid,
      final Continuation<? super List<ClazzEnrolmentAndPerson>> $completion) {
    final String _sql = "\n"
            + "       SELECT ClazzEnrolment.*,\n"
            + "              Person.*,\n"
            + "              PersonPicture.*\n"
            + "         FROM ClazzEnrolment\n"
            + "              JOIN Person\n"
            + "                   ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "              LEFT JOIN PersonPicture\n"
            + "                   ON PersonPicture.personPictureUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   \n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "              /* Begin permission check*/\n"
            + "          AND (\n"
            + "                   ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "        \n"
            + "                    8192\n"
            + "                    \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "    \n"
            + "                    8192\n"
            + "                    \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "              )  \n"
            + "              /* End permission check */\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolmentAndPerson>>() {
      @Override
      @NonNull
      public List<ClazzEnrolmentAndPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<ClazzEnrolmentAndPerson> _result = new ArrayList<ClazzEnrolmentAndPerson>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolmentAndPerson _item;
            final ClazzEnrolment _tmpEnrolment;
            if (!(_cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && _cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && _cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && _cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && _cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzEnrolmentLct))) {
              _tmpEnrolment = new ClazzEnrolment();
              final long _tmpClazzEnrolmentUid;
              _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
              _tmpEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
              final long _tmpClazzEnrolmentPersonUid;
              _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
              _tmpEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
              final long _tmpClazzEnrolmentClazzUid;
              _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
              _tmpEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
              final long _tmpClazzEnrolmentDateJoined;
              _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
              _tmpEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
              final long _tmpClazzEnrolmentDateLeft;
              _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
              _tmpEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
              final int _tmpClazzEnrolmentRole;
              _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
              _tmpEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
              final float _tmpClazzEnrolmentAttendancePercentage;
              _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
              _tmpEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
              final boolean _tmpClazzEnrolmentActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
              _tmpClazzEnrolmentActive = _tmp != 0;
              _tmpEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
              final long _tmpClazzEnrolmentLeavingReasonUid;
              _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
              _tmpEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
              final int _tmpClazzEnrolmentOutcome;
              _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
              _tmpEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
              final long _tmpClazzEnrolmentLocalChangeSeqNum;
              _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
              _tmpEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
              final long _tmpClazzEnrolmentMasterChangeSeqNum;
              _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
              _tmpEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
              final int _tmpClazzEnrolmentLastChangedBy;
              _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
              _tmpEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
              final long _tmpClazzEnrolmentLct;
              _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
              _tmpEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            } else {
              _tmpEnrolment = null;
            }
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _item = new ClazzEnrolmentAndPerson(_tmpPerson,_tmpEnrolment,_tmpPicture);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByAccountPersonUidAndClazzUid(final long accountPersonUid, final long clazzUid,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findEnrolmentsByClazzUidAndRole(final long clazzUid, final long accountPersonUid,
      final int roleId, final long permission,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "       SELECT ClazzEnrolment.*\n"
            + "         FROM ClazzEnrolment\n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "          AND ClazzEnrolment.clazzEnrolmentRole = ?\n"
            + "              /* Begin permission check*/\n"
            + "          AND (\n"
            + "                   (\n"
            + "         (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "    )\n"
            + "                OR ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "              )  \n"
            + "              /* End permission check */\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findEnrolmentsByClazzUidAndRolePaged(final long clazzUid, final int roleId,
      final int sortOrder, final String searchText, final int filter, final long accountPersonUid,
      final long currentTime, final long permission, final int studentsLimit,
      final int studentsOffset,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "         WITH \n"
            + "        PersonUids(personUid) AS (\n"
            + "            SELECT CourseMember.personUid \n"
            + "              FROM (SELECT Person.*,\n"
            + "                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n"
            + "            \n"
            + "                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n"
            + "            \n"
            + "                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "                             LIMIT 1) AS enrolmentRole\n"
            + "                      FROM Person\n"
            + "                     WHERE Person.personUid IN \n"
            + "                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n"
            + "                               AND (? != 1 \n"
            + "                                     OR (? \n"
            + "                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n"
            + "                       /* Begin permission check */\n"
            + "                       AND (\n"
            + "                               ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                                \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                                \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "                            OR Person.personUid = ?\n"
            + "                           )  \n"
            + "                       /* End permission check */                   \n"
            + "                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n"
            + "                   GROUP BY Person.personUid) AS CourseMember\n"
            + "          ORDER BY CASE(?)\n"
            + "                    WHEN 1 THEN CourseMember.firstNames\n"
            + "                    WHEN 3 THEN CourseMember.lastName\n"
            + "                    ELSE ''\n"
            + "                END ASC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 2 THEN CourseMember.firstNames\n"
            + "                    WHEN 4 THEN CourseMember.lastName\n"
            + "                    ELSE ''\n"
            + "                END DESC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 7 THEN CourseMember.earliestJoinDate\n"
            + "                    WHEN 9 THEN CourseMember.latestDateLeft\n"
            + "                    ELSE 0\n"
            + "                END ASC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 8 THEN CourseMember.earliestJoinDate\n"
            + "                    WHEN 10 THEN CourseMember.latestDateLeft\n"
            + "                    ELSE 0\n"
            + "                END DESC\n"
            + "             LIMIT ?\n"
            + "            OFFSET ?   \n"
            + "         )\n"
            + "    \n"
            + "        \n"
            + "       SELECT ClazzEnrolment.*\n"
            + "         FROM ClazzEnrolment\n"
            + "        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "          AND ClazzEnrolment.clazzEnrolmentRole = ?\n"
            + "          AND ClazzEnrolment.clazzEnrolmentPersonUid IN (\n"
            + "              SELECT PersonUids.personUid\n"
            + "                FROM PersonUids)\n"
            + "              /* Begin permission check*/\n"
            + "          AND (\n"
            + "                   (\n"
            + "         (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     ?\n"
            + "         \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "    )\n"
            + "                OR ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "              )  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 30);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 4;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 14;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 15;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 16;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 17;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 18;
    _statement.bindLong(_argIndex, studentsLimit);
    _argIndex = 19;
    _statement.bindLong(_argIndex, studentsOffset);
    _argIndex = 20;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 22;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 23;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 24;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 25;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 26;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 27;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 28;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 29;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 30;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllEnrolmentsByClazzUidAndRole(final long clazzUid, final int roleId,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "        SELECT ClazzEnrolment.*\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "           AND ClazzEnrolment.clazzEnrolmentRole = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, roleId);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getClazzNameAndPersonName(final long personUid, final long clazzUid,
      final Continuation<? super CourseNameAndPersonName> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.firstNames, Person.lastName, Clazz.clazzName\n"
            + "          FROM Person\n"
            + "               LEFT JOIN Clazz\n"
            + "                         ON Clazz.clazzUid = ?\n"
            + "        WHERE Person.personUid = ?                 \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseNameAndPersonName>() {
      @Override
      @Nullable
      public CourseNameAndPersonName call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfFirstNames = 0;
          final int _cursorIndexOfLastName = 1;
          final int _cursorIndexOfClazzName = 2;
          final CourseNameAndPersonName _result;
          if (_cursor.moveToFirst()) {
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result = new CourseNameAndPersonName(_tmpClazzName,_tmpFirstNames,_tmpLastName);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findClazzEnrolmentEntitiesForPersonViewPermissionCheck(final long accountPersonUid,
      final long otherPersonUid,
      final Continuation<? super List<? extends ClazzEnrolment>> $completion) {
    final String _sql = "\n"
            + "          WITH CanViewMembersClazzesViaCoursePermission(clazzUid) AS\n"
            + "               /* Get clazzuids where active user can view members based on their own enrolment role */\n"
            + "               (SELECT CoursePermission.cpClazzUid\n"
            + "                  FROM ClazzEnrolment ClazzEnrolment_ActiveUser\n"
            + "                       JOIN CoursePermission \n"
            + "                            ON CoursePermission.cpClazzUid = ClazzEnrolment_ActiveUser.clazzEnrolmentClazzUid\n"
            + "                           AND CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ActiveUser.clazzEnrolmentRole\n"
            + "                 WHERE ClazzEnrolment_ActiveUser.clazzEnrolmentPersonUid = ? \n"
            + "                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0 \n"
            + "                UNION\n"
            + "                /* Get ClazzUids where the active user can view members based a grant directly to them */\n"
            + "                SELECT CoursePermission.cpClazzUid\n"
            + "                  FROM CoursePermission\n"
            + "                 WHERE CoursePermission.cpToPersonUid  = ?\n"
            + "                   AND (CoursePermission.cpPermissionsFlag & 8192) > 0\n"
            + "               )\n"
            + "        SELECT ClazzEnrolment.*\n"
            + "          FROM ClazzEnrolment\n"
            + "         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "            OR (    ClazzEnrolment.clazzEnrolmentClazzUid IN \n"
            + "                        (SELECT CanViewMembersClazzesViaCoursePermission.clazzUid\n"
            + "                           FROM CanViewMembersClazzesViaCoursePermission)\n"
            + "                AND (? = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = ?)   \n"
            + "                )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, otherPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzEnrolment>>() {
      @Override
      @NonNull
      public List<ClazzEnrolment> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentUid");
          final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPersonUid");
          final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentClazzUid");
          final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateJoined");
          final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentDateLeft");
          final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentRole");
          final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentAttendancePercentage");
          final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentActive");
          final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLeavingReasonUid");
          final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentOutcome");
          final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLocalChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentMasterChangeSeqNum");
          final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLastChangedBy");
          final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentLct");
          final List<ClazzEnrolment> _result = new ArrayList<ClazzEnrolment>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ClazzEnrolment _item;
            _item = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _item.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _item.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _item.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _item.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = _cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _item.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = _cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _item.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = _cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _item.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _item.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = _cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _item.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = _cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _item.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _item.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _item.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = _cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _item.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = _cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _item.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
