package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentCategory;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentCategoryDao_Impl extends ContentCategoryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentCategory> __insertionAdapterOfContentCategory;

  private final EntityDeletionOrUpdateAdapter<ContentCategory> __updateAdapterOfContentCategory;

  public ContentCategoryDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentCategory = new EntityInsertionAdapter<ContentCategory>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ContentCategory` (`contentCategoryUid`,`ctnCatContentCategorySchemaUid`,`name`,`contentCategoryLocalChangeSeqNum`,`contentCategoryMasterChangeSeqNum`,`contentCategoryLastChangedBy`,`contentCategoryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentCategory entity) {
        statement.bindLong(1, entity.getContentCategoryUid());
        statement.bindLong(2, entity.getCtnCatContentCategorySchemaUid());
        if (entity.getName() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getName());
        }
        statement.bindLong(4, entity.getContentCategoryLocalChangeSeqNum());
        statement.bindLong(5, entity.getContentCategoryMasterChangeSeqNum());
        statement.bindLong(6, entity.getContentCategoryLastChangedBy());
        statement.bindLong(7, entity.getContentCategoryLct());
      }
    };
    this.__updateAdapterOfContentCategory = new EntityDeletionOrUpdateAdapter<ContentCategory>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContentCategory` SET `contentCategoryUid` = ?,`ctnCatContentCategorySchemaUid` = ?,`name` = ?,`contentCategoryLocalChangeSeqNum` = ?,`contentCategoryMasterChangeSeqNum` = ?,`contentCategoryLastChangedBy` = ?,`contentCategoryLct` = ? WHERE `contentCategoryUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentCategory entity) {
        statement.bindLong(1, entity.getContentCategoryUid());
        statement.bindLong(2, entity.getCtnCatContentCategorySchemaUid());
        if (entity.getName() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getName());
        }
        statement.bindLong(4, entity.getContentCategoryLocalChangeSeqNum());
        statement.bindLong(5, entity.getContentCategoryMasterChangeSeqNum());
        statement.bindLong(6, entity.getContentCategoryLastChangedBy());
        statement.bindLong(7, entity.getContentCategoryLct());
        statement.bindLong(8, entity.getContentCategoryUid());
      }
    };
  }

  @Override
  public long insert(final ContentCategory entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfContentCategory.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentCategory entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfContentCategory.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ContentCategory> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentCategory.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentCategory entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentCategory.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<ContentCategory> publicContentCategories() {
    final String _sql = "SELECT ContentCategory.* FROM ContentCategory";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentCategoryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryUid");
      final int _cursorIndexOfCtnCatContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctnCatContentCategorySchemaUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfContentCategoryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLocalChangeSeqNum");
      final int _cursorIndexOfContentCategoryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryMasterChangeSeqNum");
      final int _cursorIndexOfContentCategoryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLastChangedBy");
      final int _cursorIndexOfContentCategoryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLct");
      final List<ContentCategory> _result = new ArrayList<ContentCategory>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ContentCategory _item;
        _item = new ContentCategory();
        final long _tmpContentCategoryUid;
        _tmpContentCategoryUid = _cursor.getLong(_cursorIndexOfContentCategoryUid);
        _item.setContentCategoryUid(_tmpContentCategoryUid);
        final long _tmpCtnCatContentCategorySchemaUid;
        _tmpCtnCatContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfCtnCatContentCategorySchemaUid);
        _item.setCtnCatContentCategorySchemaUid(_tmpCtnCatContentCategorySchemaUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _item.setName(_tmpName);
        final long _tmpContentCategoryLocalChangeSeqNum;
        _tmpContentCategoryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryLocalChangeSeqNum);
        _item.setContentCategoryLocalChangeSeqNum(_tmpContentCategoryLocalChangeSeqNum);
        final long _tmpContentCategoryMasterChangeSeqNum;
        _tmpContentCategoryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryMasterChangeSeqNum);
        _item.setContentCategoryMasterChangeSeqNum(_tmpContentCategoryMasterChangeSeqNum);
        final int _tmpContentCategoryLastChangedBy;
        _tmpContentCategoryLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategoryLastChangedBy);
        _item.setContentCategoryLastChangedBy(_tmpContentCategoryLastChangedBy);
        final long _tmpContentCategoryLct;
        _tmpContentCategoryLct = _cursor.getLong(_cursorIndexOfContentCategoryLct);
        _item.setContentCategoryLct(_tmpContentCategoryLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentCategory findCategoryBySchemaIdAndName(final long schemaId, final String name) {
    final String _sql = "SELECT * FROM ContentCategory WHERE ctnCatContentCategorySchemaUid = ? AND name = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schemaId);
    _argIndex = 2;
    _statement.bindString(_argIndex, name);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentCategoryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryUid");
      final int _cursorIndexOfCtnCatContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctnCatContentCategorySchemaUid");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfContentCategoryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLocalChangeSeqNum");
      final int _cursorIndexOfContentCategoryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryMasterChangeSeqNum");
      final int _cursorIndexOfContentCategoryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLastChangedBy");
      final int _cursorIndexOfContentCategoryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategoryLct");
      final ContentCategory _result;
      if (_cursor.moveToFirst()) {
        _result = new ContentCategory();
        final long _tmpContentCategoryUid;
        _tmpContentCategoryUid = _cursor.getLong(_cursorIndexOfContentCategoryUid);
        _result.setContentCategoryUid(_tmpContentCategoryUid);
        final long _tmpCtnCatContentCategorySchemaUid;
        _tmpCtnCatContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfCtnCatContentCategorySchemaUid);
        _result.setCtnCatContentCategorySchemaUid(_tmpCtnCatContentCategorySchemaUid);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final long _tmpContentCategoryLocalChangeSeqNum;
        _tmpContentCategoryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryLocalChangeSeqNum);
        _result.setContentCategoryLocalChangeSeqNum(_tmpContentCategoryLocalChangeSeqNum);
        final long _tmpContentCategoryMasterChangeSeqNum;
        _tmpContentCategoryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategoryMasterChangeSeqNum);
        _result.setContentCategoryMasterChangeSeqNum(_tmpContentCategoryMasterChangeSeqNum);
        final int _tmpContentCategoryLastChangedBy;
        _tmpContentCategoryLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategoryLastChangedBy);
        _result.setContentCategoryLastChangedBy(_tmpContentCategoryLastChangedBy);
        final long _tmpContentCategoryLct;
        _tmpContentCategoryLct = _cursor.getLong(_cursorIndexOfContentCategoryLct);
        _result.setContentCategoryLct(_tmpContentCategoryLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
