package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.StudentResultAndCourseBlockSourcedId;
import com.ustadmobile.lib.db.entities.StudentResult;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class StudentResultDao_Impl extends StudentResultDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StudentResult> __insertionAdapterOfStudentResult;

  private final EntityInsertionAdapter<StudentResult> __insertionAdapterOfStudentResult_1;

  public StudentResultDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStudentResult = new EntityInsertionAdapter<StudentResult>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `StudentResult` (`srUid`,`srSourcedId`,`srCourseBlockUid`,`srLineItemSourcedId`,`srLineItemHref`,`srClazzUid`,`srAssignmentUid`,`srStatus`,`srMetaData`,`srStudentPersonUid`,`srStudentPersonSourcedId`,`srStudentGroupId`,`srMarkerPersonUid`,`srMarkerGroupId`,`srScoreStatus`,`srScore`,`srScoreDate`,`srLastModified`,`srComment`,`srAppId`,`srDeleted`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final StudentResult entity) {
        statement.bindLong(1, entity.getSrUid());
        if (entity.getSrSourcedId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getSrSourcedId());
        }
        statement.bindLong(3, entity.getSrCourseBlockUid());
        if (entity.getSrLineItemSourcedId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getSrLineItemSourcedId());
        }
        if (entity.getSrLineItemHref() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getSrLineItemHref());
        }
        statement.bindLong(6, entity.getSrClazzUid());
        statement.bindLong(7, entity.getSrAssignmentUid());
        statement.bindLong(8, entity.getSrStatus());
        if (entity.getSrMetaData() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getSrMetaData());
        }
        statement.bindLong(10, entity.getSrStudentPersonUid());
        if (entity.getSrStudentPersonSourcedId() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getSrStudentPersonSourcedId());
        }
        statement.bindLong(12, entity.getSrStudentGroupId());
        statement.bindLong(13, entity.getSrMarkerPersonUid());
        statement.bindLong(14, entity.getSrMarkerGroupId());
        statement.bindLong(15, entity.getSrScoreStatus());
        statement.bindDouble(16, entity.getSrScore());
        statement.bindLong(17, entity.getSrScoreDate());
        statement.bindLong(18, entity.getSrLastModified());
        if (entity.getSrComment() == null) {
          statement.bindNull(19);
        } else {
          statement.bindString(19, entity.getSrComment());
        }
        if (entity.getSrAppId() == null) {
          statement.bindNull(20);
        } else {
          statement.bindString(20, entity.getSrAppId());
        }
        final int _tmp = entity.getSrDeleted() ? 1 : 0;
        statement.bindLong(21, _tmp);
      }
    };
    this.__insertionAdapterOfStudentResult_1 = new EntityInsertionAdapter<StudentResult>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `StudentResult` (`srUid`,`srSourcedId`,`srCourseBlockUid`,`srLineItemSourcedId`,`srLineItemHref`,`srClazzUid`,`srAssignmentUid`,`srStatus`,`srMetaData`,`srStudentPersonUid`,`srStudentPersonSourcedId`,`srStudentGroupId`,`srMarkerPersonUid`,`srMarkerGroupId`,`srScoreStatus`,`srScore`,`srScoreDate`,`srLastModified`,`srComment`,`srAppId`,`srDeleted`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final StudentResult entity) {
        statement.bindLong(1, entity.getSrUid());
        if (entity.getSrSourcedId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getSrSourcedId());
        }
        statement.bindLong(3, entity.getSrCourseBlockUid());
        if (entity.getSrLineItemSourcedId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getSrLineItemSourcedId());
        }
        if (entity.getSrLineItemHref() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getSrLineItemHref());
        }
        statement.bindLong(6, entity.getSrClazzUid());
        statement.bindLong(7, entity.getSrAssignmentUid());
        statement.bindLong(8, entity.getSrStatus());
        if (entity.getSrMetaData() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getSrMetaData());
        }
        statement.bindLong(10, entity.getSrStudentPersonUid());
        if (entity.getSrStudentPersonSourcedId() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getSrStudentPersonSourcedId());
        }
        statement.bindLong(12, entity.getSrStudentGroupId());
        statement.bindLong(13, entity.getSrMarkerPersonUid());
        statement.bindLong(14, entity.getSrMarkerGroupId());
        statement.bindLong(15, entity.getSrScoreStatus());
        statement.bindDouble(16, entity.getSrScore());
        statement.bindLong(17, entity.getSrScoreDate());
        statement.bindLong(18, entity.getSrLastModified());
        if (entity.getSrComment() == null) {
          statement.bindNull(19);
        } else {
          statement.bindString(19, entity.getSrComment());
        }
        if (entity.getSrAppId() == null) {
          statement.bindNull(20);
        } else {
          statement.bindString(20, entity.getSrAppId());
        }
        final int _tmp = entity.getSrDeleted() ? 1 : 0;
        statement.bindLong(21, _tmp);
      }
    };
  }

  @Override
  public Object insertListAsync(final List<StudentResult> list,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStudentResult.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertAsync(final StudentResult studentResult,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStudentResult_1.insert(studentResult);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByClazzAndStudent(final long clazzUid, final long studentPersonUid,
      final long accountPersonUid,
      final Continuation<? super List<StudentResultAndCourseBlockSourcedId>> $completion) {
    final String _sql = "\n"
            + "        SELECT StudentResult.*,\n"
            + "               CourseBlock.cbSourcedId AS cbSourcedId\n"
            + "          FROM StudentResult\n"
            + "               LEFT JOIN CourseBlock\n"
            + "                         ON StudentResult.srCourseBlockUid = CourseBlock.cbUid \n"
            + "         WHERE StudentResult.srClazzUid = ?\n"
            + "           AND StudentResult.srStudentPersonUid = ?\n"
            + "           AND ? = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, studentPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StudentResultAndCourseBlockSourcedId>>() {
      @Override
      @NonNull
      public List<StudentResultAndCourseBlockSourcedId> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSrUid = CursorUtil.getColumnIndexOrThrow(_cursor, "srUid");
          final int _cursorIndexOfSrSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "srSourcedId");
          final int _cursorIndexOfSrCourseBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "srCourseBlockUid");
          final int _cursorIndexOfSrLineItemSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "srLineItemSourcedId");
          final int _cursorIndexOfSrLineItemHref = CursorUtil.getColumnIndexOrThrow(_cursor, "srLineItemHref");
          final int _cursorIndexOfSrClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "srClazzUid");
          final int _cursorIndexOfSrAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "srAssignmentUid");
          final int _cursorIndexOfSrStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "srStatus");
          final int _cursorIndexOfSrMetaData = CursorUtil.getColumnIndexOrThrow(_cursor, "srMetaData");
          final int _cursorIndexOfSrStudentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "srStudentPersonUid");
          final int _cursorIndexOfSrStudentPersonSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "srStudentPersonSourcedId");
          final int _cursorIndexOfSrStudentGroupId = CursorUtil.getColumnIndexOrThrow(_cursor, "srStudentGroupId");
          final int _cursorIndexOfSrMarkerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "srMarkerPersonUid");
          final int _cursorIndexOfSrMarkerGroupId = CursorUtil.getColumnIndexOrThrow(_cursor, "srMarkerGroupId");
          final int _cursorIndexOfSrScoreStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "srScoreStatus");
          final int _cursorIndexOfSrScore = CursorUtil.getColumnIndexOrThrow(_cursor, "srScore");
          final int _cursorIndexOfSrScoreDate = CursorUtil.getColumnIndexOrThrow(_cursor, "srScoreDate");
          final int _cursorIndexOfSrLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "srLastModified");
          final int _cursorIndexOfSrComment = CursorUtil.getColumnIndexOrThrow(_cursor, "srComment");
          final int _cursorIndexOfSrAppId = CursorUtil.getColumnIndexOrThrow(_cursor, "srAppId");
          final int _cursorIndexOfSrDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "srDeleted");
          final int _cursorIndexOfCbSourcedId = CursorUtil.getColumnIndexOrThrow(_cursor, "cbSourcedId");
          final List<StudentResultAndCourseBlockSourcedId> _result = new ArrayList<StudentResultAndCourseBlockSourcedId>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StudentResultAndCourseBlockSourcedId _item;
            final String _tmpCbSourcedId;
            if (_cursor.isNull(_cursorIndexOfCbSourcedId)) {
              _tmpCbSourcedId = null;
            } else {
              _tmpCbSourcedId = _cursor.getString(_cursorIndexOfCbSourcedId);
            }
            final StudentResult _tmpStudentResult;
            final long _tmpSrUid;
            _tmpSrUid = _cursor.getLong(_cursorIndexOfSrUid);
            final String _tmpSrSourcedId;
            if (_cursor.isNull(_cursorIndexOfSrSourcedId)) {
              _tmpSrSourcedId = null;
            } else {
              _tmpSrSourcedId = _cursor.getString(_cursorIndexOfSrSourcedId);
            }
            final long _tmpSrCourseBlockUid;
            _tmpSrCourseBlockUid = _cursor.getLong(_cursorIndexOfSrCourseBlockUid);
            final String _tmpSrLineItemSourcedId;
            if (_cursor.isNull(_cursorIndexOfSrLineItemSourcedId)) {
              _tmpSrLineItemSourcedId = null;
            } else {
              _tmpSrLineItemSourcedId = _cursor.getString(_cursorIndexOfSrLineItemSourcedId);
            }
            final String _tmpSrLineItemHref;
            if (_cursor.isNull(_cursorIndexOfSrLineItemHref)) {
              _tmpSrLineItemHref = null;
            } else {
              _tmpSrLineItemHref = _cursor.getString(_cursorIndexOfSrLineItemHref);
            }
            final long _tmpSrClazzUid;
            _tmpSrClazzUid = _cursor.getLong(_cursorIndexOfSrClazzUid);
            final long _tmpSrAssignmentUid;
            _tmpSrAssignmentUid = _cursor.getLong(_cursorIndexOfSrAssignmentUid);
            final int _tmpSrStatus;
            _tmpSrStatus = _cursor.getInt(_cursorIndexOfSrStatus);
            final String _tmpSrMetaData;
            if (_cursor.isNull(_cursorIndexOfSrMetaData)) {
              _tmpSrMetaData = null;
            } else {
              _tmpSrMetaData = _cursor.getString(_cursorIndexOfSrMetaData);
            }
            final long _tmpSrStudentPersonUid;
            _tmpSrStudentPersonUid = _cursor.getLong(_cursorIndexOfSrStudentPersonUid);
            final String _tmpSrStudentPersonSourcedId;
            if (_cursor.isNull(_cursorIndexOfSrStudentPersonSourcedId)) {
              _tmpSrStudentPersonSourcedId = null;
            } else {
              _tmpSrStudentPersonSourcedId = _cursor.getString(_cursorIndexOfSrStudentPersonSourcedId);
            }
            final int _tmpSrStudentGroupId;
            _tmpSrStudentGroupId = _cursor.getInt(_cursorIndexOfSrStudentGroupId);
            final long _tmpSrMarkerPersonUid;
            _tmpSrMarkerPersonUid = _cursor.getLong(_cursorIndexOfSrMarkerPersonUid);
            final int _tmpSrMarkerGroupId;
            _tmpSrMarkerGroupId = _cursor.getInt(_cursorIndexOfSrMarkerGroupId);
            final int _tmpSrScoreStatus;
            _tmpSrScoreStatus = _cursor.getInt(_cursorIndexOfSrScoreStatus);
            final float _tmpSrScore;
            _tmpSrScore = _cursor.getFloat(_cursorIndexOfSrScore);
            final long _tmpSrScoreDate;
            _tmpSrScoreDate = _cursor.getLong(_cursorIndexOfSrScoreDate);
            final long _tmpSrLastModified;
            _tmpSrLastModified = _cursor.getLong(_cursorIndexOfSrLastModified);
            final String _tmpSrComment;
            if (_cursor.isNull(_cursorIndexOfSrComment)) {
              _tmpSrComment = null;
            } else {
              _tmpSrComment = _cursor.getString(_cursorIndexOfSrComment);
            }
            final String _tmpSrAppId;
            if (_cursor.isNull(_cursorIndexOfSrAppId)) {
              _tmpSrAppId = null;
            } else {
              _tmpSrAppId = _cursor.getString(_cursorIndexOfSrAppId);
            }
            final boolean _tmpSrDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSrDeleted);
            _tmpSrDeleted = _tmp != 0;
            _tmpStudentResult = new StudentResult(_tmpSrUid,_tmpSrSourcedId,_tmpSrCourseBlockUid,_tmpSrLineItemSourcedId,_tmpSrLineItemHref,_tmpSrClazzUid,_tmpSrAssignmentUid,_tmpSrStatus,_tmpSrMetaData,_tmpSrStudentPersonUid,_tmpSrStudentPersonSourcedId,_tmpSrStudentGroupId,_tmpSrMarkerPersonUid,_tmpSrMarkerGroupId,_tmpSrScoreStatus,_tmpSrScore,_tmpSrScoreDate,_tmpSrLastModified,_tmpSrComment,_tmpSrAppId,_tmpSrDeleted);
            _item = new StudentResultAndCourseBlockSourcedId(_tmpStudentResult,_tmpCbSourcedId);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findUidBySourcedId(final String sourcedId,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT StudentResult.srUid  \n"
            + "                  FROM StudentResult \n"
            + "                 WHERE srSourcedId = ?), 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, sourcedId);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object existsByUid(final long srUid, final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT StudentResult.srUid\n"
            + "                 FROM StudentResult\n"
            + "                WHERE StudentResult.srUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, srUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
