package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.CourseBlock
import com.ustadmobile.lib.db.entities.StudentResult
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun StudentResultDao.findByClazzAndStudent_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_studentPersonUid : Long = request.queryParam("studentPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByClazzAndStudent = findByClazzAndStudent(
    clazzUid = _arg_clazzUid,
    studentPersonUid = _arg_studentPersonUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findByClazzUid =
      request.db.doorWrapper.getDaoByClass(CourseBlockDao::class).findByClazzUid(
    clazzUid = _arg_clazzUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByClazzAndStudent.map {
        _row ->
        DoorReplicationEntity(tableId = 471,
          orUid = 0,
          entity = json.encodeToJsonElement(StudentResult.serializer(),
              _row.studentResult).jsonObject,
        )
      }
    )
    addAll(
      _result_findByClazzUid.map {
        _row ->
        DoorReplicationEntity(tableId = 124,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseBlock.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
