package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonAuth2;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonAuth2Dao_Impl extends PersonAuth2Dao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonAuth2> __insertionAdapterOfPersonAuth2;

  private final EntityInsertionAdapter<PersonAuth2> __insertionAdapterOfPersonAuth2_1;

  public PersonAuth2Dao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonAuth2 = new EntityInsertionAdapter<PersonAuth2>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `PersonAuth2` (`pauthUid`,`pauthMechanism`,`pauthAuth`,`pauthLcsn`,`pauthPcsn`,`pauthLcb`,`pauthLct`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonAuth2 entity) {
        statement.bindLong(1, entity.getPauthUid());
        if (entity.getPauthMechanism() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPauthMechanism());
        }
        if (entity.getPauthAuth() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getPauthAuth());
        }
        statement.bindLong(4, entity.getPauthLcsn());
        statement.bindLong(5, entity.getPauthPcsn());
        statement.bindLong(6, entity.getPauthLcb());
        statement.bindLong(7, entity.getPauthLct());
      }
    };
    this.__insertionAdapterOfPersonAuth2_1 = new EntityInsertionAdapter<PersonAuth2>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `PersonAuth2` (`pauthUid`,`pauthMechanism`,`pauthAuth`,`pauthLcsn`,`pauthPcsn`,`pauthLcb`,`pauthLct`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PersonAuth2 entity) {
        statement.bindLong(1, entity.getPauthUid());
        if (entity.getPauthMechanism() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getPauthMechanism());
        }
        if (entity.getPauthAuth() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getPauthAuth());
        }
        statement.bindLong(4, entity.getPauthLcsn());
        statement.bindLong(5, entity.getPauthPcsn());
        statement.bindLong(6, entity.getPauthLcb());
        statement.bindLong(7, entity.getPauthLct());
      }
    };
  }

  @Override
  public Object insertListAsync(final List<PersonAuth2> auths,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPersonAuth2.insert(auths);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object insertAsync(final PersonAuth2 auth, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfPersonAuth2_1.insertAndReturnId(auth);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByPersonUid(final long personUid,
      final Continuation<? super PersonAuth2> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonAuth2.*\n"
            + "          FROM PersonAuth2\n"
            + "         WHERE PersonAuth2.pauthUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonAuth2>() {
      @Override
      @Nullable
      public PersonAuth2 call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPauthUid = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthUid");
          final int _cursorIndexOfPauthMechanism = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthMechanism");
          final int _cursorIndexOfPauthAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthAuth");
          final int _cursorIndexOfPauthLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcsn");
          final int _cursorIndexOfPauthPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthPcsn");
          final int _cursorIndexOfPauthLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcb");
          final int _cursorIndexOfPauthLct = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLct");
          final PersonAuth2 _result;
          if (_cursor.moveToFirst()) {
            _result = new PersonAuth2();
            final long _tmpPauthUid;
            _tmpPauthUid = _cursor.getLong(_cursorIndexOfPauthUid);
            _result.setPauthUid(_tmpPauthUid);
            final String _tmpPauthMechanism;
            if (_cursor.isNull(_cursorIndexOfPauthMechanism)) {
              _tmpPauthMechanism = null;
            } else {
              _tmpPauthMechanism = _cursor.getString(_cursorIndexOfPauthMechanism);
            }
            _result.setPauthMechanism(_tmpPauthMechanism);
            final String _tmpPauthAuth;
            if (_cursor.isNull(_cursorIndexOfPauthAuth)) {
              _tmpPauthAuth = null;
            } else {
              _tmpPauthAuth = _cursor.getString(_cursorIndexOfPauthAuth);
            }
            _result.setPauthAuth(_tmpPauthAuth);
            final long _tmpPauthLcsn;
            _tmpPauthLcsn = _cursor.getLong(_cursorIndexOfPauthLcsn);
            _result.setPauthLcsn(_tmpPauthLcsn);
            final long _tmpPauthPcsn;
            _tmpPauthPcsn = _cursor.getLong(_cursorIndexOfPauthPcsn);
            _result.setPauthPcsn(_tmpPauthPcsn);
            final long _tmpPauthLcb;
            _tmpPauthLcb = _cursor.getLong(_cursorIndexOfPauthLcb);
            _result.setPauthLcb(_tmpPauthLcb);
            final long _tmpPauthLct;
            _tmpPauthLct = _cursor.getLong(_cursorIndexOfPauthLct);
            _result.setPauthLct(_tmpPauthLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUsername(final String username,
      final Continuation<? super PersonAuth2> $completion) {
    final String _sql = "\n"
            + "        SELECT PersonAuth2.*\n"
            + "          FROM PersonAuth2\n"
            + "               JOIN Person ON PersonAuth2.pauthUid = Person.personUid\n"
            + "         WHERE Person.username = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, username);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonAuth2>() {
      @Override
      @Nullable
      public PersonAuth2 call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPauthUid = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthUid");
          final int _cursorIndexOfPauthMechanism = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthMechanism");
          final int _cursorIndexOfPauthAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthAuth");
          final int _cursorIndexOfPauthLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcsn");
          final int _cursorIndexOfPauthPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthPcsn");
          final int _cursorIndexOfPauthLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcb");
          final int _cursorIndexOfPauthLct = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLct");
          final PersonAuth2 _result;
          if (_cursor.moveToFirst()) {
            _result = new PersonAuth2();
            final long _tmpPauthUid;
            _tmpPauthUid = _cursor.getLong(_cursorIndexOfPauthUid);
            _result.setPauthUid(_tmpPauthUid);
            final String _tmpPauthMechanism;
            if (_cursor.isNull(_cursorIndexOfPauthMechanism)) {
              _tmpPauthMechanism = null;
            } else {
              _tmpPauthMechanism = _cursor.getString(_cursorIndexOfPauthMechanism);
            }
            _result.setPauthMechanism(_tmpPauthMechanism);
            final String _tmpPauthAuth;
            if (_cursor.isNull(_cursorIndexOfPauthAuth)) {
              _tmpPauthAuth = null;
            } else {
              _tmpPauthAuth = _cursor.getString(_cursorIndexOfPauthAuth);
            }
            _result.setPauthAuth(_tmpPauthAuth);
            final long _tmpPauthLcsn;
            _tmpPauthLcsn = _cursor.getLong(_cursorIndexOfPauthLcsn);
            _result.setPauthLcsn(_tmpPauthLcsn);
            final long _tmpPauthPcsn;
            _tmpPauthPcsn = _cursor.getLong(_cursorIndexOfPauthPcsn);
            _result.setPauthPcsn(_tmpPauthPcsn);
            final long _tmpPauthLcb;
            _tmpPauthLcb = _cursor.getLong(_cursorIndexOfPauthLcb);
            _result.setPauthLcb(_tmpPauthLcb);
            final long _tmpPauthLct;
            _tmpPauthLct = _cursor.getLong(_cursorIndexOfPauthLct);
            _result.setPauthLct(_tmpPauthLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
