package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Site;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class SiteDao_Impl extends SiteDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Site> __insertionAdapterOfSite;

  private final EntityInsertionAdapter<Site> __insertionAdapterOfSite_1;

  private final EntityDeletionOrUpdateAdapter<Site> __updateAdapterOfSite;

  public SiteDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSite = new EntityInsertionAdapter<Site>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `Site` (`siteUid`,`sitePcsn`,`siteLcsn`,`siteLcb`,`siteLct`,`siteName`,`guestLogin`,`registrationAllowed`,`authSalt`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Site entity) {
        statement.bindLong(1, entity.getSiteUid());
        statement.bindLong(2, entity.getSitePcsn());
        statement.bindLong(3, entity.getSiteLcsn());
        statement.bindLong(4, entity.getSiteLcb());
        statement.bindLong(5, entity.getSiteLct());
        if (entity.getSiteName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getSiteName());
        }
        final int _tmp = entity.getGuestLogin() ? 1 : 0;
        statement.bindLong(7, _tmp);
        final int _tmp_1 = entity.getRegistrationAllowed() ? 1 : 0;
        statement.bindLong(8, _tmp_1);
        if (entity.getAuthSalt() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getAuthSalt());
        }
      }
    };
    this.__insertionAdapterOfSite_1 = new EntityInsertionAdapter<Site>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Site` (`siteUid`,`sitePcsn`,`siteLcsn`,`siteLcb`,`siteLct`,`siteName`,`guestLogin`,`registrationAllowed`,`authSalt`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Site entity) {
        statement.bindLong(1, entity.getSiteUid());
        statement.bindLong(2, entity.getSitePcsn());
        statement.bindLong(3, entity.getSiteLcsn());
        statement.bindLong(4, entity.getSiteLcb());
        statement.bindLong(5, entity.getSiteLct());
        if (entity.getSiteName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getSiteName());
        }
        final int _tmp = entity.getGuestLogin() ? 1 : 0;
        statement.bindLong(7, _tmp);
        final int _tmp_1 = entity.getRegistrationAllowed() ? 1 : 0;
        statement.bindLong(8, _tmp_1);
        if (entity.getAuthSalt() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getAuthSalt());
        }
      }
    };
    this.__updateAdapterOfSite = new EntityDeletionOrUpdateAdapter<Site>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Site` SET `siteUid` = ?,`sitePcsn` = ?,`siteLcsn` = ?,`siteLcb` = ?,`siteLct` = ?,`siteName` = ?,`guestLogin` = ?,`registrationAllowed` = ?,`authSalt` = ? WHERE `siteUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Site entity) {
        statement.bindLong(1, entity.getSiteUid());
        statement.bindLong(2, entity.getSitePcsn());
        statement.bindLong(3, entity.getSiteLcsn());
        statement.bindLong(4, entity.getSiteLcb());
        statement.bindLong(5, entity.getSiteLct());
        if (entity.getSiteName() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getSiteName());
        }
        final int _tmp = entity.getGuestLogin() ? 1 : 0;
        statement.bindLong(7, _tmp);
        final int _tmp_1 = entity.getRegistrationAllowed() ? 1 : 0;
        statement.bindLong(8, _tmp_1);
        if (entity.getAuthSalt() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getAuthSalt());
        }
        statement.bindLong(10, entity.getSiteUid());
      }
    };
  }

  @Override
  public Object replaceAsync(final Site site, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfSite.insertAndReturnId(site);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public long insert(final Site site) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfSite_1.insertAndReturnId(site);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Site workspace, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfSite.handle(workspace);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Site getSite() {
    final String _sql = "SELECT * FROM Site LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "siteUid");
      final int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sitePcsn");
      final int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcsn");
      final int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcb");
      final int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLct");
      final int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow(_cursor, "siteName");
      final int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow(_cursor, "guestLogin");
      final int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "registrationAllowed");
      final int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow(_cursor, "authSalt");
      final Site _result;
      if (_cursor.moveToFirst()) {
        _result = new Site();
        final long _tmpSiteUid;
        _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
        _result.setSiteUid(_tmpSiteUid);
        final long _tmpSitePcsn;
        _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
        _result.setSitePcsn(_tmpSitePcsn);
        final long _tmpSiteLcsn;
        _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
        _result.setSiteLcsn(_tmpSiteLcsn);
        final int _tmpSiteLcb;
        _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
        _result.setSiteLcb(_tmpSiteLcb);
        final long _tmpSiteLct;
        _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
        _result.setSiteLct(_tmpSiteLct);
        final String _tmpSiteName;
        if (_cursor.isNull(_cursorIndexOfSiteName)) {
          _tmpSiteName = null;
        } else {
          _tmpSiteName = _cursor.getString(_cursorIndexOfSiteName);
        }
        _result.setSiteName(_tmpSiteName);
        final boolean _tmpGuestLogin;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
        _tmpGuestLogin = _tmp != 0;
        _result.setGuestLogin(_tmpGuestLogin);
        final boolean _tmpRegistrationAllowed;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
        _tmpRegistrationAllowed = _tmp_1 != 0;
        _result.setRegistrationAllowed(_tmpRegistrationAllowed);
        final String _tmpAuthSalt;
        if (_cursor.isNull(_cursorIndexOfAuthSalt)) {
          _tmpAuthSalt = null;
        } else {
          _tmpAuthSalt = _cursor.getString(_cursorIndexOfAuthSalt);
        }
        _result.setAuthSalt(_tmpAuthSalt);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getSiteAsync(final Continuation<? super Site> $completion) {
    final String _sql = "SELECT * FROM Site LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Site>() {
      @Override
      @Nullable
      public Site call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "siteUid");
          final int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sitePcsn");
          final int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcsn");
          final int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcb");
          final int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLct");
          final int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow(_cursor, "siteName");
          final int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow(_cursor, "guestLogin");
          final int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "registrationAllowed");
          final int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow(_cursor, "authSalt");
          final Site _result;
          if (_cursor.moveToFirst()) {
            _result = new Site();
            final long _tmpSiteUid;
            _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
            _result.setSiteUid(_tmpSiteUid);
            final long _tmpSitePcsn;
            _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
            _result.setSitePcsn(_tmpSitePcsn);
            final long _tmpSiteLcsn;
            _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
            _result.setSiteLcsn(_tmpSiteLcsn);
            final int _tmpSiteLcb;
            _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
            _result.setSiteLcb(_tmpSiteLcb);
            final long _tmpSiteLct;
            _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
            _result.setSiteLct(_tmpSiteLct);
            final String _tmpSiteName;
            if (_cursor.isNull(_cursorIndexOfSiteName)) {
              _tmpSiteName = null;
            } else {
              _tmpSiteName = _cursor.getString(_cursorIndexOfSiteName);
            }
            _result.setSiteName(_tmpSiteName);
            final boolean _tmpGuestLogin;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
            _tmpGuestLogin = _tmp != 0;
            _result.setGuestLogin(_tmpGuestLogin);
            final boolean _tmpRegistrationAllowed;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
            _tmpRegistrationAllowed = _tmp_1 != 0;
            _result.setRegistrationAllowed(_tmpRegistrationAllowed);
            final String _tmpAuthSalt;
            if (_cursor.isNull(_cursorIndexOfAuthSalt)) {
              _tmpAuthSalt = null;
            } else {
              _tmpAuthSalt = _cursor.getString(_cursorIndexOfAuthSalt);
            }
            _result.setAuthSalt(_tmpAuthSalt);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getSiteAuthSaltAsync(final Continuation<? super String> $completion) {
    final String _sql = "SELECT authSalt FROM Site LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Site> getSiteAsFlow() {
    final String _sql = "SELECT * FROM Site LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Site"}, new Callable<Site>() {
      @Override
      @Nullable
      public Site call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "siteUid");
          final int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sitePcsn");
          final int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcsn");
          final int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcb");
          final int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLct");
          final int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow(_cursor, "siteName");
          final int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow(_cursor, "guestLogin");
          final int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "registrationAllowed");
          final int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow(_cursor, "authSalt");
          final Site _result;
          if (_cursor.moveToFirst()) {
            _result = new Site();
            final long _tmpSiteUid;
            _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
            _result.setSiteUid(_tmpSiteUid);
            final long _tmpSitePcsn;
            _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
            _result.setSitePcsn(_tmpSitePcsn);
            final long _tmpSiteLcsn;
            _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
            _result.setSiteLcsn(_tmpSiteLcsn);
            final int _tmpSiteLcb;
            _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
            _result.setSiteLcb(_tmpSiteLcb);
            final long _tmpSiteLct;
            _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
            _result.setSiteLct(_tmpSiteLct);
            final String _tmpSiteName;
            if (_cursor.isNull(_cursorIndexOfSiteName)) {
              _tmpSiteName = null;
            } else {
              _tmpSiteName = _cursor.getString(_cursorIndexOfSiteName);
            }
            _result.setSiteName(_tmpSiteName);
            final boolean _tmpGuestLogin;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
            _tmpGuestLogin = _tmp != 0;
            _result.setGuestLogin(_tmpGuestLogin);
            final boolean _tmpRegistrationAllowed;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
            _tmpRegistrationAllowed = _tmp_1 != 0;
            _result.setRegistrationAllowed(_tmpRegistrationAllowed);
            final String _tmpAuthSalt;
            if (_cursor.isNull(_cursorIndexOfAuthSalt)) {
              _tmpAuthSalt = null;
            } else {
              _tmpAuthSalt = _cursor.getString(_cursorIndexOfAuthSalt);
            }
            _result.setAuthSalt(_tmpAuthSalt);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
