package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.ClazzAndDetailPermissions;
import com.ustadmobile.lib.db.composites.ClazzAndDisplayDetails;
import com.ustadmobile.lib.db.composites.ClazzNameAndTerminology;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.ClazzWithHolidayCalendarAndAndTerminology;
import com.ustadmobile.lib.db.entities.ClazzWithListDisplayDetails;
import com.ustadmobile.lib.db.entities.CoursePicture;
import com.ustadmobile.lib.db.entities.CourseTerminology;
import com.ustadmobile.lib.db.entities.HolidayCalendar;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzDao_Impl extends ClazzDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Clazz> __insertionAdapterOfClazz;

  private final EntityDeletionOrUpdateAdapter<Clazz> __updateAdapterOfClazz;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzAttendanceAverageAsync;

  public ClazzDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazz = new EntityInsertionAdapter<Clazz>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Clazz` (`clazzUid`,`clazzName`,`clazzDesc`,`attendanceAverage`,`clazzHolidayUMCalendarUid`,`clazzScheuleUMCalendarUid`,`isClazzActive`,`clazzLocationUid`,`clazzStartTime`,`clazzEndTime`,`clazzFeatures`,`clazzSchoolUid`,`clazzEnrolmentPolicy`,`clazzTerminologyUid`,`clazzMasterChangeSeqNum`,`clazzLocalChangeSeqNum`,`clazzLastChangedBy`,`clazzLct`,`clazzTimeZone`,`clazzStudentsPersonGroupUid`,`clazzTeachersPersonGroupUid`,`clazzPendingStudentsPersonGroupUid`,`clazzParentsPersonGroupUid`,`clazzCode`,`clazzOwnerPersonUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Clazz entity) {
        statement.bindLong(1, entity.getClazzUid());
        if (entity.getClazzName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getClazzName());
        }
        if (entity.getClazzDesc() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getClazzDesc());
        }
        statement.bindDouble(4, entity.getAttendanceAverage());
        statement.bindLong(5, entity.getClazzHolidayUMCalendarUid());
        statement.bindLong(6, entity.getClazzScheuleUMCalendarUid());
        final int _tmp = entity.isClazzActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getClazzLocationUid());
        statement.bindLong(9, entity.getClazzStartTime());
        statement.bindLong(10, entity.getClazzEndTime());
        statement.bindLong(11, entity.getClazzFeatures());
        statement.bindLong(12, entity.getClazzSchoolUid());
        statement.bindLong(13, entity.getClazzEnrolmentPolicy());
        statement.bindLong(14, entity.getClazzTerminologyUid());
        statement.bindLong(15, entity.getClazzMasterChangeSeqNum());
        statement.bindLong(16, entity.getClazzLocalChangeSeqNum());
        statement.bindLong(17, entity.getClazzLastChangedBy());
        statement.bindLong(18, entity.getClazzLct());
        if (entity.getClazzTimeZone() == null) {
          statement.bindNull(19);
        } else {
          statement.bindString(19, entity.getClazzTimeZone());
        }
        statement.bindLong(20, entity.getClazzStudentsPersonGroupUid());
        statement.bindLong(21, entity.getClazzTeachersPersonGroupUid());
        statement.bindLong(22, entity.getClazzPendingStudentsPersonGroupUid());
        statement.bindLong(23, entity.getClazzParentsPersonGroupUid());
        if (entity.getClazzCode() == null) {
          statement.bindNull(24);
        } else {
          statement.bindString(24, entity.getClazzCode());
        }
        statement.bindLong(25, entity.getClazzOwnerPersonUid());
      }
    };
    this.__updateAdapterOfClazz = new EntityDeletionOrUpdateAdapter<Clazz>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `Clazz` SET `clazzUid` = ?,`clazzName` = ?,`clazzDesc` = ?,`attendanceAverage` = ?,`clazzHolidayUMCalendarUid` = ?,`clazzScheuleUMCalendarUid` = ?,`isClazzActive` = ?,`clazzLocationUid` = ?,`clazzStartTime` = ?,`clazzEndTime` = ?,`clazzFeatures` = ?,`clazzSchoolUid` = ?,`clazzEnrolmentPolicy` = ?,`clazzTerminologyUid` = ?,`clazzMasterChangeSeqNum` = ?,`clazzLocalChangeSeqNum` = ?,`clazzLastChangedBy` = ?,`clazzLct` = ?,`clazzTimeZone` = ?,`clazzStudentsPersonGroupUid` = ?,`clazzTeachersPersonGroupUid` = ?,`clazzPendingStudentsPersonGroupUid` = ?,`clazzParentsPersonGroupUid` = ?,`clazzCode` = ?,`clazzOwnerPersonUid` = ? WHERE `clazzUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Clazz entity) {
        statement.bindLong(1, entity.getClazzUid());
        if (entity.getClazzName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getClazzName());
        }
        if (entity.getClazzDesc() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getClazzDesc());
        }
        statement.bindDouble(4, entity.getAttendanceAverage());
        statement.bindLong(5, entity.getClazzHolidayUMCalendarUid());
        statement.bindLong(6, entity.getClazzScheuleUMCalendarUid());
        final int _tmp = entity.isClazzActive() ? 1 : 0;
        statement.bindLong(7, _tmp);
        statement.bindLong(8, entity.getClazzLocationUid());
        statement.bindLong(9, entity.getClazzStartTime());
        statement.bindLong(10, entity.getClazzEndTime());
        statement.bindLong(11, entity.getClazzFeatures());
        statement.bindLong(12, entity.getClazzSchoolUid());
        statement.bindLong(13, entity.getClazzEnrolmentPolicy());
        statement.bindLong(14, entity.getClazzTerminologyUid());
        statement.bindLong(15, entity.getClazzMasterChangeSeqNum());
        statement.bindLong(16, entity.getClazzLocalChangeSeqNum());
        statement.bindLong(17, entity.getClazzLastChangedBy());
        statement.bindLong(18, entity.getClazzLct());
        if (entity.getClazzTimeZone() == null) {
          statement.bindNull(19);
        } else {
          statement.bindString(19, entity.getClazzTimeZone());
        }
        statement.bindLong(20, entity.getClazzStudentsPersonGroupUid());
        statement.bindLong(21, entity.getClazzTeachersPersonGroupUid());
        statement.bindLong(22, entity.getClazzPendingStudentsPersonGroupUid());
        statement.bindLong(23, entity.getClazzParentsPersonGroupUid());
        if (entity.getClazzCode() == null) {
          statement.bindNull(24);
        } else {
          statement.bindString(24, entity.getClazzCode());
        }
        statement.bindLong(25, entity.getClazzOwnerPersonUid());
        statement.bindLong(26, entity.getClazzUid());
      }
    };
    this.__preparedStmtOfUpdateClazzAttendanceAverageAsync = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Clazz \n"
                + "           SET attendanceAverage = \n"
                + "               COALESCE(CAST(\n"
                + "                    (SELECT SUM(clazzLogNumPresent) \n"
                + "                       FROM ClazzLog \n"
                + "                      WHERE clazzLogClazzUid = ?\n"
                + "                       AND clazzLogStatusFlag = 4) AS REAL) /\n"
                + "                    \n"
                + "                    CAST(MAX(1.0, \n"
                + "                        (SELECT SUM(clazzLogNumPresent) + SUM(clazzLogNumPartial) + SUM(clazzLogNumAbsent)\n"
                + "                        FROM ClazzLog \n"
                + "                       WHERE clazzLogClazzUid = ? \n"
                + "                        AND clazzLogStatusFlag = 4)) AS REAL), 0),\n"
                + "               clazzLct = ?         \n"
                + "         WHERE clazzUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Clazz entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfClazz.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Clazz entity, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfClazz.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends Clazz> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazz.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Clazz entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazz.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Clazz entity, final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfClazz.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateClazzAttendanceAverageAsync(final long clazzUid, final long timeChanged,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzAttendanceAverageAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, timeChanged);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, clazzUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateClazzAttendanceAverageAsync.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Clazz findByUid(final long uid) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
      final Clazz _result;
      if (_cursor.moveToFirst()) {
        _result = new Clazz();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _result.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _result.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _result.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _result.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp != 0;
        _result.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _result.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _result.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _result.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _result.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _result.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _result.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _result.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _result.setClazzCode(_tmpClazzCode);
        final long _tmpClazzOwnerPersonUid;
        _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
        _result.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<Clazz> findByUidLive(final long uid) {
    final String _sql = "SELECT * From Clazz WHERE clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz"}, new Callable<Clazz>() {
      @Override
      @Nullable
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final Clazz _result;
          if (_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _result.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByClazzCode(final String code, final Continuation<? super Clazz> $completion) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzCode = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, code);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Clazz>() {
      @Override
      @Nullable
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final Clazz _result;
          if (_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _result.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByClazzCodeFromWeb(final String code,
      final Continuation<? super Clazz> $completion) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzCode = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, code);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Clazz>() {
      @Override
      @Nullable
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final Clazz _result;
          if (_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _result.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<Clazz>> findAllLive() {
    final String _sql = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz"}, new Callable<List<Clazz>>() {
      @Override
      @NonNull
      public List<Clazz> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Clazz _item;
            _item = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _item.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _item.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _item.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _item.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _item.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _item.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _item.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _item.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _item.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _item.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _item.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _item.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _item.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Clazz> findAll() {
    final String _sql = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
      final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Clazz _item;
        _item = new Clazz();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _item.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _item.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _item.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _item.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp != 0;
        _item.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _item.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _item.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _item.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _item.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _item.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _item.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _item.setClazzCode(_tmpClazzCode);
        final long _tmpClazzOwnerPersonUid;
        _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
        _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long clazzUid, final Continuation<? super Clazz> $completion) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Clazz>() {
      @Override
      @Nullable
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final Clazz _result;
          if (_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _result.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object clazzUidExistsAsync(final long clazzUid,
      final Continuation<? super Boolean> $completion) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT Clazz.clazzUid\n"
            + "                 FROM Clazz\n"
            + "                WHERE Clazz.clazzUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      @NonNull
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if (_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Clazz> findByUidAsFlow(final long uid) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz"}, new Callable<Clazz>() {
      @Override
      @Nullable
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final Clazz _result;
          if (_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _result.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByUidWithHolidayCalendarAsync(final long uid,
      final Continuation<? super ClazzWithHolidayCalendarAndAndTerminology> $completion) {
    final String _sql = "\n"
            + "        SELECT Clazz.*, \n"
            + "               CoursePicture.*,\n"
            + "               HolidayCalendar.*, \n"
            + "               CourseTerminology.*\n"
            + "          FROM Clazz \n"
            + "               LEFT JOIN HolidayCalendar \n"
            + "                         ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n"
            + "\n"
            + "               LEFT JOIN CourseTerminology\n"
            + "                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "                      \n"
            + "               LEFT JOIN CoursePicture\n"
            + "                         ON CoursePicture.coursePictureUid = ?\n"
            + "         WHERE Clazz.clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzWithHolidayCalendarAndAndTerminology>() {
      @Override
      @Nullable
      public ClazzWithHolidayCalendarAndAndTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUid");
          final int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLct");
          final int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUri");
          final int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureThumbnailUri");
          final int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureActive");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final ClazzWithHolidayCalendarAndAndTerminology _result;
          if (_cursor.moveToFirst()) {
            final CoursePicture _tmpCoursePicture;
            if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
              final long _tmpCoursePictureUid;
              _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
              final long _tmpCoursePictureLct;
              _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
              final String _tmpCoursePictureUri;
              if (_cursor.isNull(_cursorIndexOfCoursePictureUri)) {
                _tmpCoursePictureUri = null;
              } else {
                _tmpCoursePictureUri = _cursor.getString(_cursorIndexOfCoursePictureUri);
              }
              final String _tmpCoursePictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri)) {
                _tmpCoursePictureThumbnailUri = null;
              } else {
                _tmpCoursePictureThumbnailUri = _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
              }
              final boolean _tmpCoursePictureActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCoursePictureActive);
              _tmpCoursePictureActive = _tmp != 0;
              _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid,_tmpCoursePictureLct,_tmpCoursePictureUri,_tmpCoursePictureThumbnailUri,_tmpCoursePictureActive);
            } else {
              _tmpCoursePicture = null;
            }
            final HolidayCalendar _tmpHolidayCalendar;
            if (!(_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
              _tmpHolidayCalendar = new HolidayCalendar();
              final long _tmpUmCalendarUid;
              _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
              _tmpHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
              final String _tmpUmCalendarName;
              if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
                _tmpUmCalendarName = null;
              } else {
                _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
              }
              _tmpHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
              final int _tmpUmCalendarCategory;
              _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
              _tmpHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
              final boolean _tmpUmCalendarActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfUmCalendarActive);
              _tmpUmCalendarActive = _tmp_1 != 0;
              _tmpHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
              final long _tmpUmCalendarMasterChangeSeqNum;
              _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
              _tmpHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
              final long _tmpUmCalendarLocalChangeSeqNum;
              _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
              _tmpHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
              final int _tmpUmCalendarLastChangedBy;
              _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
              _tmpHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
              final long _tmpUmCalendarLct;
              _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
              _tmpHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
            } else {
              _tmpHolidayCalendar = null;
            }
            final CourseTerminology _tmpTerminology;
            if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
              _tmpTerminology = new CourseTerminology();
              final long _tmpCtUid;
              _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
              _tmpTerminology.setCtUid(_tmpCtUid);
              final String _tmpCtTitle;
              if (_cursor.isNull(_cursorIndexOfCtTitle)) {
                _tmpCtTitle = null;
              } else {
                _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
              }
              _tmpTerminology.setCtTitle(_tmpCtTitle);
              final String _tmpCtTerminology;
              if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
                _tmpCtTerminology = null;
              } else {
                _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
              }
              _tmpTerminology.setCtTerminology(_tmpCtTerminology);
              final long _tmpCtLct;
              _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
              _tmpTerminology.setCtLct(_tmpCtLct);
            } else {
              _tmpTerminology = null;
            }
            _result = new ClazzWithHolidayCalendarAndAndTerminology();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp_2 != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _result.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            _result.setCoursePicture(_tmpCoursePicture);
            _result.setHolidayCalendar(_tmpHolidayCalendar);
            _result.setTerminology(_tmpTerminology);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, ClazzWithListDisplayDetails> findClazzesWithPermission(
      final String searchQuery, final long accountPersonUid,
      final List<Long> excludeSelectedClazzList, final int sortOrder, final int filter,
      final long currentTime, final long permission) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT Clazz.*, ClazzEnrolment.*, CoursePicture.*,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND clazzEnrolmentRole = 1000 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND clazzEnrolmentRole = 1001");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               '' AS teacherNames,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               0 AS lastRecorded,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CourseTerminology.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM Clazz");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON ClazzEnrolment.clazzEnrolmentUid =");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       COALESCE(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       (SELECT ClazzEnrolment.clazzEnrolmentUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          FROM ClazzEnrolment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentActive");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         LIMIT 1), 0)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                LEFT JOIN CourseTerminology   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                LEFT JOIN CoursePicture");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          ON CoursePicture.coursePictureUid = Clazz.clazzUid           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE /* Begin permission check clause */");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    Clazz.clazzOwnerPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR EXISTS(SELECT CoursePermission.cpUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                             FROM CoursePermission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            WHERE CoursePermission.cpClazzUid = Clazz.clazzUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              AND (   CoursePermission.cpToPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(" ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              AND (CoursePermission.cpPermissionsFlag & ");
    _stringBuilder.append("?");
    _stringBuilder.append(") > 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              AND NOT CoursePermission.cpIsDeleted)   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 OR (");
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        EXISTS(SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM SystemPermission");
    _stringBuilder.append("\n");
    _stringBuilder.append("                WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" != 0 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND SystemPermission.spToPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND (SystemPermission.spPermissionsFlag &");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("          ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  AND NOT SystemPermission.spIsDeleted)");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )             ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                /* End permission check clause */ ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND CAST(Clazz.isClazzActive AS INTEGER) = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND Clazz.clazzName like ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (Clazz.clazzUid NOT IN (");
    final int _inputSize = excludeSelectedClazzList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append("))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ( ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR (CASE WHEN ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 5 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      THEN ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN Clazz.clazzStartTime AND Clazz.clazzEndTime");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      ELSE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" > Clazz.clazzEndTime ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      END))");
    _stringBuilder.append("\n");
    _stringBuilder.append("      GROUP BY Clazz.clazzUid, ClazzEnrolment.clazzEnrolmentUid, CourseTerminology.ctUid, CoursePicture.coursePictureUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 3 THEN Clazz.attendanceAverage");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 1 THEN Clazz.clazzName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 4 THEN Clazz.attendanceAverage");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 2 THEN clazz.Clazzname");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 19 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 2;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 11;
    _statement.bindString(_argIndex, searchQuery);
    _argIndex = 12;
    for (long _item : excludeSelectedClazzList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 12 + _inputSize;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 13 + _inputSize;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 14 + _inputSize;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 15 + _inputSize;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 16 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 17 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 18 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 19 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    return new LimitOffsetPagingSource<ClazzWithListDisplayDetails>(_statement, __db, "ClazzEnrolment", "Clazz", "CourseTerminology", "CoursePicture", "CoursePermission", "SystemPermission") {
      @Override
      @NonNull
      protected List<ClazzWithListDisplayDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzUid");
        final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(cursor, "clazzName");
        final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(cursor, "clazzDesc");
        final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(cursor, "attendanceAverage");
        final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzHolidayUMCalendarUid");
        final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzScheuleUMCalendarUid");
        final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(cursor, "isClazzActive");
        final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocationUid");
        final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStartTime");
        final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEndTime");
        final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(cursor, "clazzFeatures");
        final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzSchoolUid");
        final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPolicy");
        final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTerminologyUid");
        final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzMasterChangeSeqNum");
        final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocalChangeSeqNum");
        final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLastChangedBy");
        final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLct");
        final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTimeZone");
        final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStudentsPersonGroupUid");
        final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTeachersPersonGroupUid");
        final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzPendingStudentsPersonGroupUid");
        final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzParentsPersonGroupUid");
        final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(cursor, "clazzCode");
        final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzOwnerPersonUid");
        final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentUid");
        final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPersonUid");
        final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentClazzUid");
        final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateJoined");
        final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateLeft");
        final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentRole");
        final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentAttendancePercentage");
        final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentActive");
        final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLeavingReasonUid");
        final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentOutcome");
        final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLocalChangeSeqNum");
        final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentMasterChangeSeqNum");
        final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLastChangedBy");
        final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLct");
        final int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow(cursor, "coursePictureUid");
        final int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow(cursor, "coursePictureLct");
        final int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "coursePictureUri");
        final int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(cursor, "coursePictureThumbnailUri");
        final int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow(cursor, "coursePictureActive");
        final int _cursorIndexOfNumStudents = CursorUtil.getColumnIndexOrThrow(cursor, "numStudents");
        final int _cursorIndexOfNumTeachers = CursorUtil.getColumnIndexOrThrow(cursor, "numTeachers");
        final int _cursorIndexOfTeacherNames = CursorUtil.getColumnIndexOrThrow(cursor, "teacherNames");
        final int _cursorIndexOfLastRecorded = CursorUtil.getColumnIndexOrThrow(cursor, "lastRecorded");
        final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(cursor, "ctUid");
        final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(cursor, "ctTitle");
        final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(cursor, "ctTerminology");
        final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(cursor, "ctLct");
        final List<ClazzWithListDisplayDetails> _result = new ArrayList<ClazzWithListDisplayDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final ClazzWithListDisplayDetails _item_1;
          final ClazzEnrolment _tmpClazzActiveEnrolment;
          if (!(cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && cursor.isNull(_cursorIndexOfClazzEnrolmentLct))) {
            _tmpClazzActiveEnrolment = new ClazzEnrolment();
            final long _tmpClazzEnrolmentUid;
            _tmpClazzEnrolmentUid = cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
            _tmpClazzActiveEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
            final long _tmpClazzEnrolmentPersonUid;
            _tmpClazzEnrolmentPersonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
            _tmpClazzActiveEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
            final long _tmpClazzEnrolmentClazzUid;
            _tmpClazzEnrolmentClazzUid = cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
            _tmpClazzActiveEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
            final long _tmpClazzEnrolmentDateJoined;
            _tmpClazzEnrolmentDateJoined = cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
            _tmpClazzActiveEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
            final long _tmpClazzEnrolmentDateLeft;
            _tmpClazzEnrolmentDateLeft = cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
            _tmpClazzActiveEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
            final int _tmpClazzEnrolmentRole;
            _tmpClazzEnrolmentRole = cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
            _tmpClazzActiveEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
            final float _tmpClazzEnrolmentAttendancePercentage;
            _tmpClazzEnrolmentAttendancePercentage = cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
            _tmpClazzActiveEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
            final boolean _tmpClazzEnrolmentActive;
            final int _tmp;
            _tmp = cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
            _tmpClazzEnrolmentActive = _tmp != 0;
            _tmpClazzActiveEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
            final long _tmpClazzEnrolmentLeavingReasonUid;
            _tmpClazzEnrolmentLeavingReasonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
            _tmpClazzActiveEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
            final int _tmpClazzEnrolmentOutcome;
            _tmpClazzEnrolmentOutcome = cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
            _tmpClazzActiveEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
            final long _tmpClazzEnrolmentLocalChangeSeqNum;
            _tmpClazzEnrolmentLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
            _tmpClazzActiveEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
            final long _tmpClazzEnrolmentMasterChangeSeqNum;
            _tmpClazzEnrolmentMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
            _tmpClazzActiveEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
            final int _tmpClazzEnrolmentLastChangedBy;
            _tmpClazzEnrolmentLastChangedBy = cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
            _tmpClazzActiveEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
            final long _tmpClazzEnrolmentLct;
            _tmpClazzEnrolmentLct = cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
            _tmpClazzActiveEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
          } else {
            _tmpClazzActiveEnrolment = null;
          }
          final CoursePicture _tmpCoursePicture;
          if (!(cursor.isNull(_cursorIndexOfCoursePictureUid) && cursor.isNull(_cursorIndexOfCoursePictureLct) && cursor.isNull(_cursorIndexOfCoursePictureUri) && cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && cursor.isNull(_cursorIndexOfCoursePictureActive))) {
            final long _tmpCoursePictureUid;
            _tmpCoursePictureUid = cursor.getLong(_cursorIndexOfCoursePictureUid);
            final long _tmpCoursePictureLct;
            _tmpCoursePictureLct = cursor.getLong(_cursorIndexOfCoursePictureLct);
            final String _tmpCoursePictureUri;
            if (cursor.isNull(_cursorIndexOfCoursePictureUri)) {
              _tmpCoursePictureUri = null;
            } else {
              _tmpCoursePictureUri = cursor.getString(_cursorIndexOfCoursePictureUri);
            }
            final String _tmpCoursePictureThumbnailUri;
            if (cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri)) {
              _tmpCoursePictureThumbnailUri = null;
            } else {
              _tmpCoursePictureThumbnailUri = cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
            }
            final boolean _tmpCoursePictureActive;
            final int _tmp_1;
            _tmp_1 = cursor.getInt(_cursorIndexOfCoursePictureActive);
            _tmpCoursePictureActive = _tmp_1 != 0;
            _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid,_tmpCoursePictureLct,_tmpCoursePictureUri,_tmpCoursePictureThumbnailUri,_tmpCoursePictureActive);
          } else {
            _tmpCoursePicture = null;
          }
          final CourseTerminology _tmpTerminology;
          if (!(cursor.isNull(_cursorIndexOfCtUid) && cursor.isNull(_cursorIndexOfCtTitle) && cursor.isNull(_cursorIndexOfCtTerminology) && cursor.isNull(_cursorIndexOfCtLct))) {
            _tmpTerminology = new CourseTerminology();
            final long _tmpCtUid;
            _tmpCtUid = cursor.getLong(_cursorIndexOfCtUid);
            _tmpTerminology.setCtUid(_tmpCtUid);
            final String _tmpCtTitle;
            if (cursor.isNull(_cursorIndexOfCtTitle)) {
              _tmpCtTitle = null;
            } else {
              _tmpCtTitle = cursor.getString(_cursorIndexOfCtTitle);
            }
            _tmpTerminology.setCtTitle(_tmpCtTitle);
            final String _tmpCtTerminology;
            if (cursor.isNull(_cursorIndexOfCtTerminology)) {
              _tmpCtTerminology = null;
            } else {
              _tmpCtTerminology = cursor.getString(_cursorIndexOfCtTerminology);
            }
            _tmpTerminology.setCtTerminology(_tmpCtTerminology);
            final long _tmpCtLct;
            _tmpCtLct = cursor.getLong(_cursorIndexOfCtLct);
            _tmpTerminology.setCtLct(_tmpCtLct);
          } else {
            _tmpTerminology = null;
          }
          _item_1 = new ClazzWithListDisplayDetails();
          final long _tmpClazzUid;
          _tmpClazzUid = cursor.getLong(_cursorIndexOfClazzUid);
          _item_1.setClazzUid(_tmpClazzUid);
          final String _tmpClazzName;
          if (cursor.isNull(_cursorIndexOfClazzName)) {
            _tmpClazzName = null;
          } else {
            _tmpClazzName = cursor.getString(_cursorIndexOfClazzName);
          }
          _item_1.setClazzName(_tmpClazzName);
          final String _tmpClazzDesc;
          if (cursor.isNull(_cursorIndexOfClazzDesc)) {
            _tmpClazzDesc = null;
          } else {
            _tmpClazzDesc = cursor.getString(_cursorIndexOfClazzDesc);
          }
          _item_1.setClazzDesc(_tmpClazzDesc);
          final float _tmpAttendanceAverage;
          _tmpAttendanceAverage = cursor.getFloat(_cursorIndexOfAttendanceAverage);
          _item_1.setAttendanceAverage(_tmpAttendanceAverage);
          final long _tmpClazzHolidayUMCalendarUid;
          _tmpClazzHolidayUMCalendarUid = cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
          _item_1.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
          final long _tmpClazzScheuleUMCalendarUid;
          _tmpClazzScheuleUMCalendarUid = cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
          _item_1.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
          final boolean _tmpIsClazzActive;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfIsClazzActive);
          _tmpIsClazzActive = _tmp_2 != 0;
          _item_1.setClazzActive(_tmpIsClazzActive);
          final long _tmpClazzLocationUid;
          _tmpClazzLocationUid = cursor.getLong(_cursorIndexOfClazzLocationUid);
          _item_1.setClazzLocationUid(_tmpClazzLocationUid);
          final long _tmpClazzStartTime;
          _tmpClazzStartTime = cursor.getLong(_cursorIndexOfClazzStartTime);
          _item_1.setClazzStartTime(_tmpClazzStartTime);
          final long _tmpClazzEndTime;
          _tmpClazzEndTime = cursor.getLong(_cursorIndexOfClazzEndTime);
          _item_1.setClazzEndTime(_tmpClazzEndTime);
          final long _tmpClazzFeatures;
          _tmpClazzFeatures = cursor.getLong(_cursorIndexOfClazzFeatures);
          _item_1.setClazzFeatures(_tmpClazzFeatures);
          final long _tmpClazzSchoolUid;
          _tmpClazzSchoolUid = cursor.getLong(_cursorIndexOfClazzSchoolUid);
          _item_1.setClazzSchoolUid(_tmpClazzSchoolUid);
          final int _tmpClazzEnrolmentPolicy;
          _tmpClazzEnrolmentPolicy = cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
          _item_1.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
          final long _tmpClazzTerminologyUid;
          _tmpClazzTerminologyUid = cursor.getLong(_cursorIndexOfClazzTerminologyUid);
          _item_1.setClazzTerminologyUid(_tmpClazzTerminologyUid);
          final long _tmpClazzMasterChangeSeqNum;
          _tmpClazzMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
          _item_1.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
          final long _tmpClazzLocalChangeSeqNum;
          _tmpClazzLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
          _item_1.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
          final int _tmpClazzLastChangedBy;
          _tmpClazzLastChangedBy = cursor.getInt(_cursorIndexOfClazzLastChangedBy);
          _item_1.setClazzLastChangedBy(_tmpClazzLastChangedBy);
          final long _tmpClazzLct;
          _tmpClazzLct = cursor.getLong(_cursorIndexOfClazzLct);
          _item_1.setClazzLct(_tmpClazzLct);
          final String _tmpClazzTimeZone;
          if (cursor.isNull(_cursorIndexOfClazzTimeZone)) {
            _tmpClazzTimeZone = null;
          } else {
            _tmpClazzTimeZone = cursor.getString(_cursorIndexOfClazzTimeZone);
          }
          _item_1.setClazzTimeZone(_tmpClazzTimeZone);
          final long _tmpClazzStudentsPersonGroupUid;
          _tmpClazzStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
          _item_1.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
          final long _tmpClazzTeachersPersonGroupUid;
          _tmpClazzTeachersPersonGroupUid = cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
          _item_1.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
          final long _tmpClazzPendingStudentsPersonGroupUid;
          _tmpClazzPendingStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
          _item_1.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
          final long _tmpClazzParentsPersonGroupUid;
          _tmpClazzParentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
          _item_1.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
          final String _tmpClazzCode;
          if (cursor.isNull(_cursorIndexOfClazzCode)) {
            _tmpClazzCode = null;
          } else {
            _tmpClazzCode = cursor.getString(_cursorIndexOfClazzCode);
          }
          _item_1.setClazzCode(_tmpClazzCode);
          final long _tmpClazzOwnerPersonUid;
          _tmpClazzOwnerPersonUid = cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
          _item_1.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
          final int _tmpNumStudents;
          _tmpNumStudents = cursor.getInt(_cursorIndexOfNumStudents);
          _item_1.setNumStudents(_tmpNumStudents);
          final int _tmpNumTeachers;
          _tmpNumTeachers = cursor.getInt(_cursorIndexOfNumTeachers);
          _item_1.setNumTeachers(_tmpNumTeachers);
          final String _tmpTeacherNames;
          if (cursor.isNull(_cursorIndexOfTeacherNames)) {
            _tmpTeacherNames = null;
          } else {
            _tmpTeacherNames = cursor.getString(_cursorIndexOfTeacherNames);
          }
          _item_1.setTeacherNames(_tmpTeacherNames);
          final long _tmpLastRecorded;
          _tmpLastRecorded = cursor.getLong(_cursorIndexOfLastRecorded);
          _item_1.setLastRecorded(_tmpLastRecorded);
          _item_1.setClazzActiveEnrolment(_tmpClazzActiveEnrolment);
          _item_1.setCoursePicture(_tmpCoursePicture);
          _item_1.setTerminology(_tmpTerminology);
          _result.add(_item_1);
        }
        return _result;
      }
    };
  }

  @Override
  public Object getClassNamesFromListOfIds(final List<Long> ids,
      final Continuation<? super List<UidAndLabel>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT Clazz.clazzUid AS uid, Clazz.clazzName AS labelName From Clazz WHERE clazzUid IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : ids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UidAndLabel>>() {
      @Override
      @NonNull
      public List<UidAndLabel> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUid = 0;
          final int _cursorIndexOfLabelName = 1;
          final List<UidAndLabel> _result = new ArrayList<UidAndLabel>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final UidAndLabel _item_1;
            _item_1 = new UidAndLabel();
            final long _tmpUid;
            _tmpUid = _cursor.getLong(_cursorIndexOfUid);
            _item_1.setUid(_tmpUid);
            final String _tmpLabelName;
            if (_cursor.isNull(_cursorIndexOfLabelName)) {
              _tmpLabelName = null;
            } else {
              _tmpLabelName = _cursor.getString(_cursorIndexOfLabelName);
            }
            _item_1.setLabelName(_tmpLabelName);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public List<Clazz> findByClazzName(final String name) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzName = ? and CAST(isClazzActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, name);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
      final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final Clazz _item;
        _item = new Clazz();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _item.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _item.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _item.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _item.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp != 0;
        _item.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _item.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _item.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _item.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _item.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _item.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _item.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _item.setClazzCode(_tmpClazzCode);
        final long _tmpClazzOwnerPersonUid;
        _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
        _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<ClazzAndDetailPermissions> clazzAndDetailPermissionsAsFlow(
      final long accountPersonUid, final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT Clazz.*,\n"
            + "               (  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         \n"
            + "                  32\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "    \n"
            + "                  32\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "               ) AS hasAttendancePermission,\n"
            + "               (  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         \n"
            + "                  8192\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "    \n"
            + "                  8192\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "               ) AS hasViewMembersPermission,\n"
            + "               (  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         \n"
            + "                  128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "    \n"
            + "                  128\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "               ) AS hasLearningRecordPermission\n"
            + "          FROM Clazz\n"
            + "         WHERE Clazz.clazzUid = ?\n"
            + "           AND (  (\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         \n"
            + "                  1\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "    \n"
            + "                  1\n"
            + "                  \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    \n"
            + "               )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 25);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 14;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 15;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 16;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 17;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 18;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 19;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 20;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 21;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 22;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 23;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 24;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 25;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz", "CoursePermission",
        "ClazzEnrolment", "SystemPermission"}, new Callable<ClazzAndDetailPermissions>() {
      @Override
      @Nullable
      public ClazzAndDetailPermissions call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final int _cursorIndexOfHasAttendancePermission = CursorUtil.getColumnIndexOrThrow(_cursor, "hasAttendancePermission");
          final int _cursorIndexOfHasViewMembersPermission = CursorUtil.getColumnIndexOrThrow(_cursor, "hasViewMembersPermission");
          final int _cursorIndexOfHasLearningRecordPermission = CursorUtil.getColumnIndexOrThrow(_cursor, "hasLearningRecordPermission");
          final ClazzAndDetailPermissions _result;
          if (_cursor.moveToFirst()) {
            final boolean _tmpHasAttendancePermission;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfHasAttendancePermission);
            _tmpHasAttendancePermission = _tmp != 0;
            final boolean _tmpHasViewMembersPermission;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfHasViewMembersPermission);
            _tmpHasViewMembersPermission = _tmp_1 != 0;
            final boolean _tmpHasLearningRecordPermission;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfHasLearningRecordPermission);
            _tmpHasLearningRecordPermission = _tmp_2 != 0;
            final Clazz _tmpClazz;
            if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
              _tmpClazz = new Clazz();
              final long _tmpClazzUid;
              _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
              _tmpClazz.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (_cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
              }
              _tmpClazz.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
              }
              _tmpClazz.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp_3 != 0;
              _tmpClazz.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
              _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
              _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
              _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
              _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
              _tmpClazz.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (_cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
              }
              _tmpClazz.setClazzCode(_tmpClazzCode);
              final long _tmpClazzOwnerPersonUid;
              _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
              _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            } else {
              _tmpClazz = null;
            }
            _result = new ClazzAndDetailPermissions(_tmpClazz,_tmpHasAttendancePermission,_tmpHasViewMembersPermission,_tmpHasLearningRecordPermission);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<ClazzAndDisplayDetails> getClazzWithDisplayDetails(final long clazzUid,
      final long currentTime, final long accountPersonUid) {
    final String _sql = "\n"
            + "        SELECT Clazz.*, \n"
            + "               CoursePicture.*,\n"
            + "               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n"
            + "                  FROM ClazzEnrolment \n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n"
            + "                   AND clazzEnrolmentRole = 1000 \n"
            + "                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n"
            + "               (SELECT COUNT(DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid) \n"
            + "                  FROM ClazzEnrolment \n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n"
            + "                   AND clazzEnrolmentRole = 1001 \n"
            + "                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n"
            + "                CourseTerminology.*,\n"
            + "                (SELECT EXISTS(\n"
            + "                        SELECT 1\n"
            + "                          FROM ClazzEnrolment\n"
            + "                         WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "                           AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                           AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + ")\n"
            + "                ) AS activeUserIsStudent\n"
            + "         FROM Clazz \n"
            + "              LEFT JOIN CourseTerminology\n"
            + "                        ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "              LEFT JOIN CoursePicture\n"
            + "                        ON CoursePicture.coursePictureUid = ?\n"
            + "        WHERE Clazz.clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 2;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"ClazzEnrolment", "Clazz",
        "CourseTerminology", "CoursePicture"}, new Callable<ClazzAndDisplayDetails>() {
      @Override
      @Nullable
      public ClazzAndDisplayDetails call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUid");
          final int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLct");
          final int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUri");
          final int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureThumbnailUri");
          final int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureActive");
          final int _cursorIndexOfNumStudents = CursorUtil.getColumnIndexOrThrow(_cursor, "numStudents");
          final int _cursorIndexOfNumTeachers = CursorUtil.getColumnIndexOrThrow(_cursor, "numTeachers");
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final int _cursorIndexOfActiveUserIsStudent = CursorUtil.getColumnIndexOrThrow(_cursor, "activeUserIsStudent");
          final ClazzAndDisplayDetails _result;
          if (_cursor.moveToFirst()) {
            final int _tmpNumStudents;
            _tmpNumStudents = _cursor.getInt(_cursorIndexOfNumStudents);
            final int _tmpNumTeachers;
            _tmpNumTeachers = _cursor.getInt(_cursorIndexOfNumTeachers);
            final boolean _tmpActiveUserIsStudent;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActiveUserIsStudent);
            _tmpActiveUserIsStudent = _tmp != 0;
            final Clazz _tmpClazz;
            if (!(_cursor.isNull(_cursorIndexOfClazzUid) && _cursor.isNull(_cursorIndexOfClazzName) && _cursor.isNull(_cursorIndexOfClazzDesc) && _cursor.isNull(_cursorIndexOfAttendanceAverage) && _cursor.isNull(_cursorIndexOfClazzHolidayUMCalendarUid) && _cursor.isNull(_cursorIndexOfClazzScheuleUMCalendarUid) && _cursor.isNull(_cursorIndexOfIsClazzActive) && _cursor.isNull(_cursorIndexOfClazzLocationUid) && _cursor.isNull(_cursorIndexOfClazzStartTime) && _cursor.isNull(_cursorIndexOfClazzEndTime) && _cursor.isNull(_cursorIndexOfClazzFeatures) && _cursor.isNull(_cursorIndexOfClazzSchoolUid) && _cursor.isNull(_cursorIndexOfClazzEnrolmentPolicy) && _cursor.isNull(_cursorIndexOfClazzTerminologyUid) && _cursor.isNull(_cursorIndexOfClazzMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfClazzLastChangedBy) && _cursor.isNull(_cursorIndexOfClazzLct) && _cursor.isNull(_cursorIndexOfClazzTimeZone) && _cursor.isNull(_cursorIndexOfClazzStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzParentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfClazzCode) && _cursor.isNull(_cursorIndexOfClazzOwnerPersonUid))) {
              _tmpClazz = new Clazz();
              final long _tmpClazzUid;
              _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
              _tmpClazz.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (_cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
              }
              _tmpClazz.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
              }
              _tmpClazz.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _tmpClazz.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _tmpClazz.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _tmpClazz.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp_1 != 0;
              _tmpClazz.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
              _tmpClazz.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
              _tmpClazz.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
              _tmpClazz.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
              _tmpClazz.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _tmpClazz.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _tmpClazz.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _tmpClazz.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _tmpClazz.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _tmpClazz.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _tmpClazz.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
              _tmpClazz.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _tmpClazz.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _tmpClazz.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _tmpClazz.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _tmpClazz.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _tmpClazz.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (_cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
              }
              _tmpClazz.setClazzCode(_tmpClazzCode);
              final long _tmpClazzOwnerPersonUid;
              _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
              _tmpClazz.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            } else {
              _tmpClazz = null;
            }
            final CoursePicture _tmpCoursePicture;
            if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
              final long _tmpCoursePictureUid;
              _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
              final long _tmpCoursePictureLct;
              _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
              final String _tmpCoursePictureUri;
              if (_cursor.isNull(_cursorIndexOfCoursePictureUri)) {
                _tmpCoursePictureUri = null;
              } else {
                _tmpCoursePictureUri = _cursor.getString(_cursorIndexOfCoursePictureUri);
              }
              final String _tmpCoursePictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri)) {
                _tmpCoursePictureThumbnailUri = null;
              } else {
                _tmpCoursePictureThumbnailUri = _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
              }
              final boolean _tmpCoursePictureActive;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCoursePictureActive);
              _tmpCoursePictureActive = _tmp_2 != 0;
              _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid,_tmpCoursePictureLct,_tmpCoursePictureUri,_tmpCoursePictureThumbnailUri,_tmpCoursePictureActive);
            } else {
              _tmpCoursePicture = null;
            }
            final CourseTerminology _tmpTerminology;
            if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
              _tmpTerminology = new CourseTerminology();
              final long _tmpCtUid;
              _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
              _tmpTerminology.setCtUid(_tmpCtUid);
              final String _tmpCtTitle;
              if (_cursor.isNull(_cursorIndexOfCtTitle)) {
                _tmpCtTitle = null;
              } else {
                _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
              }
              _tmpTerminology.setCtTitle(_tmpCtTitle);
              final String _tmpCtTerminology;
              if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
                _tmpCtTerminology = null;
              } else {
                _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
              }
              _tmpTerminology.setCtTerminology(_tmpCtTerminology);
              final long _tmpCtLct;
              _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
              _tmpTerminology.setCtLct(_tmpCtLct);
            } else {
              _tmpTerminology = null;
            }
            _result = new ClazzAndDisplayDetails(_tmpClazz,_tmpTerminology,_tmpCoursePicture,_tmpNumStudents,_tmpNumTeachers,_tmpActiveUserIsStudent);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<ClazzWithHolidayCalendarAndAndTerminology> findClazzesWithEffectiveHolidayCalendarAndFilter(
      final long filterUid) {
    final String _sql = "\n"
            + "        SELECT Clazz.*, \n"
            + "               HolidayCalendar.*,\n"
            + "               CourseTerminology.*,\n"
            + "               CoursePicture.*\n"
            + "         FROM Clazz \n"
            + "              LEFT JOIN HolidayCalendar \n"
            + "              ON ((clazz.clazzHolidayUMCalendarUid != 0 \n"
            + "                AND HolidayCalendar.umCalendarUid = clazz.clazzHolidayUMCalendarUid)\n"
            + "                OR clazz.clazzHolidayUMCalendarUid = 0 AND clazz.clazzSchoolUid = 0 \n"
            + "                AND HolidayCalendar.umCalendarUid = 0) \n"
            + "              LEFT JOIN CourseTerminology\n"
            + "              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "              \n"
            + "              LEFT JOIN CoursePicture\n"
            + "                        ON CoursePicture.coursePictureUid = 0\n"
            + "                \n"
            + "        WHERE ? = 0 \n"
            + "           OR Clazz.clazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, filterUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, filterUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
      final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
      final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
      final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
      final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
      final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
      final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
      final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
      final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
      final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
      final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
      final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
      final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
      final int _cursorIndexOfCoursePictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUid");
      final int _cursorIndexOfCoursePictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureLct");
      final int _cursorIndexOfCoursePictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureUri");
      final int _cursorIndexOfCoursePictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureThumbnailUri");
      final int _cursorIndexOfCoursePictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "coursePictureActive");
      final List<ClazzWithHolidayCalendarAndAndTerminology> _result = new ArrayList<ClazzWithHolidayCalendarAndAndTerminology>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ClazzWithHolidayCalendarAndAndTerminology _item;
        final HolidayCalendar _tmpHolidayCalendar;
        if (!(_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
          _tmpHolidayCalendar = new HolidayCalendar();
          final long _tmpUmCalendarUid;
          _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
          _tmpHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
          final String _tmpUmCalendarName;
          if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
            _tmpUmCalendarName = null;
          } else {
            _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
          }
          _tmpHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
          final int _tmpUmCalendarCategory;
          _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
          _tmpHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
          final boolean _tmpUmCalendarActive;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
          _tmpUmCalendarActive = _tmp != 0;
          _tmpHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
          final long _tmpUmCalendarMasterChangeSeqNum;
          _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
          _tmpHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
          final long _tmpUmCalendarLocalChangeSeqNum;
          _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
          _tmpHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
          final int _tmpUmCalendarLastChangedBy;
          _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
          _tmpHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
          final long _tmpUmCalendarLct;
          _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
          _tmpHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
        } else {
          _tmpHolidayCalendar = null;
        }
        final CourseTerminology _tmpTerminology;
        if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
          _tmpTerminology = new CourseTerminology();
          final long _tmpCtUid;
          _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
          _tmpTerminology.setCtUid(_tmpCtUid);
          final String _tmpCtTitle;
          if (_cursor.isNull(_cursorIndexOfCtTitle)) {
            _tmpCtTitle = null;
          } else {
            _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
          }
          _tmpTerminology.setCtTitle(_tmpCtTitle);
          final String _tmpCtTerminology;
          if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
            _tmpCtTerminology = null;
          } else {
            _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
          }
          _tmpTerminology.setCtTerminology(_tmpCtTerminology);
          final long _tmpCtLct;
          _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
          _tmpTerminology.setCtLct(_tmpCtLct);
        } else {
          _tmpTerminology = null;
        }
        final CoursePicture _tmpCoursePicture;
        if (!(_cursor.isNull(_cursorIndexOfCoursePictureUid) && _cursor.isNull(_cursorIndexOfCoursePictureLct) && _cursor.isNull(_cursorIndexOfCoursePictureUri) && _cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri) && _cursor.isNull(_cursorIndexOfCoursePictureActive))) {
          final long _tmpCoursePictureUid;
          _tmpCoursePictureUid = _cursor.getLong(_cursorIndexOfCoursePictureUid);
          final long _tmpCoursePictureLct;
          _tmpCoursePictureLct = _cursor.getLong(_cursorIndexOfCoursePictureLct);
          final String _tmpCoursePictureUri;
          if (_cursor.isNull(_cursorIndexOfCoursePictureUri)) {
            _tmpCoursePictureUri = null;
          } else {
            _tmpCoursePictureUri = _cursor.getString(_cursorIndexOfCoursePictureUri);
          }
          final String _tmpCoursePictureThumbnailUri;
          if (_cursor.isNull(_cursorIndexOfCoursePictureThumbnailUri)) {
            _tmpCoursePictureThumbnailUri = null;
          } else {
            _tmpCoursePictureThumbnailUri = _cursor.getString(_cursorIndexOfCoursePictureThumbnailUri);
          }
          final boolean _tmpCoursePictureActive;
          final int _tmp_1;
          _tmp_1 = _cursor.getInt(_cursorIndexOfCoursePictureActive);
          _tmpCoursePictureActive = _tmp_1 != 0;
          _tmpCoursePicture = new CoursePicture(_tmpCoursePictureUid,_tmpCoursePictureLct,_tmpCoursePictureUri,_tmpCoursePictureThumbnailUri,_tmpCoursePictureActive);
        } else {
          _tmpCoursePicture = null;
        }
        _item = new ClazzWithHolidayCalendarAndAndTerminology();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _item.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _item.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _item.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _item.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp_2 != 0;
        _item.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _item.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _item.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _item.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _item.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _item.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _item.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _item.setClazzCode(_tmpClazzCode);
        final long _tmpClazzOwnerPersonUid;
        _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
        _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
        _item.setHolidayCalendar(_tmpHolidayCalendar);
        _item.setTerminology(_tmpTerminology);
        _item.setCoursePicture(_tmpCoursePicture);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Flow<String> getTitleByUidAsFlow(final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT Clazz.clazzName\n"
            + "          FROM Clazz\n"
            + "         WHERE Clazz.clazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz"}, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<ClazzNameAndTerminology> getClazzNameAndTerminologyAsFlow(final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT Clazz.clazzName AS clazzName,\n"
            + "               CourseTerminology.*\n"
            + "          FROM Clazz\n"
            + "               LEFT JOIN CourseTerminology\n"
            + "                         ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "         WHERE Clazz.clazzUid = ?                \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz",
        "CourseTerminology"}, new Callable<ClazzNameAndTerminology>() {
      @Override
      @Nullable
      public ClazzNameAndTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final ClazzNameAndTerminology _result;
          if (_cursor.moveToFirst()) {
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            final CourseTerminology _tmpTerminology;
            if (!(_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
              _tmpTerminology = new CourseTerminology();
              final long _tmpCtUid;
              _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
              _tmpTerminology.setCtUid(_tmpCtUid);
              final String _tmpCtTitle;
              if (_cursor.isNull(_cursorIndexOfCtTitle)) {
                _tmpCtTitle = null;
              } else {
                _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
              }
              _tmpTerminology.setCtTitle(_tmpCtTitle);
              final String _tmpCtTerminology;
              if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
                _tmpCtTerminology = null;
              } else {
                _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
              }
              _tmpTerminology.setCtTerminology(_tmpCtTerminology);
              final long _tmpCtLct;
              _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
              _tmpTerminology.setCtLct(_tmpCtLct);
            } else {
              _tmpTerminology = null;
            }
            _result = new ClazzNameAndTerminology(_tmpClazzName,_tmpTerminology);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<String> getClazzNameAsFlow(final long clazzUid) {
    final String _sql = "\n"
            + "        SELECT Clazz.clazzName AS clazzName\n"
            + "          FROM Clazz\n"
            + "         WHERE Clazz.clazzUid = ?                \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Clazz"}, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getClazzTimeZoneByClazzUidAsync(final long clazzUid,
      final Continuation<? super String> $completion) {
    final String _sql = "\n"
            + "        SELECT Clazz.clazzTimeZone\n"
            + "          FROM Clazz\n"
            + "         WHERE Clazz.clazzUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getCoursesByName(final List<String> names,
      final Continuation<? super List<? extends Clazz>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT Clazz.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM Clazz");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE Clazz.clazzName IN (");
    final int _inputSize = names.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(") ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : names) {
      _statement.bindString(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Clazz>>() {
      @Override
      @NonNull
      public List<Clazz> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Clazz _item_1;
            _item_1 = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _item_1.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _item_1.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _item_1.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _item_1.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _item_1.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _item_1.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _item_1.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _item_1.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _item_1.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _item_1.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _item_1.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _item_1.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _item_1.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _item_1.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _item_1.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _item_1.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _item_1.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _item_1.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _item_1.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _item_1.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _item_1.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _item_1.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _item_1.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _item_1.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _item_1.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findOneRosterUserClazzes(final long accountPersonUid,
      final long filterByEnrolledMemberPersonUid,
      final Continuation<? super List<? extends Clazz>> $completion) {
    final String _sql = "\n"
            + "        SELECT Clazz.*\n"
            + "          FROM CLAZZ\n"
            + "               LEFT JOIN ClazzEnrolment \n"
            + "                    ON ClazzEnrolment.clazzEnrolmentUid =\n"
            + "                       COALESCE(\n"
            + "                       (SELECT ClazzEnrolment.clazzEnrolmentUid \n"
            + "                          FROM ClazzEnrolment\n"
            + "                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n"
            + "                      ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC   \n"
            + "                         LIMIT 1), 0)\n"
            + "          WHERE (   Clazz.clazzOwnerPersonUid = ?\n"
            + "                 OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                             FROM CoursePermission\n"
            + "                            WHERE CoursePermission.cpClazzUid = Clazz.clazzUid\n"
            + "                              AND (   CoursePermission.cpToPersonUid = ? \n"
            + "                                   OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment.clazzEnrolmentRole )\n"
            + "                              AND (CoursePermission.cpPermissionsFlag & 1) > 0 \n"
            + "                              AND NOT CoursePermission.cpIsDeleted)   \n"
            + "                 OR (\n"
            + "        EXISTS(SELECT 1\n"
            + "                 FROM SystemPermission\n"
            + "                WHERE ? != 0 \n"
            + "                  AND SystemPermission.spToPersonUid = ?\n"
            + "                  AND (SystemPermission.spPermissionsFlag &\n"
            + "    \n"
            + "                     1\n"
            + "                     \n"
            + "        ) > 0\n"
            + "                  AND NOT SystemPermission.spIsDeleted)\n"
            + "    \n"
            + "                    )             \n"
            + "                )\n"
            + "           AND EXISTS \n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n"
            + "                )  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, filterByEnrolledMemberPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Clazz>>() {
      @Override
      @NonNull
      public List<Clazz> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfClazzOwnerPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzOwnerPersonUid");
          final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Clazz _item;
            _item = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _item.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _item.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _item.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _item.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _item.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _item.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _item.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _item.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _item.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _item.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _item.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _item.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _item.setClazzCode(_tmpClazzCode);
            final long _tmpClazzOwnerPersonUid;
            _tmpClazzOwnerPersonUid = _cursor.getLong(_cursorIndexOfClazzOwnerPersonUid);
            _item.setClazzOwnerPersonUid(_tmpClazzOwnerPersonUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
