package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.BlockStatus;
import com.ustadmobile.lib.db.composites.xapi.StatementEntityAndRelated;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.StatementEntityAndDisplayDetails;
import com.ustadmobile.lib.db.entities.StatementReportData;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import com.ustadmobile.lib.db.entities.xapi.GroupMemberActorJoin;
import com.ustadmobile.lib.db.entities.xapi.StatementEntity;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Float;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class StatementDao_Impl extends StatementDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<StatementEntity> __insertionAdapterOfStatementEntity;

  public StatementDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfStatementEntity = new EntityInsertionAdapter<StatementEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `StatementEntity` (`statementIdHi`,`statementIdLo`,`statementActorPersonUid`,`statementVerbUid`,`statementObjectType`,`statementObjectUid1`,`statementObjectUid2`,`statementActorUid`,`authorityActorUid`,`teamUid`,`resultCompletion`,`resultSuccess`,`resultScoreScaled`,`resultScoreRaw`,`resultScoreMin`,`resultScoreMax`,`resultDuration`,`resultResponse`,`timestamp`,`stored`,`contextRegistrationHi`,`contextRegistrationLo`,`contextPlatform`,`contextStatementRefIdHi`,`contextStatementRefIdLo`,`contextInstructorActorUid`,`statementLct`,`extensionProgress`,`completionOrProgress`,`statementContentEntryUid`,`statementLearnerGroupUid`,`statementClazzUid`,`statementCbUid`,`statementDoorNode`,`isSubStatement`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final StatementEntity entity) {
        statement.bindLong(1, entity.getStatementIdHi());
        statement.bindLong(2, entity.getStatementIdLo());
        statement.bindLong(3, entity.getStatementActorPersonUid());
        statement.bindLong(4, entity.getStatementVerbUid());
        statement.bindLong(5, entity.getStatementObjectType());
        statement.bindLong(6, entity.getStatementObjectUid1());
        statement.bindLong(7, entity.getStatementObjectUid2());
        statement.bindLong(8, entity.getStatementActorUid());
        statement.bindLong(9, entity.getAuthorityActorUid());
        statement.bindLong(10, entity.getTeamUid());
        final Integer _tmp = entity.getResultCompletion() == null ? null : (entity.getResultCompletion() ? 1 : 0);
        if (_tmp == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, _tmp);
        }
        final Integer _tmp_1 = entity.getResultSuccess() == null ? null : (entity.getResultSuccess() ? 1 : 0);
        if (_tmp_1 == null) {
          statement.bindNull(12);
        } else {
          statement.bindLong(12, _tmp_1);
        }
        if (entity.getResultScoreScaled() == null) {
          statement.bindNull(13);
        } else {
          statement.bindDouble(13, entity.getResultScoreScaled());
        }
        if (entity.getResultScoreRaw() == null) {
          statement.bindNull(14);
        } else {
          statement.bindDouble(14, entity.getResultScoreRaw());
        }
        if (entity.getResultScoreMin() == null) {
          statement.bindNull(15);
        } else {
          statement.bindDouble(15, entity.getResultScoreMin());
        }
        if (entity.getResultScoreMax() == null) {
          statement.bindNull(16);
        } else {
          statement.bindDouble(16, entity.getResultScoreMax());
        }
        if (entity.getResultDuration() == null) {
          statement.bindNull(17);
        } else {
          statement.bindLong(17, entity.getResultDuration());
        }
        if (entity.getResultResponse() == null) {
          statement.bindNull(18);
        } else {
          statement.bindString(18, entity.getResultResponse());
        }
        statement.bindLong(19, entity.getTimestamp());
        statement.bindLong(20, entity.getStored());
        statement.bindLong(21, entity.getContextRegistrationHi());
        statement.bindLong(22, entity.getContextRegistrationLo());
        if (entity.getContextPlatform() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getContextPlatform());
        }
        statement.bindLong(24, entity.getContextStatementRefIdHi());
        statement.bindLong(25, entity.getContextStatementRefIdLo());
        statement.bindLong(26, entity.getContextInstructorActorUid());
        statement.bindLong(27, entity.getStatementLct());
        if (entity.getExtensionProgress() == null) {
          statement.bindNull(28);
        } else {
          statement.bindLong(28, entity.getExtensionProgress());
        }
        final int _tmp_2 = entity.getCompletionOrProgress() ? 1 : 0;
        statement.bindLong(29, _tmp_2);
        statement.bindLong(30, entity.getStatementContentEntryUid());
        statement.bindLong(31, entity.getStatementLearnerGroupUid());
        statement.bindLong(32, entity.getStatementClazzUid());
        statement.bindLong(33, entity.getStatementCbUid());
        statement.bindLong(34, entity.getStatementDoorNode());
        final int _tmp_3 = entity.isSubStatement() ? 1 : 0;
        statement.bindLong(35, _tmp_3);
      }
    };
  }

  @Override
  public Object insertOrIgnoreListAsync(final List<StatementEntity> entityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfStatementEntity.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<StatementEntity> getOneStatement() {
    final String _sql = "SELECT * From StatementEntity LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"StatementEntity"}, new Callable<StatementEntity>() {
      @Override
      @Nullable
      public StatementEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final StatementEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpStatementIdHi;
            _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
            final long _tmpStatementIdLo;
            _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
            final long _tmpStatementActorPersonUid;
            _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            final int _tmpStatementObjectType;
            _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
            final long _tmpStatementObjectUid1;
            _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
            final long _tmpStatementObjectUid2;
            _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
            final long _tmpStatementActorUid;
            _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
            final long _tmpAuthorityActorUid;
            _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            final Boolean _tmpResultCompletion;
            final Integer _tmp;
            if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            }
            _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            final Boolean _tmpResultSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfResultSuccess);
            }
            _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpResultScoreScaled;
            if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
              _tmpResultScoreScaled = null;
            } else {
              _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            }
            final Float _tmpResultScoreRaw;
            if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
              _tmpResultScoreRaw = null;
            } else {
              _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
            }
            final Float _tmpResultScoreMin;
            if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
              _tmpResultScoreMin = null;
            } else {
              _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
            }
            final Float _tmpResultScoreMax;
            if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
              _tmpResultScoreMax = null;
            } else {
              _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
            }
            final Long _tmpResultDuration;
            if (_cursor.isNull(_cursorIndexOfResultDuration)) {
              _tmpResultDuration = null;
            } else {
              _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            }
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            final long _tmpContextRegistrationHi;
            _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
            final long _tmpContextRegistrationLo;
            _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            final long _tmpContextStatementRefIdHi;
            _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            final long _tmpContextStatementRefIdLo;
            _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            final long _tmpContextInstructorActorUid;
            _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            final Integer _tmpExtensionProgress;
            if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
              _tmpExtensionProgress = null;
            } else {
              _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            }
            final boolean _tmpCompletionOrProgress;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
            _tmpCompletionOrProgress = _tmp_2 != 0;
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            final long _tmpStatementCbUid;
            _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
            final long _tmpStatementDoorNode;
            _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
            final boolean _tmpIsSubStatement;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
            _tmpIsSubStatement = _tmp_3 != 0;
            _result = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Person getPerson() {
    final String _sql = "SELECT * FROM PERSON LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final Person _result;
      if (_cursor.moveToFirst()) {
        final long _tmpPersonUid;
        _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
        final String _tmpUsername;
        if (_cursor.isNull(_cursorIndexOfUsername)) {
          _tmpUsername = null;
        } else {
          _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
        }
        final String _tmpFirstNames;
        if (_cursor.isNull(_cursorIndexOfFirstNames)) {
          _tmpFirstNames = null;
        } else {
          _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
        }
        final String _tmpLastName;
        if (_cursor.isNull(_cursorIndexOfLastName)) {
          _tmpLastName = null;
        } else {
          _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
        }
        final String _tmpEmailAddr;
        if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
          _tmpEmailAddr = null;
        } else {
          _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
        }
        final String _tmpPhoneNum;
        if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
          _tmpPhoneNum = null;
        } else {
          _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
        }
        final int _tmpGender;
        _tmpGender = _cursor.getInt(_cursorIndexOfGender);
        final boolean _tmpActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfActive);
        _tmpActive = _tmp != 0;
        final long _tmpDateOfBirth;
        _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
        final String _tmpPersonAddress;
        if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
          _tmpPersonAddress = null;
        } else {
          _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
        }
        final String _tmpPersonOrgId;
        if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
          _tmpPersonOrgId = null;
        } else {
          _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
        }
        final long _tmpPersonGroupUid;
        _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
        final long _tmpPersonLct;
        _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
        final String _tmpPersonCountry;
        if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
          _tmpPersonCountry = null;
        } else {
          _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
        }
        final int _tmpPersonType;
        _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
        final long _tmpPersonMasterChangeSeqNum;
        _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
        final long _tmpPersonLocalChangeSeqNum;
        _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
        final int _tmpPersonLastChangedBy;
        _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
        final boolean _tmpAdmin;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
        _tmpAdmin = _tmp_1 != 0;
        final String _tmpPersonNotes;
        if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
          _tmpPersonNotes = null;
        } else {
          _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
        }
        final String _tmpFatherName;
        if (_cursor.isNull(_cursorIndexOfFatherName)) {
          _tmpFatherName = null;
        } else {
          _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
        }
        final String _tmpFatherNumber;
        if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
          _tmpFatherNumber = null;
        } else {
          _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
        }
        final String _tmpMotherName;
        if (_cursor.isNull(_cursorIndexOfMotherName)) {
          _tmpMotherName = null;
        } else {
          _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
        }
        final String _tmpMotherNum;
        if (_cursor.isNull(_cursorIndexOfMotherNum)) {
          _tmpMotherNum = null;
        } else {
          _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
        }
        _result = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getStatements(final long statementIdHi, final long statementIdLo,
      final Continuation<? super List<StatementEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT StatementEntity.*\n"
            + "          FROM StatementEntity\n"
            + "         WHERE (    (? = 0 AND ? = 0) \n"
            + "                 OR (statementIdHi = ? AND statementIdLo = ?))\n"
            + "                  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, statementIdHi);
    _argIndex = 2;
    _statement.bindLong(_argIndex, statementIdLo);
    _argIndex = 3;
    _statement.bindLong(_argIndex, statementIdHi);
    _argIndex = 4;
    _statement.bindLong(_argIndex, statementIdLo);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementEntity>>() {
      @Override
      @NonNull
      public List<StatementEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final List<StatementEntity> _result = new ArrayList<StatementEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementEntity _item;
            final long _tmpStatementIdHi;
            _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
            final long _tmpStatementIdLo;
            _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
            final long _tmpStatementActorPersonUid;
            _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            final int _tmpStatementObjectType;
            _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
            final long _tmpStatementObjectUid1;
            _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
            final long _tmpStatementObjectUid2;
            _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
            final long _tmpStatementActorUid;
            _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
            final long _tmpAuthorityActorUid;
            _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            final Boolean _tmpResultCompletion;
            final Integer _tmp;
            if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            }
            _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            final Boolean _tmpResultSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfResultSuccess);
            }
            _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpResultScoreScaled;
            if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
              _tmpResultScoreScaled = null;
            } else {
              _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            }
            final Float _tmpResultScoreRaw;
            if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
              _tmpResultScoreRaw = null;
            } else {
              _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
            }
            final Float _tmpResultScoreMin;
            if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
              _tmpResultScoreMin = null;
            } else {
              _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
            }
            final Float _tmpResultScoreMax;
            if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
              _tmpResultScoreMax = null;
            } else {
              _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
            }
            final Long _tmpResultDuration;
            if (_cursor.isNull(_cursorIndexOfResultDuration)) {
              _tmpResultDuration = null;
            } else {
              _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            }
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            final long _tmpContextRegistrationHi;
            _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
            final long _tmpContextRegistrationLo;
            _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            final long _tmpContextStatementRefIdHi;
            _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            final long _tmpContextStatementRefIdLo;
            _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            final long _tmpContextInstructorActorUid;
            _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            final Integer _tmpExtensionProgress;
            if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
              _tmpExtensionProgress = null;
            } else {
              _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            }
            final boolean _tmpCompletionOrProgress;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
            _tmpCompletionOrProgress = _tmp_2 != 0;
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            final long _tmpStatementCbUid;
            _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
            final long _tmpStatementDoorNode;
            _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
            final boolean _tmpIsSubStatement;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
            _tmpIsSubStatement = _tmp_3 != 0;
            _item = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findById(final long statementIdHi, final long statementIdLo,
      final Continuation<? super StatementEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT StatementEntity.*\n"
            + "          FROM StatementEntity\n"
            + "         WHERE statementIdHi = ? \n"
            + "           AND statementIdLo = ?       \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, statementIdHi);
    _argIndex = 2;
    _statement.bindLong(_argIndex, statementIdLo);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<StatementEntity>() {
      @Override
      @Nullable
      public StatementEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final StatementEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpStatementIdHi;
            _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
            final long _tmpStatementIdLo;
            _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
            final long _tmpStatementActorPersonUid;
            _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            final int _tmpStatementObjectType;
            _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
            final long _tmpStatementObjectUid1;
            _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
            final long _tmpStatementObjectUid2;
            _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
            final long _tmpStatementActorUid;
            _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
            final long _tmpAuthorityActorUid;
            _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            final Boolean _tmpResultCompletion;
            final Integer _tmp;
            if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            }
            _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            final Boolean _tmpResultSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfResultSuccess);
            }
            _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpResultScoreScaled;
            if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
              _tmpResultScoreScaled = null;
            } else {
              _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            }
            final Float _tmpResultScoreRaw;
            if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
              _tmpResultScoreRaw = null;
            } else {
              _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
            }
            final Float _tmpResultScoreMin;
            if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
              _tmpResultScoreMin = null;
            } else {
              _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
            }
            final Float _tmpResultScoreMax;
            if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
              _tmpResultScoreMax = null;
            } else {
              _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
            }
            final Long _tmpResultDuration;
            if (_cursor.isNull(_cursorIndexOfResultDuration)) {
              _tmpResultDuration = null;
            } else {
              _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            }
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            final long _tmpContextRegistrationHi;
            _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
            final long _tmpContextRegistrationLo;
            _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            final long _tmpContextStatementRefIdHi;
            _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            final long _tmpContextStatementRefIdLo;
            _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            final long _tmpContextInstructorActorUid;
            _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            final Integer _tmpExtensionProgress;
            if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
              _tmpExtensionProgress = null;
            } else {
              _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            }
            final boolean _tmpCompletionOrProgress;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
            _tmpCompletionOrProgress = _tmp_2 != 0;
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            final long _tmpStatementCbUid;
            _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
            final long _tmpStatementDoorNode;
            _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
            final boolean _tmpIsSubStatement;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
            _tmpIsSubStatement = _tmp_3 != 0;
            _result = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findStatusStatementsByContentEntryUid(final long contentEntryUid,
      final long courseBlockUid, final long accountPersonUid,
      final Continuation<? super List<StatementEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT StatementEntity.*\n"
            + "               \n"
            + "            \n"
            + "          FROM StatementEntity\n"
            + "         WHERE StatementEntity.statementActorPersonUid = ?\n"
            + "           AND StatementEntity.statementContentEntryUid = ?\n"
            + "           AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "           AND (? = 0 OR StatementEntity.statementCbUid = ?)\n"
            + "    \n"
            + "        AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n"
            + "              OR (StatementEntity.extensionProgress IS NOT NULL))\n"
            + "        \n"
            + "        \n"
            + "    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, courseBlockUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, courseBlockUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementEntity>>() {
      @Override
      @NonNull
      public List<StatementEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final List<StatementEntity> _result = new ArrayList<StatementEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementEntity _item;
            final long _tmpStatementIdHi;
            _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
            final long _tmpStatementIdLo;
            _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
            final long _tmpStatementActorPersonUid;
            _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            final int _tmpStatementObjectType;
            _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
            final long _tmpStatementObjectUid1;
            _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
            final long _tmpStatementObjectUid2;
            _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
            final long _tmpStatementActorUid;
            _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
            final long _tmpAuthorityActorUid;
            _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            final Boolean _tmpResultCompletion;
            final Integer _tmp;
            if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            }
            _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            final Boolean _tmpResultSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfResultSuccess);
            }
            _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpResultScoreScaled;
            if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
              _tmpResultScoreScaled = null;
            } else {
              _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            }
            final Float _tmpResultScoreRaw;
            if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
              _tmpResultScoreRaw = null;
            } else {
              _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
            }
            final Float _tmpResultScoreMin;
            if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
              _tmpResultScoreMin = null;
            } else {
              _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
            }
            final Float _tmpResultScoreMax;
            if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
              _tmpResultScoreMax = null;
            } else {
              _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
            }
            final Long _tmpResultDuration;
            if (_cursor.isNull(_cursorIndexOfResultDuration)) {
              _tmpResultDuration = null;
            } else {
              _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            }
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            final long _tmpContextRegistrationHi;
            _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
            final long _tmpContextRegistrationLo;
            _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            final long _tmpContextStatementRefIdHi;
            _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            final long _tmpContextStatementRefIdLo;
            _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            final long _tmpContextInstructorActorUid;
            _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            final Integer _tmpExtensionProgress;
            if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
              _tmpExtensionProgress = null;
            } else {
              _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            }
            final boolean _tmpCompletionOrProgress;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
            _tmpCompletionOrProgress = _tmp_2 != 0;
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            final long _tmpStatementCbUid;
            _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
            final long _tmpStatementDoorNode;
            _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
            final boolean _tmpIsSubStatement;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
            _tmpIsSubStatement = _tmp_3 != 0;
            _item = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findStatusStatementByParentContentEntryUid(final long parentUid,
      final long accountPersonUid, final Continuation<? super List<StatementEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT StatementEntity.*\n"
            + "               \n"
            + "        FROM StatementEntity\n"
            + "       WHERE StatementEntity.statementActorPersonUid = ?\n"
            + "         AND StatementEntity.statementContentEntryUid IN (\n"
            + "             SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n"
            + "               FROM ContentEntryParentChildJoin\n"
            + "              WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?)\n"
            + "         AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n"
            + "         AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n"
            + "              OR (StatementEntity.extensionProgress IS NOT NULL))     \n"
            + "    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementEntity>>() {
      @Override
      @NonNull
      public List<StatementEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final List<StatementEntity> _result = new ArrayList<StatementEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementEntity _item;
            final long _tmpStatementIdHi;
            _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
            final long _tmpStatementIdLo;
            _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
            final long _tmpStatementActorPersonUid;
            _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            final int _tmpStatementObjectType;
            _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
            final long _tmpStatementObjectUid1;
            _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
            final long _tmpStatementObjectUid2;
            _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
            final long _tmpStatementActorUid;
            _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
            final long _tmpAuthorityActorUid;
            _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            final Boolean _tmpResultCompletion;
            final Integer _tmp;
            if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            }
            _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            final Boolean _tmpResultSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfResultSuccess);
            }
            _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpResultScoreScaled;
            if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
              _tmpResultScoreScaled = null;
            } else {
              _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            }
            final Float _tmpResultScoreRaw;
            if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
              _tmpResultScoreRaw = null;
            } else {
              _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
            }
            final Float _tmpResultScoreMin;
            if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
              _tmpResultScoreMin = null;
            } else {
              _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
            }
            final Float _tmpResultScoreMax;
            if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
              _tmpResultScoreMax = null;
            } else {
              _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
            }
            final Long _tmpResultDuration;
            if (_cursor.isNull(_cursorIndexOfResultDuration)) {
              _tmpResultDuration = null;
            } else {
              _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            }
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            final long _tmpContextRegistrationHi;
            _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
            final long _tmpContextRegistrationLo;
            _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            final long _tmpContextStatementRefIdHi;
            _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            final long _tmpContextStatementRefIdLo;
            _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            final long _tmpContextInstructorActorUid;
            _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            final Integer _tmpExtensionProgress;
            if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
              _tmpExtensionProgress = null;
            } else {
              _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            }
            final boolean _tmpCompletionOrProgress;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
            _tmpCompletionOrProgress = _tmp_2 != 0;
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            final long _tmpStatementCbUid;
            _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
            final long _tmpStatementDoorNode;
            _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
            final boolean _tmpIsSubStatement;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
            _tmpIsSubStatement = _tmp_3 != 0;
            _item = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findStatusStatementsForStudentByClazzUid(final long clazzUid,
      final long accountPersonUid, final Continuation<? super List<StatementEntity>> $completion) {
    final String _sql = "\n"
            + "        WITH PersonUids(personUid) AS (\n"
            + "            SELECT ? AS personUid\n"
            + "        ),\n"
            + "        \n"
            + "        \n"
            + "        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n"
            + "        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n"
            + "             SELECT ActorEntity.actorUid AS actorUid, \n"
            + "                    ActorEntity.actorPersonUid AS actorPersonUid\n"
            + "               FROM ActorEntity\n"
            + "              WHERE ActorEntity.actorPersonUid IN\n"
            + "                    (SELECT PersonUids.personUid\n"
            + "                       FROM PersonUids)           \n"
            + "        ),\n"
            + "        \n"
            + "        -- Add in group actor uids\n"
            + "        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n"
            + "             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n"
            + "                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n"
            + "               FROM AgentActorUidsForPersonUid     \n"
            + "              UNION \n"
            + "             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n"
            + "                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n"
            + "               FROM AgentActorUidsForPersonUid\n"
            + "                    JOIN GroupMemberActorJoin \n"
            + "                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n"
            + "        )\n"
            + "    \n"
            + "        \n"
            + "        SELECT StatementEntity.*\n"
            + "               \n"
            + "               FROM StatementEntity\n"
            + "              WHERE (\n"
            + "        (SELECT EXISTS(\n"
            + "                SELECT 1\n"
            + "                  FROM ClazzEnrolment\n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ?\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n"
            + "    )\n"
            + "                AND StatementEntity.statementActorUid IN (\n"
            + "                    SELECT ActorUidsForPersonUid.actorUid\n"
            + "                      FROM ActorUidsForPersonUid)\n"
            + "                AND StatementEntity.statementClazzUid = ?\n"
            + "                AND (    (CAST(StatementEntity.resultCompletion AS INTEGER) = 1)\n"
            + "                      OR (StatementEntity.extensionProgress IS NOT NULL))\n"
            + "    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementEntity>>() {
      @Override
      @NonNull
      public List<StatementEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final List<StatementEntity> _result = new ArrayList<StatementEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementEntity _item;
            final long _tmpStatementIdHi;
            _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
            final long _tmpStatementIdLo;
            _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
            final long _tmpStatementActorPersonUid;
            _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            final int _tmpStatementObjectType;
            _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
            final long _tmpStatementObjectUid1;
            _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
            final long _tmpStatementObjectUid2;
            _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
            final long _tmpStatementActorUid;
            _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
            final long _tmpAuthorityActorUid;
            _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            final Boolean _tmpResultCompletion;
            final Integer _tmp;
            if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            }
            _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            final Boolean _tmpResultSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfResultSuccess);
            }
            _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpResultScoreScaled;
            if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
              _tmpResultScoreScaled = null;
            } else {
              _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            }
            final Float _tmpResultScoreRaw;
            if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
              _tmpResultScoreRaw = null;
            } else {
              _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
            }
            final Float _tmpResultScoreMin;
            if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
              _tmpResultScoreMin = null;
            } else {
              _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
            }
            final Float _tmpResultScoreMax;
            if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
              _tmpResultScoreMax = null;
            } else {
              _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
            }
            final Long _tmpResultDuration;
            if (_cursor.isNull(_cursorIndexOfResultDuration)) {
              _tmpResultDuration = null;
            } else {
              _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            }
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            final long _tmpContextRegistrationHi;
            _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
            final long _tmpContextRegistrationLo;
            _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            final long _tmpContextStatementRefIdHi;
            _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            final long _tmpContextStatementRefIdLo;
            _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            final long _tmpContextInstructorActorUid;
            _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            final Integer _tmpExtensionProgress;
            if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
              _tmpExtensionProgress = null;
            } else {
              _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            }
            final boolean _tmpCompletionOrProgress;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
            _tmpCompletionOrProgress = _tmp_2 != 0;
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            final long _tmpStatementCbUid;
            _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
            final long _tmpStatementDoorNode;
            _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
            final boolean _tmpIsSubStatement;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
            _tmpIsSubStatement = _tmp_3 != 0;
            _item = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findStatusForStudentsInClazzStatements(final long clazzUid, final int roleId,
      final int sortOrder, final String searchText, final int filter, final long accountPersonUid,
      final long currentTime, final int studentsLimit, final int studentsOffset,
      final boolean completionOrProgressTrueVal,
      final Continuation<? super List<StatementEntityAndRelated>> $completion) {
    final String _sql = "\n"
            + "        -- Get the PersonUids for those that are within the current page as per studentsLimit and \n"
            + "        -- studentsOffset\n"
            + "        WITH \n"
            + "        PersonUids(personUid) AS (\n"
            + "            SELECT CourseMember.personUid \n"
            + "              FROM (SELECT Person.*,\n"
            + "                           (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n"
            + "            \n"
            + "                           (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n"
            + "            \n"
            + "                           (SELECT ClazzEnrolment.clazzEnrolmentRole \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentActive\n"
            + "                          ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n"
            + "                             LIMIT 1) AS enrolmentRole\n"
            + "                      FROM Person\n"
            + "                     WHERE Person.personUid IN \n"
            + "                           (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid \n"
            + "                              FROM ClazzEnrolment \n"
            + "                             WHERE ClazzEnrolment.clazzEnrolmentClazzUid = ? \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentActive \n"
            + "                               AND ClazzEnrolment.clazzEnrolmentRole = ? \n"
            + "                               AND (? != 1 \n"
            + "                                     OR (? \n"
            + "                                          BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                                          AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n"
            + "                       /* Begin permission check */\n"
            + "                       AND (\n"
            + "                               ((\n"
            + "             /* If the accountPersonUid is the owner of the course, all permissions are granted */\n"
            + "             (COALESCE(\n"
            + "                          (SELECT _Clazz_Permission.clazzOwnerPersonUid \n"
            + "                             FROM Clazz _Clazz_Permission\n"
            + "                            WHERE _Clazz_Permission.clazzUid = ?), 0) = ?)\n"
            + "              /* \n"
            + "              If there is a CoursePermission entity that is for the course as per the clazzUid\n"
            + "              parameter that is granted to the person directly or to the enrolmentRole that the \n"
            + "              person has in the course, then permission is granted.\n"
            + "              */              \n"
            + "              OR EXISTS(SELECT CoursePermission.cpUid\n"
            + "                          FROM CoursePermission\n"
            + "                               \n"
            + "        LEFT JOIN ClazzEnrolment ClazzEnrolment_ForAccountPerson \n"
            + "                        ON CoursePermission.cpToEnrolmentRole != 0\n"
            + "                       AND ClazzEnrolment_ForAccountPerson.clazzEnrolmentUid = \n"
            + "                           (SELECT COALESCE(\n"
            + "                                   (SELECT _ClazzEnrolment_AccountPersonInner.clazzEnrolmentUid \n"
            + "                                      FROM ClazzEnrolment _ClazzEnrolment_AccountPersonInner\n"
            + "                                     WHERE _ClazzEnrolment_AccountPersonInner.clazzEnrolmentClazzUid = CoursePermission.cpClazzUid\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentPersonUid = ?\n"
            + "                                       AND _ClazzEnrolment_AccountPersonInner.clazzEnrolmentActive\n"
            + "                                  ORDER BY _ClazzEnrolment_AccountPersonInner.clazzEnrolmentDateLeft DESC   \n"
            + "                                     LIMIT 1), 0))\n"
            + "    \n"
            + "                         WHERE CoursePermission.cpClazzUid = ?\n"
            + "                           AND (CoursePermission.cpToPersonUid = ? \n"
            + "                                OR CoursePermission.cpToEnrolmentRole = ClazzEnrolment_ForAccountPerson.clazzEnrolmentRole)\n"
            + "                           AND (CoursePermission.cpPermissionsFlag & \n"
            + "         128\n"
            + "                                \n"
            + "        ) > 0)\n"
            + "              OR EXISTS(SELECT SystemPermission.spUid\n"
            + "                          FROM SystemPermission\n"
            + "                         WHERE SystemPermission.spToPersonUid = ?\n"
            + "                           AND (SystemPermission.spPermissionsFlag & \n"
            + "     128\n"
            + "                                \n"
            + "        ) > 0)\n"
            + "               )\n"
            + "    )\n"
            + "                            OR Person.personUid = ?\n"
            + "                           )  \n"
            + "                       /* End permission check */                   \n"
            + "                       AND Person.firstNames || ' ' || Person.lastName LIKE ?\n"
            + "                   GROUP BY Person.personUid) AS CourseMember\n"
            + "          ORDER BY CASE(?)\n"
            + "                    WHEN 1 THEN CourseMember.firstNames\n"
            + "                    WHEN 3 THEN CourseMember.lastName\n"
            + "                    ELSE ''\n"
            + "                END ASC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 2 THEN CourseMember.firstNames\n"
            + "                    WHEN 4 THEN CourseMember.lastName\n"
            + "                    ELSE ''\n"
            + "                END DESC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 7 THEN CourseMember.earliestJoinDate\n"
            + "                    WHEN 9 THEN CourseMember.latestDateLeft\n"
            + "                    ELSE 0\n"
            + "                END ASC,\n"
            + "                CASE(?)\n"
            + "                    WHEN 8 THEN CourseMember.earliestJoinDate\n"
            + "                    WHEN 10 THEN CourseMember.latestDateLeft\n"
            + "                    ELSE 0\n"
            + "                END DESC\n"
            + "             LIMIT ?\n"
            + "            OFFSET ?   \n"
            + "         )\n"
            + "    ,\n"
            + "        \n"
            + "        \n"
            + "        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship\n"
            + "        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(\n"
            + "             SELECT ActorEntity.actorUid AS actorUid, \n"
            + "                    ActorEntity.actorPersonUid AS actorPersonUid\n"
            + "               FROM ActorEntity\n"
            + "              WHERE ActorEntity.actorPersonUid IN\n"
            + "                    (SELECT PersonUids.personUid\n"
            + "                       FROM PersonUids)           \n"
            + "        ),\n"
            + "        \n"
            + "        -- Add in group actor uids\n"
            + "        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (\n"
            + "             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,\n"
            + "                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n"
            + "               FROM AgentActorUidsForPersonUid     \n"
            + "              UNION \n"
            + "             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,\n"
            + "                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid\n"
            + "               FROM AgentActorUidsForPersonUid\n"
            + "                    JOIN GroupMemberActorJoin \n"
            + "                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid\n"
            + "        )\n"
            + "    \n"
            + "\n"
            + "        \n"
            + "        -- Fetch all statements that could be completion or progress for the Gradebook report\n"
            + "        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*\n"
            + "          FROM StatementEntity\n"
            + "               JOIN ActorEntity\n"
            + "                    ON ActorEntity.actorUid = StatementEntity.statementActorUid\n"
            + "               LEFT JOIN GroupMemberActorJoin\n"
            + "                    ON ActorEntity.actorObjectType = 2\n"
            + "                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid\n"
            + "                       AND GroupMemberActorJoin.gmajMemberActorUid IN (\n"
            + "                           SELECT DISTINCT ActorUidsForPersonUid.actorUid\n"
            + "                             FROM ActorUidsForPersonUid)\n"
            + "         WHERE StatementEntity.statementClazzUid = ?\n"
            + "           AND StatementEntity.completionOrProgress = ?\n"
            + "           AND StatementEntity.statementActorUid IN (\n"
            + "               SELECT DISTINCT ActorUidsForPersonUid.actorUid\n"
            + "                 FROM ActorUidsForPersonUid) \n"
            + "           AND (      StatementEntity.resultScoreScaled IS NOT NULL\n"
            + "                   OR StatementEntity.resultCompletion IS NOT NULL\n"
            + "                   OR StatementEntity.resultSuccess IS NOT NULL\n"
            + "                   OR StatementEntity.extensionProgress IS NOT NULL \n"
            + "               )\n"
            + "    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 21);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, roleId);
    _argIndex = 4;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 5;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 6;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 12;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 13;
    if (searchText == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchText);
    }
    _argIndex = 14;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 15;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 16;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 17;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 18;
    _statement.bindLong(_argIndex, studentsLimit);
    _argIndex = 19;
    _statement.bindLong(_argIndex, studentsOffset);
    _argIndex = 20;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 21;
    final int _tmp = completionOrProgressTrueVal ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementEntityAndRelated>>() {
      @Override
      @NonNull
      public List<StatementEntityAndRelated> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorUid");
          final int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorPersonUid");
          final int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorName");
          final int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox");
          final int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox_sha1sum");
          final int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorOpenid");
          final int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountName");
          final int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountHomePage");
          final int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "actorEtag");
          final int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actorLct");
          final int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "actorObjectType");
          final int _cursorIndexOfGmajGroupActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "gmajGroupActorUid");
          final int _cursorIndexOfGmajMemberActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "gmajMemberActorUid");
          final int _cursorIndexOfGmajLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "gmajLastMod");
          final List<StatementEntityAndRelated> _result = new ArrayList<StatementEntityAndRelated>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementEntityAndRelated _item;
            final StatementEntity _tmpStatementEntity;
            if (!(_cursor.isNull(_cursorIndexOfStatementIdHi) && _cursor.isNull(_cursorIndexOfStatementIdLo) && _cursor.isNull(_cursorIndexOfStatementActorPersonUid) && _cursor.isNull(_cursorIndexOfStatementVerbUid) && _cursor.isNull(_cursorIndexOfStatementObjectType) && _cursor.isNull(_cursorIndexOfStatementObjectUid1) && _cursor.isNull(_cursorIndexOfStatementObjectUid2) && _cursor.isNull(_cursorIndexOfStatementActorUid) && _cursor.isNull(_cursorIndexOfAuthorityActorUid) && _cursor.isNull(_cursorIndexOfTeamUid) && _cursor.isNull(_cursorIndexOfResultCompletion) && _cursor.isNull(_cursorIndexOfResultSuccess) && _cursor.isNull(_cursorIndexOfResultScoreScaled) && _cursor.isNull(_cursorIndexOfResultScoreRaw) && _cursor.isNull(_cursorIndexOfResultScoreMin) && _cursor.isNull(_cursorIndexOfResultScoreMax) && _cursor.isNull(_cursorIndexOfResultDuration) && _cursor.isNull(_cursorIndexOfResultResponse) && _cursor.isNull(_cursorIndexOfTimestamp) && _cursor.isNull(_cursorIndexOfStored) && _cursor.isNull(_cursorIndexOfContextRegistrationHi) && _cursor.isNull(_cursorIndexOfContextRegistrationLo) && _cursor.isNull(_cursorIndexOfContextPlatform) && _cursor.isNull(_cursorIndexOfContextStatementRefIdHi) && _cursor.isNull(_cursorIndexOfContextStatementRefIdLo) && _cursor.isNull(_cursorIndexOfContextInstructorActorUid) && _cursor.isNull(_cursorIndexOfStatementLct) && _cursor.isNull(_cursorIndexOfExtensionProgress) && _cursor.isNull(_cursorIndexOfCompletionOrProgress) && _cursor.isNull(_cursorIndexOfStatementContentEntryUid) && _cursor.isNull(_cursorIndexOfStatementLearnerGroupUid) && _cursor.isNull(_cursorIndexOfStatementClazzUid) && _cursor.isNull(_cursorIndexOfStatementCbUid) && _cursor.isNull(_cursorIndexOfStatementDoorNode) && _cursor.isNull(_cursorIndexOfIsSubStatement))) {
              final long _tmpStatementIdHi;
              _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
              final long _tmpStatementIdLo;
              _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
              final long _tmpStatementActorPersonUid;
              _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
              final long _tmpStatementVerbUid;
              _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
              final int _tmpStatementObjectType;
              _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
              final long _tmpStatementObjectUid1;
              _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
              final long _tmpStatementObjectUid2;
              _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
              final long _tmpStatementActorUid;
              _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
              final long _tmpAuthorityActorUid;
              _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
              final long _tmpTeamUid;
              _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
              final Boolean _tmpResultCompletion;
              final Integer _tmp_1;
              if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getInt(_cursorIndexOfResultCompletion);
              }
              _tmpResultCompletion = _tmp_1 == null ? null : _tmp_1 != 0;
              final Boolean _tmpResultSuccess;
              final Integer _tmp_2;
              if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getInt(_cursorIndexOfResultSuccess);
              }
              _tmpResultSuccess = _tmp_2 == null ? null : _tmp_2 != 0;
              final Float _tmpResultScoreScaled;
              if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
                _tmpResultScoreScaled = null;
              } else {
                _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
              }
              final Float _tmpResultScoreRaw;
              if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
                _tmpResultScoreRaw = null;
              } else {
                _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
              }
              final Float _tmpResultScoreMin;
              if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
                _tmpResultScoreMin = null;
              } else {
                _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
              }
              final Float _tmpResultScoreMax;
              if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
                _tmpResultScoreMax = null;
              } else {
                _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
              }
              final Long _tmpResultDuration;
              if (_cursor.isNull(_cursorIndexOfResultDuration)) {
                _tmpResultDuration = null;
              } else {
                _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
              }
              final String _tmpResultResponse;
              if (_cursor.isNull(_cursorIndexOfResultResponse)) {
                _tmpResultResponse = null;
              } else {
                _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
              }
              final long _tmpTimestamp;
              _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
              final long _tmpStored;
              _tmpStored = _cursor.getLong(_cursorIndexOfStored);
              final long _tmpContextRegistrationHi;
              _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
              final long _tmpContextRegistrationLo;
              _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
              final String _tmpContextPlatform;
              if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
                _tmpContextPlatform = null;
              } else {
                _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
              }
              final long _tmpContextStatementRefIdHi;
              _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
              final long _tmpContextStatementRefIdLo;
              _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
              final long _tmpContextInstructorActorUid;
              _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
              final long _tmpStatementLct;
              _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
              final Integer _tmpExtensionProgress;
              if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
                _tmpExtensionProgress = null;
              } else {
                _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
              }
              final boolean _tmpCompletionOrProgress;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
              _tmpCompletionOrProgress = _tmp_3 != 0;
              final long _tmpStatementContentEntryUid;
              _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
              final long _tmpStatementLearnerGroupUid;
              _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
              final long _tmpStatementClazzUid;
              _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
              final long _tmpStatementCbUid;
              _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
              final long _tmpStatementDoorNode;
              _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
              final boolean _tmpIsSubStatement;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfIsSubStatement);
              _tmpIsSubStatement = _tmp_4 != 0;
              _tmpStatementEntity = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
            } else {
              _tmpStatementEntity = null;
            }
            final ActorEntity _tmpActorEntity;
            if (!(_cursor.isNull(_cursorIndexOfActorUid) && _cursor.isNull(_cursorIndexOfActorPersonUid) && _cursor.isNull(_cursorIndexOfActorName) && _cursor.isNull(_cursorIndexOfActorMbox) && _cursor.isNull(_cursorIndexOfActorMboxSha1sum) && _cursor.isNull(_cursorIndexOfActorOpenid) && _cursor.isNull(_cursorIndexOfActorAccountName) && _cursor.isNull(_cursorIndexOfActorAccountHomePage) && _cursor.isNull(_cursorIndexOfActorEtag) && _cursor.isNull(_cursorIndexOfActorLct) && _cursor.isNull(_cursorIndexOfActorObjectType))) {
              final long _tmpActorUid;
              _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
              final long _tmpActorPersonUid;
              _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
              final String _tmpActorName;
              if (_cursor.isNull(_cursorIndexOfActorName)) {
                _tmpActorName = null;
              } else {
                _tmpActorName = _cursor.getString(_cursorIndexOfActorName);
              }
              final String _tmpActorMbox;
              if (_cursor.isNull(_cursorIndexOfActorMbox)) {
                _tmpActorMbox = null;
              } else {
                _tmpActorMbox = _cursor.getString(_cursorIndexOfActorMbox);
              }
              final String _tmpActorMbox_sha1sum;
              if (_cursor.isNull(_cursorIndexOfActorMboxSha1sum)) {
                _tmpActorMbox_sha1sum = null;
              } else {
                _tmpActorMbox_sha1sum = _cursor.getString(_cursorIndexOfActorMboxSha1sum);
              }
              final String _tmpActorOpenid;
              if (_cursor.isNull(_cursorIndexOfActorOpenid)) {
                _tmpActorOpenid = null;
              } else {
                _tmpActorOpenid = _cursor.getString(_cursorIndexOfActorOpenid);
              }
              final String _tmpActorAccountName;
              if (_cursor.isNull(_cursorIndexOfActorAccountName)) {
                _tmpActorAccountName = null;
              } else {
                _tmpActorAccountName = _cursor.getString(_cursorIndexOfActorAccountName);
              }
              final String _tmpActorAccountHomePage;
              if (_cursor.isNull(_cursorIndexOfActorAccountHomePage)) {
                _tmpActorAccountHomePage = null;
              } else {
                _tmpActorAccountHomePage = _cursor.getString(_cursorIndexOfActorAccountHomePage);
              }
              final long _tmpActorEtag;
              _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
              final long _tmpActorLct;
              _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
              final int _tmpActorObjectType;
              _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
              _tmpActorEntity = new ActorEntity(_tmpActorUid,_tmpActorPersonUid,_tmpActorName,_tmpActorMbox,_tmpActorMbox_sha1sum,_tmpActorOpenid,_tmpActorAccountName,_tmpActorAccountHomePage,_tmpActorEtag,_tmpActorLct,_tmpActorObjectType);
            } else {
              _tmpActorEntity = null;
            }
            final GroupMemberActorJoin _tmpGroupMemberActorJoin;
            if (!(_cursor.isNull(_cursorIndexOfGmajGroupActorUid) && _cursor.isNull(_cursorIndexOfGmajMemberActorUid) && _cursor.isNull(_cursorIndexOfGmajLastMod))) {
              final long _tmpGmajGroupActorUid;
              _tmpGmajGroupActorUid = _cursor.getLong(_cursorIndexOfGmajGroupActorUid);
              final long _tmpGmajMemberActorUid;
              _tmpGmajMemberActorUid = _cursor.getLong(_cursorIndexOfGmajMemberActorUid);
              final long _tmpGmajLastMod;
              _tmpGmajLastMod = _cursor.getLong(_cursorIndexOfGmajLastMod);
              _tmpGroupMemberActorJoin = new GroupMemberActorJoin(_tmpGmajGroupActorUid,_tmpGmajMemberActorUid,_tmpGmajLastMod);
            } else {
              _tmpGroupMemberActorJoin = null;
            }
            _item = new StatementEntityAndRelated(_tmpStatementEntity,_tmpGroupMemberActorJoin,_tmpActorEntity);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findStatusForStudentsInClazzByUidList(final long clazzUid,
      final List<Long> studentPersonUids, final boolean completionOrProgressTrueVal,
      final Continuation<? super List<StatementEntityAndRelated>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        WITH PersonUids(personUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE Person.personUid IN (");
    final int _inputSize = studentPersonUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(") ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT PersonUids.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM PersonUids)           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Add in group actor uids");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              UNION ");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        )");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Fetch all statements that could be completion or progress for the Gradebook report");
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT StatementEntity.*, ActorEntity.*, GroupMemberActorJoin.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       AND GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           SELECT DISTINCT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                             FROM ActorUidsForPersonUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE StatementEntity.statementClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND StatementEntity.completionOrProgress = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("               SELECT DISTINCT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 FROM ActorUidsForPersonUid) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (      StatementEntity.resultScoreScaled IS NOT NULL");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   OR StatementEntity.resultCompletion IS NOT NULL");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   OR StatementEntity.resultSuccess IS NOT NULL");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   OR StatementEntity.extensionProgress IS NOT NULL ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               )");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 2 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : studentPersonUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 1 + _inputSize;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2 + _inputSize;
    final int _tmp = completionOrProgressTrueVal ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementEntityAndRelated>>() {
      @Override
      @NonNull
      public List<StatementEntityAndRelated> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorUid");
          final int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorPersonUid");
          final int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorName");
          final int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox");
          final int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox_sha1sum");
          final int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorOpenid");
          final int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountName");
          final int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountHomePage");
          final int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "actorEtag");
          final int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actorLct");
          final int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "actorObjectType");
          final int _cursorIndexOfGmajGroupActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "gmajGroupActorUid");
          final int _cursorIndexOfGmajMemberActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "gmajMemberActorUid");
          final int _cursorIndexOfGmajLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "gmajLastMod");
          final List<StatementEntityAndRelated> _result = new ArrayList<StatementEntityAndRelated>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementEntityAndRelated _item_1;
            final StatementEntity _tmpStatementEntity;
            if (!(_cursor.isNull(_cursorIndexOfStatementIdHi) && _cursor.isNull(_cursorIndexOfStatementIdLo) && _cursor.isNull(_cursorIndexOfStatementActorPersonUid) && _cursor.isNull(_cursorIndexOfStatementVerbUid) && _cursor.isNull(_cursorIndexOfStatementObjectType) && _cursor.isNull(_cursorIndexOfStatementObjectUid1) && _cursor.isNull(_cursorIndexOfStatementObjectUid2) && _cursor.isNull(_cursorIndexOfStatementActorUid) && _cursor.isNull(_cursorIndexOfAuthorityActorUid) && _cursor.isNull(_cursorIndexOfTeamUid) && _cursor.isNull(_cursorIndexOfResultCompletion) && _cursor.isNull(_cursorIndexOfResultSuccess) && _cursor.isNull(_cursorIndexOfResultScoreScaled) && _cursor.isNull(_cursorIndexOfResultScoreRaw) && _cursor.isNull(_cursorIndexOfResultScoreMin) && _cursor.isNull(_cursorIndexOfResultScoreMax) && _cursor.isNull(_cursorIndexOfResultDuration) && _cursor.isNull(_cursorIndexOfResultResponse) && _cursor.isNull(_cursorIndexOfTimestamp) && _cursor.isNull(_cursorIndexOfStored) && _cursor.isNull(_cursorIndexOfContextRegistrationHi) && _cursor.isNull(_cursorIndexOfContextRegistrationLo) && _cursor.isNull(_cursorIndexOfContextPlatform) && _cursor.isNull(_cursorIndexOfContextStatementRefIdHi) && _cursor.isNull(_cursorIndexOfContextStatementRefIdLo) && _cursor.isNull(_cursorIndexOfContextInstructorActorUid) && _cursor.isNull(_cursorIndexOfStatementLct) && _cursor.isNull(_cursorIndexOfExtensionProgress) && _cursor.isNull(_cursorIndexOfCompletionOrProgress) && _cursor.isNull(_cursorIndexOfStatementContentEntryUid) && _cursor.isNull(_cursorIndexOfStatementLearnerGroupUid) && _cursor.isNull(_cursorIndexOfStatementClazzUid) && _cursor.isNull(_cursorIndexOfStatementCbUid) && _cursor.isNull(_cursorIndexOfStatementDoorNode) && _cursor.isNull(_cursorIndexOfIsSubStatement))) {
              final long _tmpStatementIdHi;
              _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
              final long _tmpStatementIdLo;
              _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
              final long _tmpStatementActorPersonUid;
              _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
              final long _tmpStatementVerbUid;
              _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
              final int _tmpStatementObjectType;
              _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
              final long _tmpStatementObjectUid1;
              _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
              final long _tmpStatementObjectUid2;
              _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
              final long _tmpStatementActorUid;
              _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
              final long _tmpAuthorityActorUid;
              _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
              final long _tmpTeamUid;
              _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
              final Boolean _tmpResultCompletion;
              final Integer _tmp_1;
              if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getInt(_cursorIndexOfResultCompletion);
              }
              _tmpResultCompletion = _tmp_1 == null ? null : _tmp_1 != 0;
              final Boolean _tmpResultSuccess;
              final Integer _tmp_2;
              if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getInt(_cursorIndexOfResultSuccess);
              }
              _tmpResultSuccess = _tmp_2 == null ? null : _tmp_2 != 0;
              final Float _tmpResultScoreScaled;
              if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
                _tmpResultScoreScaled = null;
              } else {
                _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
              }
              final Float _tmpResultScoreRaw;
              if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
                _tmpResultScoreRaw = null;
              } else {
                _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
              }
              final Float _tmpResultScoreMin;
              if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
                _tmpResultScoreMin = null;
              } else {
                _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
              }
              final Float _tmpResultScoreMax;
              if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
                _tmpResultScoreMax = null;
              } else {
                _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
              }
              final Long _tmpResultDuration;
              if (_cursor.isNull(_cursorIndexOfResultDuration)) {
                _tmpResultDuration = null;
              } else {
                _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
              }
              final String _tmpResultResponse;
              if (_cursor.isNull(_cursorIndexOfResultResponse)) {
                _tmpResultResponse = null;
              } else {
                _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
              }
              final long _tmpTimestamp;
              _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
              final long _tmpStored;
              _tmpStored = _cursor.getLong(_cursorIndexOfStored);
              final long _tmpContextRegistrationHi;
              _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
              final long _tmpContextRegistrationLo;
              _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
              final String _tmpContextPlatform;
              if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
                _tmpContextPlatform = null;
              } else {
                _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
              }
              final long _tmpContextStatementRefIdHi;
              _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
              final long _tmpContextStatementRefIdLo;
              _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
              final long _tmpContextInstructorActorUid;
              _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
              final long _tmpStatementLct;
              _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
              final Integer _tmpExtensionProgress;
              if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
                _tmpExtensionProgress = null;
              } else {
                _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
              }
              final boolean _tmpCompletionOrProgress;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
              _tmpCompletionOrProgress = _tmp_3 != 0;
              final long _tmpStatementContentEntryUid;
              _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
              final long _tmpStatementLearnerGroupUid;
              _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
              final long _tmpStatementClazzUid;
              _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
              final long _tmpStatementCbUid;
              _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
              final long _tmpStatementDoorNode;
              _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
              final boolean _tmpIsSubStatement;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfIsSubStatement);
              _tmpIsSubStatement = _tmp_4 != 0;
              _tmpStatementEntity = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
            } else {
              _tmpStatementEntity = null;
            }
            final ActorEntity _tmpActorEntity;
            if (!(_cursor.isNull(_cursorIndexOfActorUid) && _cursor.isNull(_cursorIndexOfActorPersonUid) && _cursor.isNull(_cursorIndexOfActorName) && _cursor.isNull(_cursorIndexOfActorMbox) && _cursor.isNull(_cursorIndexOfActorMboxSha1sum) && _cursor.isNull(_cursorIndexOfActorOpenid) && _cursor.isNull(_cursorIndexOfActorAccountName) && _cursor.isNull(_cursorIndexOfActorAccountHomePage) && _cursor.isNull(_cursorIndexOfActorEtag) && _cursor.isNull(_cursorIndexOfActorLct) && _cursor.isNull(_cursorIndexOfActorObjectType))) {
              final long _tmpActorUid;
              _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
              final long _tmpActorPersonUid;
              _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
              final String _tmpActorName;
              if (_cursor.isNull(_cursorIndexOfActorName)) {
                _tmpActorName = null;
              } else {
                _tmpActorName = _cursor.getString(_cursorIndexOfActorName);
              }
              final String _tmpActorMbox;
              if (_cursor.isNull(_cursorIndexOfActorMbox)) {
                _tmpActorMbox = null;
              } else {
                _tmpActorMbox = _cursor.getString(_cursorIndexOfActorMbox);
              }
              final String _tmpActorMbox_sha1sum;
              if (_cursor.isNull(_cursorIndexOfActorMboxSha1sum)) {
                _tmpActorMbox_sha1sum = null;
              } else {
                _tmpActorMbox_sha1sum = _cursor.getString(_cursorIndexOfActorMboxSha1sum);
              }
              final String _tmpActorOpenid;
              if (_cursor.isNull(_cursorIndexOfActorOpenid)) {
                _tmpActorOpenid = null;
              } else {
                _tmpActorOpenid = _cursor.getString(_cursorIndexOfActorOpenid);
              }
              final String _tmpActorAccountName;
              if (_cursor.isNull(_cursorIndexOfActorAccountName)) {
                _tmpActorAccountName = null;
              } else {
                _tmpActorAccountName = _cursor.getString(_cursorIndexOfActorAccountName);
              }
              final String _tmpActorAccountHomePage;
              if (_cursor.isNull(_cursorIndexOfActorAccountHomePage)) {
                _tmpActorAccountHomePage = null;
              } else {
                _tmpActorAccountHomePage = _cursor.getString(_cursorIndexOfActorAccountHomePage);
              }
              final long _tmpActorEtag;
              _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
              final long _tmpActorLct;
              _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
              final int _tmpActorObjectType;
              _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
              _tmpActorEntity = new ActorEntity(_tmpActorUid,_tmpActorPersonUid,_tmpActorName,_tmpActorMbox,_tmpActorMbox_sha1sum,_tmpActorOpenid,_tmpActorAccountName,_tmpActorAccountHomePage,_tmpActorEtag,_tmpActorLct,_tmpActorObjectType);
            } else {
              _tmpActorEntity = null;
            }
            final GroupMemberActorJoin _tmpGroupMemberActorJoin;
            if (!(_cursor.isNull(_cursorIndexOfGmajGroupActorUid) && _cursor.isNull(_cursorIndexOfGmajMemberActorUid) && _cursor.isNull(_cursorIndexOfGmajLastMod))) {
              final long _tmpGmajGroupActorUid;
              _tmpGmajGroupActorUid = _cursor.getLong(_cursorIndexOfGmajGroupActorUid);
              final long _tmpGmajMemberActorUid;
              _tmpGmajMemberActorUid = _cursor.getLong(_cursorIndexOfGmajMemberActorUid);
              final long _tmpGmajLastMod;
              _tmpGmajLastMod = _cursor.getLong(_cursorIndexOfGmajLastMod);
              _tmpGroupMemberActorJoin = new GroupMemberActorJoin(_tmpGmajGroupActorUid,_tmpGmajMemberActorUid,_tmpGmajLastMod);
            } else {
              _tmpGroupMemberActorJoin = null;
            }
            _item_1 = new StatementEntityAndRelated(_tmpStatementEntity,_tmpGroupMemberActorJoin,_tmpActorEntity);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findActorEntitiesForStudentInClazzByUidList(final long clazzUid,
      final List<Long> studentPersonUids, final long accountPersonUid,
      final Continuation<? super List<ActorEntity>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        WITH PersonUids(personUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE Person.personUid IN (");
    final int _inputSize = studentPersonUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(") ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT PersonUids.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM PersonUids)           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Add in group actor uids");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              UNION ");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        )");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT ActorEntity.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE ActorEntity.actorPersonUid IN ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT PersonUids.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM PersonUids)");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 4 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : studentPersonUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 1 + _inputSize;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2 + _inputSize;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3 + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 4 + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ActorEntity>>() {
      @Override
      @NonNull
      public List<ActorEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorUid");
          final int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorPersonUid");
          final int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorName");
          final int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox");
          final int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox_sha1sum");
          final int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorOpenid");
          final int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountName");
          final int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountHomePage");
          final int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "actorEtag");
          final int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actorLct");
          final int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "actorObjectType");
          final List<ActorEntity> _result = new ArrayList<ActorEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ActorEntity _item_1;
            final long _tmpActorUid;
            _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
            final long _tmpActorPersonUid;
            _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
            final String _tmpActorName;
            if (_cursor.isNull(_cursorIndexOfActorName)) {
              _tmpActorName = null;
            } else {
              _tmpActorName = _cursor.getString(_cursorIndexOfActorName);
            }
            final String _tmpActorMbox;
            if (_cursor.isNull(_cursorIndexOfActorMbox)) {
              _tmpActorMbox = null;
            } else {
              _tmpActorMbox = _cursor.getString(_cursorIndexOfActorMbox);
            }
            final String _tmpActorMbox_sha1sum;
            if (_cursor.isNull(_cursorIndexOfActorMboxSha1sum)) {
              _tmpActorMbox_sha1sum = null;
            } else {
              _tmpActorMbox_sha1sum = _cursor.getString(_cursorIndexOfActorMboxSha1sum);
            }
            final String _tmpActorOpenid;
            if (_cursor.isNull(_cursorIndexOfActorOpenid)) {
              _tmpActorOpenid = null;
            } else {
              _tmpActorOpenid = _cursor.getString(_cursorIndexOfActorOpenid);
            }
            final String _tmpActorAccountName;
            if (_cursor.isNull(_cursorIndexOfActorAccountName)) {
              _tmpActorAccountName = null;
            } else {
              _tmpActorAccountName = _cursor.getString(_cursorIndexOfActorAccountName);
            }
            final String _tmpActorAccountHomePage;
            if (_cursor.isNull(_cursorIndexOfActorAccountHomePage)) {
              _tmpActorAccountHomePage = null;
            } else {
              _tmpActorAccountHomePage = _cursor.getString(_cursorIndexOfActorAccountHomePage);
            }
            final long _tmpActorEtag;
            _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
            final long _tmpActorLct;
            _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
            final int _tmpActorObjectType;
            _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
            _item_1 = new ActorEntity(_tmpActorUid,_tmpActorPersonUid,_tmpActorName,_tmpActorMbox,_tmpActorMbox_sha1sum,_tmpActorOpenid,_tmpActorAccountName,_tmpActorAccountHomePage,_tmpActorEtag,_tmpActorLct,_tmpActorObjectType);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findStatusForStudentsInClazz(final long clazzUid,
      final List<Long> studentPersonUids, final long accountPersonUid,
      final Continuation<? super List<BlockStatus>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        WITH PersonUids(personUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE Person.personUid IN (");
    final int _inputSize = studentPersonUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT PersonUids.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM PersonUids)           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Add in group actor uids");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              UNION ");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        )");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ,");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT Person.personUid AS personUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    CourseBlock.cbUid AS cbUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    CourseBlock.cbType AS cbType,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ClazzAssignment.caMarkingType AS caMarkingType");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    JOIN CourseBlock");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON CourseBlock.cbClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    LEFT JOIN ClazzAssignment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON CourseBlock.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE Person.personUid IN (");
    final int _inputSize_1 = studentPersonUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize_1);
    _stringBuilder.append(")       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        )");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               PersonUidsAndCourseBlocks.cbUid AS sCbUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT MAX(StatementEntity.extensionProgress)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ) AS sProgress,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT EXISTS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("               )) AS sIsCompleted,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT CASE");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       /*If there is a statement marked as success, then count as successful even if");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        *there were subsequent failed attempts");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        */");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            SELECT EXISTS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   )                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ) THEN 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       /*If there are no statements marked as success, however there are statements marekd as fail,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        *then count as fail ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        */");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            SELECT EXISTS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   )                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ) THEN 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       /* Else there is no known success/fail result*/");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ELSE NULL");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       END");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ) AS sIsSuccess,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               -- See ClazzGradebookScreen for info on which score is selected");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT CASE");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       -- When there is a peer marked assignment, take the average of the latest distinct ...");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              AND PersonUidsAndCourseBlocks.caMarkingType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            ) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                         ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                     AND StatementEntity.timestamp = (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                         SELECT MAX(StatementEntity_Inner.timestamp)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                           FROM StatementEntity StatementEntity_Inner");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity ActorEntity_Inner");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity_Inner.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                          WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity_Inner.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   LIMIT 1)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       -- When an assignment, but not peer marked, then the latest score     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN PersonUidsAndCourseBlocks.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            THEN (SELECT StatementEntity.resultScoreScaled");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                         ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                ORDER BY StatementEntity.timestamp DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   LIMIT 1)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       -- else the best score accomplished so far            ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                               FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ))            ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       END");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ) AS sScoreScaled");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM PersonUidsAndCourseBlocks");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = ");
    _stringBuilder.append("?");
    _stringBuilder.append(" ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 3 + _inputSize + _inputSize_1;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : studentPersonUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 1 + _inputSize;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2 + _inputSize;
    for (long _item_1 : studentPersonUids) {
      _statement.bindLong(_argIndex, _item_1);
      _argIndex++;
    }
    _argIndex = 2 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<BlockStatus>>() {
      @Override
      @NonNull
      public List<BlockStatus> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSPersonUid = 0;
          final int _cursorIndexOfSCbUid = 1;
          final int _cursorIndexOfSProgress = 2;
          final int _cursorIndexOfSIsCompleted = 3;
          final int _cursorIndexOfSIsSuccess = 4;
          final int _cursorIndexOfSScoreScaled = 5;
          final List<BlockStatus> _result = new ArrayList<BlockStatus>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final BlockStatus _item_2;
            final long _tmpSPersonUid;
            _tmpSPersonUid = _cursor.getLong(_cursorIndexOfSPersonUid);
            final long _tmpSCbUid;
            _tmpSCbUid = _cursor.getLong(_cursorIndexOfSCbUid);
            final Integer _tmpSProgress;
            if (_cursor.isNull(_cursorIndexOfSProgress)) {
              _tmpSProgress = null;
            } else {
              _tmpSProgress = _cursor.getInt(_cursorIndexOfSProgress);
            }
            final boolean _tmpSIsCompleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSIsCompleted);
            _tmpSIsCompleted = _tmp != 0;
            final Boolean _tmpSIsSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfSIsSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfSIsSuccess);
            }
            _tmpSIsSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpSScoreScaled;
            if (_cursor.isNull(_cursorIndexOfSScoreScaled)) {
              _tmpSScoreScaled = null;
            } else {
              _tmpSScoreScaled = _cursor.getFloat(_cursorIndexOfSScoreScaled);
            }
            _item_2 = new BlockStatus(_tmpSPersonUid,_tmpSCbUid,_tmpSProgress,_tmpSIsCompleted,_tmpSIsSuccess,_tmpSScoreScaled);
            _result.add(_item_2);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<List<BlockStatus>> findStatusForStudentsInClazzAsFlow(final long clazzUid,
      final List<Long> studentPersonUids, final long accountPersonUid) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        WITH PersonUids(personUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT Person.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE Person.personUid IN (");
    final int _inputSize = studentPersonUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Get the ActorUids for the PersonUids See ActoryEntity doc for info on this join relationship");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AgentActorUidsForPersonUid(actorUid, actorPersonUid) AS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT ActorEntity.actorUid AS actorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ActorEntity.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE ActorEntity.actorPersonUid IN");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    (SELECT PersonUids.personUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       FROM PersonUids)           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ),");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        -- Add in group actor uids");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ActorUidsForPersonUid(actorUid, actorPersonUid) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT AgentActorUidsForPersonUid.actorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              UNION ");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT GroupMemberActorJoin.gmajGroupActorUid AS actorUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    AgentActorUidsForPersonUid.actorPersonUid AS actorPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM AgentActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    JOIN GroupMemberActorJoin ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON GroupMemberActorJoin.gmajMemberActorUid = AgentActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        )");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ,");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        PersonUidsAndCourseBlocks(personUid, cbUid, cbType, caMarkingType) AS (");
    _stringBuilder.append("\n");
    _stringBuilder.append("             SELECT Person.personUid AS personUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    CourseBlock.cbUid AS cbUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    CourseBlock.cbType AS cbType,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ClazzAssignment.caMarkingType AS caMarkingType");
    _stringBuilder.append("\n");
    _stringBuilder.append("               FROM Person");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    JOIN CourseBlock");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON CourseBlock.cbClazzUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    LEFT JOIN ClazzAssignment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         ON CourseBlock.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AND ClazzAssignment.caUid = CourseBlock.cbEntityUid     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("              WHERE Person.personUid IN (");
    final int _inputSize_1 = studentPersonUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize_1);
    _stringBuilder.append(")       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        )");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT PersonUidsAndCourseBlocks.personUid AS sPersonUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               PersonUidsAndCourseBlocks.cbUid AS sCbUid,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT MAX(StatementEntity.extensionProgress)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ) AS sProgress,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT EXISTS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("               )) AS sIsCompleted,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT CASE");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       /*If there is a statement marked as success, then count as successful even if");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        *there were subsequent failed attempts");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        */");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            SELECT EXISTS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   )                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ) THEN 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       /*If there are no statements marked as success, however there are statements marekd as fail,");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        *then count as fail ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        */");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            SELECT EXISTS(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    SELECT 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   )                           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ) THEN 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       /* Else there is no known success/fail result*/");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ELSE NULL");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       END");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ) AS sIsSuccess,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               -- See ClazzGradebookScreen for info on which score is selected");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT CASE");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       -- When there is a peer marked assignment, take the average of the latest distinct ...");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN (     PersonUidsAndCourseBlocks.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              AND PersonUidsAndCourseBlocks.caMarkingType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            ) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            THEN (SELECT AVG(StatementEntity.resultScoreScaled)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                         ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                     AND StatementEntity.timestamp = (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                         SELECT MAX(StatementEntity_Inner.timestamp)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                           FROM StatementEntity StatementEntity_Inner");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                                ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity ActorEntity_Inner");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity_Inner.actorUid = StatementEntity_Inner.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin GroupMemberActorJoin_Inner");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity_Inner.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin_Inner.gmajGroupActorUid, GroupMemberActorJoin_Inner.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                          WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity_Inner.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity_Inner.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                            AND StatementEntity_Inner.contextInstructorActorUid = StatementEntity.contextInstructorActorUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   LIMIT 1)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       -- When an assignment, but not peer marked, then the latest score     ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       WHEN PersonUidsAndCourseBlocks.cbType = 103");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            THEN (SELECT StatementEntity.resultScoreScaled");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                         ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    )");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                ORDER BY StatementEntity.timestamp DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                   LIMIT 1)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       -- else the best score accomplished so far            ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ELSE (SELECT MAX(StatementEntity.resultScoreScaled) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                               FROM StatementEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("       JOIN ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("       LEFT JOIN GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ON ActorEntity.actorObjectType = 2");
    _stringBuilder.append("\n");
    _stringBuilder.append("               AND (GroupMemberActorJoin.gmajGroupActorUid, GroupMemberActorJoin.gmajMemberActorUid) IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   SELECT GroupMemberActorJoin.gmajGroupActorUid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          GroupMemberActorJoin.gmajMemberActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                     FROM GroupMemberActorJoin");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    WHERE GroupMemberActorJoin.gmajGroupActorUid = StatementEntity.statementActorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                      AND GroupMemberActorJoin.gmajMemberActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                              WHERE (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            StatementEntity.statementCbUid = PersonUidsAndCourseBlocks.cbUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("        AND StatementEntity.statementActorUid IN (");
    _stringBuilder.append("\n");
    _stringBuilder.append("            SELECT ActorUidsForPersonUid.actorUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("              FROM ActorUidsForPersonUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("             WHERE ActorUidsForPersonUid.actorPersonUid = PersonUidsAndCourseBlocks.personUid)  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ))            ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       END");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ) AS sScoreScaled");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM PersonUidsAndCourseBlocks");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = ");
    _stringBuilder.append("?");
    _stringBuilder.append(" ");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 3 + _inputSize + _inputSize_1;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : studentPersonUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    _argIndex = 1 + _inputSize;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2 + _inputSize;
    for (long _item_1 : studentPersonUids) {
      _statement.bindLong(_argIndex, _item_1);
      _argIndex++;
    }
    _argIndex = 2 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3 + _inputSize + _inputSize;
    _statement.bindLong(_argIndex, accountPersonUid);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"Person", "ActorEntity",
        "GroupMemberActorJoin", "CourseBlock", "ClazzAssignment",
        "StatementEntity"}, new Callable<List<BlockStatus>>() {
      @Override
      @NonNull
      public List<BlockStatus> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSPersonUid = 0;
          final int _cursorIndexOfSCbUid = 1;
          final int _cursorIndexOfSProgress = 2;
          final int _cursorIndexOfSIsCompleted = 3;
          final int _cursorIndexOfSIsSuccess = 4;
          final int _cursorIndexOfSScoreScaled = 5;
          final List<BlockStatus> _result = new ArrayList<BlockStatus>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final BlockStatus _item_2;
            final long _tmpSPersonUid;
            _tmpSPersonUid = _cursor.getLong(_cursorIndexOfSPersonUid);
            final long _tmpSCbUid;
            _tmpSCbUid = _cursor.getLong(_cursorIndexOfSCbUid);
            final Integer _tmpSProgress;
            if (_cursor.isNull(_cursorIndexOfSProgress)) {
              _tmpSProgress = null;
            } else {
              _tmpSProgress = _cursor.getInt(_cursorIndexOfSProgress);
            }
            final boolean _tmpSIsCompleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSIsCompleted);
            _tmpSIsCompleted = _tmp != 0;
            final Boolean _tmpSIsSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfSIsSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfSIsSuccess);
            }
            _tmpSIsSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpSScoreScaled;
            if (_cursor.isNull(_cursorIndexOfSScoreScaled)) {
              _tmpSScoreScaled = null;
            } else {
              _tmpSScoreScaled = _cursor.getFloat(_cursorIndexOfSScoreScaled);
            }
            _item_2 = new BlockStatus(_tmpSPersonUid,_tmpSCbUid,_tmpSProgress,_tmpSIsCompleted,_tmpSIsSuccess,_tmpSScoreScaled);
            _result.add(_item_2);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findResumableRegistration(final long activityUid, final long accountPersonUid,
      final long actorUid, final Continuation<? super StatementEntity> $completion) {
    final String _sql = "\n"
            + "        WITH MostRecentRegistration(statementIdHi, statementIdLo, contextRegistrationHi, contextRegistrationLo) AS (\n"
            + "             SELECT StatementEntity.statementIdHi, StatementEntity.contextRegistrationLo,\n"
            + "                    StatementEntity.contextRegistrationHi, StatementEntity.contextRegistrationLo\n"
            + "               FROM StatementEntity\n"
            + "              WHERE StatementEntity.statementActorUid = ?\n"
            + "                AND StatementEntity.statementObjectUid1 = ?\n"
            + "                AND StatementEntity.contextRegistrationHi != 0\n"
            + "           ORDER BY StatementEntity.timestamp DESC\n"
            + "              LIMIT 1\n"
            + "        )\n"
            + "        \n"
            + "        SELECT StatementEntity.*\n"
            + "          FROM StatementEntity\n"
            + "         WHERE StatementEntity.statementIdHi = (SELECT statementIdHi FROM MostRecentRegistration)\n"
            + "           AND StatementEntity.statementIdLo = (SELECT statementIdLo FROM MostRecentRegistration)\n"
            + "           AND NOT EXISTS(\n"
            + "                   SELECT 1\n"
            + "                     FROM StatementEntity StatementEntity_Inner\n"
            + "                    WHERE StatementEntity_Inner.statementActorUid = ?\n"
            + "                      AND StatementEntity_Inner.statementObjectUid1 = ?\n"
            + "                      AND StatementEntity_Inner.contextRegistrationHi = (SELECT contextRegistrationHi FROM MostRecentRegistration)\n"
            + "                      AND StatementEntity_Inner.contextRegistrationLo = (SELECT contextRegistrationLo FROM MostRecentRegistration)\n"
            + "                      AND CAST(StatementEntity_Inner.completionOrProgress AS INTEGER) = 1\n"
            + "                      AND (     StatementEntity_Inner.resultCompletion IS NOT NULL \n"
            + "                            AND CAST(StatementEntity_Inner.resultCompletion AS INTEGER) = 1)\n"
            + "                     )\n"
            + "           AND ? IN \n"
            + "               (SELECT ActorEntity.actorPersonUid\n"
            + "                  FROM ActorEntity\n"
            + "                 WHERE ActorEntity.actorUid = ?)          \n"
            + "                     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, activityUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, activityUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, actorUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<StatementEntity>() {
      @Override
      @Nullable
      public StatementEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdHi");
          final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "statementIdLo");
          final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorPersonUid");
          final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementVerbUid");
          final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectType");
          final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid1");
          final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndexOrThrow(_cursor, "statementObjectUid2");
          final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementActorUid");
          final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "authorityActorUid");
          final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndexOrThrow(_cursor, "teamUid");
          final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndexOrThrow(_cursor, "resultCompletion");
          final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndexOrThrow(_cursor, "resultSuccess");
          final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreScaled");
          final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreRaw");
          final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMin");
          final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndexOrThrow(_cursor, "resultScoreMax");
          final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndexOrThrow(_cursor, "resultDuration");
          final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndexOrThrow(_cursor, "resultResponse");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfStored = CursorUtil.getColumnIndexOrThrow(_cursor, "stored");
          final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationHi");
          final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextRegistrationLo");
          final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndexOrThrow(_cursor, "contextPlatform");
          final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdHi");
          final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndexOrThrow(_cursor, "contextStatementRefIdLo");
          final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contextInstructorActorUid");
          final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLct");
          final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "extensionProgress");
          final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "completionOrProgress");
          final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementContentEntryUid");
          final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLearnerGroupUid");
          final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementClazzUid");
          final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementCbUid");
          final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndexOrThrow(_cursor, "statementDoorNode");
          final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndexOrThrow(_cursor, "isSubStatement");
          final StatementEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpStatementIdHi;
            _tmpStatementIdHi = _cursor.getLong(_cursorIndexOfStatementIdHi);
            final long _tmpStatementIdLo;
            _tmpStatementIdLo = _cursor.getLong(_cursorIndexOfStatementIdLo);
            final long _tmpStatementActorPersonUid;
            _tmpStatementActorPersonUid = _cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            final long _tmpStatementVerbUid;
            _tmpStatementVerbUid = _cursor.getLong(_cursorIndexOfStatementVerbUid);
            final int _tmpStatementObjectType;
            _tmpStatementObjectType = _cursor.getInt(_cursorIndexOfStatementObjectType);
            final long _tmpStatementObjectUid1;
            _tmpStatementObjectUid1 = _cursor.getLong(_cursorIndexOfStatementObjectUid1);
            final long _tmpStatementObjectUid2;
            _tmpStatementObjectUid2 = _cursor.getLong(_cursorIndexOfStatementObjectUid2);
            final long _tmpStatementActorUid;
            _tmpStatementActorUid = _cursor.getLong(_cursorIndexOfStatementActorUid);
            final long _tmpAuthorityActorUid;
            _tmpAuthorityActorUid = _cursor.getLong(_cursorIndexOfAuthorityActorUid);
            final long _tmpTeamUid;
            _tmpTeamUid = _cursor.getLong(_cursorIndexOfTeamUid);
            final Boolean _tmpResultCompletion;
            final Integer _tmp;
            if (_cursor.isNull(_cursorIndexOfResultCompletion)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getInt(_cursorIndexOfResultCompletion);
            }
            _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            final Boolean _tmpResultSuccess;
            final Integer _tmp_1;
            if (_cursor.isNull(_cursorIndexOfResultSuccess)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getInt(_cursorIndexOfResultSuccess);
            }
            _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            final Float _tmpResultScoreScaled;
            if (_cursor.isNull(_cursorIndexOfResultScoreScaled)) {
              _tmpResultScoreScaled = null;
            } else {
              _tmpResultScoreScaled = _cursor.getFloat(_cursorIndexOfResultScoreScaled);
            }
            final Float _tmpResultScoreRaw;
            if (_cursor.isNull(_cursorIndexOfResultScoreRaw)) {
              _tmpResultScoreRaw = null;
            } else {
              _tmpResultScoreRaw = _cursor.getFloat(_cursorIndexOfResultScoreRaw);
            }
            final Float _tmpResultScoreMin;
            if (_cursor.isNull(_cursorIndexOfResultScoreMin)) {
              _tmpResultScoreMin = null;
            } else {
              _tmpResultScoreMin = _cursor.getFloat(_cursorIndexOfResultScoreMin);
            }
            final Float _tmpResultScoreMax;
            if (_cursor.isNull(_cursorIndexOfResultScoreMax)) {
              _tmpResultScoreMax = null;
            } else {
              _tmpResultScoreMax = _cursor.getFloat(_cursorIndexOfResultScoreMax);
            }
            final Long _tmpResultDuration;
            if (_cursor.isNull(_cursorIndexOfResultDuration)) {
              _tmpResultDuration = null;
            } else {
              _tmpResultDuration = _cursor.getLong(_cursorIndexOfResultDuration);
            }
            final String _tmpResultResponse;
            if (_cursor.isNull(_cursorIndexOfResultResponse)) {
              _tmpResultResponse = null;
            } else {
              _tmpResultResponse = _cursor.getString(_cursorIndexOfResultResponse);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final long _tmpStored;
            _tmpStored = _cursor.getLong(_cursorIndexOfStored);
            final long _tmpContextRegistrationHi;
            _tmpContextRegistrationHi = _cursor.getLong(_cursorIndexOfContextRegistrationHi);
            final long _tmpContextRegistrationLo;
            _tmpContextRegistrationLo = _cursor.getLong(_cursorIndexOfContextRegistrationLo);
            final String _tmpContextPlatform;
            if (_cursor.isNull(_cursorIndexOfContextPlatform)) {
              _tmpContextPlatform = null;
            } else {
              _tmpContextPlatform = _cursor.getString(_cursorIndexOfContextPlatform);
            }
            final long _tmpContextStatementRefIdHi;
            _tmpContextStatementRefIdHi = _cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            final long _tmpContextStatementRefIdLo;
            _tmpContextStatementRefIdLo = _cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            final long _tmpContextInstructorActorUid;
            _tmpContextInstructorActorUid = _cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            final long _tmpStatementLct;
            _tmpStatementLct = _cursor.getLong(_cursorIndexOfStatementLct);
            final Integer _tmpExtensionProgress;
            if (_cursor.isNull(_cursorIndexOfExtensionProgress)) {
              _tmpExtensionProgress = null;
            } else {
              _tmpExtensionProgress = _cursor.getInt(_cursorIndexOfExtensionProgress);
            }
            final boolean _tmpCompletionOrProgress;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCompletionOrProgress);
            _tmpCompletionOrProgress = _tmp_2 != 0;
            final long _tmpStatementContentEntryUid;
            _tmpStatementContentEntryUid = _cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            final long _tmpStatementLearnerGroupUid;
            _tmpStatementLearnerGroupUid = _cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            final long _tmpStatementClazzUid;
            _tmpStatementClazzUid = _cursor.getLong(_cursorIndexOfStatementClazzUid);
            final long _tmpStatementCbUid;
            _tmpStatementCbUid = _cursor.getLong(_cursorIndexOfStatementCbUid);
            final long _tmpStatementDoorNode;
            _tmpStatementDoorNode = _cursor.getLong(_cursorIndexOfStatementDoorNode);
            final boolean _tmpIsSubStatement;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsSubStatement);
            _tmpIsSubStatement = _tmp_3 != 0;
            _result = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getResults(final SupportSQLiteQuery query,
      final Continuation<? super List<StatementReportData>> $completion) {
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<StatementReportData>>() {
      @Override
      @NonNull
      public List<StatementReportData> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, query, false, null);
        try {
          final int _cursorIndexOfYAxis = CursorUtil.getColumnIndex(_cursor, "yAxis");
          final int _cursorIndexOfXAxis = CursorUtil.getColumnIndex(_cursor, "xAxis");
          final int _cursorIndexOfSubgroup = CursorUtil.getColumnIndex(_cursor, "subgroup");
          final List<StatementReportData> _result = new ArrayList<StatementReportData>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final StatementReportData _item;
            final float _tmpYAxis;
            if (_cursorIndexOfYAxis == -1) {
              _tmpYAxis = 0f;
            } else {
              _tmpYAxis = _cursor.getFloat(_cursorIndexOfYAxis);
            }
            final String _tmpXAxis;
            if (_cursorIndexOfXAxis == -1) {
              _tmpXAxis = null;
            } else {
              if (_cursor.isNull(_cursorIndexOfXAxis)) {
                _tmpXAxis = null;
              } else {
                _tmpXAxis = _cursor.getString(_cursorIndexOfXAxis);
              }
            }
            final String _tmpSubgroup;
            if (_cursorIndexOfSubgroup == -1) {
              _tmpSubgroup = null;
            } else {
              if (_cursor.isNull(_cursorIndexOfSubgroup)) {
                _tmpSubgroup = null;
              } else {
                _tmpSubgroup = _cursor.getString(_cursorIndexOfSubgroup);
              }
            }
            _item = new StatementReportData(_tmpYAxis,_tmpXAxis,_tmpSubgroup);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, StatementEntityAndDisplayDetails> getListResults(
      final SupportSQLiteQuery query) {
    return new LimitOffsetPagingSource<StatementEntityAndDisplayDetails>(query, __db, "StatementEntity", "Person") {
      @Override
      @NonNull
      protected List<StatementEntityAndDisplayDetails> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfStatementIdHi = CursorUtil.getColumnIndex(cursor, "statementIdHi");
        final int _cursorIndexOfStatementIdLo = CursorUtil.getColumnIndex(cursor, "statementIdLo");
        final int _cursorIndexOfStatementActorPersonUid = CursorUtil.getColumnIndex(cursor, "statementActorPersonUid");
        final int _cursorIndexOfStatementVerbUid = CursorUtil.getColumnIndex(cursor, "statementVerbUid");
        final int _cursorIndexOfStatementObjectType = CursorUtil.getColumnIndex(cursor, "statementObjectType");
        final int _cursorIndexOfStatementObjectUid1 = CursorUtil.getColumnIndex(cursor, "statementObjectUid1");
        final int _cursorIndexOfStatementObjectUid2 = CursorUtil.getColumnIndex(cursor, "statementObjectUid2");
        final int _cursorIndexOfStatementActorUid = CursorUtil.getColumnIndex(cursor, "statementActorUid");
        final int _cursorIndexOfAuthorityActorUid = CursorUtil.getColumnIndex(cursor, "authorityActorUid");
        final int _cursorIndexOfTeamUid = CursorUtil.getColumnIndex(cursor, "teamUid");
        final int _cursorIndexOfResultCompletion = CursorUtil.getColumnIndex(cursor, "resultCompletion");
        final int _cursorIndexOfResultSuccess = CursorUtil.getColumnIndex(cursor, "resultSuccess");
        final int _cursorIndexOfResultScoreScaled = CursorUtil.getColumnIndex(cursor, "resultScoreScaled");
        final int _cursorIndexOfResultScoreRaw = CursorUtil.getColumnIndex(cursor, "resultScoreRaw");
        final int _cursorIndexOfResultScoreMin = CursorUtil.getColumnIndex(cursor, "resultScoreMin");
        final int _cursorIndexOfResultScoreMax = CursorUtil.getColumnIndex(cursor, "resultScoreMax");
        final int _cursorIndexOfResultDuration = CursorUtil.getColumnIndex(cursor, "resultDuration");
        final int _cursorIndexOfResultResponse = CursorUtil.getColumnIndex(cursor, "resultResponse");
        final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndex(cursor, "timestamp");
        final int _cursorIndexOfStored = CursorUtil.getColumnIndex(cursor, "stored");
        final int _cursorIndexOfContextRegistrationHi = CursorUtil.getColumnIndex(cursor, "contextRegistrationHi");
        final int _cursorIndexOfContextRegistrationLo = CursorUtil.getColumnIndex(cursor, "contextRegistrationLo");
        final int _cursorIndexOfContextPlatform = CursorUtil.getColumnIndex(cursor, "contextPlatform");
        final int _cursorIndexOfContextStatementRefIdHi = CursorUtil.getColumnIndex(cursor, "contextStatementRefIdHi");
        final int _cursorIndexOfContextStatementRefIdLo = CursorUtil.getColumnIndex(cursor, "contextStatementRefIdLo");
        final int _cursorIndexOfContextInstructorActorUid = CursorUtil.getColumnIndex(cursor, "contextInstructorActorUid");
        final int _cursorIndexOfStatementLct = CursorUtil.getColumnIndex(cursor, "statementLct");
        final int _cursorIndexOfExtensionProgress = CursorUtil.getColumnIndex(cursor, "extensionProgress");
        final int _cursorIndexOfCompletionOrProgress = CursorUtil.getColumnIndex(cursor, "completionOrProgress");
        final int _cursorIndexOfStatementContentEntryUid = CursorUtil.getColumnIndex(cursor, "statementContentEntryUid");
        final int _cursorIndexOfStatementLearnerGroupUid = CursorUtil.getColumnIndex(cursor, "statementLearnerGroupUid");
        final int _cursorIndexOfStatementClazzUid = CursorUtil.getColumnIndex(cursor, "statementClazzUid");
        final int _cursorIndexOfStatementCbUid = CursorUtil.getColumnIndex(cursor, "statementCbUid");
        final int _cursorIndexOfStatementDoorNode = CursorUtil.getColumnIndex(cursor, "statementDoorNode");
        final int _cursorIndexOfIsSubStatement = CursorUtil.getColumnIndex(cursor, "isSubStatement");
        final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndex(cursor, "personUid");
        final int _cursorIndexOfUsername = CursorUtil.getColumnIndex(cursor, "username");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndex(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndex(cursor, "lastName");
        final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndex(cursor, "emailAddr");
        final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndex(cursor, "phoneNum");
        final int _cursorIndexOfGender = CursorUtil.getColumnIndex(cursor, "gender");
        final int _cursorIndexOfActive = CursorUtil.getColumnIndex(cursor, "active");
        final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndex(cursor, "dateOfBirth");
        final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndex(cursor, "personAddress");
        final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndex(cursor, "personOrgId");
        final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndex(cursor, "personGroupUid");
        final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndex(cursor, "personLct");
        final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndex(cursor, "personCountry");
        final int _cursorIndexOfPersonType = CursorUtil.getColumnIndex(cursor, "personType");
        final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndex(cursor, "personMasterChangeSeqNum");
        final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndex(cursor, "personLocalChangeSeqNum");
        final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndex(cursor, "personLastChangedBy");
        final int _cursorIndexOfAdmin = CursorUtil.getColumnIndex(cursor, "admin");
        final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndex(cursor, "personNotes");
        final int _cursorIndexOfFatherName = CursorUtil.getColumnIndex(cursor, "fatherName");
        final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndex(cursor, "fatherNumber");
        final int _cursorIndexOfMotherName = CursorUtil.getColumnIndex(cursor, "motherName");
        final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndex(cursor, "motherNum");
        final List<StatementEntityAndDisplayDetails> _result = new ArrayList<StatementEntityAndDisplayDetails>(cursor.getCount());
        while (cursor.moveToNext()) {
          final StatementEntityAndDisplayDetails _item;
          final StatementEntity _tmpStatement;
          if (!((_cursorIndexOfStatementIdHi == -1 || cursor.isNull(_cursorIndexOfStatementIdHi)) && (_cursorIndexOfStatementIdLo == -1 || cursor.isNull(_cursorIndexOfStatementIdLo)) && (_cursorIndexOfStatementActorPersonUid == -1 || cursor.isNull(_cursorIndexOfStatementActorPersonUid)) && (_cursorIndexOfStatementVerbUid == -1 || cursor.isNull(_cursorIndexOfStatementVerbUid)) && (_cursorIndexOfStatementObjectType == -1 || cursor.isNull(_cursorIndexOfStatementObjectType)) && (_cursorIndexOfStatementObjectUid1 == -1 || cursor.isNull(_cursorIndexOfStatementObjectUid1)) && (_cursorIndexOfStatementObjectUid2 == -1 || cursor.isNull(_cursorIndexOfStatementObjectUid2)) && (_cursorIndexOfStatementActorUid == -1 || cursor.isNull(_cursorIndexOfStatementActorUid)) && (_cursorIndexOfAuthorityActorUid == -1 || cursor.isNull(_cursorIndexOfAuthorityActorUid)) && (_cursorIndexOfTeamUid == -1 || cursor.isNull(_cursorIndexOfTeamUid)) && (_cursorIndexOfResultCompletion == -1 || cursor.isNull(_cursorIndexOfResultCompletion)) && (_cursorIndexOfResultSuccess == -1 || cursor.isNull(_cursorIndexOfResultSuccess)) && (_cursorIndexOfResultScoreScaled == -1 || cursor.isNull(_cursorIndexOfResultScoreScaled)) && (_cursorIndexOfResultScoreRaw == -1 || cursor.isNull(_cursorIndexOfResultScoreRaw)) && (_cursorIndexOfResultScoreMin == -1 || cursor.isNull(_cursorIndexOfResultScoreMin)) && (_cursorIndexOfResultScoreMax == -1 || cursor.isNull(_cursorIndexOfResultScoreMax)) && (_cursorIndexOfResultDuration == -1 || cursor.isNull(_cursorIndexOfResultDuration)) && (_cursorIndexOfResultResponse == -1 || cursor.isNull(_cursorIndexOfResultResponse)) && (_cursorIndexOfTimestamp == -1 || cursor.isNull(_cursorIndexOfTimestamp)) && (_cursorIndexOfStored == -1 || cursor.isNull(_cursorIndexOfStored)) && (_cursorIndexOfContextRegistrationHi == -1 || cursor.isNull(_cursorIndexOfContextRegistrationHi)) && (_cursorIndexOfContextRegistrationLo == -1 || cursor.isNull(_cursorIndexOfContextRegistrationLo)) && (_cursorIndexOfContextPlatform == -1 || cursor.isNull(_cursorIndexOfContextPlatform)) && (_cursorIndexOfContextStatementRefIdHi == -1 || cursor.isNull(_cursorIndexOfContextStatementRefIdHi)) && (_cursorIndexOfContextStatementRefIdLo == -1 || cursor.isNull(_cursorIndexOfContextStatementRefIdLo)) && (_cursorIndexOfContextInstructorActorUid == -1 || cursor.isNull(_cursorIndexOfContextInstructorActorUid)) && (_cursorIndexOfStatementLct == -1 || cursor.isNull(_cursorIndexOfStatementLct)) && (_cursorIndexOfExtensionProgress == -1 || cursor.isNull(_cursorIndexOfExtensionProgress)) && (_cursorIndexOfCompletionOrProgress == -1 || cursor.isNull(_cursorIndexOfCompletionOrProgress)) && (_cursorIndexOfStatementContentEntryUid == -1 || cursor.isNull(_cursorIndexOfStatementContentEntryUid)) && (_cursorIndexOfStatementLearnerGroupUid == -1 || cursor.isNull(_cursorIndexOfStatementLearnerGroupUid)) && (_cursorIndexOfStatementClazzUid == -1 || cursor.isNull(_cursorIndexOfStatementClazzUid)) && (_cursorIndexOfStatementCbUid == -1 || cursor.isNull(_cursorIndexOfStatementCbUid)) && (_cursorIndexOfStatementDoorNode == -1 || cursor.isNull(_cursorIndexOfStatementDoorNode)) && (_cursorIndexOfIsSubStatement == -1 || cursor.isNull(_cursorIndexOfIsSubStatement)))) {
            final long _tmpStatementIdHi;
            if (_cursorIndexOfStatementIdHi == -1) {
              _tmpStatementIdHi = 0;
            } else {
              _tmpStatementIdHi = cursor.getLong(_cursorIndexOfStatementIdHi);
            }
            final long _tmpStatementIdLo;
            if (_cursorIndexOfStatementIdLo == -1) {
              _tmpStatementIdLo = 0;
            } else {
              _tmpStatementIdLo = cursor.getLong(_cursorIndexOfStatementIdLo);
            }
            final long _tmpStatementActorPersonUid;
            if (_cursorIndexOfStatementActorPersonUid == -1) {
              _tmpStatementActorPersonUid = 0;
            } else {
              _tmpStatementActorPersonUid = cursor.getLong(_cursorIndexOfStatementActorPersonUid);
            }
            final long _tmpStatementVerbUid;
            if (_cursorIndexOfStatementVerbUid == -1) {
              _tmpStatementVerbUid = 0;
            } else {
              _tmpStatementVerbUid = cursor.getLong(_cursorIndexOfStatementVerbUid);
            }
            final int _tmpStatementObjectType;
            if (_cursorIndexOfStatementObjectType == -1) {
              _tmpStatementObjectType = 0;
            } else {
              _tmpStatementObjectType = cursor.getInt(_cursorIndexOfStatementObjectType);
            }
            final long _tmpStatementObjectUid1;
            if (_cursorIndexOfStatementObjectUid1 == -1) {
              _tmpStatementObjectUid1 = 0;
            } else {
              _tmpStatementObjectUid1 = cursor.getLong(_cursorIndexOfStatementObjectUid1);
            }
            final long _tmpStatementObjectUid2;
            if (_cursorIndexOfStatementObjectUid2 == -1) {
              _tmpStatementObjectUid2 = 0;
            } else {
              _tmpStatementObjectUid2 = cursor.getLong(_cursorIndexOfStatementObjectUid2);
            }
            final long _tmpStatementActorUid;
            if (_cursorIndexOfStatementActorUid == -1) {
              _tmpStatementActorUid = 0;
            } else {
              _tmpStatementActorUid = cursor.getLong(_cursorIndexOfStatementActorUid);
            }
            final long _tmpAuthorityActorUid;
            if (_cursorIndexOfAuthorityActorUid == -1) {
              _tmpAuthorityActorUid = 0;
            } else {
              _tmpAuthorityActorUid = cursor.getLong(_cursorIndexOfAuthorityActorUid);
            }
            final long _tmpTeamUid;
            if (_cursorIndexOfTeamUid == -1) {
              _tmpTeamUid = 0;
            } else {
              _tmpTeamUid = cursor.getLong(_cursorIndexOfTeamUid);
            }
            final Boolean _tmpResultCompletion;
            if (_cursorIndexOfResultCompletion == -1) {
              _tmpResultCompletion = null;
            } else {
              final Integer _tmp;
              if (cursor.isNull(_cursorIndexOfResultCompletion)) {
                _tmp = null;
              } else {
                _tmp = cursor.getInt(_cursorIndexOfResultCompletion);
              }
              _tmpResultCompletion = _tmp == null ? null : _tmp != 0;
            }
            final Boolean _tmpResultSuccess;
            if (_cursorIndexOfResultSuccess == -1) {
              _tmpResultSuccess = null;
            } else {
              final Integer _tmp_1;
              if (cursor.isNull(_cursorIndexOfResultSuccess)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = cursor.getInt(_cursorIndexOfResultSuccess);
              }
              _tmpResultSuccess = _tmp_1 == null ? null : _tmp_1 != 0;
            }
            final Float _tmpResultScoreScaled;
            if (_cursorIndexOfResultScoreScaled == -1) {
              _tmpResultScoreScaled = null;
            } else {
              if (cursor.isNull(_cursorIndexOfResultScoreScaled)) {
                _tmpResultScoreScaled = null;
              } else {
                _tmpResultScoreScaled = cursor.getFloat(_cursorIndexOfResultScoreScaled);
              }
            }
            final Float _tmpResultScoreRaw;
            if (_cursorIndexOfResultScoreRaw == -1) {
              _tmpResultScoreRaw = null;
            } else {
              if (cursor.isNull(_cursorIndexOfResultScoreRaw)) {
                _tmpResultScoreRaw = null;
              } else {
                _tmpResultScoreRaw = cursor.getFloat(_cursorIndexOfResultScoreRaw);
              }
            }
            final Float _tmpResultScoreMin;
            if (_cursorIndexOfResultScoreMin == -1) {
              _tmpResultScoreMin = null;
            } else {
              if (cursor.isNull(_cursorIndexOfResultScoreMin)) {
                _tmpResultScoreMin = null;
              } else {
                _tmpResultScoreMin = cursor.getFloat(_cursorIndexOfResultScoreMin);
              }
            }
            final Float _tmpResultScoreMax;
            if (_cursorIndexOfResultScoreMax == -1) {
              _tmpResultScoreMax = null;
            } else {
              if (cursor.isNull(_cursorIndexOfResultScoreMax)) {
                _tmpResultScoreMax = null;
              } else {
                _tmpResultScoreMax = cursor.getFloat(_cursorIndexOfResultScoreMax);
              }
            }
            final Long _tmpResultDuration;
            if (_cursorIndexOfResultDuration == -1) {
              _tmpResultDuration = null;
            } else {
              if (cursor.isNull(_cursorIndexOfResultDuration)) {
                _tmpResultDuration = null;
              } else {
                _tmpResultDuration = cursor.getLong(_cursorIndexOfResultDuration);
              }
            }
            final String _tmpResultResponse;
            if (_cursorIndexOfResultResponse == -1) {
              _tmpResultResponse = null;
            } else {
              if (cursor.isNull(_cursorIndexOfResultResponse)) {
                _tmpResultResponse = null;
              } else {
                _tmpResultResponse = cursor.getString(_cursorIndexOfResultResponse);
              }
            }
            final long _tmpTimestamp;
            if (_cursorIndexOfTimestamp == -1) {
              _tmpTimestamp = 0;
            } else {
              _tmpTimestamp = cursor.getLong(_cursorIndexOfTimestamp);
            }
            final long _tmpStored;
            if (_cursorIndexOfStored == -1) {
              _tmpStored = 0;
            } else {
              _tmpStored = cursor.getLong(_cursorIndexOfStored);
            }
            final long _tmpContextRegistrationHi;
            if (_cursorIndexOfContextRegistrationHi == -1) {
              _tmpContextRegistrationHi = 0;
            } else {
              _tmpContextRegistrationHi = cursor.getLong(_cursorIndexOfContextRegistrationHi);
            }
            final long _tmpContextRegistrationLo;
            if (_cursorIndexOfContextRegistrationLo == -1) {
              _tmpContextRegistrationLo = 0;
            } else {
              _tmpContextRegistrationLo = cursor.getLong(_cursorIndexOfContextRegistrationLo);
            }
            final String _tmpContextPlatform;
            if (_cursorIndexOfContextPlatform == -1) {
              _tmpContextPlatform = null;
            } else {
              if (cursor.isNull(_cursorIndexOfContextPlatform)) {
                _tmpContextPlatform = null;
              } else {
                _tmpContextPlatform = cursor.getString(_cursorIndexOfContextPlatform);
              }
            }
            final long _tmpContextStatementRefIdHi;
            if (_cursorIndexOfContextStatementRefIdHi == -1) {
              _tmpContextStatementRefIdHi = 0;
            } else {
              _tmpContextStatementRefIdHi = cursor.getLong(_cursorIndexOfContextStatementRefIdHi);
            }
            final long _tmpContextStatementRefIdLo;
            if (_cursorIndexOfContextStatementRefIdLo == -1) {
              _tmpContextStatementRefIdLo = 0;
            } else {
              _tmpContextStatementRefIdLo = cursor.getLong(_cursorIndexOfContextStatementRefIdLo);
            }
            final long _tmpContextInstructorActorUid;
            if (_cursorIndexOfContextInstructorActorUid == -1) {
              _tmpContextInstructorActorUid = 0;
            } else {
              _tmpContextInstructorActorUid = cursor.getLong(_cursorIndexOfContextInstructorActorUid);
            }
            final long _tmpStatementLct;
            if (_cursorIndexOfStatementLct == -1) {
              _tmpStatementLct = 0;
            } else {
              _tmpStatementLct = cursor.getLong(_cursorIndexOfStatementLct);
            }
            final Integer _tmpExtensionProgress;
            if (_cursorIndexOfExtensionProgress == -1) {
              _tmpExtensionProgress = null;
            } else {
              if (cursor.isNull(_cursorIndexOfExtensionProgress)) {
                _tmpExtensionProgress = null;
              } else {
                _tmpExtensionProgress = cursor.getInt(_cursorIndexOfExtensionProgress);
              }
            }
            final boolean _tmpCompletionOrProgress;
            if (_cursorIndexOfCompletionOrProgress == -1) {
              _tmpCompletionOrProgress = false;
            } else {
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfCompletionOrProgress);
              _tmpCompletionOrProgress = _tmp_2 != 0;
            }
            final long _tmpStatementContentEntryUid;
            if (_cursorIndexOfStatementContentEntryUid == -1) {
              _tmpStatementContentEntryUid = 0;
            } else {
              _tmpStatementContentEntryUid = cursor.getLong(_cursorIndexOfStatementContentEntryUid);
            }
            final long _tmpStatementLearnerGroupUid;
            if (_cursorIndexOfStatementLearnerGroupUid == -1) {
              _tmpStatementLearnerGroupUid = 0;
            } else {
              _tmpStatementLearnerGroupUid = cursor.getLong(_cursorIndexOfStatementLearnerGroupUid);
            }
            final long _tmpStatementClazzUid;
            if (_cursorIndexOfStatementClazzUid == -1) {
              _tmpStatementClazzUid = 0;
            } else {
              _tmpStatementClazzUid = cursor.getLong(_cursorIndexOfStatementClazzUid);
            }
            final long _tmpStatementCbUid;
            if (_cursorIndexOfStatementCbUid == -1) {
              _tmpStatementCbUid = 0;
            } else {
              _tmpStatementCbUid = cursor.getLong(_cursorIndexOfStatementCbUid);
            }
            final long _tmpStatementDoorNode;
            if (_cursorIndexOfStatementDoorNode == -1) {
              _tmpStatementDoorNode = 0;
            } else {
              _tmpStatementDoorNode = cursor.getLong(_cursorIndexOfStatementDoorNode);
            }
            final boolean _tmpIsSubStatement;
            if (_cursorIndexOfIsSubStatement == -1) {
              _tmpIsSubStatement = false;
            } else {
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfIsSubStatement);
              _tmpIsSubStatement = _tmp_3 != 0;
            }
            _tmpStatement = new StatementEntity(_tmpStatementIdHi,_tmpStatementIdLo,_tmpStatementActorPersonUid,_tmpStatementVerbUid,_tmpStatementObjectType,_tmpStatementObjectUid1,_tmpStatementObjectUid2,_tmpStatementActorUid,_tmpAuthorityActorUid,_tmpTeamUid,_tmpResultCompletion,_tmpResultSuccess,_tmpResultScoreScaled,_tmpResultScoreRaw,_tmpResultScoreMin,_tmpResultScoreMax,_tmpResultDuration,_tmpResultResponse,_tmpTimestamp,_tmpStored,_tmpContextRegistrationHi,_tmpContextRegistrationLo,_tmpContextPlatform,_tmpContextStatementRefIdHi,_tmpContextStatementRefIdLo,_tmpContextInstructorActorUid,_tmpStatementLct,_tmpExtensionProgress,_tmpCompletionOrProgress,_tmpStatementContentEntryUid,_tmpStatementLearnerGroupUid,_tmpStatementClazzUid,_tmpStatementCbUid,_tmpStatementDoorNode,_tmpIsSubStatement);
          } else {
            _tmpStatement = null;
          }
          final Person _tmpPerson;
          if (!((_cursorIndexOfPersonUid == -1 || cursor.isNull(_cursorIndexOfPersonUid)) && (_cursorIndexOfUsername == -1 || cursor.isNull(_cursorIndexOfUsername)) && (_cursorIndexOfFirstNames == -1 || cursor.isNull(_cursorIndexOfFirstNames)) && (_cursorIndexOfLastName == -1 || cursor.isNull(_cursorIndexOfLastName)) && (_cursorIndexOfEmailAddr == -1 || cursor.isNull(_cursorIndexOfEmailAddr)) && (_cursorIndexOfPhoneNum == -1 || cursor.isNull(_cursorIndexOfPhoneNum)) && (_cursorIndexOfGender == -1 || cursor.isNull(_cursorIndexOfGender)) && (_cursorIndexOfActive == -1 || cursor.isNull(_cursorIndexOfActive)) && (_cursorIndexOfDateOfBirth == -1 || cursor.isNull(_cursorIndexOfDateOfBirth)) && (_cursorIndexOfPersonAddress == -1 || cursor.isNull(_cursorIndexOfPersonAddress)) && (_cursorIndexOfPersonOrgId == -1 || cursor.isNull(_cursorIndexOfPersonOrgId)) && (_cursorIndexOfPersonGroupUid == -1 || cursor.isNull(_cursorIndexOfPersonGroupUid)) && (_cursorIndexOfPersonLct == -1 || cursor.isNull(_cursorIndexOfPersonLct)) && (_cursorIndexOfPersonCountry == -1 || cursor.isNull(_cursorIndexOfPersonCountry)) && (_cursorIndexOfPersonType == -1 || cursor.isNull(_cursorIndexOfPersonType)) && (_cursorIndexOfPersonMasterChangeSeqNum == -1 || cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum)) && (_cursorIndexOfPersonLocalChangeSeqNum == -1 || cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum)) && (_cursorIndexOfPersonLastChangedBy == -1 || cursor.isNull(_cursorIndexOfPersonLastChangedBy)) && (_cursorIndexOfAdmin == -1 || cursor.isNull(_cursorIndexOfAdmin)) && (_cursorIndexOfPersonNotes == -1 || cursor.isNull(_cursorIndexOfPersonNotes)) && (_cursorIndexOfFatherName == -1 || cursor.isNull(_cursorIndexOfFatherName)) && (_cursorIndexOfFatherNumber == -1 || cursor.isNull(_cursorIndexOfFatherNumber)) && (_cursorIndexOfMotherName == -1 || cursor.isNull(_cursorIndexOfMotherName)) && (_cursorIndexOfMotherNum == -1 || cursor.isNull(_cursorIndexOfMotherNum)))) {
            final long _tmpPersonUid;
            if (_cursorIndexOfPersonUid == -1) {
              _tmpPersonUid = 0;
            } else {
              _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
            }
            final String _tmpUsername;
            if (_cursorIndexOfUsername == -1) {
              _tmpUsername = null;
            } else {
              if (cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = cursor.getString(_cursorIndexOfUsername);
              }
            }
            final String _tmpFirstNames;
            if (_cursorIndexOfFirstNames == -1) {
              _tmpFirstNames = null;
            } else {
              if (cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
              }
            }
            final String _tmpLastName;
            if (_cursorIndexOfLastName == -1) {
              _tmpLastName = null;
            } else {
              if (cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = cursor.getString(_cursorIndexOfLastName);
              }
            }
            final String _tmpEmailAddr;
            if (_cursorIndexOfEmailAddr == -1) {
              _tmpEmailAddr = null;
            } else {
              if (cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = cursor.getString(_cursorIndexOfEmailAddr);
              }
            }
            final String _tmpPhoneNum;
            if (_cursorIndexOfPhoneNum == -1) {
              _tmpPhoneNum = null;
            } else {
              if (cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = cursor.getString(_cursorIndexOfPhoneNum);
              }
            }
            final int _tmpGender;
            if (_cursorIndexOfGender == -1) {
              _tmpGender = 0;
            } else {
              _tmpGender = cursor.getInt(_cursorIndexOfGender);
            }
            final boolean _tmpActive;
            if (_cursorIndexOfActive == -1) {
              _tmpActive = false;
            } else {
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp_4 != 0;
            }
            final long _tmpDateOfBirth;
            if (_cursorIndexOfDateOfBirth == -1) {
              _tmpDateOfBirth = 0;
            } else {
              _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
            }
            final String _tmpPersonAddress;
            if (_cursorIndexOfPersonAddress == -1) {
              _tmpPersonAddress = null;
            } else {
              if (cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = cursor.getString(_cursorIndexOfPersonAddress);
              }
            }
            final String _tmpPersonOrgId;
            if (_cursorIndexOfPersonOrgId == -1) {
              _tmpPersonOrgId = null;
            } else {
              if (cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = cursor.getString(_cursorIndexOfPersonOrgId);
              }
            }
            final long _tmpPersonGroupUid;
            if (_cursorIndexOfPersonGroupUid == -1) {
              _tmpPersonGroupUid = 0;
            } else {
              _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
            }
            final long _tmpPersonLct;
            if (_cursorIndexOfPersonLct == -1) {
              _tmpPersonLct = 0;
            } else {
              _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
            }
            final String _tmpPersonCountry;
            if (_cursorIndexOfPersonCountry == -1) {
              _tmpPersonCountry = null;
            } else {
              if (cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = cursor.getString(_cursorIndexOfPersonCountry);
              }
            }
            final int _tmpPersonType;
            if (_cursorIndexOfPersonType == -1) {
              _tmpPersonType = 0;
            } else {
              _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
            }
            final long _tmpPersonMasterChangeSeqNum;
            if (_cursorIndexOfPersonMasterChangeSeqNum == -1) {
              _tmpPersonMasterChangeSeqNum = 0;
            } else {
              _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            }
            final long _tmpPersonLocalChangeSeqNum;
            if (_cursorIndexOfPersonLocalChangeSeqNum == -1) {
              _tmpPersonLocalChangeSeqNum = 0;
            } else {
              _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            }
            final int _tmpPersonLastChangedBy;
            if (_cursorIndexOfPersonLastChangedBy == -1) {
              _tmpPersonLastChangedBy = 0;
            } else {
              _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            }
            final boolean _tmpAdmin;
            if (_cursorIndexOfAdmin == -1) {
              _tmpAdmin = false;
            } else {
              final int _tmp_5;
              _tmp_5 = cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_5 != 0;
            }
            final String _tmpPersonNotes;
            if (_cursorIndexOfPersonNotes == -1) {
              _tmpPersonNotes = null;
            } else {
              if (cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = cursor.getString(_cursorIndexOfPersonNotes);
              }
            }
            final String _tmpFatherName;
            if (_cursorIndexOfFatherName == -1) {
              _tmpFatherName = null;
            } else {
              if (cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = cursor.getString(_cursorIndexOfFatherName);
              }
            }
            final String _tmpFatherNumber;
            if (_cursorIndexOfFatherNumber == -1) {
              _tmpFatherNumber = null;
            } else {
              if (cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = cursor.getString(_cursorIndexOfFatherNumber);
              }
            }
            final String _tmpMotherName;
            if (_cursorIndexOfMotherName == -1) {
              _tmpMotherName = null;
            } else {
              if (cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = cursor.getString(_cursorIndexOfMotherName);
              }
            }
            final String _tmpMotherNum;
            if (_cursorIndexOfMotherNum == -1) {
              _tmpMotherNum = null;
            } else {
              if (cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = cursor.getString(_cursorIndexOfMotherNum);
              }
            }
            _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
          } else {
            _tmpPerson = null;
          }
          _item = new StatementEntityAndDisplayDetails(_tmpStatement,_tmpPerson);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
