package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.Site
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class SiteDao {
  @Query(`value` = "SELECT * FROM Site LIMIT 1")
  public actual abstract fun getSite(): Site?

  @Query(`value` = "SELECT * FROM Site LIMIT 1")
  public actual abstract suspend fun getSiteAsync(): Site?

  @Query(`value` = "SELECT authSalt FROM Site LIMIT 1")
  public actual abstract suspend fun getSiteAuthSaltAsync(): String?

  @Query(`value` = "SELECT * FROM Site LIMIT 1")
  public actual abstract fun getSiteAsFlow(): Flow<Site?>

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun replaceAsync(site: Site): Long

  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract fun insert(site: Site): Long

  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(workspace: Site)
}
