package com.ustadmobile.core.db.dao

import com.ustadmobile.lib.db.composites.PersonAndClazzLogAttendanceRecord
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecordWithPerson
import kotlin.Long
import kotlin.collections.List

public actual abstract class ClazzLogAttendanceRecordDao : BaseDao<ClazzLogAttendanceRecord> {
  public actual abstract suspend fun insertListAsync(entities: List<ClazzLogAttendanceRecord>)

  public actual abstract fun findByUid(uid: Long): ClazzLogAttendanceRecord?

  public actual abstract suspend fun updateListAsync(entities: List<ClazzLogAttendanceRecord>)

  public actual abstract suspend fun findByClazzLogUid(clazzLogUid: Long):
      List<ClazzLogAttendanceRecordWithPerson>

  public actual abstract fun updateRescheduledClazzLogUids(
    oldClazzLogUid: Long,
    newClazzLogUid: Long,
    changedTime: Long,
  )

  public actual abstract suspend fun findByClazzAndTime(
    clazzUid: Long,
    clazzLogUid: Long,
    time: Long,
  ): List<PersonAndClazzLogAttendanceRecord>

  public actual abstract suspend fun upsertListAsync(entityList: List<ClazzLogAttendanceRecord>)
}
