/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.RoomMasterTable;
import androidx.room.RoomOpenDelegate;
import androidx.room.Transactor;
import androidx.room.concurrent.ExclusiveLock;
import androidx.room.migration.Migration;
import androidx.room.util.MigrationUtil;
import androidx.sqlite.SQLite;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteDriver;
import androidx.sqlite.SQLiteStatement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u0000 ;2\u00020\u0001:\u0002:;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00122\"\u0010\u0017\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018H\u00a6@\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0004J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010,\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0004J\u0010\u00100\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0004J\u0010\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00103\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\f\u00104\u001a\u00020.*\u000205H\u0004J\f\u00106\u001a\u00020.*\u000205H\u0004J\u0010\u00107\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00108\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/room/BaseRoomConnectionManager;", "", "<init>", "()V", "configuration", "Landroidx/room/DatabaseConfiguration;", "getConfiguration", "()Landroidx/room/DatabaseConfiguration;", "openDelegate", "Landroidx/room/RoomOpenDelegate;", "getOpenDelegate", "()Landroidx/room/RoomOpenDelegate;", "callbacks", "", "Landroidx/room/RoomDatabase$Callback;", "getCallbacks", "()Ljava/util/List;", "isConfigured", "", "isInitializing", "useConnection", "R", "isReadOnly", "block", "Lkotlin/Function2;", "Landroidx/room/Transactor;", "Lkotlin/coroutines/Continuation;", "(ZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveFileName", "", "fileName", "resolveFileName$room_runtime", "configureDatabase", "", "connection", "Landroidx/sqlite/SQLiteConnection;", "configurationConnection", "configureJournalMode", "configureSynchronousFlag", "configureBusyTimeout", "onCreate", "hasEmptySchema", "updateIdentity", "createMasterTableIfNotExists", "onMigrate", "oldVersion", "", "newVersion", "dropAllTables", "onOpen", "checkIdentity", "hasRoomMasterTable", "getMaxNumberOfReaders", "Landroidx/room/RoomDatabase$JournalMode;", "getMaxNumberOfWriters", "invokeCreateCallback", "invokeDestructiveMigrationCallback", "invokeOpenCallback", "DriverWrapper", "Companion", "room-runtime"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nRoomConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomConnectionManager.kt\nandroidx/room/BaseRoomConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n1#2:363\n1863#3,2:364\n1863#3,2:366\n1863#3,2:368\n1863#3,2:370\n1863#3,2:372\n*S KotlinDebug\n*F\n+ 1 RoomConnectionManager.kt\nandroidx/room/BaseRoomConnectionManager\n*L\n209#1:364,2\n253#1:366,2\n342#1:368,2\n346#1:370,2\n350#1:372,2\n*E\n"})
public abstract class BaseRoomConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isConfigured;
    private boolean isInitializing;
    public static final int BUSY_TIMEOUT_MS = 3000;

    @NotNull
    protected abstract DatabaseConfiguration getConfiguration();

    @NotNull
    protected abstract RoomOpenDelegate getOpenDelegate();

    @NotNull
    protected abstract List<RoomDatabase.Callback> getCallbacks();

    @Nullable
    public abstract <R> Object useConnection(boolean var1, @NotNull Function2<? super Transactor, ? super Continuation<? super R>, ? extends Object> var2, @NotNull Continuation<? super R> var3);

    @NotNull
    public String resolveFileName$room_runtime(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void configureDatabase(SQLiteConnection connection) {
        int statement22;
        this.configureJournalMode(connection);
        this.configureSynchronousFlag(connection);
        this.configureBusyTimeout(connection);
        Object object = (AutoCloseable)connection.prepare("PRAGMA user_version");
        Throwable throwable = null;
        try {
            SQLiteStatement statement22 = (SQLiteStatement)object;
            boolean bl = false;
            statement22.step();
            statement22 = (int)statement22.getLong(0);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        int version = statement22;
        if (version != this.getOpenDelegate().getVersion()) {
            Object $this$configureDatabase_u24lambda_u241;
            SQLite.execSQL((SQLiteConnection)connection, (String)"BEGIN EXCLUSIVE TRANSACTION");
            object = this;
            try {
                $this$configureDatabase_u24lambda_u241 = (BaseRoomConnectionManager)object;
                boolean bl = false;
                if (version == 0) {
                    ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).onCreate(connection);
                } else {
                    ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).onMigrate(connection, version, ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).getOpenDelegate().getVersion());
                }
                SQLite.execSQL((SQLiteConnection)connection, (String)("PRAGMA user_version = " + ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).getOpenDelegate().getVersion()));
                $this$configureDatabase_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$configureDatabase_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$configureDatabase_u24lambda_u241;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"END TRANSACTION");
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 != null) {
                Throwable it = throwable = throwable2;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"ROLLBACK TRANSACTION");
                throw it;
            }
        }
        this.onOpen(connection);
    }

    private final void configurationConnection(SQLiteConnection connection) {
        this.configureSynchronousFlag(connection);
        this.configureBusyTimeout(connection);
        this.getOpenDelegate().onOpen(connection);
    }

    private final void configureJournalMode(SQLiteConnection connection) {
        boolean wal;
        boolean bl = wal = this.getConfiguration().getJournalMode() == RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING;
        if (wal) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA journal_mode = WAL");
        } else {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA journal_mode = TRUNCATE");
        }
    }

    private final void configureSynchronousFlag(SQLiteConnection connection) {
        boolean wal;
        boolean bl = wal = this.getConfiguration().getJournalMode() == RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING;
        if (wal) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA synchronous = NORMAL");
        } else {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA synchronous = FULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void configureBusyTimeout(SQLiteConnection connection) {
        long l;
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("PRAGMA busy_timeout");
        Throwable throwable = null;
        try {
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            it.step();
            l = it.getLong(0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        long currentBusyTimeout = l;
        if (currentBusyTimeout < 3000L) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA busy_timeout = 3000");
        }
    }

    protected final void onCreate(@NotNull SQLiteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean isEmptyDatabase = this.hasEmptySchema(connection);
        this.getOpenDelegate().createAllTables(connection);
        if (!isEmptyDatabase) {
            RoomOpenDelegate.ValidationResult result2 = this.getOpenDelegate().onValidateSchema(connection);
            if (!result2.isValid) {
                throw new IllegalStateException(("Pre-packaged database has an invalid schema: " + result2.expectedFoundMsg).toString());
            }
        }
        this.updateIdentity(connection);
        this.getOpenDelegate().onCreate(connection);
        this.invokeCreateCallback(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasEmptySchema(SQLiteConnection connection) {
        boolean bl;
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT count(*) FROM sqlite_master WHERE name != 'android_metadata'");
        Throwable throwable = null;
        try {
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            boolean bl2 = false;
            bl = it.step() && it.getLong(0) == 0L;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    private final void updateIdentity(SQLiteConnection connection) {
        this.createMasterTableIfNotExists(connection);
        SQLite.execSQL((SQLiteConnection)connection, (String)RoomMasterTable.createInsertQuery((String)this.getOpenDelegate().getIdentityHash()));
    }

    private final void createMasterTableIfNotExists(SQLiteConnection connection) {
        SQLite.execSQL((SQLiteConnection)connection, (String)"CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    protected final void onMigrate(@NotNull SQLiteConnection connection, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean migrated = false;
        List<Migration> migrations = MigrationUtil.findMigrationPath(this.getConfiguration().getMigrationContainer(), oldVersion, newVersion);
        if (migrations != null) {
            this.getOpenDelegate().onPreMigrate(connection);
            Iterable $this$forEach$iv = migrations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Migration it = (Migration)element$iv;
                boolean bl = false;
                it.migrate(connection);
            }
            RoomOpenDelegate.ValidationResult result2 = this.getOpenDelegate().onValidateSchema(connection);
            if (!result2.isValid) {
                throw new IllegalStateException(("Migration didn't properly handle: " + result2.expectedFoundMsg).toString());
            }
            this.getOpenDelegate().onPostMigrate(connection);
            this.updateIdentity(connection);
            migrated = true;
        }
        if (!migrated) {
            if (MigrationUtil.isMigrationRequired(this.getConfiguration(), oldVersion, newVersion)) {
                throw new IllegalStateException(("A migration from " + oldVersion + " to " + newVersion + " was required but not found. Please provide the necessary Migration path via RoomDatabase.Builder.addMigration(...) or allow for destructive migrations via one of the RoomDatabase.Builder.fallbackToDestructiveMigration* functions.").toString());
            }
            this.dropAllTables(connection);
            this.invokeDestructiveMigrationCallback(connection);
            this.getOpenDelegate().createAllTables(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dropAllTables(SQLiteConnection connection) {
        if (this.getConfiguration().getAllowDestructiveMigrationForAllTables()) {
            List list;
            List list2;
            AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT name, type FROM sqlite_master WHERE type = 'table' OR type = 'view'");
            Throwable throwable = null;
            try {
                SQLiteStatement statement = (SQLiteStatement)autoCloseable;
                boolean bl = false;
                List $this$dropAllTables_u24lambda_u248_u24lambda_u247 = list2 = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                while (statement.step()) {
                    String name = statement.getText(0);
                    if (StringsKt.startsWith$default((String)name, (String)"sqlite_", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"android_metadata")) continue;
                    boolean isView = Intrinsics.areEqual((Object)statement.getText(1), (Object)"view");
                    $this$dropAllTables_u24lambda_u248_u24lambda_u247.add(TuplesKt.to((Object)name, (Object)isView));
                }
                list = CollectionsKt.build((List)list2);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                list2 = (Pair)element$iv;
                boolean bl = false;
                String name = (String)list2.component1();
                boolean isView = (Boolean)list2.component2();
                if (isView) {
                    SQLite.execSQL((SQLiteConnection)connection, (String)("DROP VIEW IF EXISTS " + name));
                    continue;
                }
                SQLite.execSQL((SQLiteConnection)connection, (String)("DROP TABLE IF EXISTS " + name));
            }
        } else {
            this.getOpenDelegate().dropAllTables(connection);
        }
    }

    protected final void onOpen(@NotNull SQLiteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.checkIdentity(connection);
        this.getOpenDelegate().onOpen(connection);
        this.invokeOpenCallback(connection);
        this.isConfigured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIdentity(SQLiteConnection connection) {
        if (this.hasRoomMasterTable(connection)) {
            Object it;
            AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1");
            Throwable throwable = null;
            try {
                it = (SQLiteStatement)autoCloseable;
                boolean bl = false;
                it = it.step() ? it.getText(0) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Object identityHash = it;
            if (!Intrinsics.areEqual((Object)this.getOpenDelegate().getIdentityHash(), (Object)identityHash) && !Intrinsics.areEqual((Object)this.getOpenDelegate().getLegacyIdentityHash(), (Object)identityHash)) {
                throw new IllegalStateException(("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number. Expected identity hash: " + this.getOpenDelegate().getIdentityHash() + ", found: " + (String)identityHash).toString());
            }
        } else {
            Object $this$checkIdentity_u24lambda_u2411;
            SQLite.execSQL((SQLiteConnection)connection, (String)"BEGIN EXCLUSIVE TRANSACTION");
            Object object = this;
            try {
                $this$checkIdentity_u24lambda_u2411 = object;
                boolean bl = false;
                RoomOpenDelegate.ValidationResult result2 = ((BaseRoomConnectionManager)$this$checkIdentity_u24lambda_u2411).getOpenDelegate().onValidateSchema(connection);
                if (!result2.isValid) {
                    throw new IllegalStateException(("Pre-packaged database has an invalid schema: " + result2.expectedFoundMsg).toString());
                }
                ((BaseRoomConnectionManager)$this$checkIdentity_u24lambda_u2411).getOpenDelegate().onPostMigrate(connection);
                super.updateIdentity(connection);
                $this$checkIdentity_u24lambda_u2411 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$checkIdentity_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$checkIdentity_u24lambda_u2411;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"END TRANSACTION");
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable3;
                Throwable it = throwable3 = throwable;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"ROLLBACK TRANSACTION");
                throw it;
            }
            Result.box-impl((Object)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasRoomMasterTable(SQLiteConnection connection) {
        boolean bl;
        AutoCloseable autoCloseable = (AutoCloseable)connection.prepare("SELECT 1 FROM sqlite_master WHERE type = 'table' AND name = 'room_master_table'");
        Throwable throwable = null;
        try {
            SQLiteStatement it = (SQLiteStatement)autoCloseable;
            boolean bl2 = false;
            bl = it.step() && it.getLong(0) != 0L;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    protected final int getMaxNumberOfReaders(@NotNull RoomDatabase.JournalMode $this$getMaxNumberOfReaders) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getMaxNumberOfReaders), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getMaxNumberOfReaders.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            default: {
                throw new IllegalStateException(("Can't get max number of reader for journal mode '" + (Object)((Object)$this$getMaxNumberOfReaders) + '\'').toString());
            }
        }
        return n;
    }

    protected final int getMaxNumberOfWriters(@NotNull RoomDatabase.JournalMode $this$getMaxNumberOfWriters) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getMaxNumberOfWriters), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getMaxNumberOfWriters.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                throw new IllegalStateException(("Can't get max number of writers for journal mode '" + (Object)((Object)$this$getMaxNumberOfWriters) + '\'').toString());
            }
        }
        return n;
    }

    private final void invokeCreateCallback(SQLiteConnection connection) {
        Iterable $this$forEach$iv = this.getCallbacks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
            boolean bl = false;
            it.onCreate(connection);
        }
    }

    private final void invokeDestructiveMigrationCallback(SQLiteConnection connection) {
        Iterable $this$forEach$iv = this.getCallbacks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
            boolean bl = false;
            it.onDestructiveMigration(connection);
        }
    }

    private final void invokeOpenCallback(SQLiteConnection connection) {
        Iterable $this$forEach$iv = this.getCallbacks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
            boolean bl = false;
            it.onOpen(connection);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/room/BaseRoomConnectionManager$Companion;", "", "<init>", "()V", "BUSY_TIMEOUT_MS", "", "room-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/room/BaseRoomConnectionManager$DriverWrapper;", "Landroidx/sqlite/SQLiteDriver;", "actual", "<init>", "(Landroidx/room/BaseRoomConnectionManager;Landroidx/sqlite/SQLiteDriver;)V", "open", "Landroidx/sqlite/SQLiteConnection;", "fileName", "", "openLocked", "filename", "room-runtime"})
    protected final class DriverWrapper
    implements SQLiteDriver {
        @NotNull
        private final SQLiteDriver actual;

        public DriverWrapper(SQLiteDriver actual) {
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            this.actual = actual;
        }

        @NotNull
        public SQLiteConnection open(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return this.openLocked(BaseRoomConnectionManager.this.resolveFileName$room_runtime(fileName));
        }

        private final SQLiteConnection openLocked(String filename) {
            return (SQLiteConnection)new ExclusiveLock(filename, !BaseRoomConnectionManager.this.isConfigured && !BaseRoomConnectionManager.this.isInitializing && !Intrinsics.areEqual((Object)filename, (Object)":memory:")).withLock(() -> DriverWrapper.openLocked$lambda$1(BaseRoomConnectionManager.this, this, filename), new Function1(filename){
                final /* synthetic */ String $filename;
                {
                    this.$filename = $filename;
                }

                public final Void invoke(Throwable error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    throw new IllegalStateException("Unable to open database '" + this.$filename + "'. Was a proper path / name used in Room's database builder?", error);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final SQLiteConnection openLocked$lambda$1(BaseRoomConnectionManager this$0, DriverWrapper this$1, String $filename) {
            if (!(!this$0.isInitializing)) {
                boolean bl = false;
                String string = "Recursive database initialization detected. Did you try to use the database instance during initialization? Maybe in one of the callbacks?";
                throw new IllegalStateException(string.toString());
            }
            SQLiteConnection connection = this$1.actual.open($filename);
            if (!this$0.isConfigured) {
                try {
                    this$0.isInitializing = true;
                    this$0.configureDatabase(connection);
                }
                finally {
                    this$0.isInitializing = false;
                }
            } else {
                this$0.configurationConnection(connection);
            }
            return connection;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoomDatabase.JournalMode.values().length];
            try {
                nArray[RoomDatabase.JournalMode.TRUNCATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

