/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.school.daos;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.school.entities.PersonEntity;
import world.respect.datalayer.db.school.entities.PersonEntityWithRoles;
import world.respect.datalayer.school.model.composites.PersonListDetails;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\bg\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u00a7@\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00122\u0006\u0010\t\u001a\u00020\bH'J\u0014\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0012H'J\u0014\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00140\u0012H'J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\b\b\u0002\u0010\u0018\u001a\u00020\bH\u00a7@\u00a2\u0006\u0002\u0010\nJ2\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u001a2\b\b\u0002\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\bH'J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u001aH'J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u001f\u001a\u00020\u000eH\u00a7@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006 \u00c0\u0006\u0003"}, d2={"Lworld/respect/datalayer/db/school/daos/PersonEntityDao;", "", "insert", "", "personEntity", "Lworld/respect/datalayer/db/school/entities/PersonEntity;", "(Lworld/respect/datalayer/db/school/entities/PersonEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastModifiedByGuid", "", "guidHash", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUsername", "Lworld/respect/datalayer/db/school/entities/PersonEntityWithRoles;", "username", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGuidHash", "findByGuidHashAsFlow", "Lkotlinx/coroutines/flow/Flow;", "findAllListDetailsAsFlow", "", "Lworld/respect/datalayer/school/model/composites/PersonListDetails;", "findAllAsFlow", "findAll", "since", "findAllAsPagingSource", "Landroidx/paging/PagingSource;", "", "inClazzGuidHash", "findAllListDetailsAsPagingSource", "getAllUsers", "sourcedId", "respect-datalayer-db"})
@Dao
public interface PersonEntityDao {
    @Insert(onConflict=1)
    @Nullable
    public Object insert(@NotNull PersonEntity var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT PersonEntity.pLastModified\n          FROM PersonEntity\n         WHERE PersonEntity.pGuidHash = :guidHash\n         LIMIT 1\n    ")
    @Nullable
    public Object getLastModifiedByGuid(long var1, @NotNull Continuation<? super Long> var3);

    @Transaction
    @Query(value="\n        SELECT * \n         FROM PersonEntity\n        WHERE pUsername = :username\n    ")
    @Nullable
    public Object findByUsername(@NotNull String var1, @NotNull Continuation<? super PersonEntityWithRoles> var2);

    @Transaction
    @Query(value="\n       SELECT * \n         FROM PersonEntity\n        WHERE pGuidHash = :guidHash\n    ")
    @Nullable
    public Object findByGuidHash(long var1, @NotNull Continuation<? super PersonEntityWithRoles> var3);

    @Transaction
    @Query(value="\n        SELECT * \n         FROM PersonEntity\n        WHERE pGuidHash = :guidHash\n    ")
    @NotNull
    public Flow<PersonEntityWithRoles> findByGuidHashAsFlow(long var1);

    @Query(value="\n        SELECT PersonEntity.pGuid AS guid, \n               PersonEntity.pGivenName AS givenName, \n               PersonEntity.pFamilyName AS familyName, \n               PersonEntity.pUsername AS username\n          FROM PersonEntity\n    ")
    @NotNull
    public Flow<List<PersonListDetails>> findAllListDetailsAsFlow();

    @Transaction
    @Query(value="\n        SELECT * \n         FROM PersonEntity\n    ")
    @NotNull
    public Flow<List<PersonEntityWithRoles>> findAllAsFlow();

    @Query(value="\n        SELECT * \n         FROM PersonEntity\n        WHERE PersonEntity.pStored > :since \n    ")
    @Nullable
    public Object findAll(long var1, @NotNull Continuation<? super List<PersonEntity>> var3);

    public static /* synthetic */ Object findAll$default(PersonEntityDao personEntityDao, long l, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findAll");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return personEntityDao.findAll(l, (Continuation<? super List<PersonEntity>>)continuation);
    }

    @Transaction
    @Query(value="\n        SELECT * \n         FROM PersonEntity\n        WHERE PersonEntity.pStored > :since \n          AND (:guidHash = 0 OR PersonEntity.pGuidHash = :guidHash)\n          AND (:inClazzGuidHash = 0)\n     ORDER BY PersonEntity.pGivenName\n    ")
    @NotNull
    public PagingSource<Integer, PersonEntityWithRoles> findAllAsPagingSource(long var1, long var3, long var5);

    public static /* synthetic */ PagingSource findAllAsPagingSource$default(PersonEntityDao personEntityDao, long l, long l2, long l3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findAllAsPagingSource");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        if ((n & 4) != 0) {
            l3 = 0L;
        }
        return personEntityDao.findAllAsPagingSource(l, l2, l3);
    }

    @Query(value="\n        SELECT PersonEntity.pGuid AS guid, \n               PersonEntity.pGivenName AS givenName, \n               PersonEntity.pFamilyName AS familyName, \n               PersonEntity.pUsername AS username\n          FROM PersonEntity\n      ORDER BY PersonEntity.pGivenName    \n    ")
    @NotNull
    public PagingSource<Integer, PersonListDetails> findAllListDetailsAsPagingSource();

    @Query(value="\n            SELECT * \n            FROM PersonEntity\n            WHERE pGuid = :sourcedId\n            ")
    @Nullable
    public Object getAllUsers(@NotNull String var1, @NotNull Continuation<? super List<PersonEntity>> var2);

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Object findAll$default(PersonEntityDao personEntityDao, long l, Continuation continuation, int n, Object object) {
            return PersonEntityDao.findAll$default(personEntityDao, l, continuation, n, object);
        }

        public static /* synthetic */ PagingSource findAllAsPagingSource$default(PersonEntityDao personEntityDao, long l, long l2, long l3, int n, Object object) {
            return PersonEntityDao.findAllAsPagingSource$default(personEntityDao, l, l2, l3, n, object);
        }
    }
}

