/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.annotation.RestrictTo;
import androidx.compose.ui.graphics.Interval;
import androidx.compose.ui.graphics.IntervalTreeKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\f\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001*B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011J6\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u0015J:\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u00152\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u0015J9\u0010\u0017\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0004\u0012\u00020\f0\u0019H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u001aJ=\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0004\u0012\u00020\f0\u0019H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u001aJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0086\u0002J\u0017\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0086\u0002J\u0015\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u001fH\u0086\u0002J\u0017\u0010 \u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0086\u0002J%\u0010!\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010#J\u001a\u0010$\u001a\u00020\f2\u0010\u0010%\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u001a\u0010&\u001a\u00020\f2\u0010\u0010'\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u001a\u0010(\u001a\u00020\f2\u0010\u0010'\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u001a\u0010)\u001a\u00020\f2\u0010\u0010'\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002R\u001a\u0010\u0005\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u00008\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u00008\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a&\u0012\u000e\u0012\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u00000\tj\u0012\u0012\u000e\u0012\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000`\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"Landroidx/compose/ui/graphics/IntervalTree;", "T", "", "<init>", "()V", "terminator", "Landroidx/compose/ui/graphics/IntervalTree$Node;", "root", "stack", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "clear", "", "findFirstOverlap", "Landroidx/compose/ui/graphics/Interval;", "interval", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "start", "end", "findOverlaps", "", "results", "forEach", "block", "Lkotlin/Function1;", "forEach$ui_graphics", "contains", "", "value", "iterator", "", "plusAssign", "addInterval", "data", "(FFLjava/lang/Object;)V", "rebalance", "target", "rotateLeft", "node", "rotateRight", "updateNodeData", "Node", "ui-graphics"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@SourceDebugExtension(value={"SMAP\nIntervalTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntervalTree.kt\nandroidx/compose/ui/graphics/IntervalTree\n*L\n1#1,380:1\n152#1,16:381\n152#1,16:397\n152#1,16:413\n*S KotlinDebug\n*F\n+ 1 IntervalTree.kt\nandroidx/compose/ui/graphics/IntervalTree\n*L\n111#1:381,16\n137#1:397,16\n145#1:413,16\n*E\n"})
public final class IntervalTree<T> {
    @JvmField
    @NotNull
    public final Node terminator;
    @JvmField
    @NotNull
    public Node root;
    @JvmField
    @NotNull
    public final ArrayList<Node> stack;

    public IntervalTree() {
        this.root = this.terminator = new Node(Float.MAX_VALUE, Float.MIN_VALUE, null, 1);
        this.stack = new ArrayList();
    }

    public final void clear() {
        this.root = this.terminator;
    }

    @NotNull
    public final Interval<T> findFirstOverlap(@NotNull ClosedFloatingPointRange<Float> interval) {
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        return this.findFirstOverlap(((Number)((Object)interval.getStart())).floatValue(), ((Number)((Object)interval.getEndInclusive())).floatValue());
    }

    @NotNull
    public final Interval<T> findFirstOverlap(float start, float end) {
        if (this.root != this.terminator) {
            IntervalTree this_$iv = this;
            boolean $i$f$forEach$ui_graphics = false;
            if (this_$iv.root != this_$iv.terminator) {
                ArrayList<Node> s$iv = this_$iv.stack;
                s$iv.add(this_$iv.root);
                while (s$iv.size() > 0) {
                    Node node$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)s$iv.remove(s$iv.size() - 1), (String)"removeAt(...)");
                    if (node$iv.overlaps(start, end)) {
                        Interval interval = node$iv;
                        boolean bl = false;
                        return interval;
                    }
                    if (node$iv.getLeft() != this_$iv.terminator && node$iv.getLeft().getMax() >= start) {
                        s$iv.add(node$iv.getLeft());
                    }
                    if (node$iv.getRight() == this_$iv.terminator || !(node$iv.getRight().getMin() <= end)) continue;
                    s$iv.add(node$iv.getRight());
                }
                s$iv.clear();
            }
        }
        Interval<Object> interval = IntervalTreeKt.getEmptyInterval();
        Intrinsics.checkNotNull(interval, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.Interval<T of androidx.compose.ui.graphics.IntervalTree>");
        return interval;
    }

    public static /* synthetic */ Interval findFirstOverlap$default(IntervalTree intervalTree, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        return intervalTree.findFirstOverlap(f, f2);
    }

    @NotNull
    public final List<Interval<T>> findOverlaps(@NotNull ClosedFloatingPointRange<Float> interval, @NotNull List<Interval<T>> results) {
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        return this.findOverlaps(((Number)((Object)interval.getStart())).floatValue(), ((Number)((Object)interval.getEndInclusive())).floatValue(), results);
    }

    public static /* synthetic */ List findOverlaps$default(IntervalTree intervalTree, ClosedFloatingPointRange closedFloatingPointRange, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        return intervalTree.findOverlaps((ClosedFloatingPointRange<Float>)closedFloatingPointRange, list);
    }

    @NotNull
    public final List<Interval<T>> findOverlaps(float start, float end, @NotNull List<Interval<T>> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        IntervalTree this_$iv = this;
        boolean $i$f$forEach$ui_graphics = false;
        if (this_$iv.root != this_$iv.terminator) {
            ArrayList<Node> s$iv = this_$iv.stack;
            s$iv.add(this_$iv.root);
            while (s$iv.size() > 0) {
                Node node$iv;
                Intrinsics.checkNotNullExpressionValue((Object)s$iv.remove(s$iv.size() - 1), (String)"removeAt(...)");
                if (node$iv.overlaps(start, end)) {
                    Interval interval = node$iv;
                    boolean bl = false;
                    results.add(interval);
                }
                if (node$iv.getLeft() != this_$iv.terminator && node$iv.getLeft().getMax() >= start) {
                    s$iv.add(node$iv.getLeft());
                }
                if (node$iv.getRight() == this_$iv.terminator || !(node$iv.getRight().getMin() <= end)) continue;
                s$iv.add(node$iv.getRight());
            }
            s$iv.clear();
        }
        return results;
    }

    public static /* synthetic */ List findOverlaps$default(IntervalTree intervalTree, float f, float f2, List list, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        return intervalTree.findOverlaps(f, f2, list);
    }

    /*
     * WARNING - void declaration
     */
    public final void forEach$ui_graphics(@NotNull ClosedFloatingPointRange<Float> interval, @NotNull Function1<? super Interval<T>, Unit> block) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach$ui_graphics = false;
        IntervalTree intervalTree = this;
        float f = ((Number)((Object)interval.getStart())).floatValue();
        float end$iv = ((Number)((Object)interval.getEndInclusive())).floatValue();
        boolean $i$f$forEach$ui_graphics2 = false;
        if (this_$iv.root != this_$iv.terminator) {
            ArrayList<Node> s$iv = this_$iv.stack;
            s$iv.add(this_$iv.root);
            while (s$iv.size() > 0) {
                void start$iv;
                Node node$iv;
                Intrinsics.checkNotNullExpressionValue((Object)s$iv.remove(s$iv.size() - 1), (String)"removeAt(...)");
                if (node$iv.overlaps((float)start$iv, end$iv)) {
                    block.invoke((Object)node$iv);
                }
                if (node$iv.getLeft() != this_$iv.terminator && node$iv.getLeft().getMax() >= start$iv) {
                    s$iv.add(node$iv.getLeft());
                }
                if (node$iv.getRight() == this_$iv.terminator || !(node$iv.getRight().getMin() <= end$iv)) continue;
                s$iv.add(node$iv.getRight());
            }
            s$iv.clear();
        }
    }

    public final void forEach$ui_graphics(float start, float end, @NotNull Function1<? super Interval<T>, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach$ui_graphics = false;
        if (this.root != this.terminator) {
            ArrayList<Node> s = this.stack;
            s.add(this.root);
            while (s.size() > 0) {
                Node node;
                Intrinsics.checkNotNullExpressionValue((Object)s.remove(s.size() - 1), (String)"removeAt(...)");
                if (node.overlaps(start, end)) {
                    block.invoke((Object)node);
                }
                if (node.getLeft() != this.terminator && node.getLeft().getMax() >= start) {
                    s.add(node.getLeft());
                }
                if (node.getRight() == this.terminator || !(node.getRight().getMin() <= end)) continue;
                s.add(node.getRight());
            }
            s.clear();
        }
    }

    public static /* synthetic */ void forEach$ui_graphics$default(IntervalTree $this, float start, float end, Function1 block, int n, Object object) {
        if ((n & 2) != 0) {
            end = start;
        }
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$forEach$ui_graphics = false;
        if ($this.root != $this.terminator) {
            ArrayList<Node> s = $this.stack;
            s.add($this.root);
            while (s.size() > 0) {
                Node node;
                Intrinsics.checkNotNullExpressionValue((Object)s.remove(s.size() - 1), (String)"removeAt(...)");
                if (node.overlaps(start, end)) {
                    block.invoke((Object)node);
                }
                if (node.getLeft() != $this.terminator && node.getLeft().getMax() >= start) {
                    s.add(node.getLeft());
                }
                if (node.getRight() == $this.terminator || !(node.getRight().getMin() <= end)) continue;
                s.add(node.getRight());
            }
            s.clear();
        }
    }

    public final boolean contains(float value) {
        return this.findFirstOverlap(value, value) != IntervalTreeKt.getEmptyInterval();
    }

    public final boolean contains(@NotNull ClosedFloatingPointRange<Float> interval) {
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        return this.findFirstOverlap(((Number)((Object)interval.getStart())).floatValue(), ((Number)((Object)interval.getEndInclusive())).floatValue()) != IntervalTreeKt.getEmptyInterval();
    }

    @NotNull
    public final Iterator<Interval<T>> iterator() {
        return new Iterator<Interval<T>>(this){
            private Node _next;
            final /* synthetic */ IntervalTree<T> this$0;
            {
                this.this$0 = $receiver;
                this._next = $receiver.root.lowestNode();
            }

            public final Node get_next() {
                return this._next;
            }

            public final void set_next(Node node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"<set-?>");
                this._next = node;
            }

            public boolean hasNext() {
                return this._next != this.this$0.terminator;
            }

            public Interval<T> next() {
                Node node = this._next;
                this._next = this._next.next();
                return node;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public final void plusAssign(@NotNull Interval<T> interval) {
        Intrinsics.checkNotNullParameter(interval, (String)"interval");
        this.addInterval(interval.getStart(), interval.getEnd(), interval.getData());
    }

    public final void addInterval(float start, float end, @Nullable T data) {
        Node node = new Node(start, end, data, 0);
        Node current = this.root;
        Node parent = this.terminator;
        while (current != this.terminator) {
            parent = current;
            current = node.getStart() <= current.getStart() ? current.getLeft() : current.getRight();
        }
        node.setParent(parent);
        if (parent == this.terminator) {
            this.root = node;
        } else if (node.getStart() <= parent.getStart()) {
            parent.setLeft(node);
        } else {
            parent.setRight(node);
        }
        this.updateNodeData(node);
        this.rebalance(node);
    }

    private final void rebalance(Node target) {
        Node node = target;
        while (node != this.root && node.getParent().getColor() == 0) {
            Node ancestor = node.getParent().getParent();
            if (node.getParent() == ancestor.getLeft()) {
                Node right = ancestor.getRight();
                if (right.getColor() == 0) {
                    right.setColor(1);
                    node.getParent().setColor(1);
                    ancestor.setColor(0);
                    node = ancestor;
                    continue;
                }
                if (node == node.getParent().getRight()) {
                    node = node.getParent();
                    this.rotateLeft(node);
                }
                node.getParent().setColor(1);
                ancestor.setColor(0);
                this.rotateRight(ancestor);
                continue;
            }
            Node left = ancestor.getLeft();
            if (left.getColor() == 0) {
                left.setColor(1);
                node.getParent().setColor(1);
                ancestor.setColor(0);
                node = ancestor;
                continue;
            }
            if (node == node.getParent().getLeft()) {
                node = node.getParent();
                this.rotateRight(node);
            }
            node.getParent().setColor(1);
            ancestor.setColor(0);
            this.rotateLeft(ancestor);
        }
        this.root.setColor(1);
    }

    private final void rotateLeft(Node node) {
        Node right = node.getRight();
        node.setRight(right.getLeft());
        if (right.getLeft() != this.terminator) {
            right.getLeft().setParent(node);
        }
        right.setParent(node.getParent());
        if (node.getParent() == this.terminator) {
            this.root = right;
        } else if (node.getParent().getLeft() == node) {
            node.getParent().setLeft(right);
        } else {
            node.getParent().setRight(right);
        }
        right.setLeft(node);
        node.setParent(right);
        this.updateNodeData(node);
    }

    private final void rotateRight(Node node) {
        Node left = node.getLeft();
        node.setLeft(left.getRight());
        if (left.getRight() != this.terminator) {
            left.getRight().setParent(node);
        }
        left.setParent(node.getParent());
        if (node.getParent() == this.terminator) {
            this.root = left;
        } else if (node.getParent().getRight() == node) {
            node.getParent().setRight(left);
        } else {
            node.getParent().setLeft(left);
        }
        left.setRight(node);
        node.setParent(left);
        this.updateNodeData(node);
    }

    private final void updateNodeData(Node node) {
        for (Node current = node; current != this.terminator; current = current.getParent()) {
            current.setMin(Math.min(current.getStart(), Math.min(current.getLeft().getMin(), current.getRight().getMin())));
            current.setMax(Math.max(current.getEnd(), Math.max(current.getLeft().getMax(), current.getRight().getMax())));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\b\u0080\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010#\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0010\u0010$\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018R\u001e\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR$\u0010 \u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001c\u00a8\u0006%"}, d2={"Landroidx/compose/ui/graphics/IntervalTree$Node;", "Landroidx/compose/ui/graphics/Interval;", "start", "", "end", "data", "color", "", "Landroidx/compose/ui/graphics/TreeColor;", "<init>", "(Landroidx/compose/ui/graphics/IntervalTree;FFLjava/lang/Object;I)V", "getColor", "()I", "setColor", "(I)V", "min", "getMin", "()F", "setMin", "(F)V", "max", "getMax", "setMax", "left", "Landroidx/compose/ui/graphics/IntervalTree;", "getLeft", "()Landroidx/compose/ui/graphics/IntervalTree$Node;", "setLeft", "(Landroidx/compose/ui/graphics/IntervalTree$Node;)V", "right", "getRight", "setRight", "parent", "getParent", "setParent", "lowestNode", "next", "ui-graphics"})
    public final class Node
    extends Interval<T> {
        private int color;
        private float min;
        private float max;
        @NotNull
        private Node left;
        @NotNull
        private Node right;
        @NotNull
        private Node parent;

        public Node(float start, @Nullable float end, T data, int color) {
            super(start, end, data);
            this.color = color;
            this.min = start;
            this.max = end;
            this.left = IntervalTree.this.terminator;
            this.right = IntervalTree.this.terminator;
            this.parent = IntervalTree.this.terminator;
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final float getMin() {
            return this.min;
        }

        public final void setMin(float f) {
            this.min = f;
        }

        public final float getMax() {
            return this.max;
        }

        public final void setMax(float f) {
            this.max = f;
        }

        @NotNull
        public final Node getLeft() {
            return this.left;
        }

        public final void setLeft(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"<set-?>");
            this.left = node;
        }

        @NotNull
        public final Node getRight() {
            return this.right;
        }

        public final void setRight(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"<set-?>");
            this.right = node;
        }

        @NotNull
        public final Node getParent() {
            return this.parent;
        }

        public final void setParent(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"<set-?>");
            this.parent = node;
        }

        @NotNull
        public final Node lowestNode() {
            Node node = this;
            while (node.left != IntervalTree.this.terminator) {
                node = node.left;
            }
            return node;
        }

        @NotNull
        public final Node next() {
            if (this.right != IntervalTree.this.terminator) {
                return this.right.lowestNode();
            }
            Node a = this;
            Node b = this.parent;
            while (b != IntervalTree.this.terminator && a == b.right) {
                a = b;
                b = b.parent;
            }
            return b;
        }
    }
}

