/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongIntMap;
import androidx.collection.LongIntMapKt;
import androidx.collection.MutableLongIntMap;
import androidx.compose.foundation.text.selection.Direction;
import androidx.compose.foundation.text.selection.MultiSelectionLayout;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import androidx.compose.foundation.text.selection.SelectionLayoutKt;
import androidx.compose.foundation.text.selection.SingleSelectionLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010%\u001a\u0004\u0018\u00010&JN\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\"2\u0006\u00101\u001a\u000202J \u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020+H\u0002R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Landroidx/compose/foundation/text/selection/SelectionLayoutBuilder;", "", "currentPosition", "Landroidx/compose/ui/geometry/Offset;", "previousHandlePosition", "containerCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "isStartHandle", "", "previousSelection", "Landroidx/compose/foundation/text/selection/Selection;", "selectableIdOrderingComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "(JJLandroidx/compose/ui/layout/LayoutCoordinates;ZLandroidx/compose/foundation/text/selection/Selection;Ljava/util/Comparator;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCurrentPosition-F1C5BW0", "()J", "J", "getPreviousHandlePosition-F1C5BW0", "getContainerCoordinates", "()Landroidx/compose/ui/layout/LayoutCoordinates;", "()Z", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "getSelectableIdOrderingComparator", "()Ljava/util/Comparator;", "selectableIdToInfoListIndex", "Landroidx/collection/MutableLongIntMap;", "infoList", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "startSlot", "", "endSlot", "currentSlot", "build", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "appendInfo", "selectableId", "rawStartHandleOffset", "startXHandleDirection", "Landroidx/compose/foundation/text/selection/Direction;", "startYHandleDirection", "rawEndHandleOffset", "endXHandleDirection", "endYHandleDirection", "rawPreviousHandleOffset", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "updateSlot", "slot", "xPositionDirection", "yPositionDirection", "foundation"})
@StabilityInferred(parameters=0)
public final class SelectionLayoutBuilder {
    private final long currentPosition;
    private final long previousHandlePosition;
    @NotNull
    private final LayoutCoordinates containerCoordinates;
    private final boolean isStartHandle;
    @Nullable
    private final Selection previousSelection;
    @NotNull
    private final Comparator<Long> selectableIdOrderingComparator;
    @NotNull
    private final MutableLongIntMap selectableIdToInfoListIndex;
    @NotNull
    private final List<SelectableInfo> infoList;
    private int startSlot;
    private int endSlot;
    private int currentSlot;
    public static final int $stable = 8;

    private SelectionLayoutBuilder(long currentPosition, long previousHandlePosition, LayoutCoordinates containerCoordinates, boolean isStartHandle, Selection previousSelection, Comparator<Long> selectableIdOrderingComparator) {
        Intrinsics.checkNotNullParameter((Object)containerCoordinates, (String)"containerCoordinates");
        Intrinsics.checkNotNullParameter(selectableIdOrderingComparator, (String)"selectableIdOrderingComparator");
        this.currentPosition = currentPosition;
        this.previousHandlePosition = previousHandlePosition;
        this.containerCoordinates = containerCoordinates;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        this.selectableIdOrderingComparator = selectableIdOrderingComparator;
        this.selectableIdToInfoListIndex = LongIntMapKt.mutableLongIntMapOf();
        this.infoList = new ArrayList();
        this.startSlot = -1;
        this.endSlot = -1;
        this.currentSlot = -1;
    }

    public final long getCurrentPosition-F1C5BW0() {
        return this.currentPosition;
    }

    public final long getPreviousHandlePosition-F1C5BW0() {
        return this.previousHandlePosition;
    }

    @NotNull
    public final LayoutCoordinates getContainerCoordinates() {
        return this.containerCoordinates;
    }

    public final boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Nullable
    public final Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @NotNull
    public final Comparator<Long> getSelectableIdOrderingComparator() {
        return this.selectableIdOrderingComparator;
    }

    @Nullable
    public final SelectionLayout build() {
        SelectionLayout selectionLayout;
        int lastSlot = this.currentSlot + 1;
        switch (this.infoList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                SelectableInfo selectableInfo = (SelectableInfo)CollectionsKt.single(this.infoList);
                int n = this.startSlot == -1 ? lastSlot : this.startSlot;
                int n2 = this.endSlot == -1 ? lastSlot : this.endSlot;
                Selection selection = this.previousSelection;
                boolean bl = this.isStartHandle;
                selectionLayout = new SingleSelectionLayout(bl, n, n2, selection, selectableInfo);
                break;
            }
            default: {
                selectionLayout = new MultiSelectionLayout((LongIntMap)this.selectableIdToInfoListIndex, this.infoList, this.startSlot == -1 ? lastSlot : this.startSlot, this.endSlot == -1 ? lastSlot : this.endSlot, this.isStartHandle, this.previousSelection);
            }
        }
        return selectionLayout;
    }

    @NotNull
    public final SelectableInfo appendInfo(long selectableId, int rawStartHandleOffset, @NotNull Direction startXHandleDirection, @NotNull Direction startYHandleDirection, int rawEndHandleOffset, @NotNull Direction endXHandleDirection, @NotNull Direction endYHandleDirection, int rawPreviousHandleOffset, @NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)startXHandleDirection), (String)"startXHandleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)startYHandleDirection), (String)"startYHandleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)endXHandleDirection), (String)"endXHandleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)endYHandleDirection), (String)"endYHandleDirection");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        this.currentSlot += 2;
        SelectableInfo selectableInfo = new SelectableInfo(selectableId, this.currentSlot, rawStartHandleOffset, rawEndHandleOffset, rawPreviousHandleOffset, textLayoutResult);
        this.startSlot = this.updateSlot(this.startSlot, startXHandleDirection, startYHandleDirection);
        this.endSlot = this.updateSlot(this.endSlot, endXHandleDirection, endYHandleDirection);
        this.selectableIdToInfoListIndex.set(selectableId, this.infoList.size());
        ((Collection)this.infoList).add(selectableInfo);
        return selectableInfo;
    }

    private final int updateSlot(int slot, Direction xPositionDirection, Direction yPositionDirection) {
        int n;
        if (slot != -1) {
            return slot;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[SelectionLayoutKt.resolve2dDirection(xPositionDirection, yPositionDirection).ordinal()]) {
            case 1: {
                n = this.currentSlot - 1;
                break;
            }
            case 2: {
                n = this.currentSlot;
                break;
            }
            case 3: {
                n = slot;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public /* synthetic */ SelectionLayoutBuilder(long currentPosition, long previousHandlePosition, LayoutCoordinates containerCoordinates, boolean isStartHandle, Selection previousSelection, Comparator selectableIdOrderingComparator, DefaultConstructorMarker $constructor_marker) {
        this(currentPosition, previousHandlePosition, containerCoordinates, isStartHandle, previousSelection, selectableIdOrderingComparator);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.BEFORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.AFTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

