/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.navigation.internal.UriCodec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/navigation/internal/InternalUri;", "", "<init>", "()V", "encode", "", "s", "allow", "decode", "isAllowed", "", "c", "", "HEX_DIGITS", "", "parsePath", "uriString", "ssi", "", "navigation-common"})
public final class InternalUri {
    @NotNull
    public static final InternalUri INSTANCE = new InternalUri();
    @NotNull
    private static final char[] HEX_DIGITS;

    private InternalUri() {
    }

    @NotNull
    public final String encode(@NotNull String s, @Nullable String allow) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder encoded = null;
        int oldLength = s.length();
        int current = 0;
        while (current < oldLength) {
            int nextAllowed;
            int nextToEncode;
            for (nextToEncode = current; nextToEncode < oldLength && this.isAllowed(s.charAt(nextToEncode), allow); ++nextToEncode) {
            }
            if (nextToEncode == oldLength) {
                if (current == 0) {
                    return s;
                }
                StringBuilder stringBuilder = encoded;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append(s, current, oldLength);
                String string = encoded.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            if (nextToEncode > current) {
                encoded.append(s, current, nextToEncode);
            }
            current = nextToEncode;
            for (nextAllowed = current + 1; nextAllowed < oldLength && !this.isAllowed(s.charAt(nextAllowed), allow); ++nextAllowed) {
            }
            byte[] bytes = StringsKt.encodeToByteArray$default((String)s, (int)current, (int)nextAllowed, (boolean)false, (int)4, null);
            int bytesLength = bytes.length;
            for (int i = 0; i < bytesLength; ++i) {
                encoded.append('%');
                encoded.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
                encoded.append(HEX_DIGITS[bytes[i] & 0xF]);
            }
            current = nextAllowed;
        }
        CharSequence charSequence = encoded;
        if (charSequence == null || (charSequence = charSequence.toString()) == null) {
            charSequence = s;
        }
        return charSequence;
    }

    public static /* synthetic */ String encode$default(InternalUri internalUri, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return internalUri.encode(string, string2);
    }

    @NotNull
    public final String decode(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return UriCodec.INSTANCE.decode(s, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAllowed(char c, String allow) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if ('A' <= c) {
            if (c < '[') {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        if ('a' <= c) {
            if (c < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('0' <= c) {
            if (c < ':') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (StringsKt.indexOf$default((CharSequence)"_-!.~'()*", (char)c, (int)0, (boolean)false, (int)6, null) != -1) return true;
        if (allow == null) return false;
        if (StringsKt.indexOf$default((CharSequence)allow, (char)c, (int)0, (boolean)false, (int)6, null) == -1) return false;
        return true;
    }

    @NotNull
    public final String parsePath(@NotNull String uriString, int ssi) {
        int pathEnd;
        int pathStart;
        int length;
        block11: {
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            length = uriString.length();
            pathStart = 0;
            if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                pathStart = ssi + 3;
                while (pathStart < length) {
                    switch (uriString.charAt(pathStart)) {
                        case '#': 
                        case '?': {
                            return "";
                        }
                        case '/': 
                        case '\\': {
                            break block11;
                        }
                        default: {
                            ++pathStart;
                            break;
                        }
                    }
                }
            } else {
                pathStart = ssi + 1;
            }
        }
        block8: for (pathEnd = pathStart; pathEnd < length; ++pathEnd) {
            switch (uriString.charAt(pathEnd)) {
                case '#': 
                case '?': {
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        String string = uriString.substring(pathStart, pathEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_DIGITS = cArray;
    }
}

