/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontVariation;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.platform.DesktopFont_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.LoadedFont;
import androidx.compose.ui.text.platform.Platform;
import androidx.compose.ui.text.platform.PlatformFont;
import androidx.compose.ui.text.platform.PlatformFont_skikoKt;
import androidx.compose.ui.text.platform.ResourceFont;
import androidx.compose.ui.text.platform.SystemFont;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontSlant;
import org.jetbrains.skia.Typeface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\r\u001a)\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0010\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u001a\b\u0010\u001b\u001a\u00020\u001cH\u0000\"\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Font", "Landroidx/compose/ui/text/font/Font;", "resource", "", "weight", "Landroidx/compose/ui/text/font/FontWeight;", "style", "Landroidx/compose/ui/text/font/FontStyle;", "Font-RetOiIg", "(Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/font/Font;", "variationSettings", "Landroidx/compose/ui/text/font/FontVariation$Settings;", "Font-Ej4NQ78", "(Ljava/lang/String;Landroidx/compose/ui/text/font/FontWeight;ILandroidx/compose/ui/text/font/FontVariation$Settings;)Landroidx/compose/ui/text/font/Font;", "file", "Ljava/io/File;", "(Ljava/io/File;Landroidx/compose/ui/text/font/FontWeight;I)Landroidx/compose/ui/text/font/Font;", "(Ljava/io/File;Landroidx/compose/ui/text/font/FontWeight;ILandroidx/compose/ui/text/font/FontVariation$Settings;)Landroidx/compose/ui/text/font/Font;", "loadTypeface", "Lorg/jetbrains/skia/Typeface;", "font", "typefaceResource", "resourceName", "skFontStyle", "Lorg/jetbrains/skia/FontStyle;", "getSkFontStyle", "(Landroidx/compose/ui/text/font/Font;)Lorg/jetbrains/skia/FontStyle;", "currentPlatform", "Landroidx/compose/ui/text/platform/Platform;", "ui-text"})
@SourceDebugExtension(value={"SMAP\nDesktopFont.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopFont.desktop.kt\nandroidx/compose/ui/text/platform/DesktopFont_desktopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
public final class DesktopFont_desktopKt {
    @NotNull
    public static final Font Font-RetOiIg(@NotNull String resource2, @NotNull FontWeight weight, int style) {
        Intrinsics.checkNotNullParameter((Object)resource2, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        return new ResourceFont(resource2, weight, style, new FontVariation.Settings(new FontVariation.Setting[0]), null);
    }

    public static /* synthetic */ Font Font-RetOiIg$default(String string, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return DesktopFont_desktopKt.Font-RetOiIg(string, fontWeight, n);
    }

    @NotNull
    public static final Font Font-Ej4NQ78(@NotNull String resource2, @NotNull FontWeight weight, int style, @NotNull FontVariation.Settings variationSettings) {
        Intrinsics.checkNotNullParameter((Object)resource2, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        Intrinsics.checkNotNullParameter((Object)variationSettings, (String)"variationSettings");
        return new ResourceFont(resource2, weight, style, variationSettings, null);
    }

    public static /* synthetic */ Font Font-Ej4NQ78$default(String string, FontWeight fontWeight, int n, FontVariation.Settings settings, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        if ((n2 & 8) != 0) {
            settings = FontVariation.INSTANCE.Settings-6EWAqTQ(fontWeight, n, new FontVariation.Setting[0]);
        }
        return DesktopFont_desktopKt.Font-Ej4NQ78(string, fontWeight, n, settings);
    }

    @NotNull
    public static final Font Font-RetOiIg(@NotNull File file, @NotNull FontWeight weight, int style) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        return new FileFont(file, weight, style, new FontVariation.Settings(new FontVariation.Setting[0]), null);
    }

    public static /* synthetic */ Font Font-RetOiIg$default(File file, FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        return DesktopFont_desktopKt.Font-RetOiIg(file, fontWeight, n);
    }

    @NotNull
    public static final Font Font-Ej4NQ78(@NotNull File file, @NotNull FontWeight weight, int style, @NotNull FontVariation.Settings variationSettings) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        Intrinsics.checkNotNullParameter((Object)variationSettings, (String)"variationSettings");
        return new FileFont(file, weight, style, variationSettings, null);
    }

    public static /* synthetic */ Font Font-Ej4NQ78$default(File file, FontWeight fontWeight, int n, FontVariation.Settings settings, int n2, Object object) {
        if ((n2 & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n2 & 4) != 0) {
            n = FontStyle.Companion.getNormal-_-LCdwA();
        }
        if ((n2 & 8) != 0) {
            settings = FontVariation.INSTANCE.Settings-6EWAqTQ(fontWeight, n, new FontVariation.Setting[0]);
        }
        return DesktopFont_desktopKt.Font-Ej4NQ78(file, fontWeight, n, settings);
    }

    @NotNull
    public static final Typeface loadTypeface(@NotNull Font font) {
        Typeface typeface2;
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        if (!(font instanceof PlatformFont)) {
            throw new IllegalArgumentException("Unsupported font type: " + font);
        }
        PlatformFont platformFont = (PlatformFont)font;
        if (platformFont instanceof ResourceFont) {
            typeface2 = DesktopFont_desktopKt.typefaceResource(((ResourceFont)font).getName());
        } else if (platformFont instanceof FileFont) {
            FontMgr fontMgr = FontMgr.Companion.getDefault();
            String string = ((FileFont)font).getFile().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            typeface2 = FontMgr.makeFromFile$default((FontMgr)fontMgr, (String)string, (int)0, (int)2, null);
        } else if (platformFont instanceof LoadedFont) {
            typeface2 = FontMgr.makeFromData$default((FontMgr)FontMgr.Companion.getDefault(), (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])((byte[])((LoadedFont)font).getGetData$ui_text().invoke()), (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        } else if (platformFont instanceof SystemFont) {
            typeface2 = FontMgr.Companion.getDefault().matchFamilyStyle(((SystemFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface3 = typeface2;
        if (typeface2 == null && (typeface3 = FontMgr.Companion.getDefault().legacyMakeTypeface(((PlatformFont)font).getIdentity(), DesktopFont_desktopKt.getSkFontStyle(font))) == null) {
            throw new IllegalStateException("loadTypeface legacyMakeTypeface failed".toString());
        }
        Typeface typeface4 = typeface3;
        return PlatformFont_skikoKt.cloneWithVariationSettings(typeface4, ((PlatformFont)font).getVariationSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Typeface typefaceResource(String resourceName) {
        byte[] byArray;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        ClassLoader contextClassLoader = classLoader;
        InputStream inputStream = contextClassLoader.getResourceAsStream(resourceName);
        if (inputStream == null && (inputStream = ((Object)((Object)typefaceResource.resource.1.INSTANCE)).getClass().getResourceAsStream(resourceName)) == null) {
            throw new IllegalStateException(("Can't load font from " + resourceName).toString());
        }
        InputStream resource2 = inputStream;
        Closeable closeable = resource2;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byArray = it.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] bytes = byArray;
        FontMgr fontMgr = FontMgr.Companion.getDefault();
        Intrinsics.checkNotNull((Object)bytes);
        Typeface typeface2 = FontMgr.makeFromData$default((FontMgr)fontMgr, (Data)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])bytes, (int)0, (int)0, (int)6, null), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)typeface2);
        return typeface2;
    }

    private static final org.jetbrains.skia.FontStyle getSkFontStyle(Font $this$skFontStyle) {
        return new org.jetbrains.skia.FontStyle($this$skFontStyle.getWeight().getWeight(), 5, FontStyle.equals-impl0($this$skFontStyle.getStyle-_-LCdwA(), FontStyle.Companion.getItalic-_-LCdwA()) ? FontSlant.ITALIC : FontSlant.UPRIGHT);
    }

    @NotNull
    public static final Platform currentPlatform() {
        String name = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.startsWith$default((String)name, (String)"Linux", (boolean)false, (int)2, null) ? Platform.Linux : (StringsKt.startsWith$default((String)name, (String)"Win", (boolean)false, (int)2, null) ? Platform.Windows : (Intrinsics.areEqual((Object)name, (Object)"Mac OS X") ? Platform.MacOS : Platform.Unknown));
    }

    public static final /* synthetic */ Typeface access$typefaceResource(String resourceName) {
        return DesktopFont_desktopKt.typefaceResource(resourceName);
    }
}

