/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.report.formatter;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import world.respect.datalayer.school.model.report.StatementReportRow;
import world.respect.shared.domain.report.formatter.GraphFormatter;
import world.respect.shared.domain.report.query.RunReportUseCase;
import world.respect.shared.resources.StringUiText;
import world.respect.shared.resources.UiText;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lworld/respect/shared/domain/report/formatter/DurationGraphFormatter;", "Lworld/respect/shared/domain/report/formatter/GraphFormatter;", "", "result", "Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult;", "<init>", "(Lworld/respect/shared/domain/report/query/RunReportUseCase$RunReportResult;)V", "unit", "Lkotlin/time/DurationUnit;", "getUnit", "()Lkotlin/time/DurationUnit;", "unit$delegate", "Lkotlin/Lazy;", "adjust", "value", "(D)Ljava/lang/Double;", "format", "Lworld/respect/shared/resources/UiText;", "respect-lib-shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDurationGraphFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurationGraphFormatter.kt\nworld/respect/shared/domain/report/formatter/DurationGraphFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class DurationGraphFormatter
implements GraphFormatter<Double> {
    @NotNull
    private final RunReportUseCase.RunReportResult result;
    @NotNull
    private final Lazy unit$delegate;
    public static final int $stable = 8;

    public DurationGraphFormatter(@NotNull RunReportUseCase.RunReportResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.result = result;
        this.unit$delegate = LazyKt.lazy(() -> DurationGraphFormatter.unit_delegate$lambda$2(this));
    }

    private final DurationUnit getUnit() {
        Lazy lazy = this.unit$delegate;
        return (DurationUnit)lazy.getValue();
    }

    @Override
    @NotNull
    public Double adjust(double value) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getUnit().ordinal()]) {
            case 1 -> value / (double)60000;
            case 2 -> value / (double)3600000;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    @NotNull
    public UiText format(double value) {
        double roundedValue = (double)MathKt.roundToInt((double)(value * (double)100)) / 100.0;
        return new StringUiText(String.valueOf(roundedValue));
    }

    private static final DurationUnit unit_delegate$lambda$2(DurationGraphFormatter this$0) {
        Double d;
        Iterator iterator = ((Iterable)this$0.result.getResults()).iterator();
        if (!iterator.hasNext()) {
            d = null;
        } else {
            double d2;
            Double d3;
            List list = (List)iterator.next();
            boolean bl = false;
            Iterator iterator2 = ((Iterable)list).iterator();
            if (!iterator2.hasNext()) {
                d3 = null;
            } else {
                StatementReportRow it = (StatementReportRow)iterator2.next();
                boolean bl2 = false;
                double d4 = it.getYAxis();
                while (iterator2.hasNext()) {
                    StatementReportRow it2 = (StatementReportRow)iterator2.next();
                    $i$a$-maxOfOrNull-DurationGraphFormatter$unit$2$maxVal$1$1 = false;
                    double d5 = it2.getYAxis();
                    d4 = Math.max(d4, d5);
                }
                d3 = d4;
            }
            double d6 = d2 = d3 != null ? d3 : 0.0;
            while (iterator.hasNext()) {
                Double d7;
                List list2 = (List)iterator.next();
                $i$a$-maxOfOrNull-DurationGraphFormatter$unit$2$maxVal$1 = false;
                Iterator iterator3 = ((Iterable)list2).iterator();
                if (!iterator3.hasNext()) {
                    d7 = null;
                } else {
                    StatementReportRow it = (StatementReportRow)iterator3.next();
                    boolean bl3 = false;
                    double d8 = it.getYAxis();
                    while (iterator3.hasNext()) {
                        StatementReportRow it3 = (StatementReportRow)iterator3.next();
                        $i$a$-maxOfOrNull-DurationGraphFormatter$unit$2$maxVal$1$1 = false;
                        double d9 = it3.getYAxis();
                        d8 = Math.max(d8, d9);
                    }
                    d7 = d8;
                }
                double d10 = d7 != null ? d7 : 0.0;
                d2 = Math.max(d2, d10);
            }
            d = d2;
        }
        double maxVal = d != null ? d : 0.0;
        return maxVal > 3600000.0 ? DurationUnit.HOURS : DurationUnit.MINUTES;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DurationUnit.values().length];
            try {
                nArray[DurationUnit.MINUTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DurationUnit.HOURS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

