/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.internal;

import androidx.navigation.internal.URISyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J*\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014J,\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/navigation/internal/UriCodec;", "", "<init>", "()V", "hexCharToValue", "", "c", "", "unexpectedCharacterException", "Landroidx/navigation/internal/URISyntaxException;", "uri", "", "name", "unexpected", "index", "getNextCharacter", "end", "decode", "s", "convertPlus", "", "throwOnFailure", "INVALID_INPUT_CHARACTER", "appendDecoded", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "navigation-common"})
public final class UriCodec {
    @NotNull
    public static final UriCodec INSTANCE = new UriCodec();
    private static final char INVALID_INPUT_CHARACTER = '\ufffd';

    private UriCodec() {
    }

    private final int hexCharToValue(char c) {
        boolean bl = '0' <= c ? c < ':' : false;
        if (bl) {
            return c - 48;
        }
        boolean bl2 = 'a' <= c ? c < 'g' : false;
        if (bl2) {
            return 10 + c - 97;
        }
        boolean bl3 = 'A' <= c ? c < 'G' : false;
        if (bl3) {
            return 10 + c - 65;
        }
        return -1;
    }

    private final URISyntaxException unexpectedCharacterException(String uri, String name, char unexpected, int index) {
        String string = name;
        Object nameString = string == null ? "" : " in [" + string + "]";
        return new URISyntaxException(uri, "Unexpected character" + (String)nameString + ": " + unexpected, index);
    }

    private final char getNextCharacter(String uri, int index, int end, String name) throws URISyntaxException {
        if (index >= end) {
            String string = name;
            Object nameString = string == null ? "" : " in [" + string + "]";
            throw new URISyntaxException(uri, "Unexpected end of string" + (String)nameString, index);
        }
        return uri.charAt(index);
    }

    @NotNull
    public final String decode(@NotNull String s, boolean convertPlus, boolean throwOnFailure) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder builder = new StringBuilder(s.length());
        this.appendDecoded(builder, s, convertPlus, throwOnFailure);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String decode$default(UriCodec uriCodec, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return uriCodec.decode(string, bl, bl2);
    }

    private final void appendDecoded(StringBuilder builder, String s, boolean convertPlus, boolean throwOnFailure) {
        int n = 0;
        int n2 = s.length();
        byte[] byArray = new byte[n2];
        while (n < n2) {
            int n3 = n++;
            byArray[n3] = 0;
        }
        byte[] byteBuffer = byArray;
        Ref.IntRef byteBufferPosition = new Ref.IntRef();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            ++i;
            switch (c) {
                case '+': {
                    UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
                    StringBuilder stringBuilder = builder.append(convertPlus ? (char)' ' : '+');
                    break;
                }
                case '%': {
                    byte hexValue = 0;
                    for (int j = 0; j < 2; ++j) {
                        try {
                            c = this.getNextCharacter(s, i, s.length(), null);
                        }
                        catch (URISyntaxException e) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(e);
                            }
                            UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            return;
                        }
                        ++i;
                        int newDigit = this.hexCharToValue(c);
                        if (newDigit < 0) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(this.unexpectedCharacterException(s, null, c, i - 1));
                            }
                            UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            break;
                        }
                        hexValue = (byte)(hexValue * 16 + newDigit);
                    }
                    UriCodec.appendDecoded$put(byteBuffer, byteBufferPosition, hexValue);
                    StringBuilder stringBuilder = Unit.INSTANCE;
                    break;
                }
                default: {
                    UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
                    StringBuilder stringBuilder = builder.append(c);
                }
            }
        }
        UriCodec.appendDecoded$flush(byteBufferPosition, builder, byteBuffer, throwOnFailure);
    }

    private static final void appendDecoded$put(byte[] byteBuffer, Ref.IntRef byteBufferPosition, byte by) {
        int n = byteBufferPosition.element;
        byteBufferPosition.element = n + 1;
        byteBuffer[n] = by;
    }

    private static final void appendDecoded$flush(Ref.IntRef byteBufferPosition, StringBuilder $builder, byte[] byteBuffer, boolean $throwOnFailure) {
        if (byteBufferPosition.element == 0) {
            return;
        }
        $builder.append(StringsKt.decodeToString$default((byte[])byteBuffer, (int)0, (int)byteBufferPosition.element, (boolean)$throwOnFailure, (int)1, null));
        byteBufferPosition.element = 0;
    }
}

