/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.db.networkvalidation.daos;

import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.networkvalidation.daos.NetworkValidationInfoEntityDao;
import world.respect.datalayer.db.networkvalidation.entities.NetworkValidationInfoEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lworld/respect/datalayer/db/networkvalidation/daos/NetworkValidationInfoEntityDao_Impl;", "Lworld/respect/datalayer/db/networkvalidation/daos/NetworkValidationInfoEntityDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfNetworkValidationInfoEntity", "Landroidx/room/EntityInsertAdapter;", "Lworld/respect/datalayer/db/networkvalidation/entities/NetworkValidationInfoEntity;", "upsert", "", "entity", "(Lworld/respect/datalayer/db/networkvalidation/entities/NetworkValidationInfoEntity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLatestVaryHeaderByUrlHash", "", "nviUrlHash", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getValidationInfo", "urlHash", "validationInfoKey", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "respect-datalayer-db_debug"})
public final class NetworkValidationInfoEntityDao_Impl
implements NetworkValidationInfoEntityDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<NetworkValidationInfoEntity> __insertAdapterOfNetworkValidationInfoEntity;

    public NetworkValidationInfoEntityDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__db = __db;
        this.__insertAdapterOfNetworkValidationInfoEntity = (EntityInsertAdapter)new EntityInsertAdapter<NetworkValidationInfoEntity>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `NetworkValidationInfoEntity` (`nviUrlHash`,`nviKey`,`nviVaryHeader`,`nviLastModified`,`nviEtag`,`nviConsistentThrough`,`nviLastChecked`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, NetworkValidationInfoEntity entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindLong(1, entity.getNviUrlHash());
                statement.bindLong(2, entity.getNviKey());
                String _tmpNviVaryHeader = entity.getNviVaryHeader();
                if (_tmpNviVaryHeader == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmpNviVaryHeader);
                }
                statement.bindLong(4, entity.getNviLastModified());
                String _tmpNviEtag = entity.getNviEtag();
                if (_tmpNviEtag == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmpNviEtag);
                }
                statement.bindLong(6, entity.getNviConsistentThrough());
                statement.bindLong(7, entity.getNviLastChecked());
            }
        };
    }

    @Override
    @Nullable
    public Object upsert(@NotNull NetworkValidationInfoEntity entity, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> NetworkValidationInfoEntityDao_Impl.upsert$lambda$0(this, entity, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object getLatestVaryHeaderByUrlHash(long nviUrlHash, @NotNull Continuation<? super String> $completion) {
        String _sql = "\n        SELECT NetworkValidationInfoEntity.nviVaryHeader \n          FROM NetworkValidationInfoEntity\n         WHERE NetworkValidationInfoEntity.nviUrlHash = ?\n      ORDER BY NetworkValidationInfoEntity.nviLastChecked DESC\n         LIMIT 1\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> NetworkValidationInfoEntityDao_Impl.getLatestVaryHeaderByUrlHash$lambda$1(_sql, nviUrlHash, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object getValidationInfo(long urlHash, long validationInfoKey, @NotNull Continuation<? super NetworkValidationInfoEntity> $completion) {
        String _sql = "\n        SELECT NetworkValidationInfoEntity.* \n          FROM NetworkValidationInfoEntity\n         WHERE NetworkValidationInfoEntity.nviUrlHash = ?\n           AND NetworkValidationInfoEntity.nviKey = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> NetworkValidationInfoEntityDao_Impl.getValidationInfo$lambda$2(_sql, urlHash, validationInfoKey, arg_0), $completion);
    }

    private static final Unit upsert$lambda$0(NetworkValidationInfoEntityDao_Impl this$0, NetworkValidationInfoEntity $entity, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfNetworkValidationInfoEntity.insert(_connection, (Object)$entity);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getLatestVaryHeaderByUrlHash$lambda$1(String $_sql, long $nviUrlHash, SQLiteConnection _connection) {
        String string;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $nviUrlHash);
            String _result = null;
            _result = _stmt.step() ? (_stmt.isNull(0) ? null : _stmt.getText(0)) : null;
            string = _result;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NetworkValidationInfoEntity getValidationInfo$lambda$2(String $_sql, long $urlHash, long $validationInfoKey, SQLiteConnection _connection) {
        NetworkValidationInfoEntity networkValidationInfoEntity;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $urlHash);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $validationInfoKey);
            int _columnIndexOfNviUrlHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nviUrlHash");
            int _columnIndexOfNviKey = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nviKey");
            int _columnIndexOfNviVaryHeader = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nviVaryHeader");
            int _columnIndexOfNviLastModified = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nviLastModified");
            int _columnIndexOfNviEtag = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nviEtag");
            int _columnIndexOfNviConsistentThrough = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nviConsistentThrough");
            int _columnIndexOfNviLastChecked = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"nviLastChecked");
            NetworkValidationInfoEntity _result = null;
            if (_stmt.step()) {
                long _tmpNviUrlHash = 0L;
                _tmpNviUrlHash = _stmt.getLong(_columnIndexOfNviUrlHash);
                long _tmpNviKey = 0L;
                _tmpNviKey = _stmt.getLong(_columnIndexOfNviKey);
                String _tmpNviVaryHeader = null;
                _tmpNviVaryHeader = _stmt.isNull(_columnIndexOfNviVaryHeader) ? null : _stmt.getText(_columnIndexOfNviVaryHeader);
                long _tmpNviLastModified = 0L;
                _tmpNviLastModified = _stmt.getLong(_columnIndexOfNviLastModified);
                String _tmpNviEtag = null;
                _tmpNviEtag = _stmt.isNull(_columnIndexOfNviEtag) ? null : _stmt.getText(_columnIndexOfNviEtag);
                long _tmpNviConsistentThrough = 0L;
                _tmpNviConsistentThrough = _stmt.getLong(_columnIndexOfNviConsistentThrough);
                long _tmpNviLastChecked = 0L;
                _tmpNviLastChecked = _stmt.getLong(_columnIndexOfNviLastChecked);
                _result = new NetworkValidationInfoEntity(_tmpNviUrlHash, _tmpNviKey, _tmpNviVaryHeader, _tmpNviLastModified, _tmpNviEtag, _tmpNviConsistentThrough, _tmpNviLastChecked);
            } else {
                _result = null;
            }
            networkValidationInfoEntity = _result;
        }
        return networkValidationInfoEntity;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lworld/respect/datalayer/db/networkvalidation/daos/NetworkValidationInfoEntityDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-datalayer-db_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

