package world.respect.datalayer.db.shared.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.db.shared.entities.LangMapEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class LangMapEntityDao_Impl(
  __db: RoomDatabase,
) : LangMapEntityDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfLangMapEntity: EntityInsertAdapter<LangMapEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfLangMapEntity = object : EntityInsertAdapter<LangMapEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR ABORT INTO `LangMapEntity` (`lmeId`,`lmeTopParentType`,`lmeTopParentUid1`,`lmeTopParentUid2`,`lmePropType`,`lmePropFk`,`lmeLang`,`lmeRegion`,`lmeValue`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: LangMapEntity) {
        statement.bindLong(1, entity.lmeId)
        val _tmp: Int = __sharedConverters.fromLangMapTopParentType(entity.lmeTopParentType)
        statement.bindLong(2, _tmp.toLong())
        statement.bindLong(3, entity.lmeTopParentUid1)
        statement.bindLong(4, entity.lmeTopParentUid2)
        val _tmp_1: Int = __sharedConverters.fromLangMapPropType(entity.lmePropType)
        statement.bindLong(5, _tmp_1.toLong())
        statement.bindLong(6, entity.lmePropFk)
        statement.bindText(7, entity.lmeLang)
        val _tmpLmeRegion: String? = entity.lmeRegion
        if (_tmpLmeRegion == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpLmeRegion)
        }
        statement.bindText(9, entity.lmeValue)
      }
    }
  }

  public override suspend fun insertAsync(entity: List<LangMapEntity>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfLangMapEntity.insert(_connection, entity)
  }

  public override fun selectAllByTopParentType(lmeTopParentType: Int): Flow<List<LangMapEntity>> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM LangMapEntity
        |         WHERE LangMapEntity.lmeTopParentType = ? 
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("LangMapEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, lmeTopParentType.toLong())
        val _columnIndexOfLmeId: Int = getColumnIndexOrThrow(_stmt, "lmeId")
        val _columnIndexOfLmeTopParentType: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentType")
        val _columnIndexOfLmeTopParentUid1: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid1")
        val _columnIndexOfLmeTopParentUid2: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid2")
        val _columnIndexOfLmePropType: Int = getColumnIndexOrThrow(_stmt, "lmePropType")
        val _columnIndexOfLmePropFk: Int = getColumnIndexOrThrow(_stmt, "lmePropFk")
        val _columnIndexOfLmeLang: Int = getColumnIndexOrThrow(_stmt, "lmeLang")
        val _columnIndexOfLmeRegion: Int = getColumnIndexOrThrow(_stmt, "lmeRegion")
        val _columnIndexOfLmeValue: Int = getColumnIndexOrThrow(_stmt, "lmeValue")
        val _result: MutableList<LangMapEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: LangMapEntity
          val _tmpLmeId: Long
          _tmpLmeId = _stmt.getLong(_columnIndexOfLmeId)
          val _tmpLmeTopParentType: LangMapEntity.TopParentType
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfLmeTopParentType).toInt()
          _tmpLmeTopParentType = __sharedConverters.toLangMapTopParentType(_tmp)
          val _tmpLmeTopParentUid1: Long
          _tmpLmeTopParentUid1 = _stmt.getLong(_columnIndexOfLmeTopParentUid1)
          val _tmpLmeTopParentUid2: Long
          _tmpLmeTopParentUid2 = _stmt.getLong(_columnIndexOfLmeTopParentUid2)
          val _tmpLmePropType: LangMapEntity.PropType
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfLmePropType).toInt()
          _tmpLmePropType = __sharedConverters.toLangMapPropType(_tmp_1)
          val _tmpLmePropFk: Long
          _tmpLmePropFk = _stmt.getLong(_columnIndexOfLmePropFk)
          val _tmpLmeLang: String
          _tmpLmeLang = _stmt.getText(_columnIndexOfLmeLang)
          val _tmpLmeRegion: String?
          if (_stmt.isNull(_columnIndexOfLmeRegion)) {
            _tmpLmeRegion = null
          } else {
            _tmpLmeRegion = _stmt.getText(_columnIndexOfLmeRegion)
          }
          val _tmpLmeValue: String
          _tmpLmeValue = _stmt.getText(_columnIndexOfLmeValue)
          _item =
              LangMapEntity(_tmpLmeId,_tmpLmeTopParentType,_tmpLmeTopParentUid1,_tmpLmeTopParentUid2,_tmpLmePropType,_tmpLmePropFk,_tmpLmeLang,_tmpLmeRegion,_tmpLmeValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun selectAllByTableAndEntityId(
    lmeTopParentType: Int,
    lmeEntityUid1: Long,
    lmeEntityUid2: Long,
  ): List<LangMapEntity> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM LangMapEntity
        |         WHERE LangMapEntity.lmeTopParentType = ?
        |           AND LangMapEntity.lmeTopParentUid1 = ?
        |           AND LangMapEntity.lmeTopParentUid2 = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, lmeTopParentType.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, lmeEntityUid1)
        _argIndex = 3
        _stmt.bindLong(_argIndex, lmeEntityUid2)
        val _columnIndexOfLmeId: Int = getColumnIndexOrThrow(_stmt, "lmeId")
        val _columnIndexOfLmeTopParentType: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentType")
        val _columnIndexOfLmeTopParentUid1: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid1")
        val _columnIndexOfLmeTopParentUid2: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid2")
        val _columnIndexOfLmePropType: Int = getColumnIndexOrThrow(_stmt, "lmePropType")
        val _columnIndexOfLmePropFk: Int = getColumnIndexOrThrow(_stmt, "lmePropFk")
        val _columnIndexOfLmeLang: Int = getColumnIndexOrThrow(_stmt, "lmeLang")
        val _columnIndexOfLmeRegion: Int = getColumnIndexOrThrow(_stmt, "lmeRegion")
        val _columnIndexOfLmeValue: Int = getColumnIndexOrThrow(_stmt, "lmeValue")
        val _result: MutableList<LangMapEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: LangMapEntity
          val _tmpLmeId: Long
          _tmpLmeId = _stmt.getLong(_columnIndexOfLmeId)
          val _tmpLmeTopParentType: LangMapEntity.TopParentType
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfLmeTopParentType).toInt()
          _tmpLmeTopParentType = __sharedConverters.toLangMapTopParentType(_tmp)
          val _tmpLmeTopParentUid1: Long
          _tmpLmeTopParentUid1 = _stmt.getLong(_columnIndexOfLmeTopParentUid1)
          val _tmpLmeTopParentUid2: Long
          _tmpLmeTopParentUid2 = _stmt.getLong(_columnIndexOfLmeTopParentUid2)
          val _tmpLmePropType: LangMapEntity.PropType
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfLmePropType).toInt()
          _tmpLmePropType = __sharedConverters.toLangMapPropType(_tmp_1)
          val _tmpLmePropFk: Long
          _tmpLmePropFk = _stmt.getLong(_columnIndexOfLmePropFk)
          val _tmpLmeLang: String
          _tmpLmeLang = _stmt.getText(_columnIndexOfLmeLang)
          val _tmpLmeRegion: String?
          if (_stmt.isNull(_columnIndexOfLmeRegion)) {
            _tmpLmeRegion = null
          } else {
            _tmpLmeRegion = _stmt.getText(_columnIndexOfLmeRegion)
          }
          val _tmpLmeValue: String
          _tmpLmeValue = _stmt.getText(_columnIndexOfLmeValue)
          _item =
              LangMapEntity(_tmpLmeId,_tmpLmeTopParentType,_tmpLmeTopParentUid1,_tmpLmeTopParentUid2,_tmpLmePropType,_tmpLmePropFk,_tmpLmeLang,_tmpLmeRegion,_tmpLmeValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun selectAllByTableAndEntityIdAsFlow(
    lmeTopParentTypeId: Int,
    lmeEntityUid1: Long,
    lmeEntityUid2: Long,
  ): Flow<List<LangMapEntity>> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM LangMapEntity
        |         WHERE LangMapEntity.lmeTopParentType = ?
        |           AND LangMapEntity.lmeTopParentUid1 = ?
        |           AND LangMapEntity.lmeTopParentUid2 = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("LangMapEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, lmeTopParentTypeId.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, lmeEntityUid1)
        _argIndex = 3
        _stmt.bindLong(_argIndex, lmeEntityUid2)
        val _columnIndexOfLmeId: Int = getColumnIndexOrThrow(_stmt, "lmeId")
        val _columnIndexOfLmeTopParentType: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentType")
        val _columnIndexOfLmeTopParentUid1: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid1")
        val _columnIndexOfLmeTopParentUid2: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid2")
        val _columnIndexOfLmePropType: Int = getColumnIndexOrThrow(_stmt, "lmePropType")
        val _columnIndexOfLmePropFk: Int = getColumnIndexOrThrow(_stmt, "lmePropFk")
        val _columnIndexOfLmeLang: Int = getColumnIndexOrThrow(_stmt, "lmeLang")
        val _columnIndexOfLmeRegion: Int = getColumnIndexOrThrow(_stmt, "lmeRegion")
        val _columnIndexOfLmeValue: Int = getColumnIndexOrThrow(_stmt, "lmeValue")
        val _result: MutableList<LangMapEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: LangMapEntity
          val _tmpLmeId: Long
          _tmpLmeId = _stmt.getLong(_columnIndexOfLmeId)
          val _tmpLmeTopParentType: LangMapEntity.TopParentType
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfLmeTopParentType).toInt()
          _tmpLmeTopParentType = __sharedConverters.toLangMapTopParentType(_tmp)
          val _tmpLmeTopParentUid1: Long
          _tmpLmeTopParentUid1 = _stmt.getLong(_columnIndexOfLmeTopParentUid1)
          val _tmpLmeTopParentUid2: Long
          _tmpLmeTopParentUid2 = _stmt.getLong(_columnIndexOfLmeTopParentUid2)
          val _tmpLmePropType: LangMapEntity.PropType
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfLmePropType).toInt()
          _tmpLmePropType = __sharedConverters.toLangMapPropType(_tmp_1)
          val _tmpLmePropFk: Long
          _tmpLmePropFk = _stmt.getLong(_columnIndexOfLmePropFk)
          val _tmpLmeLang: String
          _tmpLmeLang = _stmt.getText(_columnIndexOfLmeLang)
          val _tmpLmeRegion: String?
          if (_stmt.isNull(_columnIndexOfLmeRegion)) {
            _tmpLmeRegion = null
          } else {
            _tmpLmeRegion = _stmt.getText(_columnIndexOfLmeRegion)
          }
          val _tmpLmeValue: String
          _tmpLmeValue = _stmt.getText(_columnIndexOfLmeValue)
          _item =
              LangMapEntity(_tmpLmeId,_tmpLmeTopParentType,_tmpLmeTopParentUid1,_tmpLmeTopParentUid2,_tmpLmePropType,_tmpLmePropFk,_tmpLmeLang,_tmpLmeRegion,_tmpLmeValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findAllByFeedUid(feedUid: Long): List<LangMapEntity> {
    val _sql: String = """
        |
        |        WITH 
        |            FeedPublicationUids(publicationUid) AS(
        |             SELECT OpdsPublicationEntity.opeUid
        |               FROM OpdsPublicationEntity
        |              WHERE OpdsPublicationEntity.opeOfeUid = ? 
        |        )
        |        
        |         
        |        SELECT LangMapEntity.*
        |          FROM LangMapEntity
        |         WHERE 
        |               (    LangMapEntity.lmeTopParentType = 2
        |                AND LangMapEntity.lmeTopParentUid1 = ?)
        |            OR (    LangMapEntity.lmeTopParentType = 3
        |                AND LangMapEntity.lmeTopParentUid1 IN (SELECT publicationUid FROM FeedPublicationUids))    
        |        
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _argIndex = 2
        _stmt.bindLong(_argIndex, feedUid)
        val _columnIndexOfLmeId: Int = getColumnIndexOrThrow(_stmt, "lmeId")
        val _columnIndexOfLmeTopParentType: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentType")
        val _columnIndexOfLmeTopParentUid1: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid1")
        val _columnIndexOfLmeTopParentUid2: Int = getColumnIndexOrThrow(_stmt, "lmeTopParentUid2")
        val _columnIndexOfLmePropType: Int = getColumnIndexOrThrow(_stmt, "lmePropType")
        val _columnIndexOfLmePropFk: Int = getColumnIndexOrThrow(_stmt, "lmePropFk")
        val _columnIndexOfLmeLang: Int = getColumnIndexOrThrow(_stmt, "lmeLang")
        val _columnIndexOfLmeRegion: Int = getColumnIndexOrThrow(_stmt, "lmeRegion")
        val _columnIndexOfLmeValue: Int = getColumnIndexOrThrow(_stmt, "lmeValue")
        val _result: MutableList<LangMapEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: LangMapEntity
          val _tmpLmeId: Long
          _tmpLmeId = _stmt.getLong(_columnIndexOfLmeId)
          val _tmpLmeTopParentType: LangMapEntity.TopParentType
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfLmeTopParentType).toInt()
          _tmpLmeTopParentType = __sharedConverters.toLangMapTopParentType(_tmp)
          val _tmpLmeTopParentUid1: Long
          _tmpLmeTopParentUid1 = _stmt.getLong(_columnIndexOfLmeTopParentUid1)
          val _tmpLmeTopParentUid2: Long
          _tmpLmeTopParentUid2 = _stmt.getLong(_columnIndexOfLmeTopParentUid2)
          val _tmpLmePropType: LangMapEntity.PropType
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfLmePropType).toInt()
          _tmpLmePropType = __sharedConverters.toLangMapPropType(_tmp_1)
          val _tmpLmePropFk: Long
          _tmpLmePropFk = _stmt.getLong(_columnIndexOfLmePropFk)
          val _tmpLmeLang: String
          _tmpLmeLang = _stmt.getText(_columnIndexOfLmeLang)
          val _tmpLmeRegion: String?
          if (_stmt.isNull(_columnIndexOfLmeRegion)) {
            _tmpLmeRegion = null
          } else {
            _tmpLmeRegion = _stmt.getText(_columnIndexOfLmeRegion)
          }
          val _tmpLmeValue: String
          _tmpLmeValue = _stmt.getText(_columnIndexOfLmeValue)
          _item =
              LangMapEntity(_tmpLmeId,_tmpLmeTopParentType,_tmpLmeTopParentUid1,_tmpLmeTopParentUid2,_tmpLmePropType,_tmpLmePropFk,_tmpLmeLang,_tmpLmeRegion,_tmpLmeValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteByTableAndTopParentType(
    lmeTopParentType: Int,
    lmeEntityUid1: Long,
    lmeEntityUid2: Long,
  ) {
    val _sql: String = """
        |
        |        DELETE FROM LangMapEntity
        |         WHERE LangMapEntity.lmeTopParentType = ?
        |           AND LangMapEntity.lmeTopParentUid1 = ?
        |           AND LangMapEntity.lmeTopParentUid2 = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, lmeTopParentType.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, lmeEntityUid1)
        _argIndex = 3
        _stmt.bindLong(_argIndex, lmeEntityUid2)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAllByFeedUid(feedUid: Long) {
    val _sql: String = """
        |
        |        WITH 
        |            FeedPublicationUids(publicationUid) AS(
        |             SELECT OpdsPublicationEntity.opeUid
        |               FROM OpdsPublicationEntity
        |              WHERE OpdsPublicationEntity.opeOfeUid = ? 
        |        )
        |        
        |        
        |      DELETE FROM LangMapEntity
        |       WHERE 
        |               (    LangMapEntity.lmeTopParentType = 2
        |                AND LangMapEntity.lmeTopParentUid1 = ?)
        |            OR (    LangMapEntity.lmeTopParentType = 3
        |                AND LangMapEntity.lmeTopParentUid1 IN (SELECT publicationUid FROM FeedPublicationUids))    
        |        
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _argIndex = 2
        _stmt.bindLong(_argIndex, feedUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
