package world.respect.datalayer.db

import androidx.room.InvalidationTracker
import androidx.room.RoomOpenDelegate
import androidx.room.migration.AutoMigrationSpec
import androidx.room.migration.Migration
import androidx.room.util.TableInfo
import androidx.room.util.TableInfo.Companion.read
import androidx.room.util.dropFtsSyncTriggers
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.execSQL
import javax.`annotation`.processing.Generated
import kotlin.Lazy
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.collections.MutableSet
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf
import kotlin.collections.mutableSetOf
import kotlin.reflect.KClass
import world.respect.datalayer.db.school.daos.AuthTokenEntityDao
import world.respect.datalayer.db.school.daos.AuthTokenEntityDao_Impl
import world.respect.datalayer.db.school.daos.ClazzEntityDao
import world.respect.datalayer.db.school.daos.ClazzEntityDao_Impl
import world.respect.datalayer.db.school.daos.IndicatorEntityDao
import world.respect.datalayer.db.school.daos.IndicatorEntityDao_Impl
import world.respect.datalayer.db.school.daos.PersonEntityDao
import world.respect.datalayer.db.school.daos.PersonEntityDao_Impl
import world.respect.datalayer.db.school.daos.PersonPasswordEntityDao
import world.respect.datalayer.db.school.daos.PersonPasswordEntityDao_Impl
import world.respect.datalayer.db.school.daos.PersonRoleEntityDao
import world.respect.datalayer.db.school.daos.PersonRoleEntityDao_Impl
import world.respect.datalayer.db.school.daos.ReportEntityDao
import world.respect.datalayer.db.school.daos.ReportEntityDao_Impl

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RespectSchoolDatabase_Impl : RespectSchoolDatabase() {
  private val _personEntityDao: Lazy<PersonEntityDao> = lazy {
    PersonEntityDao_Impl(this)
  }

  private val _personPasswordEntityDao: Lazy<PersonPasswordEntityDao> = lazy {
    PersonPasswordEntityDao_Impl(this)
  }

  private val _authTokenEntityDao: Lazy<AuthTokenEntityDao> = lazy {
    AuthTokenEntityDao_Impl(this)
  }

  private val _personRoleEntityDao: Lazy<PersonRoleEntityDao> = lazy {
    PersonRoleEntityDao_Impl(this)
  }

  private val _reportEntityDao: Lazy<ReportEntityDao> = lazy {
    ReportEntityDao_Impl(this)
  }

  private val _indicatorEntityDao: Lazy<IndicatorEntityDao> = lazy {
    IndicatorEntityDao_Impl(this)
  }

  private val _clazzEntityDao: Lazy<ClazzEntityDao> = lazy {
    ClazzEntityDao_Impl(this)
  }

  protected override fun createOpenDelegate(): RoomOpenDelegate {
    val _openDelegate: RoomOpenDelegate = object : RoomOpenDelegate(1,
        "f373ca458fdd6b9e0952b5370e7bca89", "cafe2f5b3f9adf6d4f6e77df5bf6b56f") {
      public override fun createAllTables(connection: SQLiteConnection) {
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonEntity` (`pGuid` TEXT NOT NULL, `pGuidHash` INTEGER NOT NULL, `pActive` INTEGER NOT NULL, `pStatus` INTEGER NOT NULL, `pLastModified` INTEGER NOT NULL, `pStored` INTEGER NOT NULL, `pUsername` TEXT, `pGivenName` TEXT NOT NULL, `pFamilyName` TEXT NOT NULL, `pMiddleName` TEXT, PRIMARY KEY(`pGuidHash`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonRoleEntity` (`prUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `prPersonGuidHash` INTEGER NOT NULL, `prIsPrimaryRole` INTEGER NOT NULL, `prRoleEnum` INTEGER NOT NULL, `prBeginDate` INTEGER, `prEndDate` INTEGER)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonPasswordEntity` (`pppGuid` INTEGER NOT NULL, `authAlgorithm` TEXT NOT NULL, `authEncoded` TEXT NOT NULL, `authSalt` TEXT NOT NULL, `authIterations` INTEGER NOT NULL, `authKeyLen` INTEGER NOT NULL, PRIMARY KEY(`pppGuid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `AuthTokenEntity` (`atUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `atPGuidHash` INTEGER NOT NULL, `atPGuid` TEXT NOT NULL, `atCode` TEXT, `atToken` TEXT NOT NULL, `atTimeCreated` INTEGER NOT NULL, `atTtl` INTEGER NOT NULL)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `ReportEntity` (`rGuid` TEXT NOT NULL, `rOwnerGuid` TEXT NOT NULL, `rTitle` TEXT NOT NULL, `rOptions` TEXT NOT NULL, `rIsTemplate` INTEGER NOT NULL, `rActive` INTEGER NOT NULL, `rLastModified` INTEGER NOT NULL, `rStored` INTEGER NOT NULL, PRIMARY KEY(`rGuid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `IndicatorEntity` (`indicatorId` TEXT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL, `type` TEXT NOT NULL, `sql` TEXT NOT NULL, PRIMARY KEY(`indicatorId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `ClassEntity` (`cGuid` TEXT NOT NULL, `cGuidHash` INTEGER NOT NULL, `cTitle` TEXT NOT NULL, `cStatus` INTEGER NOT NULL, `cDescription` TEXT, `cLastModified` INTEGER NOT NULL, `cStored` INTEGER NOT NULL, `cTeacherInviteCode` TEXT, `cStudentInviteCode` TEXT, PRIMARY KEY(`cGuidHash`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)")
        connection.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'f373ca458fdd6b9e0952b5370e7bca89')")
      }

      public override fun dropAllTables(connection: SQLiteConnection) {
        connection.execSQL("DROP TABLE IF EXISTS `PersonEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `PersonRoleEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `PersonPasswordEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `AuthTokenEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `ReportEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `IndicatorEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `ClassEntity`")
      }

      public override fun onCreate(connection: SQLiteConnection) {
      }

      public override fun onOpen(connection: SQLiteConnection) {
        internalInitInvalidationTracker(connection)
      }

      public override fun onPreMigrate(connection: SQLiteConnection) {
        dropFtsSyncTriggers(connection)
      }

      public override fun onPostMigrate(connection: SQLiteConnection) {
      }

      public override fun onValidateSchema(connection: SQLiteConnection):
          RoomOpenDelegate.ValidationResult {
        val _columnsPersonEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonEntity.put("pGuid", TableInfo.Column("pGuid", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pGuidHash", TableInfo.Column("pGuidHash", "INTEGER", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pActive", TableInfo.Column("pActive", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pStatus", TableInfo.Column("pStatus", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pLastModified", TableInfo.Column("pLastModified", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pStored", TableInfo.Column("pStored", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pUsername", TableInfo.Column("pUsername", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pGivenName", TableInfo.Column("pGivenName", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pFamilyName", TableInfo.Column("pFamilyName", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pMiddleName", TableInfo.Column("pMiddleName", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonEntity: TableInfo = TableInfo("PersonEntity", _columnsPersonEntity,
            _foreignKeysPersonEntity, _indicesPersonEntity)
        val _existingPersonEntity: TableInfo = read(connection, "PersonEntity")
        if (!_infoPersonEntity.equals(_existingPersonEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonEntity(world.respect.datalayer.db.school.entities.PersonEntity).
              | Expected:
              |""".trimMargin() + _infoPersonEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonEntity)
        }
        val _columnsPersonRoleEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonRoleEntity.put("prUid", TableInfo.Column("prUid", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prPersonGuidHash", TableInfo.Column("prPersonGuidHash",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prIsPrimaryRole", TableInfo.Column("prIsPrimaryRole",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prRoleEnum", TableInfo.Column("prRoleEnum", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prBeginDate", TableInfo.Column("prBeginDate", "INTEGER",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prEndDate", TableInfo.Column("prEndDate", "INTEGER", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonRoleEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonRoleEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonRoleEntity: TableInfo = TableInfo("PersonRoleEntity",
            _columnsPersonRoleEntity, _foreignKeysPersonRoleEntity, _indicesPersonRoleEntity)
        val _existingPersonRoleEntity: TableInfo = read(connection, "PersonRoleEntity")
        if (!_infoPersonRoleEntity.equals(_existingPersonRoleEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonRoleEntity(world.respect.datalayer.db.school.entities.PersonRoleEntity).
              | Expected:
              |""".trimMargin() + _infoPersonRoleEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonRoleEntity)
        }
        val _columnsPersonPasswordEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonPasswordEntity.put("pppGuid", TableInfo.Column("pppGuid", "INTEGER", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authAlgorithm", TableInfo.Column("authAlgorithm", "TEXT",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authEncoded", TableInfo.Column("authEncoded", "TEXT",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authSalt", TableInfo.Column("authSalt", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authIterations", TableInfo.Column("authIterations",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authKeyLen", TableInfo.Column("authKeyLen", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonPasswordEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonPasswordEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonPasswordEntity: TableInfo = TableInfo("PersonPasswordEntity",
            _columnsPersonPasswordEntity, _foreignKeysPersonPasswordEntity,
            _indicesPersonPasswordEntity)
        val _existingPersonPasswordEntity: TableInfo = read(connection, "PersonPasswordEntity")
        if (!_infoPersonPasswordEntity.equals(_existingPersonPasswordEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonPasswordEntity(world.respect.datalayer.db.school.entities.PersonPasswordEntity).
              | Expected:
              |""".trimMargin() + _infoPersonPasswordEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonPasswordEntity)
        }
        val _columnsAuthTokenEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsAuthTokenEntity.put("atUid", TableInfo.Column("atUid", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atPGuidHash", TableInfo.Column("atPGuidHash", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atPGuid", TableInfo.Column("atPGuid", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atCode", TableInfo.Column("atCode", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atToken", TableInfo.Column("atToken", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atTimeCreated", TableInfo.Column("atTimeCreated", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atTtl", TableInfo.Column("atTtl", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysAuthTokenEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesAuthTokenEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoAuthTokenEntity: TableInfo = TableInfo("AuthTokenEntity", _columnsAuthTokenEntity,
            _foreignKeysAuthTokenEntity, _indicesAuthTokenEntity)
        val _existingAuthTokenEntity: TableInfo = read(connection, "AuthTokenEntity")
        if (!_infoAuthTokenEntity.equals(_existingAuthTokenEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |AuthTokenEntity(world.respect.datalayer.db.school.entities.AuthTokenEntity).
              | Expected:
              |""".trimMargin() + _infoAuthTokenEntity + """
              |
              | Found:
              |""".trimMargin() + _existingAuthTokenEntity)
        }
        val _columnsReportEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsReportEntity.put("rGuid", TableInfo.Column("rGuid", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rOwnerGuid", TableInfo.Column("rOwnerGuid", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rTitle", TableInfo.Column("rTitle", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rOptions", TableInfo.Column("rOptions", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rIsTemplate", TableInfo.Column("rIsTemplate", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rActive", TableInfo.Column("rActive", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rLastModified", TableInfo.Column("rLastModified", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rStored", TableInfo.Column("rStored", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysReportEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesReportEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoReportEntity: TableInfo = TableInfo("ReportEntity", _columnsReportEntity,
            _foreignKeysReportEntity, _indicesReportEntity)
        val _existingReportEntity: TableInfo = read(connection, "ReportEntity")
        if (!_infoReportEntity.equals(_existingReportEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |ReportEntity(world.respect.datalayer.db.school.entities.ReportEntity).
              | Expected:
              |""".trimMargin() + _infoReportEntity + """
              |
              | Found:
              |""".trimMargin() + _existingReportEntity)
        }
        val _columnsIndicatorEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsIndicatorEntity.put("indicatorId", TableInfo.Column("indicatorId", "TEXT", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("name", TableInfo.Column("name", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("description", TableInfo.Column("description", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("type", TableInfo.Column("type", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("sql", TableInfo.Column("sql", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysIndicatorEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesIndicatorEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoIndicatorEntity: TableInfo = TableInfo("IndicatorEntity", _columnsIndicatorEntity,
            _foreignKeysIndicatorEntity, _indicesIndicatorEntity)
        val _existingIndicatorEntity: TableInfo = read(connection, "IndicatorEntity")
        if (!_infoIndicatorEntity.equals(_existingIndicatorEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |IndicatorEntity(world.respect.datalayer.db.realm.entities.IndicatorEntity).
              | Expected:
              |""".trimMargin() + _infoIndicatorEntity + """
              |
              | Found:
              |""".trimMargin() + _existingIndicatorEntity)
        }
        val _columnsClassEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsClassEntity.put("cGuid", TableInfo.Column("cGuid", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cGuidHash", TableInfo.Column("cGuidHash", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cTitle", TableInfo.Column("cTitle", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cStatus", TableInfo.Column("cStatus", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cDescription", TableInfo.Column("cDescription", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cLastModified", TableInfo.Column("cLastModified", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cStored", TableInfo.Column("cStored", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cTeacherInviteCode", TableInfo.Column("cTeacherInviteCode", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cStudentInviteCode", TableInfo.Column("cStudentInviteCode", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysClassEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesClassEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoClassEntity: TableInfo = TableInfo("ClassEntity", _columnsClassEntity,
            _foreignKeysClassEntity, _indicesClassEntity)
        val _existingClassEntity: TableInfo = read(connection, "ClassEntity")
        if (!_infoClassEntity.equals(_existingClassEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |ClassEntity(world.respect.datalayer.db.school.entities.ClassEntity).
              | Expected:
              |""".trimMargin() + _infoClassEntity + """
              |
              | Found:
              |""".trimMargin() + _existingClassEntity)
        }
        return RoomOpenDelegate.ValidationResult(true, null)
      }
    }
    return _openDelegate
  }

  protected override fun createInvalidationTracker(): InvalidationTracker {
    val _shadowTablesMap: MutableMap<String, String> = mutableMapOf()
    val _viewTables: MutableMap<String, Set<String>> = mutableMapOf()
    return InvalidationTracker(this, _shadowTablesMap, _viewTables, "PersonEntity",
        "PersonRoleEntity", "PersonPasswordEntity", "AuthTokenEntity", "ReportEntity",
        "IndicatorEntity", "ClassEntity")
  }

  public override fun clearAllTables() {
    super.performClear(false, "PersonEntity", "PersonRoleEntity", "PersonPasswordEntity",
        "AuthTokenEntity", "ReportEntity", "IndicatorEntity", "ClassEntity")
  }

  protected override fun getRequiredTypeConverterClasses(): Map<KClass<*>, List<KClass<*>>> {
    val _typeConvertersMap: MutableMap<KClass<*>, List<KClass<*>>> = mutableMapOf()
    _typeConvertersMap.put(PersonEntityDao::class, PersonEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(PersonPasswordEntityDao::class,
        PersonPasswordEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(AuthTokenEntityDao::class,
        AuthTokenEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(PersonRoleEntityDao::class,
        PersonRoleEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(ReportEntityDao::class, ReportEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(IndicatorEntityDao::class,
        IndicatorEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(ClazzEntityDao::class, ClazzEntityDao_Impl.getRequiredConverters())
    return _typeConvertersMap
  }

  public override fun getRequiredAutoMigrationSpecClasses(): Set<KClass<out AutoMigrationSpec>> {
    val _autoMigrationSpecsSet: MutableSet<KClass<out AutoMigrationSpec>> = mutableSetOf()
    return _autoMigrationSpecsSet
  }

  public override
      fun createAutoMigrations(autoMigrationSpecs: Map<KClass<out AutoMigrationSpec>, AutoMigrationSpec>):
      List<Migration> {
    val _autoMigrations: MutableList<Migration> = mutableListOf()
    return _autoMigrations
  }

  public override fun getPersonEntityDao(): PersonEntityDao = _personEntityDao.value

  public override fun getPersonPasswordEntityDao(): PersonPasswordEntityDao =
      _personPasswordEntityDao.value

  public override fun getAuthTokenEntityDao(): AuthTokenEntityDao = _authTokenEntityDao.value

  public override fun getPersonRoleEntityDao(): PersonRoleEntityDao = _personRoleEntityDao.value

  public override fun getReportEntityDao(): ReportEntityDao = _reportEntityDao.value

  public override fun getIndicatorEntityDao(): IndicatorEntityDao = _indicatorEntityDao.value

  public override fun getClassEntityDao(): ClazzEntityDao = _clazzEntityDao.value
}
