package world.respect.datalayer.db.compatibleapps.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.compatibleapps.entities.CompatibleAppAddJoin

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class CompatibleAppAddJoinDao_Impl(
  __db: RoomDatabase,
) : CompatibleAppAddJoinDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfCompatibleAppAddJoin: EntityInsertAdapter<CompatibleAppAddJoin>
  init {
    this.__db = __db
    this.__insertAdapterOfCompatibleAppAddJoin = object :
        EntityInsertAdapter<CompatibleAppAddJoin>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `CompatibleAppAddJoin` (`appCaeUid`,`added`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: CompatibleAppAddJoin) {
        statement.bindLong(1, entity.appCaeUid)
        val _tmp: Int = if (entity.added) 1 else 0
        statement.bindLong(2, _tmp.toLong())
      }
    }
  }

  public override suspend fun upsert(compatibleAppAddJoin: CompatibleAppAddJoin): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfCompatibleAppAddJoin.insert(_connection, compatibleAppAddJoin)
  }

  public override fun getCompatibleAppAddJoinAsFlow(caeUid: Long): Flow<CompatibleAppAddJoin?> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM CompatibleAppAddJoin
        |         WHERE appCaeUid = ? 
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("CompatibleAppAddJoin")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, caeUid)
        val _columnIndexOfAppCaeUid: Int = getColumnIndexOrThrow(_stmt, "appCaeUid")
        val _columnIndexOfAdded: Int = getColumnIndexOrThrow(_stmt, "added")
        val _result: CompatibleAppAddJoin?
        if (_stmt.step()) {
          val _tmpAppCaeUid: Long
          _tmpAppCaeUid = _stmt.getLong(_columnIndexOfAppCaeUid)
          val _tmpAdded: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfAdded).toInt()
          _tmpAdded = _tmp != 0
          _result = CompatibleAppAddJoin(_tmpAppCaeUid,_tmpAdded)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
