package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.school.entities.AuthTokenEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class AuthTokenEntityDao_Impl(
  __db: RoomDatabase,
) : AuthTokenEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfAuthTokenEntity: EntityInsertAdapter<AuthTokenEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfAuthTokenEntity = object : EntityInsertAdapter<AuthTokenEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR ABORT INTO `AuthTokenEntity` (`atUid`,`atPGuidHash`,`atPGuid`,`atCode`,`atToken`,`atTimeCreated`,`atTtl`) VALUES (nullif(?, 0),?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: AuthTokenEntity) {
        statement.bindLong(1, entity.atUid)
        statement.bindLong(2, entity.atPGuidHash)
        statement.bindText(3, entity.atPGuid)
        val _tmpAtCode: String? = entity.atCode
        if (_tmpAtCode == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmpAtCode)
        }
        statement.bindText(5, entity.atToken)
        statement.bindLong(6, entity.atTimeCreated)
        statement.bindLong(7, entity.atTtl.toLong())
      }
    }
  }

  public override suspend fun insert(token: AuthTokenEntity): Unit = performSuspending(__db, false,
      true) { _connection ->
    __insertAdapterOfAuthTokenEntity.insert(_connection, token)
  }

  public override suspend fun findByToken(token: String, timeNow: Long): AuthTokenEntity? {
    val _sql: String = """
        |
        |        SELECT AuthTokenEntity.*
        |          FROM AuthTokenEntity
        |         WHERE AuthTokenEntity.atToken = ?
        |           AND ? BETWEEN AuthTokenEntity.atTimeCreated 
        |                            AND (AuthTokenEntity.atTimeCreated + (AuthTokenEntity.atTtl * 1000))
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, token)
        _argIndex = 2
        _stmt.bindLong(_argIndex, timeNow)
        val _columnIndexOfAtUid: Int = getColumnIndexOrThrow(_stmt, "atUid")
        val _columnIndexOfAtPGuidHash: Int = getColumnIndexOrThrow(_stmt, "atPGuidHash")
        val _columnIndexOfAtPGuid: Int = getColumnIndexOrThrow(_stmt, "atPGuid")
        val _columnIndexOfAtCode: Int = getColumnIndexOrThrow(_stmt, "atCode")
        val _columnIndexOfAtToken: Int = getColumnIndexOrThrow(_stmt, "atToken")
        val _columnIndexOfAtTimeCreated: Int = getColumnIndexOrThrow(_stmt, "atTimeCreated")
        val _columnIndexOfAtTtl: Int = getColumnIndexOrThrow(_stmt, "atTtl")
        val _result: AuthTokenEntity?
        if (_stmt.step()) {
          val _tmpAtUid: Long
          _tmpAtUid = _stmt.getLong(_columnIndexOfAtUid)
          val _tmpAtPGuidHash: Long
          _tmpAtPGuidHash = _stmt.getLong(_columnIndexOfAtPGuidHash)
          val _tmpAtPGuid: String
          _tmpAtPGuid = _stmt.getText(_columnIndexOfAtPGuid)
          val _tmpAtCode: String?
          if (_stmt.isNull(_columnIndexOfAtCode)) {
            _tmpAtCode = null
          } else {
            _tmpAtCode = _stmt.getText(_columnIndexOfAtCode)
          }
          val _tmpAtToken: String
          _tmpAtToken = _stmt.getText(_columnIndexOfAtToken)
          val _tmpAtTimeCreated: Long
          _tmpAtTimeCreated = _stmt.getLong(_columnIndexOfAtTimeCreated)
          val _tmpAtTtl: Int
          _tmpAtTtl = _stmt.getLong(_columnIndexOfAtTtl).toInt()
          _result =
              AuthTokenEntity(_tmpAtUid,_tmpAtPGuidHash,_tmpAtPGuid,_tmpAtCode,_tmpAtToken,_tmpAtTimeCreated,_tmpAtTtl)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
