package world.respect.datalayer.db.school.daos

import androidx.collection.LongSparseArray
import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndex
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.room.util.recursiveFetchLongSparseArray
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import kotlinx.coroutines.flow.Flow
import kotlinx.datetime.LocalDate
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.PersonEntity
import world.respect.datalayer.db.school.entities.PersonEntityWithRoles
import world.respect.datalayer.db.school.entities.PersonRoleEntity
import world.respect.datalayer.school.model.PersonRoleEnum
import world.respect.datalayer.school.model.StatusEnum
import world.respect.datalayer.school.model.composites.PersonListDetails

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PersonEntityDao_Impl(
  __db: RoomDatabase,
) : PersonEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfPersonEntity: EntityInsertAdapter<PersonEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfPersonEntity = object : EntityInsertAdapter<PersonEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `PersonEntity` (`pGuid`,`pGuidHash`,`pActive`,`pStatus`,`pLastModified`,`pStored`,`pUsername`,`pGivenName`,`pFamilyName`,`pMiddleName`) VALUES (?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PersonEntity) {
        statement.bindText(1, entity.pGuid)
        statement.bindLong(2, entity.pGuidHash)
        val _tmp: Int = if (entity.pActive) 1 else 0
        statement.bindLong(3, _tmp.toLong())
        val _tmp_1: Int = __schoolTypeConverters.fromStatusEnum(entity.pStatus)
        statement.bindLong(4, _tmp_1.toLong())
        statement.bindLong(5, entity.pLastModified)
        statement.bindLong(6, entity.pStored)
        val _tmpPUsername: String? = entity.pUsername
        if (_tmpPUsername == null) {
          statement.bindNull(7)
        } else {
          statement.bindText(7, _tmpPUsername)
        }
        statement.bindText(8, entity.pGivenName)
        statement.bindText(9, entity.pFamilyName)
        val _tmpPMiddleName: String? = entity.pMiddleName
        if (_tmpPMiddleName == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmpPMiddleName)
        }
      }
    }
  }

  public override suspend fun insert(personEntity: PersonEntity): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfPersonEntity.insert(_connection, personEntity)
  }

  public override suspend fun getLastModifiedByGuid(guidHash: Long): Long? {
    val _sql: String = """
        |
        |        SELECT PersonEntity.pLastModified
        |          FROM PersonEntity
        |         WHERE PersonEntity.pGuidHash = ?
        |         LIMIT 1
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _result: Long?
        if (_stmt.step()) {
          if (_stmt.isNull(0)) {
            _result = null
          } else {
            _result = _stmt.getLong(0)
          }
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByUsername(username: String): PersonEntityWithRoles? {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM PersonEntity
        |        WHERE pUsername = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, username)
        val _columnIndexOfPGuid: Int = getColumnIndexOrThrow(_stmt, "pGuid")
        val _columnIndexOfPGuidHash: Int = getColumnIndexOrThrow(_stmt, "pGuidHash")
        val _columnIndexOfPActive: Int = getColumnIndexOrThrow(_stmt, "pActive")
        val _columnIndexOfPStatus: Int = getColumnIndexOrThrow(_stmt, "pStatus")
        val _columnIndexOfPLastModified: Int = getColumnIndexOrThrow(_stmt, "pLastModified")
        val _columnIndexOfPStored: Int = getColumnIndexOrThrow(_stmt, "pStored")
        val _columnIndexOfPUsername: Int = getColumnIndexOrThrow(_stmt, "pUsername")
        val _columnIndexOfPGivenName: Int = getColumnIndexOrThrow(_stmt, "pGivenName")
        val _columnIndexOfPFamilyName: Int = getColumnIndexOrThrow(_stmt, "pFamilyName")
        val _columnIndexOfPMiddleName: Int = getColumnIndexOrThrow(_stmt, "pMiddleName")
        val _collectionRoles: LongSparseArray<MutableList<PersonRoleEntity>> =
            LongSparseArray<MutableList<PersonRoleEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash)
          if (!_collectionRoles.containsKey(_tmpKey)) {
            _collectionRoles.put(_tmpKey, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection,
            _collectionRoles)
        val _result: PersonEntityWithRoles?
        if (_stmt.step()) {
          val _tmpPerson: PersonEntity
          val _tmpPGuid: String
          _tmpPGuid = _stmt.getText(_columnIndexOfPGuid)
          val _tmpPGuidHash: Long
          _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash)
          val _tmpPActive: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfPActive).toInt()
          _tmpPActive = _tmp != 0
          val _tmpPStatus: StatusEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfPStatus).toInt()
          _tmpPStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
          val _tmpPLastModified: Long
          _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified)
          val _tmpPStored: Long
          _tmpPStored = _stmt.getLong(_columnIndexOfPStored)
          val _tmpPUsername: String?
          if (_stmt.isNull(_columnIndexOfPUsername)) {
            _tmpPUsername = null
          } else {
            _tmpPUsername = _stmt.getText(_columnIndexOfPUsername)
          }
          val _tmpPGivenName: String
          _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName)
          val _tmpPFamilyName: String
          _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName)
          val _tmpPMiddleName: String?
          if (_stmt.isNull(_columnIndexOfPMiddleName)) {
            _tmpPMiddleName = null
          } else {
            _tmpPMiddleName = _stmt.getText(_columnIndexOfPMiddleName)
          }
          _tmpPerson =
              PersonEntity(_tmpPGuid,_tmpPGuidHash,_tmpPActive,_tmpPStatus,_tmpPLastModified,_tmpPStored,_tmpPUsername,_tmpPGivenName,_tmpPFamilyName,_tmpPMiddleName)
          val _tmpRolesCollection: MutableList<PersonRoleEntity>
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash)
          _tmpRolesCollection = checkNotNull(_collectionRoles.get(_tmpKey_1))
          _result = PersonEntityWithRoles(_tmpPerson,_tmpRolesCollection)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuidHash(guidHash: Long): PersonEntityWithRoles? {
    val _sql: String = """
        |
        |       SELECT * 
        |         FROM PersonEntity
        |        WHERE pGuidHash = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfPGuid: Int = getColumnIndexOrThrow(_stmt, "pGuid")
        val _columnIndexOfPGuidHash: Int = getColumnIndexOrThrow(_stmt, "pGuidHash")
        val _columnIndexOfPActive: Int = getColumnIndexOrThrow(_stmt, "pActive")
        val _columnIndexOfPStatus: Int = getColumnIndexOrThrow(_stmt, "pStatus")
        val _columnIndexOfPLastModified: Int = getColumnIndexOrThrow(_stmt, "pLastModified")
        val _columnIndexOfPStored: Int = getColumnIndexOrThrow(_stmt, "pStored")
        val _columnIndexOfPUsername: Int = getColumnIndexOrThrow(_stmt, "pUsername")
        val _columnIndexOfPGivenName: Int = getColumnIndexOrThrow(_stmt, "pGivenName")
        val _columnIndexOfPFamilyName: Int = getColumnIndexOrThrow(_stmt, "pFamilyName")
        val _columnIndexOfPMiddleName: Int = getColumnIndexOrThrow(_stmt, "pMiddleName")
        val _collectionRoles: LongSparseArray<MutableList<PersonRoleEntity>> =
            LongSparseArray<MutableList<PersonRoleEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash)
          if (!_collectionRoles.containsKey(_tmpKey)) {
            _collectionRoles.put(_tmpKey, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection,
            _collectionRoles)
        val _result: PersonEntityWithRoles?
        if (_stmt.step()) {
          val _tmpPerson: PersonEntity
          val _tmpPGuid: String
          _tmpPGuid = _stmt.getText(_columnIndexOfPGuid)
          val _tmpPGuidHash: Long
          _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash)
          val _tmpPActive: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfPActive).toInt()
          _tmpPActive = _tmp != 0
          val _tmpPStatus: StatusEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfPStatus).toInt()
          _tmpPStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
          val _tmpPLastModified: Long
          _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified)
          val _tmpPStored: Long
          _tmpPStored = _stmt.getLong(_columnIndexOfPStored)
          val _tmpPUsername: String?
          if (_stmt.isNull(_columnIndexOfPUsername)) {
            _tmpPUsername = null
          } else {
            _tmpPUsername = _stmt.getText(_columnIndexOfPUsername)
          }
          val _tmpPGivenName: String
          _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName)
          val _tmpPFamilyName: String
          _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName)
          val _tmpPMiddleName: String?
          if (_stmt.isNull(_columnIndexOfPMiddleName)) {
            _tmpPMiddleName = null
          } else {
            _tmpPMiddleName = _stmt.getText(_columnIndexOfPMiddleName)
          }
          _tmpPerson =
              PersonEntity(_tmpPGuid,_tmpPGuidHash,_tmpPActive,_tmpPStatus,_tmpPLastModified,_tmpPStored,_tmpPUsername,_tmpPGivenName,_tmpPFamilyName,_tmpPMiddleName)
          val _tmpRolesCollection: MutableList<PersonRoleEntity>
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash)
          _tmpRolesCollection = checkNotNull(_collectionRoles.get(_tmpKey_1))
          _result = PersonEntityWithRoles(_tmpPerson,_tmpRolesCollection)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByGuidHashAsFlow(guidHash: Long): Flow<PersonEntityWithRoles?> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM PersonEntity
        |        WHERE pGuidHash = ?
        |    
        """.trimMargin()
    return createFlow(__db, true, arrayOf("PersonRoleEntity", "PersonEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfPGuid: Int = getColumnIndexOrThrow(_stmt, "pGuid")
        val _columnIndexOfPGuidHash: Int = getColumnIndexOrThrow(_stmt, "pGuidHash")
        val _columnIndexOfPActive: Int = getColumnIndexOrThrow(_stmt, "pActive")
        val _columnIndexOfPStatus: Int = getColumnIndexOrThrow(_stmt, "pStatus")
        val _columnIndexOfPLastModified: Int = getColumnIndexOrThrow(_stmt, "pLastModified")
        val _columnIndexOfPStored: Int = getColumnIndexOrThrow(_stmt, "pStored")
        val _columnIndexOfPUsername: Int = getColumnIndexOrThrow(_stmt, "pUsername")
        val _columnIndexOfPGivenName: Int = getColumnIndexOrThrow(_stmt, "pGivenName")
        val _columnIndexOfPFamilyName: Int = getColumnIndexOrThrow(_stmt, "pFamilyName")
        val _columnIndexOfPMiddleName: Int = getColumnIndexOrThrow(_stmt, "pMiddleName")
        val _collectionRoles: LongSparseArray<MutableList<PersonRoleEntity>> =
            LongSparseArray<MutableList<PersonRoleEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash)
          if (!_collectionRoles.containsKey(_tmpKey)) {
            _collectionRoles.put(_tmpKey, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection,
            _collectionRoles)
        val _result: PersonEntityWithRoles?
        if (_stmt.step()) {
          val _tmpPerson: PersonEntity
          val _tmpPGuid: String
          _tmpPGuid = _stmt.getText(_columnIndexOfPGuid)
          val _tmpPGuidHash: Long
          _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash)
          val _tmpPActive: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfPActive).toInt()
          _tmpPActive = _tmp != 0
          val _tmpPStatus: StatusEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfPStatus).toInt()
          _tmpPStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
          val _tmpPLastModified: Long
          _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified)
          val _tmpPStored: Long
          _tmpPStored = _stmt.getLong(_columnIndexOfPStored)
          val _tmpPUsername: String?
          if (_stmt.isNull(_columnIndexOfPUsername)) {
            _tmpPUsername = null
          } else {
            _tmpPUsername = _stmt.getText(_columnIndexOfPUsername)
          }
          val _tmpPGivenName: String
          _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName)
          val _tmpPFamilyName: String
          _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName)
          val _tmpPMiddleName: String?
          if (_stmt.isNull(_columnIndexOfPMiddleName)) {
            _tmpPMiddleName = null
          } else {
            _tmpPMiddleName = _stmt.getText(_columnIndexOfPMiddleName)
          }
          _tmpPerson =
              PersonEntity(_tmpPGuid,_tmpPGuidHash,_tmpPActive,_tmpPStatus,_tmpPLastModified,_tmpPStored,_tmpPUsername,_tmpPGivenName,_tmpPFamilyName,_tmpPMiddleName)
          val _tmpRolesCollection: MutableList<PersonRoleEntity>
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash)
          _tmpRolesCollection = checkNotNull(_collectionRoles.get(_tmpKey_1))
          _result = PersonEntityWithRoles(_tmpPerson,_tmpRolesCollection)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllListDetailsAsFlow(): Flow<List<PersonListDetails>> {
    val _sql: String = """
        |
        |        SELECT PersonEntity.pGuid AS guid, 
        |               PersonEntity.pGivenName AS givenName, 
        |               PersonEntity.pFamilyName AS familyName, 
        |               PersonEntity.pUsername AS username
        |          FROM PersonEntity
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("PersonEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfGuid: Int = 0
        val _columnIndexOfGivenName: Int = 1
        val _columnIndexOfFamilyName: Int = 2
        val _columnIndexOfUsername: Int = 3
        val _result: MutableList<PersonListDetails> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonListDetails
          val _tmpGuid: String
          _tmpGuid = _stmt.getText(_columnIndexOfGuid)
          val _tmpGivenName: String
          _tmpGivenName = _stmt.getText(_columnIndexOfGivenName)
          val _tmpFamilyName: String
          _tmpFamilyName = _stmt.getText(_columnIndexOfFamilyName)
          val _tmpUsername: String?
          if (_stmt.isNull(_columnIndexOfUsername)) {
            _tmpUsername = null
          } else {
            _tmpUsername = _stmt.getText(_columnIndexOfUsername)
          }
          _item = PersonListDetails(_tmpGuid,_tmpGivenName,_tmpFamilyName,_tmpUsername)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllAsFlow(): Flow<List<PersonEntityWithRoles>> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM PersonEntity
        |    
        """.trimMargin()
    return createFlow(__db, true, arrayOf("PersonRoleEntity", "PersonEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfPGuid: Int = getColumnIndexOrThrow(_stmt, "pGuid")
        val _columnIndexOfPGuidHash: Int = getColumnIndexOrThrow(_stmt, "pGuidHash")
        val _columnIndexOfPActive: Int = getColumnIndexOrThrow(_stmt, "pActive")
        val _columnIndexOfPStatus: Int = getColumnIndexOrThrow(_stmt, "pStatus")
        val _columnIndexOfPLastModified: Int = getColumnIndexOrThrow(_stmt, "pLastModified")
        val _columnIndexOfPStored: Int = getColumnIndexOrThrow(_stmt, "pStored")
        val _columnIndexOfPUsername: Int = getColumnIndexOrThrow(_stmt, "pUsername")
        val _columnIndexOfPGivenName: Int = getColumnIndexOrThrow(_stmt, "pGivenName")
        val _columnIndexOfPFamilyName: Int = getColumnIndexOrThrow(_stmt, "pFamilyName")
        val _columnIndexOfPMiddleName: Int = getColumnIndexOrThrow(_stmt, "pMiddleName")
        val _collectionRoles: LongSparseArray<MutableList<PersonRoleEntity>> =
            LongSparseArray<MutableList<PersonRoleEntity>>()
        while (_stmt.step()) {
          val _tmpKey: Long
          _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash)
          if (!_collectionRoles.containsKey(_tmpKey)) {
            _collectionRoles.put(_tmpKey, mutableListOf())
          }
        }
        _stmt.reset()
        __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection,
            _collectionRoles)
        val _result: MutableList<PersonEntityWithRoles> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonEntityWithRoles
          val _tmpPerson: PersonEntity
          val _tmpPGuid: String
          _tmpPGuid = _stmt.getText(_columnIndexOfPGuid)
          val _tmpPGuidHash: Long
          _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash)
          val _tmpPActive: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfPActive).toInt()
          _tmpPActive = _tmp != 0
          val _tmpPStatus: StatusEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfPStatus).toInt()
          _tmpPStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
          val _tmpPLastModified: Long
          _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified)
          val _tmpPStored: Long
          _tmpPStored = _stmt.getLong(_columnIndexOfPStored)
          val _tmpPUsername: String?
          if (_stmt.isNull(_columnIndexOfPUsername)) {
            _tmpPUsername = null
          } else {
            _tmpPUsername = _stmt.getText(_columnIndexOfPUsername)
          }
          val _tmpPGivenName: String
          _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName)
          val _tmpPFamilyName: String
          _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName)
          val _tmpPMiddleName: String?
          if (_stmt.isNull(_columnIndexOfPMiddleName)) {
            _tmpPMiddleName = null
          } else {
            _tmpPMiddleName = _stmt.getText(_columnIndexOfPMiddleName)
          }
          _tmpPerson =
              PersonEntity(_tmpPGuid,_tmpPGuidHash,_tmpPActive,_tmpPStatus,_tmpPLastModified,_tmpPStored,_tmpPUsername,_tmpPGivenName,_tmpPFamilyName,_tmpPMiddleName)
          val _tmpRolesCollection: MutableList<PersonRoleEntity>
          val _tmpKey_1: Long
          _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash)
          _tmpRolesCollection = checkNotNull(_collectionRoles.get(_tmpKey_1))
          _item = PersonEntityWithRoles(_tmpPerson,_tmpRolesCollection)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findAll(since: Long): List<PersonEntity> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM PersonEntity
        |        WHERE PersonEntity.pStored > ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, since)
        val _columnIndexOfPGuid: Int = getColumnIndexOrThrow(_stmt, "pGuid")
        val _columnIndexOfPGuidHash: Int = getColumnIndexOrThrow(_stmt, "pGuidHash")
        val _columnIndexOfPActive: Int = getColumnIndexOrThrow(_stmt, "pActive")
        val _columnIndexOfPStatus: Int = getColumnIndexOrThrow(_stmt, "pStatus")
        val _columnIndexOfPLastModified: Int = getColumnIndexOrThrow(_stmt, "pLastModified")
        val _columnIndexOfPStored: Int = getColumnIndexOrThrow(_stmt, "pStored")
        val _columnIndexOfPUsername: Int = getColumnIndexOrThrow(_stmt, "pUsername")
        val _columnIndexOfPGivenName: Int = getColumnIndexOrThrow(_stmt, "pGivenName")
        val _columnIndexOfPFamilyName: Int = getColumnIndexOrThrow(_stmt, "pFamilyName")
        val _columnIndexOfPMiddleName: Int = getColumnIndexOrThrow(_stmt, "pMiddleName")
        val _result: MutableList<PersonEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonEntity
          val _tmpPGuid: String
          _tmpPGuid = _stmt.getText(_columnIndexOfPGuid)
          val _tmpPGuidHash: Long
          _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash)
          val _tmpPActive: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfPActive).toInt()
          _tmpPActive = _tmp != 0
          val _tmpPStatus: StatusEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfPStatus).toInt()
          _tmpPStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
          val _tmpPLastModified: Long
          _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified)
          val _tmpPStored: Long
          _tmpPStored = _stmt.getLong(_columnIndexOfPStored)
          val _tmpPUsername: String?
          if (_stmt.isNull(_columnIndexOfPUsername)) {
            _tmpPUsername = null
          } else {
            _tmpPUsername = _stmt.getText(_columnIndexOfPUsername)
          }
          val _tmpPGivenName: String
          _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName)
          val _tmpPFamilyName: String
          _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName)
          val _tmpPMiddleName: String?
          if (_stmt.isNull(_columnIndexOfPMiddleName)) {
            _tmpPMiddleName = null
          } else {
            _tmpPMiddleName = _stmt.getText(_columnIndexOfPMiddleName)
          }
          _item =
              PersonEntity(_tmpPGuid,_tmpPGuidHash,_tmpPActive,_tmpPStatus,_tmpPLastModified,_tmpPStored,_tmpPUsername,_tmpPGivenName,_tmpPFamilyName,_tmpPMiddleName)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllAsPagingSource(
    since: Long,
    guidHash: Long,
    inClazzGuidHash: Long,
  ): PagingSource<Int, PersonEntityWithRoles> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM PersonEntity
        |        WHERE PersonEntity.pStored > ? 
        |          AND (? = 0 OR PersonEntity.pGuidHash = ?)
        |          AND (? = 0)
        |     ORDER BY PersonEntity.pGivenName
        |    
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      _stmt.bindLong(_argIndex, since)
      _argIndex = 2
      _stmt.bindLong(_argIndex, guidHash)
      _argIndex = 3
      _stmt.bindLong(_argIndex, guidHash)
      _argIndex = 4
      _stmt.bindLong(_argIndex, inClazzGuidHash)
    }
    return object : LimitOffsetPagingSource<PersonEntityWithRoles>(_rawQuery, __db,
        "PersonRoleEntity", "PersonEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int):
          List<PersonEntityWithRoles> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfPGuid: Int = getColumnIndexOrThrow(_stmt, "pGuid")
          val _columnIndexOfPGuidHash: Int = getColumnIndexOrThrow(_stmt, "pGuidHash")
          val _columnIndexOfPActive: Int = getColumnIndexOrThrow(_stmt, "pActive")
          val _columnIndexOfPStatus: Int = getColumnIndexOrThrow(_stmt, "pStatus")
          val _columnIndexOfPLastModified: Int = getColumnIndexOrThrow(_stmt, "pLastModified")
          val _columnIndexOfPStored: Int = getColumnIndexOrThrow(_stmt, "pStored")
          val _columnIndexOfPUsername: Int = getColumnIndexOrThrow(_stmt, "pUsername")
          val _columnIndexOfPGivenName: Int = getColumnIndexOrThrow(_stmt, "pGivenName")
          val _columnIndexOfPFamilyName: Int = getColumnIndexOrThrow(_stmt, "pFamilyName")
          val _columnIndexOfPMiddleName: Int = getColumnIndexOrThrow(_stmt, "pMiddleName")
          val _collectionRoles: LongSparseArray<MutableList<PersonRoleEntity>> =
              LongSparseArray<MutableList<PersonRoleEntity>>()
          while (_stmt.step()) {
            val _tmpKey: Long
            _tmpKey = _stmt.getLong(_columnIndexOfPGuidHash)
            if (!_collectionRoles.containsKey(_tmpKey)) {
              _collectionRoles.put(_tmpKey, mutableListOf())
            }
          }
          _stmt.reset()
          __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection,
              _collectionRoles)
          val _result: MutableList<PersonEntityWithRoles> = mutableListOf()
          while (_stmt.step()) {
            val _item: PersonEntityWithRoles
            val _tmpPerson: PersonEntity
            val _tmpPGuid: String
            _tmpPGuid = _stmt.getText(_columnIndexOfPGuid)
            val _tmpPGuidHash: Long
            _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash)
            val _tmpPActive: Boolean
            val _tmp: Int
            _tmp = _stmt.getLong(_columnIndexOfPActive).toInt()
            _tmpPActive = _tmp != 0
            val _tmpPStatus: StatusEnum
            val _tmp_1: Int
            _tmp_1 = _stmt.getLong(_columnIndexOfPStatus).toInt()
            _tmpPStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
            val _tmpPLastModified: Long
            _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified)
            val _tmpPStored: Long
            _tmpPStored = _stmt.getLong(_columnIndexOfPStored)
            val _tmpPUsername: String?
            if (_stmt.isNull(_columnIndexOfPUsername)) {
              _tmpPUsername = null
            } else {
              _tmpPUsername = _stmt.getText(_columnIndexOfPUsername)
            }
            val _tmpPGivenName: String
            _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName)
            val _tmpPFamilyName: String
            _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName)
            val _tmpPMiddleName: String?
            if (_stmt.isNull(_columnIndexOfPMiddleName)) {
              _tmpPMiddleName = null
            } else {
              _tmpPMiddleName = _stmt.getText(_columnIndexOfPMiddleName)
            }
            _tmpPerson =
                PersonEntity(_tmpPGuid,_tmpPGuidHash,_tmpPActive,_tmpPStatus,_tmpPLastModified,_tmpPStored,_tmpPUsername,_tmpPGivenName,_tmpPFamilyName,_tmpPMiddleName)
            val _tmpRolesCollection: MutableList<PersonRoleEntity>
            val _tmpKey_1: Long
            _tmpKey_1 = _stmt.getLong(_columnIndexOfPGuidHash)
            _tmpRolesCollection = checkNotNull(_collectionRoles.get(_tmpKey_1))
            _item = PersonEntityWithRoles(_tmpPerson,_tmpRolesCollection)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override fun findAllListDetailsAsPagingSource(): PagingSource<Int, PersonListDetails> {
    val _sql: String = """
        |
        |        SELECT PersonEntity.pGuid AS guid, 
        |               PersonEntity.pGivenName AS givenName, 
        |               PersonEntity.pFamilyName AS familyName, 
        |               PersonEntity.pUsername AS username
        |          FROM PersonEntity
        |      ORDER BY PersonEntity.pGivenName    
        |    
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql)
    return object : LimitOffsetPagingSource<PersonListDetails>(_rawQuery, __db, "PersonEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int):
          List<PersonListDetails> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfGuid: Int = 0
          val _columnIndexOfGivenName: Int = 1
          val _columnIndexOfFamilyName: Int = 2
          val _columnIndexOfUsername: Int = 3
          val _result: MutableList<PersonListDetails> = mutableListOf()
          while (_stmt.step()) {
            val _item: PersonListDetails
            val _tmpGuid: String
            _tmpGuid = _stmt.getText(_columnIndexOfGuid)
            val _tmpGivenName: String
            _tmpGivenName = _stmt.getText(_columnIndexOfGivenName)
            val _tmpFamilyName: String
            _tmpFamilyName = _stmt.getText(_columnIndexOfFamilyName)
            val _tmpUsername: String?
            if (_stmt.isNull(_columnIndexOfUsername)) {
              _tmpUsername = null
            } else {
              _tmpUsername = _stmt.getText(_columnIndexOfUsername)
            }
            _item = PersonListDetails(_tmpGuid,_tmpGivenName,_tmpFamilyName,_tmpUsername)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public override suspend fun getAllUsers(sourcedId: String): List<PersonEntity> {
    val _sql: String = """
        |
        |            SELECT * 
        |            FROM PersonEntity
        |            WHERE pGuid = ?
        |            
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, sourcedId)
        val _columnIndexOfPGuid: Int = getColumnIndexOrThrow(_stmt, "pGuid")
        val _columnIndexOfPGuidHash: Int = getColumnIndexOrThrow(_stmt, "pGuidHash")
        val _columnIndexOfPActive: Int = getColumnIndexOrThrow(_stmt, "pActive")
        val _columnIndexOfPStatus: Int = getColumnIndexOrThrow(_stmt, "pStatus")
        val _columnIndexOfPLastModified: Int = getColumnIndexOrThrow(_stmt, "pLastModified")
        val _columnIndexOfPStored: Int = getColumnIndexOrThrow(_stmt, "pStored")
        val _columnIndexOfPUsername: Int = getColumnIndexOrThrow(_stmt, "pUsername")
        val _columnIndexOfPGivenName: Int = getColumnIndexOrThrow(_stmt, "pGivenName")
        val _columnIndexOfPFamilyName: Int = getColumnIndexOrThrow(_stmt, "pFamilyName")
        val _columnIndexOfPMiddleName: Int = getColumnIndexOrThrow(_stmt, "pMiddleName")
        val _result: MutableList<PersonEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: PersonEntity
          val _tmpPGuid: String
          _tmpPGuid = _stmt.getText(_columnIndexOfPGuid)
          val _tmpPGuidHash: Long
          _tmpPGuidHash = _stmt.getLong(_columnIndexOfPGuidHash)
          val _tmpPActive: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfPActive).toInt()
          _tmpPActive = _tmp != 0
          val _tmpPStatus: StatusEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfPStatus).toInt()
          _tmpPStatus = __schoolTypeConverters.toStatusEnum(_tmp_1)
          val _tmpPLastModified: Long
          _tmpPLastModified = _stmt.getLong(_columnIndexOfPLastModified)
          val _tmpPStored: Long
          _tmpPStored = _stmt.getLong(_columnIndexOfPStored)
          val _tmpPUsername: String?
          if (_stmt.isNull(_columnIndexOfPUsername)) {
            _tmpPUsername = null
          } else {
            _tmpPUsername = _stmt.getText(_columnIndexOfPUsername)
          }
          val _tmpPGivenName: String
          _tmpPGivenName = _stmt.getText(_columnIndexOfPGivenName)
          val _tmpPFamilyName: String
          _tmpPFamilyName = _stmt.getText(_columnIndexOfPFamilyName)
          val _tmpPMiddleName: String?
          if (_stmt.isNull(_columnIndexOfPMiddleName)) {
            _tmpPMiddleName = null
          } else {
            _tmpPMiddleName = _stmt.getText(_columnIndexOfPMiddleName)
          }
          _item =
              PersonEntity(_tmpPGuid,_tmpPGuidHash,_tmpPActive,_tmpPStatus,_tmpPLastModified,_tmpPStored,_tmpPUsername,_tmpPGivenName,_tmpPFamilyName,_tmpPMiddleName)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  private
      fun __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection: SQLiteConnection,
      _map: LongSparseArray<MutableList<PersonRoleEntity>>) {
    if (_map.isEmpty()) {
      return
    }
    if (_map.size() > 999) {
      recursiveFetchLongSparseArray(_map, true) { _tmpMap ->
        __fetchRelationshipPersonRoleEntityAsworldRespectDatalayerDbSchoolEntitiesPersonRoleEntity(_connection,
            _tmpMap)
      }
      return
    }
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("SELECT `prUid`,`prPersonGuidHash`,`prIsPrimaryRole`,`prRoleEnum`,`prBeginDate`,`prEndDate` FROM `PersonRoleEntity` WHERE `prPersonGuidHash` IN (")
    val _inputSize: Int = _map.size()
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(")")
    val _sql: String = _stringBuilder.toString()
    val _stmt: SQLiteStatement = _connection.prepare(_sql)
    var _argIndex: Int = 1
    for (i in 0 until _map.size()) {
      val _item: Long = _map.keyAt(i)
      _stmt.bindLong(_argIndex, _item)
      _argIndex++
    }
    try {
      val _itemKeyIndex: Int = getColumnIndex(_stmt, "prPersonGuidHash")
      if (_itemKeyIndex == -1) {
        return
      }
      val _columnIndexOfPrUid: Int = 0
      val _columnIndexOfPrPersonGuidHash: Int = 1
      val _columnIndexOfPrIsPrimaryRole: Int = 2
      val _columnIndexOfPrRoleEnum: Int = 3
      val _columnIndexOfPrBeginDate: Int = 4
      val _columnIndexOfPrEndDate: Int = 5
      while (_stmt.step()) {
        val _tmpKey: Long
        _tmpKey = _stmt.getLong(_itemKeyIndex)
        val _tmpRelation: MutableList<PersonRoleEntity>? = _map.get(_tmpKey)
        if (_tmpRelation != null) {
          val _item_1: PersonRoleEntity
          val _tmpPrUid: Int
          _tmpPrUid = _stmt.getLong(_columnIndexOfPrUid).toInt()
          val _tmpPrPersonGuidHash: Long
          _tmpPrPersonGuidHash = _stmt.getLong(_columnIndexOfPrPersonGuidHash)
          val _tmpPrIsPrimaryRole: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfPrIsPrimaryRole).toInt()
          _tmpPrIsPrimaryRole = _tmp != 0
          val _tmpPrRoleEnum: PersonRoleEnum
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfPrRoleEnum).toInt()
          _tmpPrRoleEnum = __schoolTypeConverters.toPersonRoleType(_tmp_1)
          val _tmpPrBeginDate: LocalDate?
          val _tmp_2: Long?
          if (_stmt.isNull(_columnIndexOfPrBeginDate)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getLong(_columnIndexOfPrBeginDate)
          }
          _tmpPrBeginDate = __schoolTypeConverters.toLocalDate(_tmp_2)
          val _tmpPrEndDate: LocalDate?
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfPrEndDate)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfPrEndDate)
          }
          _tmpPrEndDate = __schoolTypeConverters.toLocalDate(_tmp_3)
          _item_1 =
              PersonRoleEntity(_tmpPrUid,_tmpPrPersonGuidHash,_tmpPrIsPrimaryRole,_tmpPrRoleEnum,_tmpPrBeginDate,_tmpPrEndDate)
          _tmpRelation.add(_item_1)
        }
      }
    } finally {
      _stmt.close()
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
