package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.entities.ReportEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class ReportEntityDao_Impl(
  __db: RoomDatabase,
) : ReportEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfReportEntity: EntityInsertAdapter<ReportEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfReportEntity = object : EntityInsertAdapter<ReportEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `ReportEntity` (`rGuid`,`rOwnerGuid`,`rTitle`,`rOptions`,`rIsTemplate`,`rActive`,`rLastModified`,`rStored`) VALUES (?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: ReportEntity) {
        statement.bindText(1, entity.rGuid)
        statement.bindText(2, entity.rOwnerGuid)
        statement.bindText(3, entity.rTitle)
        statement.bindText(4, entity.rOptions)
        val _tmp: Int = if (entity.rIsTemplate) 1 else 0
        statement.bindLong(5, _tmp.toLong())
        val _tmp_1: Int = if (entity.rActive) 1 else 0
        statement.bindLong(6, _tmp_1.toLong())
        statement.bindLong(7, entity.rLastModified)
        statement.bindLong(8, entity.rStored)
      }
    }
  }

  public override suspend fun putReport(reportEntity: ReportEntity): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfReportEntity.insert(_connection, reportEntity)
  }

  public override fun getAllReportsByTemplate(template: Boolean): Flow<List<ReportEntity>> {
    val _sql: String = """
        |
        |        SELECT * 
        |        FROM ReportEntity
        |        WHERE rIsTemplate = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("ReportEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: Int = if (template) 1 else 0
        _stmt.bindLong(_argIndex, _tmp.toLong())
        val _columnIndexOfRGuid: Int = getColumnIndexOrThrow(_stmt, "rGuid")
        val _columnIndexOfROwnerGuid: Int = getColumnIndexOrThrow(_stmt, "rOwnerGuid")
        val _columnIndexOfRTitle: Int = getColumnIndexOrThrow(_stmt, "rTitle")
        val _columnIndexOfROptions: Int = getColumnIndexOrThrow(_stmt, "rOptions")
        val _columnIndexOfRIsTemplate: Int = getColumnIndexOrThrow(_stmt, "rIsTemplate")
        val _columnIndexOfRActive: Int = getColumnIndexOrThrow(_stmt, "rActive")
        val _columnIndexOfRLastModified: Int = getColumnIndexOrThrow(_stmt, "rLastModified")
        val _columnIndexOfRStored: Int = getColumnIndexOrThrow(_stmt, "rStored")
        val _result: MutableList<ReportEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: ReportEntity
          val _tmpRGuid: String
          _tmpRGuid = _stmt.getText(_columnIndexOfRGuid)
          val _tmpROwnerGuid: String
          _tmpROwnerGuid = _stmt.getText(_columnIndexOfROwnerGuid)
          val _tmpRTitle: String
          _tmpRTitle = _stmt.getText(_columnIndexOfRTitle)
          val _tmpROptions: String
          _tmpROptions = _stmt.getText(_columnIndexOfROptions)
          val _tmpRIsTemplate: Boolean
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfRIsTemplate).toInt()
          _tmpRIsTemplate = _tmp_1 != 0
          val _tmpRActive: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfRActive).toInt()
          _tmpRActive = _tmp_2 != 0
          val _tmpRLastModified: Long
          _tmpRLastModified = _stmt.getLong(_columnIndexOfRLastModified)
          val _tmpRStored: Long
          _tmpRStored = _stmt.getLong(_columnIndexOfRStored)
          _item =
              ReportEntity(_tmpRGuid,_tmpROwnerGuid,_tmpRTitle,_tmpROptions,_tmpRIsTemplate,_tmpRActive,_tmpRLastModified,_tmpRStored)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getReportAsync(reportId: String): ReportEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM ReportEntity
        |        WHERE rGuid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, reportId)
        val _columnIndexOfRGuid: Int = getColumnIndexOrThrow(_stmt, "rGuid")
        val _columnIndexOfROwnerGuid: Int = getColumnIndexOrThrow(_stmt, "rOwnerGuid")
        val _columnIndexOfRTitle: Int = getColumnIndexOrThrow(_stmt, "rTitle")
        val _columnIndexOfROptions: Int = getColumnIndexOrThrow(_stmt, "rOptions")
        val _columnIndexOfRIsTemplate: Int = getColumnIndexOrThrow(_stmt, "rIsTemplate")
        val _columnIndexOfRActive: Int = getColumnIndexOrThrow(_stmt, "rActive")
        val _columnIndexOfRLastModified: Int = getColumnIndexOrThrow(_stmt, "rLastModified")
        val _columnIndexOfRStored: Int = getColumnIndexOrThrow(_stmt, "rStored")
        val _result: ReportEntity?
        if (_stmt.step()) {
          val _tmpRGuid: String
          _tmpRGuid = _stmt.getText(_columnIndexOfRGuid)
          val _tmpROwnerGuid: String
          _tmpROwnerGuid = _stmt.getText(_columnIndexOfROwnerGuid)
          val _tmpRTitle: String
          _tmpRTitle = _stmt.getText(_columnIndexOfRTitle)
          val _tmpROptions: String
          _tmpROptions = _stmt.getText(_columnIndexOfROptions)
          val _tmpRIsTemplate: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfRIsTemplate).toInt()
          _tmpRIsTemplate = _tmp != 0
          val _tmpRActive: Boolean
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfRActive).toInt()
          _tmpRActive = _tmp_1 != 0
          val _tmpRLastModified: Long
          _tmpRLastModified = _stmt.getLong(_columnIndexOfRLastModified)
          val _tmpRStored: Long
          _tmpRStored = _stmt.getLong(_columnIndexOfRStored)
          _result =
              ReportEntity(_tmpRGuid,_tmpROwnerGuid,_tmpRTitle,_tmpROptions,_tmpRIsTemplate,_tmpRActive,_tmpRLastModified,_tmpRStored)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun getReportAsFlow(reportId: String): Flow<ReportEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM ReportEntity
        |        WHERE rGuid = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("ReportEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, reportId)
        val _columnIndexOfRGuid: Int = getColumnIndexOrThrow(_stmt, "rGuid")
        val _columnIndexOfROwnerGuid: Int = getColumnIndexOrThrow(_stmt, "rOwnerGuid")
        val _columnIndexOfRTitle: Int = getColumnIndexOrThrow(_stmt, "rTitle")
        val _columnIndexOfROptions: Int = getColumnIndexOrThrow(_stmt, "rOptions")
        val _columnIndexOfRIsTemplate: Int = getColumnIndexOrThrow(_stmt, "rIsTemplate")
        val _columnIndexOfRActive: Int = getColumnIndexOrThrow(_stmt, "rActive")
        val _columnIndexOfRLastModified: Int = getColumnIndexOrThrow(_stmt, "rLastModified")
        val _columnIndexOfRStored: Int = getColumnIndexOrThrow(_stmt, "rStored")
        val _result: ReportEntity?
        if (_stmt.step()) {
          val _tmpRGuid: String
          _tmpRGuid = _stmt.getText(_columnIndexOfRGuid)
          val _tmpROwnerGuid: String
          _tmpROwnerGuid = _stmt.getText(_columnIndexOfROwnerGuid)
          val _tmpRTitle: String
          _tmpRTitle = _stmt.getText(_columnIndexOfRTitle)
          val _tmpROptions: String
          _tmpROptions = _stmt.getText(_columnIndexOfROptions)
          val _tmpRIsTemplate: Boolean
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfRIsTemplate).toInt()
          _tmpRIsTemplate = _tmp != 0
          val _tmpRActive: Boolean
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfRActive).toInt()
          _tmpRActive = _tmp_1 != 0
          val _tmpRLastModified: Long
          _tmpRLastModified = _stmt.getLong(_columnIndexOfRLastModified)
          val _tmpRStored: Long
          _tmpRStored = _stmt.getLong(_columnIndexOfRStored)
          _result =
              ReportEntity(_tmpRGuid,_tmpROwnerGuid,_tmpRTitle,_tmpROptions,_tmpRIsTemplate,_tmpRActive,_tmpRLastModified,_tmpRStored)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteReportByUid(reportUid: String) {
    val _sql: String = "DELETE FROM ReportEntity WHERE rGuid = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, reportUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
