package world.respect.datalayer.db

import androidx.room.InvalidationTracker
import androidx.room.RoomOpenDelegate
import androidx.room.migration.AutoMigrationSpec
import androidx.room.migration.Migration
import androidx.room.util.TableInfo
import androidx.room.util.TableInfo.Companion.read
import androidx.room.util.dropFtsSyncTriggers
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.execSQL
import javax.`annotation`.processing.Generated
import kotlin.Lazy
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.collections.MutableSet
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf
import kotlin.collections.mutableSetOf
import kotlin.reflect.KClass
import world.respect.datalayer.db.compatibleapps.daos.CompatibleAppAddJoinDao
import world.respect.datalayer.db.compatibleapps.daos.CompatibleAppAddJoinDao_Impl
import world.respect.datalayer.db.compatibleapps.daos.CompatibleAppEntityDao
import world.respect.datalayer.db.compatibleapps.daos.CompatibleAppEntityDao_Impl
import world.respect.datalayer.db.networkvalidation.daos.NetworkValidationInfoEntityDao
import world.respect.datalayer.db.networkvalidation.daos.NetworkValidationInfoEntityDao_Impl
import world.respect.datalayer.db.opds.daos.OpdsFeedEntityDao
import world.respect.datalayer.db.opds.daos.OpdsFeedEntityDao_Impl
import world.respect.datalayer.db.opds.daos.OpdsFeedMetadataEntityDao
import world.respect.datalayer.db.opds.daos.OpdsFeedMetadataEntityDao_Impl
import world.respect.datalayer.db.opds.daos.OpdsGroupEntityDao
import world.respect.datalayer.db.opds.daos.OpdsGroupEntityDao_Impl
import world.respect.datalayer.db.opds.daos.OpdsPublicationEntityDao
import world.respect.datalayer.db.opds.daos.OpdsPublicationEntityDao_Impl
import world.respect.datalayer.db.opds.daos.ReadiumLinkEntityDao
import world.respect.datalayer.db.opds.daos.ReadiumLinkEntityDao_Impl
import world.respect.datalayer.db.schooldirectory.daos.SchoolConfigEntityDao
import world.respect.datalayer.db.schooldirectory.daos.SchoolConfigEntityDao_Impl
import world.respect.datalayer.db.schooldirectory.daos.SchoolDirectoryEntityDao
import world.respect.datalayer.db.schooldirectory.daos.SchoolDirectoryEntityDao_Impl
import world.respect.datalayer.db.schooldirectory.daos.SchoolDirectoryEntryEntityDao
import world.respect.datalayer.db.schooldirectory.daos.SchoolDirectoryEntryEntityDao_Impl
import world.respect.datalayer.db.shared.daos.LangMapEntityDao
import world.respect.datalayer.db.shared.daos.LangMapEntityDao_Impl

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RespectAppDatabase_Impl : RespectAppDatabase() {
  private val _compatibleAppEntityDao: Lazy<CompatibleAppEntityDao> = lazy {
    CompatibleAppEntityDao_Impl(this)
  }

  private val _compatibleAppAddJoinDao: Lazy<CompatibleAppAddJoinDao> = lazy {
    CompatibleAppAddJoinDao_Impl(this)
  }

  private val _langMapEntityDao: Lazy<LangMapEntityDao> = lazy {
    LangMapEntityDao_Impl(this)
  }

  private val _opdsFeedEntityDao: Lazy<OpdsFeedEntityDao> = lazy {
    OpdsFeedEntityDao_Impl(this)
  }

  private val _opdsPublicationEntityDao: Lazy<OpdsPublicationEntityDao> = lazy {
    OpdsPublicationEntityDao_Impl(this)
  }

  private val _opdsFeedMetadataEntityDao: Lazy<OpdsFeedMetadataEntityDao> = lazy {
    OpdsFeedMetadataEntityDao_Impl(this)
  }

  private val _readiumLinkEntityDao: Lazy<ReadiumLinkEntityDao> = lazy {
    ReadiumLinkEntityDao_Impl(this)
  }

  private val _opdsGroupEntityDao: Lazy<OpdsGroupEntityDao> = lazy {
    OpdsGroupEntityDao_Impl(this)
  }

  private val _schoolDirectoryEntryEntityDao: Lazy<SchoolDirectoryEntryEntityDao> = lazy {
    SchoolDirectoryEntryEntityDao_Impl(this)
  }

  private val _schoolConfigEntityDao: Lazy<SchoolConfigEntityDao> = lazy {
    SchoolConfigEntityDao_Impl(this)
  }

  private val _schoolDirectoryEntityDao: Lazy<SchoolDirectoryEntityDao> = lazy {
    SchoolDirectoryEntityDao_Impl(this)
  }

  private val _networkValidationInfoEntityDao: Lazy<NetworkValidationInfoEntityDao> = lazy {
    NetworkValidationInfoEntityDao_Impl(this)
  }

  protected override fun createOpenDelegate(): RoomOpenDelegate {
    val _openDelegate: RoomOpenDelegate = object : RoomOpenDelegate(1,
        "d30b2001f17778b46dae95fd5d88bb2b", "03f709db1c05cab23b08562d88626cda") {
      public override fun createAllTables(connection: SQLiteConnection) {
        connection.execSQL("CREATE TABLE IF NOT EXISTS `LangMapEntity` (`lmeId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `lmeTopParentType` INTEGER NOT NULL, `lmeTopParentUid1` INTEGER NOT NULL, `lmeTopParentUid2` INTEGER NOT NULL, `lmePropType` INTEGER NOT NULL, `lmePropFk` INTEGER NOT NULL, `lmeLang` TEXT NOT NULL, `lmeRegion` TEXT, `lmeValue` TEXT NOT NULL)")
        connection.execSQL("CREATE INDEX IF NOT EXISTS `index_LangMapEntity_lmeTopParentType_lmeTopParentUid1_lmeTopParentUid2_lmePropType` ON `LangMapEntity` (`lmeTopParentType`, `lmeTopParentUid1`, `lmeTopParentUid2`, `lmePropType`)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `ReadiumLinkEntity` (`rleId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `rleOpdsParentType` INTEGER NOT NULL, `rleOpdsParentUid` INTEGER NOT NULL, `rlePropType` TEXT NOT NULL, `rlePropFk` INTEGER NOT NULL, `rleIndex` INTEGER NOT NULL, `rleHref` TEXT NOT NULL, `rleRel` TEXT, `rleType` TEXT, `rleTitle` TEXT, `rleTemplated` INTEGER, `rleProperties` TEXT, `rleHeight` INTEGER, `rleWidth` INTEGER, `rleSize` INTEGER, `rleBitrate` REAL, `rleDuration` REAL, `rleLanguage` TEXT)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OpdsPublicationEntity` (`opeUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `opeOfeUid` INTEGER NOT NULL, `opeOgeUid` INTEGER NOT NULL, `opeIndex` INTEGER NOT NULL, `opeUrl` TEXT, `opeUrlHash` INTEGER NOT NULL, `opeLastModified` INTEGER NOT NULL, `opeEtag` TEXT, `opeMdIdentifier` TEXT, `opeMdLanguage` TEXT, `opeMdType` TEXT, `opeMdDescription` TEXT, `opeMdNumberOfPages` INTEGER, `opeMdDuration` REAL)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `ReadiumSubjectEntity` (`rseUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `rseStringValue` TEXT, `rseTopParentType` INTEGER NOT NULL, `rseTopParentUid` INTEGER NOT NULL, `rseSubjectSortAs` TEXT, `rseSubjectCode` TEXT, `rseSubjectScheme` TEXT, `rseIndex` INTEGER NOT NULL)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OpdsFacetEntity` (`ofaeUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ofaeOfeUid` INTEGER NOT NULL)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OpdsGroupEntity` (`ogeUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ogeOfeUid` INTEGER NOT NULL, `ogeIndex` INTEGER NOT NULL)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OpdsFeedEntity` (`ofeUid` INTEGER NOT NULL, `ofeUrl` TEXT NOT NULL, `ofeUrlHash` INTEGER NOT NULL, `ofeLastModifiedHeader` INTEGER NOT NULL, `ofeEtag` TEXT, PRIMARY KEY(`ofeUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OpdsFeedMetadataEntity` (`ofmeUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ofmeOfeUid` INTEGER NOT NULL, `ofmePropType` INTEGER NOT NULL, `ofmePropFk` INTEGER NOT NULL, `ofmeIdentifier` TEXT, `ofmeType` TEXT, `ofmeTitle` TEXT NOT NULL, `ofmeSubtitle` TEXT, `ofmeModified` TEXT, `ofmeDescription` TEXT, `ofmeItemsPerPage` INTEGER, `ofmeCurrentPage` INTEGER, `ofmeNumberOfItems` INTEGER)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `CompatibleAppEntity` (`caeUid` INTEGER NOT NULL, `caeUrl` TEXT NOT NULL, `caeIcon` TEXT, `caeLastModified` INTEGER NOT NULL, `caeEtag` TEXT, `caeLicense` TEXT NOT NULL, `caeWebsite` TEXT NOT NULL, `caeLearningUnits` TEXT NOT NULL, `caeDefaultLaunchUri` TEXT NOT NULL, `caeAndroidPackageId` TEXT, `caeAndroidStoreList` TEXT, `caeAndroidSourceCode` TEXT, PRIMARY KEY(`caeUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `CompatibleAppAddJoin` (`appCaeUid` INTEGER NOT NULL, `added` INTEGER NOT NULL, PRIMARY KEY(`appCaeUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `SchoolDirectoryEntity` (`rdUid` INTEGER NOT NULL, `rdUrl` TEXT NOT NULL, `rdInvitePrefix` TEXT NOT NULL, PRIMARY KEY(`rdUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `SchoolDirectoryEntryEntity` (`reUid` INTEGER NOT NULL, `reLastMod` INTEGER NOT NULL, `reEtag` TEXT, `reSelf` TEXT NOT NULL, `reXapi` TEXT NOT NULL, `reOneRoster` TEXT NOT NULL, `reRespectExt` TEXT, PRIMARY KEY(`reUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `SchoolConfigEntity` (`rcUid` INTEGER NOT NULL, `dbUrl` TEXT NOT NULL, PRIMARY KEY(`rcUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `NetworkValidationInfoEntity` (`nviUrlHash` INTEGER NOT NULL, `nviKey` INTEGER NOT NULL, `nviVaryHeader` TEXT, `nviLastModified` INTEGER NOT NULL, `nviEtag` TEXT, `nviConsistentThrough` INTEGER NOT NULL, `nviLastChecked` INTEGER NOT NULL, PRIMARY KEY(`nviUrlHash`, `nviKey`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)")
        connection.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'd30b2001f17778b46dae95fd5d88bb2b')")
      }

      public override fun dropAllTables(connection: SQLiteConnection) {
        connection.execSQL("DROP TABLE IF EXISTS `LangMapEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `ReadiumLinkEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `OpdsPublicationEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `ReadiumSubjectEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `OpdsFacetEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `OpdsGroupEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `OpdsFeedEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `OpdsFeedMetadataEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `CompatibleAppEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `CompatibleAppAddJoin`")
        connection.execSQL("DROP TABLE IF EXISTS `SchoolDirectoryEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `SchoolDirectoryEntryEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `SchoolConfigEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `NetworkValidationInfoEntity`")
      }

      public override fun onCreate(connection: SQLiteConnection) {
      }

      public override fun onOpen(connection: SQLiteConnection) {
        internalInitInvalidationTracker(connection)
      }

      public override fun onPreMigrate(connection: SQLiteConnection) {
        dropFtsSyncTriggers(connection)
      }

      public override fun onPostMigrate(connection: SQLiteConnection) {
      }

      public override fun onValidateSchema(connection: SQLiteConnection):
          RoomOpenDelegate.ValidationResult {
        val _columnsLangMapEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsLangMapEntity.put("lmeId", TableInfo.Column("lmeId", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmeTopParentType", TableInfo.Column("lmeTopParentType",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmeTopParentUid1", TableInfo.Column("lmeTopParentUid1",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmeTopParentUid2", TableInfo.Column("lmeTopParentUid2",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmePropType", TableInfo.Column("lmePropType", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmePropFk", TableInfo.Column("lmePropFk", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmeLang", TableInfo.Column("lmeLang", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmeRegion", TableInfo.Column("lmeRegion", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsLangMapEntity.put("lmeValue", TableInfo.Column("lmeValue", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysLangMapEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesLangMapEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        _indicesLangMapEntity.add(TableInfo.Index("index_LangMapEntity_lmeTopParentType_lmeTopParentUid1_lmeTopParentUid2_lmePropType",
            false, listOf("lmeTopParentType", "lmeTopParentUid1", "lmeTopParentUid2",
            "lmePropType"), listOf("ASC", "ASC", "ASC", "ASC")))
        val _infoLangMapEntity: TableInfo = TableInfo("LangMapEntity", _columnsLangMapEntity,
            _foreignKeysLangMapEntity, _indicesLangMapEntity)
        val _existingLangMapEntity: TableInfo = read(connection, "LangMapEntity")
        if (!_infoLangMapEntity.equals(_existingLangMapEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |LangMapEntity(world.respect.datalayer.db.shared.entities.LangMapEntity).
              | Expected:
              |""".trimMargin() + _infoLangMapEntity + """
              |
              | Found:
              |""".trimMargin() + _existingLangMapEntity)
        }
        val _columnsReadiumLinkEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsReadiumLinkEntity.put("rleId", TableInfo.Column("rleId", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleOpdsParentType", TableInfo.Column("rleOpdsParentType",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleOpdsParentUid", TableInfo.Column("rleOpdsParentUid",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rlePropType", TableInfo.Column("rlePropType", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rlePropFk", TableInfo.Column("rlePropFk", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleIndex", TableInfo.Column("rleIndex", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleHref", TableInfo.Column("rleHref", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleRel", TableInfo.Column("rleRel", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleType", TableInfo.Column("rleType", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleTitle", TableInfo.Column("rleTitle", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleTemplated", TableInfo.Column("rleTemplated", "INTEGER",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleProperties", TableInfo.Column("rleProperties", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleHeight", TableInfo.Column("rleHeight", "INTEGER", false,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleWidth", TableInfo.Column("rleWidth", "INTEGER", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleSize", TableInfo.Column("rleSize", "INTEGER", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleBitrate", TableInfo.Column("rleBitrate", "REAL", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleDuration", TableInfo.Column("rleDuration", "REAL", false,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumLinkEntity.put("rleLanguage", TableInfo.Column("rleLanguage", "TEXT", false,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysReadiumLinkEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesReadiumLinkEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoReadiumLinkEntity: TableInfo = TableInfo("ReadiumLinkEntity",
            _columnsReadiumLinkEntity, _foreignKeysReadiumLinkEntity, _indicesReadiumLinkEntity)
        val _existingReadiumLinkEntity: TableInfo = read(connection, "ReadiumLinkEntity")
        if (!_infoReadiumLinkEntity.equals(_existingReadiumLinkEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |ReadiumLinkEntity(world.respect.datalayer.db.opds.entities.ReadiumLinkEntity).
              | Expected:
              |""".trimMargin() + _infoReadiumLinkEntity + """
              |
              | Found:
              |""".trimMargin() + _existingReadiumLinkEntity)
        }
        val _columnsOpdsPublicationEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOpdsPublicationEntity.put("opeUid", TableInfo.Column("opeUid", "INTEGER", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeOfeUid", TableInfo.Column("opeOfeUid", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeOgeUid", TableInfo.Column("opeOgeUid", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeIndex", TableInfo.Column("opeIndex", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeUrl", TableInfo.Column("opeUrl", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeUrlHash", TableInfo.Column("opeUrlHash", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeLastModified", TableInfo.Column("opeLastModified",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeEtag", TableInfo.Column("opeEtag", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeMdIdentifier", TableInfo.Column("opeMdIdentifier",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeMdLanguage", TableInfo.Column("opeMdLanguage", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeMdType", TableInfo.Column("opeMdType", "TEXT", false,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeMdDescription", TableInfo.Column("opeMdDescription",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeMdNumberOfPages",
            TableInfo.Column("opeMdNumberOfPages", "INTEGER", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsPublicationEntity.put("opeMdDuration", TableInfo.Column("opeMdDuration", "REAL",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOpdsPublicationEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOpdsPublicationEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOpdsPublicationEntity: TableInfo = TableInfo("OpdsPublicationEntity",
            _columnsOpdsPublicationEntity, _foreignKeysOpdsPublicationEntity,
            _indicesOpdsPublicationEntity)
        val _existingOpdsPublicationEntity: TableInfo = read(connection, "OpdsPublicationEntity")
        if (!_infoOpdsPublicationEntity.equals(_existingOpdsPublicationEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OpdsPublicationEntity(world.respect.datalayer.db.opds.entities.OpdsPublicationEntity).
              | Expected:
              |""".trimMargin() + _infoOpdsPublicationEntity + """
              |
              | Found:
              |""".trimMargin() + _existingOpdsPublicationEntity)
        }
        val _columnsReadiumSubjectEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsReadiumSubjectEntity.put("rseUid", TableInfo.Column("rseUid", "INTEGER", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumSubjectEntity.put("rseStringValue", TableInfo.Column("rseStringValue",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumSubjectEntity.put("rseTopParentType", TableInfo.Column("rseTopParentType",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumSubjectEntity.put("rseTopParentUid", TableInfo.Column("rseTopParentUid",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumSubjectEntity.put("rseSubjectSortAs", TableInfo.Column("rseSubjectSortAs",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumSubjectEntity.put("rseSubjectCode", TableInfo.Column("rseSubjectCode",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumSubjectEntity.put("rseSubjectScheme", TableInfo.Column("rseSubjectScheme",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReadiumSubjectEntity.put("rseIndex", TableInfo.Column("rseIndex", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysReadiumSubjectEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesReadiumSubjectEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoReadiumSubjectEntity: TableInfo = TableInfo("ReadiumSubjectEntity",
            _columnsReadiumSubjectEntity, _foreignKeysReadiumSubjectEntity,
            _indicesReadiumSubjectEntity)
        val _existingReadiumSubjectEntity: TableInfo = read(connection, "ReadiumSubjectEntity")
        if (!_infoReadiumSubjectEntity.equals(_existingReadiumSubjectEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |ReadiumSubjectEntity(world.respect.datalayer.db.opds.entities.ReadiumSubjectEntity).
              | Expected:
              |""".trimMargin() + _infoReadiumSubjectEntity + """
              |
              | Found:
              |""".trimMargin() + _existingReadiumSubjectEntity)
        }
        val _columnsOpdsFacetEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOpdsFacetEntity.put("ofaeUid", TableInfo.Column("ofaeUid", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFacetEntity.put("ofaeOfeUid", TableInfo.Column("ofaeOfeUid", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOpdsFacetEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOpdsFacetEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOpdsFacetEntity: TableInfo = TableInfo("OpdsFacetEntity", _columnsOpdsFacetEntity,
            _foreignKeysOpdsFacetEntity, _indicesOpdsFacetEntity)
        val _existingOpdsFacetEntity: TableInfo = read(connection, "OpdsFacetEntity")
        if (!_infoOpdsFacetEntity.equals(_existingOpdsFacetEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OpdsFacetEntity(world.respect.datalayer.db.opds.entities.OpdsFacetEntity).
              | Expected:
              |""".trimMargin() + _infoOpdsFacetEntity + """
              |
              | Found:
              |""".trimMargin() + _existingOpdsFacetEntity)
        }
        val _columnsOpdsGroupEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOpdsGroupEntity.put("ogeUid", TableInfo.Column("ogeUid", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsGroupEntity.put("ogeOfeUid", TableInfo.Column("ogeOfeUid", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsGroupEntity.put("ogeIndex", TableInfo.Column("ogeIndex", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOpdsGroupEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOpdsGroupEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOpdsGroupEntity: TableInfo = TableInfo("OpdsGroupEntity", _columnsOpdsGroupEntity,
            _foreignKeysOpdsGroupEntity, _indicesOpdsGroupEntity)
        val _existingOpdsGroupEntity: TableInfo = read(connection, "OpdsGroupEntity")
        if (!_infoOpdsGroupEntity.equals(_existingOpdsGroupEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OpdsGroupEntity(world.respect.datalayer.db.opds.entities.OpdsGroupEntity).
              | Expected:
              |""".trimMargin() + _infoOpdsGroupEntity + """
              |
              | Found:
              |""".trimMargin() + _existingOpdsGroupEntity)
        }
        val _columnsOpdsFeedEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOpdsFeedEntity.put("ofeUid", TableInfo.Column("ofeUid", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedEntity.put("ofeUrl", TableInfo.Column("ofeUrl", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedEntity.put("ofeUrlHash", TableInfo.Column("ofeUrlHash", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedEntity.put("ofeLastModifiedHeader",
            TableInfo.Column("ofeLastModifiedHeader", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedEntity.put("ofeEtag", TableInfo.Column("ofeEtag", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOpdsFeedEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOpdsFeedEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOpdsFeedEntity: TableInfo = TableInfo("OpdsFeedEntity", _columnsOpdsFeedEntity,
            _foreignKeysOpdsFeedEntity, _indicesOpdsFeedEntity)
        val _existingOpdsFeedEntity: TableInfo = read(connection, "OpdsFeedEntity")
        if (!_infoOpdsFeedEntity.equals(_existingOpdsFeedEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OpdsFeedEntity(world.respect.datalayer.db.opds.entities.OpdsFeedEntity).
              | Expected:
              |""".trimMargin() + _infoOpdsFeedEntity + """
              |
              | Found:
              |""".trimMargin() + _existingOpdsFeedEntity)
        }
        val _columnsOpdsFeedMetadataEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOpdsFeedMetadataEntity.put("ofmeUid", TableInfo.Column("ofmeUid", "INTEGER", true,
            1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeOfeUid", TableInfo.Column("ofmeOfeUid", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmePropType", TableInfo.Column("ofmePropType",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmePropFk", TableInfo.Column("ofmePropFk", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeIdentifier", TableInfo.Column("ofmeIdentifier",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeType", TableInfo.Column("ofmeType", "TEXT", false,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeTitle", TableInfo.Column("ofmeTitle", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeSubtitle", TableInfo.Column("ofmeSubtitle", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeModified", TableInfo.Column("ofmeModified", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeDescription", TableInfo.Column("ofmeDescription",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeItemsPerPage", TableInfo.Column("ofmeItemsPerPage",
            "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeCurrentPage", TableInfo.Column("ofmeCurrentPage",
            "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOpdsFeedMetadataEntity.put("ofmeNumberOfItems",
            TableInfo.Column("ofmeNumberOfItems", "INTEGER", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOpdsFeedMetadataEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOpdsFeedMetadataEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOpdsFeedMetadataEntity: TableInfo = TableInfo("OpdsFeedMetadataEntity",
            _columnsOpdsFeedMetadataEntity, _foreignKeysOpdsFeedMetadataEntity,
            _indicesOpdsFeedMetadataEntity)
        val _existingOpdsFeedMetadataEntity: TableInfo = read(connection, "OpdsFeedMetadataEntity")
        if (!_infoOpdsFeedMetadataEntity.equals(_existingOpdsFeedMetadataEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OpdsFeedMetadataEntity(world.respect.datalayer.db.opds.entities.OpdsFeedMetadataEntity).
              | Expected:
              |""".trimMargin() + _infoOpdsFeedMetadataEntity + """
              |
              | Found:
              |""".trimMargin() + _existingOpdsFeedMetadataEntity)
        }
        val _columnsCompatibleAppEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsCompatibleAppEntity.put("caeUid", TableInfo.Column("caeUid", "INTEGER", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeUrl", TableInfo.Column("caeUrl", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeIcon", TableInfo.Column("caeIcon", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeLastModified", TableInfo.Column("caeLastModified",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeEtag", TableInfo.Column("caeEtag", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeLicense", TableInfo.Column("caeLicense", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeWebsite", TableInfo.Column("caeWebsite", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeLearningUnits", TableInfo.Column("caeLearningUnits",
            "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeDefaultLaunchUri",
            TableInfo.Column("caeDefaultLaunchUri", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeAndroidPackageId",
            TableInfo.Column("caeAndroidPackageId", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeAndroidStoreList",
            TableInfo.Column("caeAndroidStoreList", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppEntity.put("caeAndroidSourceCode",
            TableInfo.Column("caeAndroidSourceCode", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysCompatibleAppEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesCompatibleAppEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoCompatibleAppEntity: TableInfo = TableInfo("CompatibleAppEntity",
            _columnsCompatibleAppEntity, _foreignKeysCompatibleAppEntity,
            _indicesCompatibleAppEntity)
        val _existingCompatibleAppEntity: TableInfo = read(connection, "CompatibleAppEntity")
        if (!_infoCompatibleAppEntity.equals(_existingCompatibleAppEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |CompatibleAppEntity(world.respect.datalayer.db.compatibleapps.entities.CompatibleAppEntity).
              | Expected:
              |""".trimMargin() + _infoCompatibleAppEntity + """
              |
              | Found:
              |""".trimMargin() + _existingCompatibleAppEntity)
        }
        val _columnsCompatibleAppAddJoin: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsCompatibleAppAddJoin.put("appCaeUid", TableInfo.Column("appCaeUid", "INTEGER", true,
            1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCompatibleAppAddJoin.put("added", TableInfo.Column("added", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysCompatibleAppAddJoin: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesCompatibleAppAddJoin: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoCompatibleAppAddJoin: TableInfo = TableInfo("CompatibleAppAddJoin",
            _columnsCompatibleAppAddJoin, _foreignKeysCompatibleAppAddJoin,
            _indicesCompatibleAppAddJoin)
        val _existingCompatibleAppAddJoin: TableInfo = read(connection, "CompatibleAppAddJoin")
        if (!_infoCompatibleAppAddJoin.equals(_existingCompatibleAppAddJoin)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |CompatibleAppAddJoin(world.respect.datalayer.db.compatibleapps.entities.CompatibleAppAddJoin).
              | Expected:
              |""".trimMargin() + _infoCompatibleAppAddJoin + """
              |
              | Found:
              |""".trimMargin() + _existingCompatibleAppAddJoin)
        }
        val _columnsSchoolDirectoryEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsSchoolDirectoryEntity.put("rdUid", TableInfo.Column("rdUid", "INTEGER", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntity.put("rdUrl", TableInfo.Column("rdUrl", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntity.put("rdInvitePrefix", TableInfo.Column("rdInvitePrefix",
            "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysSchoolDirectoryEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesSchoolDirectoryEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoSchoolDirectoryEntity: TableInfo = TableInfo("SchoolDirectoryEntity",
            _columnsSchoolDirectoryEntity, _foreignKeysSchoolDirectoryEntity,
            _indicesSchoolDirectoryEntity)
        val _existingSchoolDirectoryEntity: TableInfo = read(connection, "SchoolDirectoryEntity")
        if (!_infoSchoolDirectoryEntity.equals(_existingSchoolDirectoryEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |SchoolDirectoryEntity(world.respect.datalayer.db.schooldirectory.entities.SchoolDirectoryEntity).
              | Expected:
              |""".trimMargin() + _infoSchoolDirectoryEntity + """
              |
              | Found:
              |""".trimMargin() + _existingSchoolDirectoryEntity)
        }
        val _columnsSchoolDirectoryEntryEntity: MutableMap<String, TableInfo.Column> =
            mutableMapOf()
        _columnsSchoolDirectoryEntryEntity.put("reUid", TableInfo.Column("reUid", "INTEGER", true,
            1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntryEntity.put("reLastMod", TableInfo.Column("reLastMod", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntryEntity.put("reEtag", TableInfo.Column("reEtag", "TEXT", false,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntryEntity.put("reSelf", TableInfo.Column("reSelf", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntryEntity.put("reXapi", TableInfo.Column("reXapi", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntryEntity.put("reOneRoster", TableInfo.Column("reOneRoster",
            "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolDirectoryEntryEntity.put("reRespectExt", TableInfo.Column("reRespectExt",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysSchoolDirectoryEntryEntity: MutableSet<TableInfo.ForeignKey> =
            mutableSetOf()
        val _indicesSchoolDirectoryEntryEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoSchoolDirectoryEntryEntity: TableInfo = TableInfo("SchoolDirectoryEntryEntity",
            _columnsSchoolDirectoryEntryEntity, _foreignKeysSchoolDirectoryEntryEntity,
            _indicesSchoolDirectoryEntryEntity)
        val _existingSchoolDirectoryEntryEntity: TableInfo = read(connection,
            "SchoolDirectoryEntryEntity")
        if (!_infoSchoolDirectoryEntryEntity.equals(_existingSchoolDirectoryEntryEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |SchoolDirectoryEntryEntity(world.respect.datalayer.db.schooldirectory.entities.SchoolDirectoryEntryEntity).
              | Expected:
              |""".trimMargin() + _infoSchoolDirectoryEntryEntity + """
              |
              | Found:
              |""".trimMargin() + _existingSchoolDirectoryEntryEntity)
        }
        val _columnsSchoolConfigEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsSchoolConfigEntity.put("rcUid", TableInfo.Column("rcUid", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsSchoolConfigEntity.put("dbUrl", TableInfo.Column("dbUrl", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysSchoolConfigEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesSchoolConfigEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoSchoolConfigEntity: TableInfo = TableInfo("SchoolConfigEntity",
            _columnsSchoolConfigEntity, _foreignKeysSchoolConfigEntity, _indicesSchoolConfigEntity)
        val _existingSchoolConfigEntity: TableInfo = read(connection, "SchoolConfigEntity")
        if (!_infoSchoolConfigEntity.equals(_existingSchoolConfigEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |SchoolConfigEntity(world.respect.datalayer.db.schooldirectory.entities.SchoolConfigEntity).
              | Expected:
              |""".trimMargin() + _infoSchoolConfigEntity + """
              |
              | Found:
              |""".trimMargin() + _existingSchoolConfigEntity)
        }
        val _columnsNetworkValidationInfoEntity: MutableMap<String, TableInfo.Column> =
            mutableMapOf()
        _columnsNetworkValidationInfoEntity.put("nviUrlHash", TableInfo.Column("nviUrlHash",
            "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNetworkValidationInfoEntity.put("nviKey", TableInfo.Column("nviKey", "INTEGER",
            true, 2, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNetworkValidationInfoEntity.put("nviVaryHeader", TableInfo.Column("nviVaryHeader",
            "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNetworkValidationInfoEntity.put("nviLastModified",
            TableInfo.Column("nviLastModified", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsNetworkValidationInfoEntity.put("nviEtag", TableInfo.Column("nviEtag", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNetworkValidationInfoEntity.put("nviConsistentThrough",
            TableInfo.Column("nviConsistentThrough", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsNetworkValidationInfoEntity.put("nviLastChecked", TableInfo.Column("nviLastChecked",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysNetworkValidationInfoEntity: MutableSet<TableInfo.ForeignKey> =
            mutableSetOf()
        val _indicesNetworkValidationInfoEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoNetworkValidationInfoEntity: TableInfo = TableInfo("NetworkValidationInfoEntity",
            _columnsNetworkValidationInfoEntity, _foreignKeysNetworkValidationInfoEntity,
            _indicesNetworkValidationInfoEntity)
        val _existingNetworkValidationInfoEntity: TableInfo = read(connection,
            "NetworkValidationInfoEntity")
        if (!_infoNetworkValidationInfoEntity.equals(_existingNetworkValidationInfoEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |NetworkValidationInfoEntity(world.respect.datalayer.db.networkvalidation.entities.NetworkValidationInfoEntity).
              | Expected:
              |""".trimMargin() + _infoNetworkValidationInfoEntity + """
              |
              | Found:
              |""".trimMargin() + _existingNetworkValidationInfoEntity)
        }
        return RoomOpenDelegate.ValidationResult(true, null)
      }
    }
    return _openDelegate
  }

  protected override fun createInvalidationTracker(): InvalidationTracker {
    val _shadowTablesMap: MutableMap<String, String> = mutableMapOf()
    val _viewTables: MutableMap<String, Set<String>> = mutableMapOf()
    return InvalidationTracker(this, _shadowTablesMap, _viewTables, "LangMapEntity",
        "ReadiumLinkEntity", "OpdsPublicationEntity", "ReadiumSubjectEntity", "OpdsFacetEntity",
        "OpdsGroupEntity", "OpdsFeedEntity", "OpdsFeedMetadataEntity", "CompatibleAppEntity",
        "CompatibleAppAddJoin", "SchoolDirectoryEntity", "SchoolDirectoryEntryEntity",
        "SchoolConfigEntity", "NetworkValidationInfoEntity")
  }

  public override fun clearAllTables() {
    super.performClear(false, "LangMapEntity", "ReadiumLinkEntity", "OpdsPublicationEntity",
        "ReadiumSubjectEntity", "OpdsFacetEntity", "OpdsGroupEntity", "OpdsFeedEntity",
        "OpdsFeedMetadataEntity", "CompatibleAppEntity", "CompatibleAppAddJoin",
        "SchoolDirectoryEntity", "SchoolDirectoryEntryEntity", "SchoolConfigEntity",
        "NetworkValidationInfoEntity")
  }

  protected override fun getRequiredTypeConverterClasses(): Map<KClass<*>, List<KClass<*>>> {
    val _typeConvertersMap: MutableMap<KClass<*>, List<KClass<*>>> = mutableMapOf()
    _typeConvertersMap.put(CompatibleAppEntityDao::class,
        CompatibleAppEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(CompatibleAppAddJoinDao::class,
        CompatibleAppAddJoinDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(LangMapEntityDao::class, LangMapEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OpdsFeedEntityDao::class, OpdsFeedEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OpdsPublicationEntityDao::class,
        OpdsPublicationEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OpdsFeedMetadataEntityDao::class,
        OpdsFeedMetadataEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(ReadiumLinkEntityDao::class,
        ReadiumLinkEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OpdsGroupEntityDao::class,
        OpdsGroupEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(SchoolDirectoryEntryEntityDao::class,
        SchoolDirectoryEntryEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(SchoolConfigEntityDao::class,
        SchoolConfigEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(SchoolDirectoryEntityDao::class,
        SchoolDirectoryEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(NetworkValidationInfoEntityDao::class,
        NetworkValidationInfoEntityDao_Impl.getRequiredConverters())
    return _typeConvertersMap
  }

  public override fun getRequiredAutoMigrationSpecClasses(): Set<KClass<out AutoMigrationSpec>> {
    val _autoMigrationSpecsSet: MutableSet<KClass<out AutoMigrationSpec>> = mutableSetOf()
    return _autoMigrationSpecsSet
  }

  public override
      fun createAutoMigrations(autoMigrationSpecs: Map<KClass<out AutoMigrationSpec>, AutoMigrationSpec>):
      List<Migration> {
    val _autoMigrations: MutableList<Migration> = mutableListOf()
    return _autoMigrations
  }

  public override fun getCompatibleAppEntityDao(): CompatibleAppEntityDao =
      _compatibleAppEntityDao.value

  public override fun getCompatibleAppAddJoinDao(): CompatibleAppAddJoinDao =
      _compatibleAppAddJoinDao.value

  public override fun getLangMapEntityDao(): LangMapEntityDao = _langMapEntityDao.value

  public override fun getOpdsFeedEntityDao(): OpdsFeedEntityDao = _opdsFeedEntityDao.value

  public override fun getOpdsPublicationEntityDao(): OpdsPublicationEntityDao =
      _opdsPublicationEntityDao.value

  public override fun getOpdsFeedMetadataEntityDao(): OpdsFeedMetadataEntityDao =
      _opdsFeedMetadataEntityDao.value

  public override fun getReadiumLinkEntityDao(): ReadiumLinkEntityDao = _readiumLinkEntityDao.value

  public override fun getOpdsGroupEntityDao(): OpdsGroupEntityDao = _opdsGroupEntityDao.value

  public override fun getSchoolEntityDao(): SchoolDirectoryEntryEntityDao =
      _schoolDirectoryEntryEntityDao.value

  public override fun getSchoolConfigEntityDao(): SchoolConfigEntityDao =
      _schoolConfigEntityDao.value

  public override fun getSchoolDirectoryEntityDao(): SchoolDirectoryEntityDao =
      _schoolDirectoryEntityDao.value

  public override fun getNetworkValidationInfoEntityDao(): NetworkValidationInfoEntityDao =
      _networkValidationInfoEntityDao.value
}
