package world.respect.datalayer.db.opds.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.opds.entities.OpdsFeedEntity
import world.respect.datalayer.db.shared.LastModifiedAndETagDb
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class OpdsFeedEntityDao_Impl(
  __db: RoomDatabase,
) : OpdsFeedEntityDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfOpdsFeedEntity: EntityInsertAdapter<OpdsFeedEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfOpdsFeedEntity = object : EntityInsertAdapter<OpdsFeedEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR ABORT INTO `OpdsFeedEntity` (`ofeUid`,`ofeUrl`,`ofeUrlHash`,`ofeLastModifiedHeader`,`ofeEtag`) VALUES (?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: OpdsFeedEntity) {
        statement.bindLong(1, entity.ofeUid)
        val _tmp: String? = __sharedConverters.fromUrl(entity.ofeUrl)
        if (_tmp == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp)
        }
        statement.bindLong(3, entity.ofeUrlHash)
        statement.bindLong(4, entity.ofeLastModifiedHeader)
        val _tmpOfeEtag: String? = entity.ofeEtag
        if (_tmpOfeEtag == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpOfeEtag)
        }
      }
    }
  }

  public override suspend fun insertList(entities: List<OpdsFeedEntity>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfOpdsFeedEntity.insert(_connection, entities)
  }

  public override fun findByUrlHashAsFlow(urlHash: Long): Flow<OpdsFeedEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |          FROM OpdsFeedEntity 
        |         WHERE ofeUrlHash = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("OpdsFeedEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, urlHash)
        val _columnIndexOfOfeUid: Int = getColumnIndexOrThrow(_stmt, "ofeUid")
        val _columnIndexOfOfeUrl: Int = getColumnIndexOrThrow(_stmt, "ofeUrl")
        val _columnIndexOfOfeUrlHash: Int = getColumnIndexOrThrow(_stmt, "ofeUrlHash")
        val _columnIndexOfOfeLastModifiedHeader: Int = getColumnIndexOrThrow(_stmt,
            "ofeLastModifiedHeader")
        val _columnIndexOfOfeEtag: Int = getColumnIndexOrThrow(_stmt, "ofeEtag")
        val _result: OpdsFeedEntity?
        if (_stmt.step()) {
          val _tmpOfeUid: Long
          _tmpOfeUid = _stmt.getLong(_columnIndexOfOfeUid)
          val _tmpOfeUrl: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfOfeUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfOfeUrl)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpOfeUrl = _tmp_1
          }
          val _tmpOfeUrlHash: Long
          _tmpOfeUrlHash = _stmt.getLong(_columnIndexOfOfeUrlHash)
          val _tmpOfeLastModifiedHeader: Long
          _tmpOfeLastModifiedHeader = _stmt.getLong(_columnIndexOfOfeLastModifiedHeader)
          val _tmpOfeEtag: String?
          if (_stmt.isNull(_columnIndexOfOfeEtag)) {
            _tmpOfeEtag = null
          } else {
            _tmpOfeEtag = _stmt.getText(_columnIndexOfOfeEtag)
          }
          _result =
              OpdsFeedEntity(_tmpOfeUid,_tmpOfeUrl,_tmpOfeUrlHash,_tmpOfeLastModifiedHeader,_tmpOfeEtag)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getLastModifiedAndETag(urlHash: Long): LastModifiedAndETagDb? {
    val _sql: String = """
        |
        |        SELECT OpdsFeedEntity.ofeLastModifiedHeader AS lastModified,
        |               OpdsFeedEntity.ofeEtag AS etag
        |          FROM OpdsFeedEntity
        |         WHERE ofeUrlHash = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, urlHash)
        val _columnIndexOfLastModified: Int = 0
        val _columnIndexOfEtag: Int = 1
        val _result: LastModifiedAndETagDb?
        if (_stmt.step()) {
          val _tmpLastModified: Long
          _tmpLastModified = _stmt.getLong(_columnIndexOfLastModified)
          val _tmpEtag: String?
          if (_stmt.isNull(_columnIndexOfEtag)) {
            _tmpEtag = null
          } else {
            _tmpEtag = _stmt.getText(_columnIndexOfEtag)
          }
          _result = LastModifiedAndETagDb(_tmpLastModified,_tmpEtag)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteByFeedUid(feedUid: Long) {
    val _sql: String = """
        |
        |        DELETE FROM OpdsFeedEntity 
        |         WHERE ofeUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
