package world.respect.datalayer.db.opds.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import com.eygraber.uri.Uri
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.opds.entities.OpdsPublicationEntity
import world.respect.datalayer.db.shared.LastModifiedAndETagDb
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class OpdsPublicationEntityDao_Impl(
  __db: RoomDatabase,
) : OpdsPublicationEntityDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfOpdsPublicationEntity: EntityInsertAdapter<OpdsPublicationEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfOpdsPublicationEntity = object :
        EntityInsertAdapter<OpdsPublicationEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR ABORT INTO `OpdsPublicationEntity` (`opeUid`,`opeOfeUid`,`opeOgeUid`,`opeIndex`,`opeUrl`,`opeUrlHash`,`opeLastModified`,`opeEtag`,`opeMdIdentifier`,`opeMdLanguage`,`opeMdType`,`opeMdDescription`,`opeMdNumberOfPages`,`opeMdDuration`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: OpdsPublicationEntity) {
        statement.bindLong(1, entity.opeUid)
        statement.bindLong(2, entity.opeOfeUid)
        statement.bindLong(3, entity.opeOgeUid)
        statement.bindLong(4, entity.opeIndex.toLong())
        val _tmpOpeUrl: Url? = entity.opeUrl
        val _tmp: String? = __sharedConverters.fromUrl(_tmpOpeUrl)
        if (_tmp == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmp)
        }
        statement.bindLong(6, entity.opeUrlHash)
        statement.bindLong(7, entity.opeLastModified)
        val _tmpOpeEtag: String? = entity.opeEtag
        if (_tmpOpeEtag == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpOpeEtag)
        }
        val _tmpOpeMdIdentifier: Uri? = entity.opeMdIdentifier
        val _tmp_1: String? = __sharedConverters.fromUri(_tmpOpeMdIdentifier)
        if (_tmp_1 == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmp_1)
        }
        val _tmpOpeMdLanguage: List<String>? = entity.opeMdLanguage
        val _tmp_2: String? = __sharedConverters.fromStringList(_tmpOpeMdLanguage)
        if (_tmp_2 == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmp_2)
        }
        val _tmpOpeMdType: Uri? = entity.opeMdType
        val _tmp_3: String? = __sharedConverters.fromUri(_tmpOpeMdType)
        if (_tmp_3 == null) {
          statement.bindNull(11)
        } else {
          statement.bindText(11, _tmp_3)
        }
        val _tmpOpeMdDescription: String? = entity.opeMdDescription
        if (_tmpOpeMdDescription == null) {
          statement.bindNull(12)
        } else {
          statement.bindText(12, _tmpOpeMdDescription)
        }
        val _tmpOpeMdNumberOfPages: Int? = entity.opeMdNumberOfPages
        if (_tmpOpeMdNumberOfPages == null) {
          statement.bindNull(13)
        } else {
          statement.bindLong(13, _tmpOpeMdNumberOfPages.toLong())
        }
        val _tmpOpeMdDuration: Double? = entity.opeMdDuration
        if (_tmpOpeMdDuration == null) {
          statement.bindNull(14)
        } else {
          statement.bindDouble(14, _tmpOpeMdDuration)
        }
      }
    }
  }

  public override suspend fun insertList(entities: List<OpdsPublicationEntity>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfOpdsPublicationEntity.insert(_connection, entities)
  }

  public override suspend fun findByFeedUid(feedUid: Long): List<OpdsPublicationEntity> {
    val _sql: String = """
        |
        |        SELECT OpdsPublicationEntity.*
        |          FROM OpdsPublicationEntity
        |         WHERE opeOfeUid = ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        val _columnIndexOfOpeUid: Int = getColumnIndexOrThrow(_stmt, "opeUid")
        val _columnIndexOfOpeOfeUid: Int = getColumnIndexOrThrow(_stmt, "opeOfeUid")
        val _columnIndexOfOpeOgeUid: Int = getColumnIndexOrThrow(_stmt, "opeOgeUid")
        val _columnIndexOfOpeIndex: Int = getColumnIndexOrThrow(_stmt, "opeIndex")
        val _columnIndexOfOpeUrl: Int = getColumnIndexOrThrow(_stmt, "opeUrl")
        val _columnIndexOfOpeUrlHash: Int = getColumnIndexOrThrow(_stmt, "opeUrlHash")
        val _columnIndexOfOpeLastModified: Int = getColumnIndexOrThrow(_stmt, "opeLastModified")
        val _columnIndexOfOpeEtag: Int = getColumnIndexOrThrow(_stmt, "opeEtag")
        val _columnIndexOfOpeMdIdentifier: Int = getColumnIndexOrThrow(_stmt, "opeMdIdentifier")
        val _columnIndexOfOpeMdLanguage: Int = getColumnIndexOrThrow(_stmt, "opeMdLanguage")
        val _columnIndexOfOpeMdType: Int = getColumnIndexOrThrow(_stmt, "opeMdType")
        val _columnIndexOfOpeMdDescription: Int = getColumnIndexOrThrow(_stmt, "opeMdDescription")
        val _columnIndexOfOpeMdNumberOfPages: Int = getColumnIndexOrThrow(_stmt,
            "opeMdNumberOfPages")
        val _columnIndexOfOpeMdDuration: Int = getColumnIndexOrThrow(_stmt, "opeMdDuration")
        val _result: MutableList<OpdsPublicationEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: OpdsPublicationEntity
          val _tmpOpeUid: Long
          _tmpOpeUid = _stmt.getLong(_columnIndexOfOpeUid)
          val _tmpOpeOfeUid: Long
          _tmpOpeOfeUid = _stmt.getLong(_columnIndexOfOpeOfeUid)
          val _tmpOpeOgeUid: Long
          _tmpOpeOgeUid = _stmt.getLong(_columnIndexOfOpeOgeUid)
          val _tmpOpeIndex: Int
          _tmpOpeIndex = _stmt.getLong(_columnIndexOfOpeIndex).toInt()
          val _tmpOpeUrl: Url?
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfOpeUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfOpeUrl)
          }
          _tmpOpeUrl = __sharedConverters.toUrl(_tmp)
          val _tmpOpeUrlHash: Long
          _tmpOpeUrlHash = _stmt.getLong(_columnIndexOfOpeUrlHash)
          val _tmpOpeLastModified: Long
          _tmpOpeLastModified = _stmt.getLong(_columnIndexOfOpeLastModified)
          val _tmpOpeEtag: String?
          if (_stmt.isNull(_columnIndexOfOpeEtag)) {
            _tmpOpeEtag = null
          } else {
            _tmpOpeEtag = _stmt.getText(_columnIndexOfOpeEtag)
          }
          val _tmpOpeMdIdentifier: Uri?
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfOpeMdIdentifier)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfOpeMdIdentifier)
          }
          _tmpOpeMdIdentifier = __sharedConverters.toUri(_tmp_1)
          val _tmpOpeMdLanguage: List<String>?
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfOpeMdLanguage)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfOpeMdLanguage)
          }
          _tmpOpeMdLanguage = __sharedConverters.toStringList(_tmp_2)
          val _tmpOpeMdType: Uri?
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfOpeMdType)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfOpeMdType)
          }
          _tmpOpeMdType = __sharedConverters.toUri(_tmp_3)
          val _tmpOpeMdDescription: String?
          if (_stmt.isNull(_columnIndexOfOpeMdDescription)) {
            _tmpOpeMdDescription = null
          } else {
            _tmpOpeMdDescription = _stmt.getText(_columnIndexOfOpeMdDescription)
          }
          val _tmpOpeMdNumberOfPages: Int?
          if (_stmt.isNull(_columnIndexOfOpeMdNumberOfPages)) {
            _tmpOpeMdNumberOfPages = null
          } else {
            _tmpOpeMdNumberOfPages = _stmt.getLong(_columnIndexOfOpeMdNumberOfPages).toInt()
          }
          val _tmpOpeMdDuration: Double?
          if (_stmt.isNull(_columnIndexOfOpeMdDuration)) {
            _tmpOpeMdDuration = null
          } else {
            _tmpOpeMdDuration = _stmt.getDouble(_columnIndexOfOpeMdDuration)
          }
          _item =
              OpdsPublicationEntity(_tmpOpeUid,_tmpOpeOfeUid,_tmpOpeOgeUid,_tmpOpeIndex,_tmpOpeUrl,_tmpOpeUrlHash,_tmpOpeLastModified,_tmpOpeEtag,_tmpOpeMdIdentifier,_tmpOpeMdLanguage,_tmpOpeMdType,_tmpOpeMdDescription,_tmpOpeMdNumberOfPages,_tmpOpeMdDuration)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getUidByUrlHash(urlHash: Long): Long {
    val _sql: String = """
        |
        |        SELECT OpdsPublicationEntity.opeUid
        |          FROM OpdsPublicationEntity
        |         WHERE OpdsPublicationEntity.opeUrlHash = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, urlHash)
        val _result: Long
        if (_stmt.step()) {
          _result = _stmt.getLong(0)
        } else {
          _result = 0L
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findByUrlHashAsFlow(urlHash: Long): Flow<OpdsPublicationEntity?> {
    val _sql: String = """
        |
        |        SELECT OpdsPublicationEntity.*
        |          FROM OpdsPublicationEntity
        |         WHERE OpdsPublicationEntity.opeUrlHash = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("OpdsPublicationEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, urlHash)
        val _columnIndexOfOpeUid: Int = getColumnIndexOrThrow(_stmt, "opeUid")
        val _columnIndexOfOpeOfeUid: Int = getColumnIndexOrThrow(_stmt, "opeOfeUid")
        val _columnIndexOfOpeOgeUid: Int = getColumnIndexOrThrow(_stmt, "opeOgeUid")
        val _columnIndexOfOpeIndex: Int = getColumnIndexOrThrow(_stmt, "opeIndex")
        val _columnIndexOfOpeUrl: Int = getColumnIndexOrThrow(_stmt, "opeUrl")
        val _columnIndexOfOpeUrlHash: Int = getColumnIndexOrThrow(_stmt, "opeUrlHash")
        val _columnIndexOfOpeLastModified: Int = getColumnIndexOrThrow(_stmt, "opeLastModified")
        val _columnIndexOfOpeEtag: Int = getColumnIndexOrThrow(_stmt, "opeEtag")
        val _columnIndexOfOpeMdIdentifier: Int = getColumnIndexOrThrow(_stmt, "opeMdIdentifier")
        val _columnIndexOfOpeMdLanguage: Int = getColumnIndexOrThrow(_stmt, "opeMdLanguage")
        val _columnIndexOfOpeMdType: Int = getColumnIndexOrThrow(_stmt, "opeMdType")
        val _columnIndexOfOpeMdDescription: Int = getColumnIndexOrThrow(_stmt, "opeMdDescription")
        val _columnIndexOfOpeMdNumberOfPages: Int = getColumnIndexOrThrow(_stmt,
            "opeMdNumberOfPages")
        val _columnIndexOfOpeMdDuration: Int = getColumnIndexOrThrow(_stmt, "opeMdDuration")
        val _result: OpdsPublicationEntity?
        if (_stmt.step()) {
          val _tmpOpeUid: Long
          _tmpOpeUid = _stmt.getLong(_columnIndexOfOpeUid)
          val _tmpOpeOfeUid: Long
          _tmpOpeOfeUid = _stmt.getLong(_columnIndexOfOpeOfeUid)
          val _tmpOpeOgeUid: Long
          _tmpOpeOgeUid = _stmt.getLong(_columnIndexOfOpeOgeUid)
          val _tmpOpeIndex: Int
          _tmpOpeIndex = _stmt.getLong(_columnIndexOfOpeIndex).toInt()
          val _tmpOpeUrl: Url?
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfOpeUrl)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfOpeUrl)
          }
          _tmpOpeUrl = __sharedConverters.toUrl(_tmp)
          val _tmpOpeUrlHash: Long
          _tmpOpeUrlHash = _stmt.getLong(_columnIndexOfOpeUrlHash)
          val _tmpOpeLastModified: Long
          _tmpOpeLastModified = _stmt.getLong(_columnIndexOfOpeLastModified)
          val _tmpOpeEtag: String?
          if (_stmt.isNull(_columnIndexOfOpeEtag)) {
            _tmpOpeEtag = null
          } else {
            _tmpOpeEtag = _stmt.getText(_columnIndexOfOpeEtag)
          }
          val _tmpOpeMdIdentifier: Uri?
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfOpeMdIdentifier)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfOpeMdIdentifier)
          }
          _tmpOpeMdIdentifier = __sharedConverters.toUri(_tmp_1)
          val _tmpOpeMdLanguage: List<String>?
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfOpeMdLanguage)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfOpeMdLanguage)
          }
          _tmpOpeMdLanguage = __sharedConverters.toStringList(_tmp_2)
          val _tmpOpeMdType: Uri?
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfOpeMdType)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfOpeMdType)
          }
          _tmpOpeMdType = __sharedConverters.toUri(_tmp_3)
          val _tmpOpeMdDescription: String?
          if (_stmt.isNull(_columnIndexOfOpeMdDescription)) {
            _tmpOpeMdDescription = null
          } else {
            _tmpOpeMdDescription = _stmt.getText(_columnIndexOfOpeMdDescription)
          }
          val _tmpOpeMdNumberOfPages: Int?
          if (_stmt.isNull(_columnIndexOfOpeMdNumberOfPages)) {
            _tmpOpeMdNumberOfPages = null
          } else {
            _tmpOpeMdNumberOfPages = _stmt.getLong(_columnIndexOfOpeMdNumberOfPages).toInt()
          }
          val _tmpOpeMdDuration: Double?
          if (_stmt.isNull(_columnIndexOfOpeMdDuration)) {
            _tmpOpeMdDuration = null
          } else {
            _tmpOpeMdDuration = _stmt.getDouble(_columnIndexOfOpeMdDuration)
          }
          _result =
              OpdsPublicationEntity(_tmpOpeUid,_tmpOpeOfeUid,_tmpOpeOgeUid,_tmpOpeIndex,_tmpOpeUrl,_tmpOpeUrlHash,_tmpOpeLastModified,_tmpOpeEtag,_tmpOpeMdIdentifier,_tmpOpeMdLanguage,_tmpOpeMdType,_tmpOpeMdDescription,_tmpOpeMdNumberOfPages,_tmpOpeMdDuration)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getLastModifiedAndETag(urlHash: Long): LastModifiedAndETagDb? {
    val _sql: String = """
        |
        |        SELECT OpdsPublicationEntity.opeLastModified AS lastModified,
        |               OpdsPublicationEntity.opeEtag AS etag
        |          FROM OpdsPublicationEntity
        |         WHERE OpdsPublicationEntity.opeUrlHash = ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, urlHash)
        val _columnIndexOfLastModified: Int = 0
        val _columnIndexOfEtag: Int = 1
        val _result: LastModifiedAndETagDb?
        if (_stmt.step()) {
          val _tmpLastModified: Long
          _tmpLastModified = _stmt.getLong(_columnIndexOfLastModified)
          val _tmpEtag: String?
          if (_stmt.isNull(_columnIndexOfEtag)) {
            _tmpEtag = null
          } else {
            _tmpEtag = _stmt.getText(_columnIndexOfEtag)
          }
          _result = LastModifiedAndETagDb(_tmpLastModified,_tmpEtag)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAllByFeedUid(feedUid: Long) {
    val _sql: String = """
        |
        |        DELETE FROM OpdsPublicationEntity 
        |         WHERE opeOfeUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, feedUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteByUid(pubUid: Long) {
    val _sql: String = """
        |
        |        DELETE FROM OpdsPublicationEntity 
        |         WHERE opeUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, pubUid)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
