package world.respect.datalayer.db.school.daos

import androidx.room.EntityDeleteOrUpdateAdapter
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.coroutines.createFlow
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.realm.entities.IndicatorEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class IndicatorEntityDao_Impl(
  __db: RoomDatabase,
) : IndicatorEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfIndicatorEntity: EntityInsertAdapter<IndicatorEntity>

  private val __updateAdapterOfIndicatorEntity: EntityDeleteOrUpdateAdapter<IndicatorEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfIndicatorEntity = object : EntityInsertAdapter<IndicatorEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `IndicatorEntity` (`indicatorId`,`name`,`description`,`type`,`sql`) VALUES (?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: IndicatorEntity) {
        statement.bindText(1, entity.indicatorId)
        statement.bindText(2, entity.name)
        statement.bindText(3, entity.description)
        statement.bindText(4, entity.type)
        statement.bindText(5, entity.sql)
      }
    }
    this.__updateAdapterOfIndicatorEntity = object : EntityDeleteOrUpdateAdapter<IndicatorEntity>()
        {
      protected override fun createQuery(): String =
          "UPDATE OR ABORT `IndicatorEntity` SET `indicatorId` = ?,`name` = ?,`description` = ?,`type` = ?,`sql` = ? WHERE `indicatorId` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: IndicatorEntity) {
        statement.bindText(1, entity.indicatorId)
        statement.bindText(2, entity.name)
        statement.bindText(3, entity.description)
        statement.bindText(4, entity.type)
        statement.bindText(5, entity.sql)
        statement.bindText(6, entity.indicatorId)
      }
    }
  }

  public override suspend fun putIndicator(indicatorEntity: IndicatorEntity): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfIndicatorEntity.insert(_connection, indicatorEntity)
  }

  public override suspend fun updateIndicator(entity: IndicatorEntity): Unit =
      performSuspending(__db, false, true) { _connection ->
    __updateAdapterOfIndicatorEntity.handle(_connection, entity)
  }

  public override fun getAllIndicator(): Flow<List<IndicatorEntity>> {
    val _sql: String = """
        |
        |        SELECT * 
        |        FROM IndicatorEntity
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("IndicatorEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfIndicatorId: Int = getColumnIndexOrThrow(_stmt, "indicatorId")
        val _columnIndexOfName: Int = getColumnIndexOrThrow(_stmt, "name")
        val _columnIndexOfDescription: Int = getColumnIndexOrThrow(_stmt, "description")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfSql: Int = getColumnIndexOrThrow(_stmt, "sql")
        val _result: MutableList<IndicatorEntity> = mutableListOf()
        while (_stmt.step()) {
          val _item: IndicatorEntity
          val _tmpIndicatorId: String
          _tmpIndicatorId = _stmt.getText(_columnIndexOfIndicatorId)
          val _tmpName: String
          _tmpName = _stmt.getText(_columnIndexOfName)
          val _tmpDescription: String
          _tmpDescription = _stmt.getText(_columnIndexOfDescription)
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpSql: String
          _tmpSql = _stmt.getText(_columnIndexOfSql)
          _item = IndicatorEntity(_tmpIndicatorId,_tmpName,_tmpDescription,_tmpType,_tmpSql)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getIndicatorAsync(indicatorId: String): IndicatorEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM IndicatorEntity
        |        WHERE indicatorId = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, indicatorId)
        val _columnIndexOfIndicatorId: Int = getColumnIndexOrThrow(_stmt, "indicatorId")
        val _columnIndexOfName: Int = getColumnIndexOrThrow(_stmt, "name")
        val _columnIndexOfDescription: Int = getColumnIndexOrThrow(_stmt, "description")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfSql: Int = getColumnIndexOrThrow(_stmt, "sql")
        val _result: IndicatorEntity?
        if (_stmt.step()) {
          val _tmpIndicatorId: String
          _tmpIndicatorId = _stmt.getText(_columnIndexOfIndicatorId)
          val _tmpName: String
          _tmpName = _stmt.getText(_columnIndexOfName)
          val _tmpDescription: String
          _tmpDescription = _stmt.getText(_columnIndexOfDescription)
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpSql: String
          _tmpSql = _stmt.getText(_columnIndexOfSql)
          _result = IndicatorEntity(_tmpIndicatorId,_tmpName,_tmpDescription,_tmpType,_tmpSql)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun getIndicatorAsFlow(indicatorId: String): Flow<IndicatorEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM IndicatorEntity
        |        WHERE indicatorId = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("IndicatorEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, indicatorId)
        val _columnIndexOfIndicatorId: Int = getColumnIndexOrThrow(_stmt, "indicatorId")
        val _columnIndexOfName: Int = getColumnIndexOrThrow(_stmt, "name")
        val _columnIndexOfDescription: Int = getColumnIndexOrThrow(_stmt, "description")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfSql: Int = getColumnIndexOrThrow(_stmt, "sql")
        val _result: IndicatorEntity?
        if (_stmt.step()) {
          val _tmpIndicatorId: String
          _tmpIndicatorId = _stmt.getText(_columnIndexOfIndicatorId)
          val _tmpName: String
          _tmpName = _stmt.getText(_columnIndexOfName)
          val _tmpDescription: String
          _tmpDescription = _stmt.getText(_columnIndexOfDescription)
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpSql: String
          _tmpSql = _stmt.getText(_columnIndexOfSql)
          _result = IndicatorEntity(_tmpIndicatorId,_tmpName,_tmpDescription,_tmpType,_tmpSql)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getIndicatorCount(): Int {
    val _sql: String = "SELECT COUNT(*) FROM IndicatorEntity"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _result: Int
        if (_stmt.step()) {
          val _tmp: Int
          _tmp = _stmt.getLong(0).toInt()
          _result = _tmp
        } else {
          _result = 0
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
