package world.respect.datalayer.db.school.daos

import androidx.paging.PagingSource
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.RoomRawQuery
import androidx.room.coroutines.createFlow
import androidx.room.paging.LimitOffsetPagingSource
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.time.Instant
import kotlinx.coroutines.flow.Flow
import world.respect.datalayer.db.school.SchoolTypeConverters
import world.respect.datalayer.db.school.entities.ClassEntity
import world.respect.datalayer.db.shared.SharedConverters
import world.respect.datalayer.school.model.StatusEnum

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class ClazzEntityDao_Impl(
  __db: RoomDatabase,
) : ClazzEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfClassEntity: EntityInsertAdapter<ClassEntity>

  private val __schoolTypeConverters: SchoolTypeConverters = SchoolTypeConverters()

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfClassEntity = object : EntityInsertAdapter<ClassEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `ClassEntity` (`cGuid`,`cGuidHash`,`cTitle`,`cStatus`,`cDescription`,`cLastModified`,`cStored`,`cTeacherInviteCode`,`cStudentInviteCode`) VALUES (?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: ClassEntity) {
        statement.bindText(1, entity.cGuid)
        statement.bindLong(2, entity.cGuidHash)
        statement.bindText(3, entity.cTitle)
        val _tmp: Int = __schoolTypeConverters.fromStatusEnum(entity.cStatus)
        statement.bindLong(4, _tmp.toLong())
        val _tmpCDescription: String? = entity.cDescription
        if (_tmpCDescription == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpCDescription)
        }
        val _tmp_1: Long? = __sharedConverters.fromInstant(entity.cLastModified)
        if (_tmp_1 == null) {
          statement.bindNull(6)
        } else {
          statement.bindLong(6, _tmp_1)
        }
        val _tmp_2: Long? = __sharedConverters.fromInstant(entity.cStored)
        if (_tmp_2 == null) {
          statement.bindNull(7)
        } else {
          statement.bindLong(7, _tmp_2)
        }
        val _tmpCTeacherInviteCode: String? = entity.cTeacherInviteCode
        if (_tmpCTeacherInviteCode == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpCTeacherInviteCode)
        }
        val _tmpCStudentInviteCode: String? = entity.cStudentInviteCode
        if (_tmpCStudentInviteCode == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpCStudentInviteCode)
        }
      }
    }
  }

  public override suspend fun upsert(classEntity: ClassEntity): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfClassEntity.insert(_connection, classEntity)
  }

  public override fun findByGuidHashAsFlow(guidHash: Long): Flow<ClassEntity?> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM ClassEntity
        |        WHERE ClassEntity.cGuidHash = ?
        |    
        """.trimMargin()
    return createFlow(__db, false, arrayOf("ClassEntity")) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfCGuid: Int = getColumnIndexOrThrow(_stmt, "cGuid")
        val _columnIndexOfCGuidHash: Int = getColumnIndexOrThrow(_stmt, "cGuidHash")
        val _columnIndexOfCTitle: Int = getColumnIndexOrThrow(_stmt, "cTitle")
        val _columnIndexOfCStatus: Int = getColumnIndexOrThrow(_stmt, "cStatus")
        val _columnIndexOfCDescription: Int = getColumnIndexOrThrow(_stmt, "cDescription")
        val _columnIndexOfCLastModified: Int = getColumnIndexOrThrow(_stmt, "cLastModified")
        val _columnIndexOfCStored: Int = getColumnIndexOrThrow(_stmt, "cStored")
        val _columnIndexOfCTeacherInviteCode: Int = getColumnIndexOrThrow(_stmt,
            "cTeacherInviteCode")
        val _columnIndexOfCStudentInviteCode: Int = getColumnIndexOrThrow(_stmt,
            "cStudentInviteCode")
        val _result: ClassEntity?
        if (_stmt.step()) {
          val _tmpCGuid: String
          _tmpCGuid = _stmt.getText(_columnIndexOfCGuid)
          val _tmpCGuidHash: Long
          _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash)
          val _tmpCTitle: String
          _tmpCTitle = _stmt.getText(_columnIndexOfCTitle)
          val _tmpCStatus: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfCStatus).toInt()
          _tmpCStatus = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpCDescription: String?
          if (_stmt.isNull(_columnIndexOfCDescription)) {
            _tmpCDescription = null
          } else {
            _tmpCDescription = _stmt.getText(_columnIndexOfCDescription)
          }
          val _tmpCLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfCLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfCLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpCLastModified = _tmp_2
          }
          val _tmpCStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfCStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfCStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpCStored = _tmp_4
          }
          val _tmpCTeacherInviteCode: String?
          if (_stmt.isNull(_columnIndexOfCTeacherInviteCode)) {
            _tmpCTeacherInviteCode = null
          } else {
            _tmpCTeacherInviteCode = _stmt.getText(_columnIndexOfCTeacherInviteCode)
          }
          val _tmpCStudentInviteCode: String?
          if (_stmt.isNull(_columnIndexOfCStudentInviteCode)) {
            _tmpCStudentInviteCode = null
          } else {
            _tmpCStudentInviteCode = _stmt.getText(_columnIndexOfCStudentInviteCode)
          }
          _result =
              ClassEntity(_tmpCGuid,_tmpCGuidHash,_tmpCTitle,_tmpCStatus,_tmpCDescription,_tmpCLastModified,_tmpCStored,_tmpCTeacherInviteCode,_tmpCStudentInviteCode)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByGuid(guidHash: Long): ClassEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM ClassEntity
        |        WHERE ClassEntity.cGuidHash = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, guidHash)
        val _columnIndexOfCGuid: Int = getColumnIndexOrThrow(_stmt, "cGuid")
        val _columnIndexOfCGuidHash: Int = getColumnIndexOrThrow(_stmt, "cGuidHash")
        val _columnIndexOfCTitle: Int = getColumnIndexOrThrow(_stmt, "cTitle")
        val _columnIndexOfCStatus: Int = getColumnIndexOrThrow(_stmt, "cStatus")
        val _columnIndexOfCDescription: Int = getColumnIndexOrThrow(_stmt, "cDescription")
        val _columnIndexOfCLastModified: Int = getColumnIndexOrThrow(_stmt, "cLastModified")
        val _columnIndexOfCStored: Int = getColumnIndexOrThrow(_stmt, "cStored")
        val _columnIndexOfCTeacherInviteCode: Int = getColumnIndexOrThrow(_stmt,
            "cTeacherInviteCode")
        val _columnIndexOfCStudentInviteCode: Int = getColumnIndexOrThrow(_stmt,
            "cStudentInviteCode")
        val _result: ClassEntity?
        if (_stmt.step()) {
          val _tmpCGuid: String
          _tmpCGuid = _stmt.getText(_columnIndexOfCGuid)
          val _tmpCGuidHash: Long
          _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash)
          val _tmpCTitle: String
          _tmpCTitle = _stmt.getText(_columnIndexOfCTitle)
          val _tmpCStatus: StatusEnum
          val _tmp: Int
          _tmp = _stmt.getLong(_columnIndexOfCStatus).toInt()
          _tmpCStatus = __schoolTypeConverters.toStatusEnum(_tmp)
          val _tmpCDescription: String?
          if (_stmt.isNull(_columnIndexOfCDescription)) {
            _tmpCDescription = null
          } else {
            _tmpCDescription = _stmt.getText(_columnIndexOfCDescription)
          }
          val _tmpCLastModified: Instant
          val _tmp_1: Long?
          if (_stmt.isNull(_columnIndexOfCLastModified)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getLong(_columnIndexOfCLastModified)
          }
          val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpCLastModified = _tmp_2
          }
          val _tmpCStored: Instant
          val _tmp_3: Long?
          if (_stmt.isNull(_columnIndexOfCStored)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getLong(_columnIndexOfCStored)
          }
          val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
          } else {
            _tmpCStored = _tmp_4
          }
          val _tmpCTeacherInviteCode: String?
          if (_stmt.isNull(_columnIndexOfCTeacherInviteCode)) {
            _tmpCTeacherInviteCode = null
          } else {
            _tmpCTeacherInviteCode = _stmt.getText(_columnIndexOfCTeacherInviteCode)
          }
          val _tmpCStudentInviteCode: String?
          if (_stmt.isNull(_columnIndexOfCStudentInviteCode)) {
            _tmpCStudentInviteCode = null
          } else {
            _tmpCStudentInviteCode = _stmt.getText(_columnIndexOfCStudentInviteCode)
          }
          _result =
              ClassEntity(_tmpCGuid,_tmpCGuidHash,_tmpCTitle,_tmpCStatus,_tmpCDescription,_tmpCLastModified,_tmpCStored,_tmpCTeacherInviteCode,_tmpCStudentInviteCode)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override fun findAllAsPagingSource(since: Long, guidHash: Long):
      PagingSource<Int, ClassEntity> {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM ClassEntity
        |        WHERE ClassEntity.cStored > ? 
        |          AND (? = 0 OR ClassEntity.cGuidHash = ?)
        |     ORDER BY ClassEntity.cTitle
        |    
        """.trimMargin()
    val _rawQuery: RoomRawQuery = RoomRawQuery(_sql) { _stmt ->
      var _argIndex: Int = 1
      _stmt.bindLong(_argIndex, since)
      _argIndex = 2
      _stmt.bindLong(_argIndex, guidHash)
      _argIndex = 3
      _stmt.bindLong(_argIndex, guidHash)
    }
    return object : LimitOffsetPagingSource<ClassEntity>(_rawQuery, __db, "ClassEntity") {
      protected override suspend fun convertRows(limitOffsetQuery: RoomRawQuery, itemCount: Int):
          List<ClassEntity> = performSuspending(__db, true, false) { _connection ->
        val _stmt: SQLiteStatement = _connection.prepare(limitOffsetQuery.sql)
        limitOffsetQuery.getBindingFunction().invoke(_stmt)
        try {
          val _columnIndexOfCGuid: Int = getColumnIndexOrThrow(_stmt, "cGuid")
          val _columnIndexOfCGuidHash: Int = getColumnIndexOrThrow(_stmt, "cGuidHash")
          val _columnIndexOfCTitle: Int = getColumnIndexOrThrow(_stmt, "cTitle")
          val _columnIndexOfCStatus: Int = getColumnIndexOrThrow(_stmt, "cStatus")
          val _columnIndexOfCDescription: Int = getColumnIndexOrThrow(_stmt, "cDescription")
          val _columnIndexOfCLastModified: Int = getColumnIndexOrThrow(_stmt, "cLastModified")
          val _columnIndexOfCStored: Int = getColumnIndexOrThrow(_stmt, "cStored")
          val _columnIndexOfCTeacherInviteCode: Int = getColumnIndexOrThrow(_stmt,
              "cTeacherInviteCode")
          val _columnIndexOfCStudentInviteCode: Int = getColumnIndexOrThrow(_stmt,
              "cStudentInviteCode")
          val _result: MutableList<ClassEntity> = mutableListOf()
          while (_stmt.step()) {
            val _item: ClassEntity
            val _tmpCGuid: String
            _tmpCGuid = _stmt.getText(_columnIndexOfCGuid)
            val _tmpCGuidHash: Long
            _tmpCGuidHash = _stmt.getLong(_columnIndexOfCGuidHash)
            val _tmpCTitle: String
            _tmpCTitle = _stmt.getText(_columnIndexOfCTitle)
            val _tmpCStatus: StatusEnum
            val _tmp: Int
            _tmp = _stmt.getLong(_columnIndexOfCStatus).toInt()
            _tmpCStatus = __schoolTypeConverters.toStatusEnum(_tmp)
            val _tmpCDescription: String?
            if (_stmt.isNull(_columnIndexOfCDescription)) {
              _tmpCDescription = null
            } else {
              _tmpCDescription = _stmt.getText(_columnIndexOfCDescription)
            }
            val _tmpCLastModified: Instant
            val _tmp_1: Long?
            if (_stmt.isNull(_columnIndexOfCLastModified)) {
              _tmp_1 = null
            } else {
              _tmp_1 = _stmt.getLong(_columnIndexOfCLastModified)
            }
            val _tmp_2: Instant? = __sharedConverters.toInstant(_tmp_1)
            if (_tmp_2 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpCLastModified = _tmp_2
            }
            val _tmpCStored: Instant
            val _tmp_3: Long?
            if (_stmt.isNull(_columnIndexOfCStored)) {
              _tmp_3 = null
            } else {
              _tmp_3 = _stmt.getLong(_columnIndexOfCStored)
            }
            val _tmp_4: Instant? = __sharedConverters.toInstant(_tmp_3)
            if (_tmp_4 == null) {
              error("Expected NON-NULL 'kotlin.time.Instant', but it was NULL.")
            } else {
              _tmpCStored = _tmp_4
            }
            val _tmpCTeacherInviteCode: String?
            if (_stmt.isNull(_columnIndexOfCTeacherInviteCode)) {
              _tmpCTeacherInviteCode = null
            } else {
              _tmpCTeacherInviteCode = _stmt.getText(_columnIndexOfCTeacherInviteCode)
            }
            val _tmpCStudentInviteCode: String?
            if (_stmt.isNull(_columnIndexOfCStudentInviteCode)) {
              _tmpCStudentInviteCode = null
            } else {
              _tmpCStudentInviteCode = _stmt.getText(_columnIndexOfCStudentInviteCode)
            }
            _item =
                ClassEntity(_tmpCGuid,_tmpCGuidHash,_tmpCTitle,_tmpCStatus,_tmpCDescription,_tmpCLastModified,_tmpCStored,_tmpCTeacherInviteCode,_tmpCStudentInviteCode)
            _result.add(_item)
          }
          _result
        } finally {
          _stmt.close()
        }
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
