package world.respect.datalayer.db.school.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.school.entities.PersonPasswordEntity

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class PersonPasswordEntityDao_Impl(
  __db: RoomDatabase,
) : PersonPasswordEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfPersonPasswordEntity: EntityInsertAdapter<PersonPasswordEntity>
  init {
    this.__db = __db
    this.__insertAdapterOfPersonPasswordEntity = object :
        EntityInsertAdapter<PersonPasswordEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `PersonPasswordEntity` (`pppGuid`,`authAlgorithm`,`authEncoded`,`authSalt`,`authIterations`,`authKeyLen`) VALUES (?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: PersonPasswordEntity) {
        statement.bindLong(1, entity.pppGuid)
        statement.bindText(2, entity.authAlgorithm)
        statement.bindText(3, entity.authEncoded)
        statement.bindText(4, entity.authSalt)
        statement.bindLong(5, entity.authIterations.toLong())
        statement.bindLong(6, entity.authKeyLen.toLong())
      }
    }
  }

  public override suspend fun upsert(personPasswordEntity: PersonPasswordEntity): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfPersonPasswordEntity.insert(_connection, personPasswordEntity)
  }

  public override suspend fun findByUid(uid: Long): PersonPasswordEntity? {
    val _sql: String = """
        |
        |            SELECT * 
        |             FROM PersonPasswordEntity
        |            WHERE pppGuid = ?
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid)
        val _columnIndexOfPppGuid: Int = getColumnIndexOrThrow(_stmt, "pppGuid")
        val _columnIndexOfAuthAlgorithm: Int = getColumnIndexOrThrow(_stmt, "authAlgorithm")
        val _columnIndexOfAuthEncoded: Int = getColumnIndexOrThrow(_stmt, "authEncoded")
        val _columnIndexOfAuthSalt: Int = getColumnIndexOrThrow(_stmt, "authSalt")
        val _columnIndexOfAuthIterations: Int = getColumnIndexOrThrow(_stmt, "authIterations")
        val _columnIndexOfAuthKeyLen: Int = getColumnIndexOrThrow(_stmt, "authKeyLen")
        val _result: PersonPasswordEntity?
        if (_stmt.step()) {
          val _tmpPppGuid: Long
          _tmpPppGuid = _stmt.getLong(_columnIndexOfPppGuid)
          val _tmpAuthAlgorithm: String
          _tmpAuthAlgorithm = _stmt.getText(_columnIndexOfAuthAlgorithm)
          val _tmpAuthEncoded: String
          _tmpAuthEncoded = _stmt.getText(_columnIndexOfAuthEncoded)
          val _tmpAuthSalt: String
          _tmpAuthSalt = _stmt.getText(_columnIndexOfAuthSalt)
          val _tmpAuthIterations: Int
          _tmpAuthIterations = _stmt.getLong(_columnIndexOfAuthIterations).toInt()
          val _tmpAuthKeyLen: Int
          _tmpAuthKeyLen = _stmt.getLong(_columnIndexOfAuthKeyLen).toInt()
          _result =
              PersonPasswordEntity(_tmpPppGuid,_tmpAuthAlgorithm,_tmpAuthEncoded,_tmpAuthSalt,_tmpAuthIterations,_tmpAuthKeyLen)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
