package world.respect.datalayer.db.schooldirectory.daos

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import io.ktor.http.Url
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import world.respect.datalayer.db.schooldirectory.entities.SchoolDirectoryEntryEntity
import world.respect.datalayer.db.shared.SharedConverters

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class SchoolDirectoryEntryEntityDao_Impl(
  __db: RoomDatabase,
) : SchoolDirectoryEntryEntityDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfSchoolDirectoryEntryEntity:
      EntityInsertAdapter<SchoolDirectoryEntryEntity>

  private val __sharedConverters: SharedConverters = SharedConverters()
  init {
    this.__db = __db
    this.__insertAdapterOfSchoolDirectoryEntryEntity = object :
        EntityInsertAdapter<SchoolDirectoryEntryEntity>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `SchoolDirectoryEntryEntity` (`reUid`,`reLastMod`,`reEtag`,`reSelf`,`reXapi`,`reOneRoster`,`reRespectExt`) VALUES (?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: SchoolDirectoryEntryEntity) {
        statement.bindLong(1, entity.reUid)
        statement.bindLong(2, entity.reLastMod)
        val _tmpReEtag: String? = entity.reEtag
        if (_tmpReEtag == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmpReEtag)
        }
        val _tmp: String? = __sharedConverters.fromUrl(entity.reSelf)
        if (_tmp == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmp)
        }
        val _tmp_1: String? = __sharedConverters.fromUrl(entity.reXapi)
        if (_tmp_1 == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmp_1)
        }
        val _tmp_2: String? = __sharedConverters.fromUrl(entity.reOneRoster)
        if (_tmp_2 == null) {
          statement.bindNull(6)
        } else {
          statement.bindText(6, _tmp_2)
        }
        val _tmpReRespectExt: Url? = entity.reRespectExt
        val _tmp_3: String? = __sharedConverters.fromUrl(_tmpReRespectExt)
        if (_tmp_3 == null) {
          statement.bindNull(7)
        } else {
          statement.bindText(7, _tmp_3)
        }
      }
    }
  }

  public override suspend fun upsert(realmEntity: SchoolDirectoryEntryEntity): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfSchoolDirectoryEntryEntity.insert(_connection, realmEntity)
  }

  public override suspend fun findByUid(uid: Long): SchoolDirectoryEntryEntity? {
    val _sql: String = """
        |
        |        SELECT * 
        |         FROM SchoolDirectoryEntryEntity
        |        WHERE reUid = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, uid)
        val _columnIndexOfReUid: Int = getColumnIndexOrThrow(_stmt, "reUid")
        val _columnIndexOfReLastMod: Int = getColumnIndexOrThrow(_stmt, "reLastMod")
        val _columnIndexOfReEtag: Int = getColumnIndexOrThrow(_stmt, "reEtag")
        val _columnIndexOfReSelf: Int = getColumnIndexOrThrow(_stmt, "reSelf")
        val _columnIndexOfReXapi: Int = getColumnIndexOrThrow(_stmt, "reXapi")
        val _columnIndexOfReOneRoster: Int = getColumnIndexOrThrow(_stmt, "reOneRoster")
        val _columnIndexOfReRespectExt: Int = getColumnIndexOrThrow(_stmt, "reRespectExt")
        val _result: SchoolDirectoryEntryEntity?
        if (_stmt.step()) {
          val _tmpReUid: Long
          _tmpReUid = _stmt.getLong(_columnIndexOfReUid)
          val _tmpReLastMod: Long
          _tmpReLastMod = _stmt.getLong(_columnIndexOfReLastMod)
          val _tmpReEtag: String?
          if (_stmt.isNull(_columnIndexOfReEtag)) {
            _tmpReEtag = null
          } else {
            _tmpReEtag = _stmt.getText(_columnIndexOfReEtag)
          }
          val _tmpReSelf: Url
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfReSelf)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfReSelf)
          }
          val _tmp_1: Url? = __sharedConverters.toUrl(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReSelf = _tmp_1
          }
          val _tmpReXapi: Url
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfReXapi)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfReXapi)
          }
          val _tmp_3: Url? = __sharedConverters.toUrl(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReXapi = _tmp_3
          }
          val _tmpReOneRoster: Url
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfReOneRoster)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfReOneRoster)
          }
          val _tmp_5: Url? = __sharedConverters.toUrl(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'io.ktor.http.Url', but it was NULL.")
          } else {
            _tmpReOneRoster = _tmp_5
          }
          val _tmpReRespectExt: Url?
          val _tmp_6: String?
          if (_stmt.isNull(_columnIndexOfReRespectExt)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getText(_columnIndexOfReRespectExt)
          }
          _tmpReRespectExt = __sharedConverters.toUrl(_tmp_6)
          _result =
              SchoolDirectoryEntryEntity(_tmpReUid,_tmpReLastMod,_tmpReEtag,_tmpReSelf,_tmpReXapi,_tmpReOneRoster,_tmpReRespectExt)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
