package com.ustadmobile.libcache.db.dao

import androidx.room.EntityDeleteOrUpdateAdapter
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import com.ustadmobile.libcache.db.entities.CacheEntry
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class CacheEntryDao_Impl(
  __db: RoomDatabase,
) : CacheEntryDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfCacheEntry: EntityInsertAdapter<CacheEntry>

  private val __insertAdapterOfCacheEntry_1: EntityInsertAdapter<CacheEntry>

  private val __deleteAdapterOfCacheEntry: EntityDeleteOrUpdateAdapter<CacheEntry>

  private val __updateAdapterOfCacheEntry: EntityDeleteOrUpdateAdapter<CacheEntry>
  init {
    this.__db = __db
    this.__insertAdapterOfCacheEntry = object : EntityInsertAdapter<CacheEntry>() {
      protected override fun createQuery(): String =
          "INSERT OR ABORT INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: CacheEntry) {
        statement.bindText(1, entity.key)
        statement.bindText(2, entity.url)
        statement.bindText(3, entity.message)
        statement.bindLong(4, entity.statusCode.toLong())
        statement.bindLong(5, entity.cacheFlags.toLong())
        statement.bindLong(6, entity.method.toLong())
        statement.bindLong(7, entity.lastAccessed)
        statement.bindLong(8, entity.lastValidated)
        val _tmpIntegrity: String? = entity.integrity
        if (_tmpIntegrity == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpIntegrity)
        }
        statement.bindText(10, entity.responseHeaders)
        statement.bindText(11, entity.storageUri)
        statement.bindLong(12, entity.storageSize)
        statement.bindLong(13, entity.uncompressedSize)
      }
    }
    this.__insertAdapterOfCacheEntry_1 = object : EntityInsertAdapter<CacheEntry>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: CacheEntry) {
        statement.bindText(1, entity.key)
        statement.bindText(2, entity.url)
        statement.bindText(3, entity.message)
        statement.bindLong(4, entity.statusCode.toLong())
        statement.bindLong(5, entity.cacheFlags.toLong())
        statement.bindLong(6, entity.method.toLong())
        statement.bindLong(7, entity.lastAccessed)
        statement.bindLong(8, entity.lastValidated)
        val _tmpIntegrity: String? = entity.integrity
        if (_tmpIntegrity == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpIntegrity)
        }
        statement.bindText(10, entity.responseHeaders)
        statement.bindText(11, entity.storageUri)
        statement.bindLong(12, entity.storageSize)
        statement.bindLong(13, entity.uncompressedSize)
      }
    }
    this.__deleteAdapterOfCacheEntry = object : EntityDeleteOrUpdateAdapter<CacheEntry>() {
      protected override fun createQuery(): String = "DELETE FROM `CacheEntry` WHERE `key` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: CacheEntry) {
        statement.bindText(1, entity.key)
      }
    }
    this.__updateAdapterOfCacheEntry = object : EntityDeleteOrUpdateAdapter<CacheEntry>() {
      protected override fun createQuery(): String =
          "UPDATE OR ABORT `CacheEntry` SET `key` = ?,`url` = ?,`message` = ?,`statusCode` = ?,`cacheFlags` = ?,`method` = ?,`lastAccessed` = ?,`lastValidated` = ?,`integrity` = ?,`responseHeaders` = ?,`storageUri` = ?,`storageSize` = ?,`uncompressedSize` = ? WHERE `key` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: CacheEntry) {
        statement.bindText(1, entity.key)
        statement.bindText(2, entity.url)
        statement.bindText(3, entity.message)
        statement.bindLong(4, entity.statusCode.toLong())
        statement.bindLong(5, entity.cacheFlags.toLong())
        statement.bindLong(6, entity.method.toLong())
        statement.bindLong(7, entity.lastAccessed)
        statement.bindLong(8, entity.lastValidated)
        val _tmpIntegrity: String? = entity.integrity
        if (_tmpIntegrity == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpIntegrity)
        }
        statement.bindText(10, entity.responseHeaders)
        statement.bindText(11, entity.storageUri)
        statement.bindLong(12, entity.storageSize)
        statement.bindLong(13, entity.uncompressedSize)
        statement.bindText(14, entity.key)
      }
    }
  }

  public override suspend fun insertAsync(entry: CacheEntry): Long = performSuspending(__db, false,
      true) { _connection ->
    val _result: Long = __insertAdapterOfCacheEntry.insertAndReturnId(_connection, entry)
    _result
  }

  public override suspend fun insertList(entry: List<CacheEntry>): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfCacheEntry.insert(_connection, entry)
  }

  public override suspend fun upsertList(entry: List<CacheEntry>): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfCacheEntry_1.insert(_connection, entry)
  }

  public override suspend fun delete(entries: List<CacheEntry>): Unit = performSuspending(__db,
      false, true) { _connection ->
    __deleteAdapterOfCacheEntry.handleMultiple(_connection, entries)
  }

  public override suspend fun updateList(entry: List<CacheEntry>): Unit = performSuspending(__db,
      false, true) { _connection ->
    __updateAdapterOfCacheEntry.handleMultiple(_connection, entry)
  }

  public override suspend fun findByUrlAsync(url: String): CacheEntry? {
    val _sql: String = """
        |
        |        SELECT CacheEntry.*
        |          FROM CacheEntry
        |         WHERE CacheEntry.url = ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, url)
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfUrl: Int = getColumnIndexOrThrow(_stmt, "url")
        val _columnIndexOfMessage: Int = getColumnIndexOrThrow(_stmt, "message")
        val _columnIndexOfStatusCode: Int = getColumnIndexOrThrow(_stmt, "statusCode")
        val _columnIndexOfCacheFlags: Int = getColumnIndexOrThrow(_stmt, "cacheFlags")
        val _columnIndexOfMethod: Int = getColumnIndexOrThrow(_stmt, "method")
        val _columnIndexOfLastAccessed: Int = getColumnIndexOrThrow(_stmt, "lastAccessed")
        val _columnIndexOfLastValidated: Int = getColumnIndexOrThrow(_stmt, "lastValidated")
        val _columnIndexOfIntegrity: Int = getColumnIndexOrThrow(_stmt, "integrity")
        val _columnIndexOfResponseHeaders: Int = getColumnIndexOrThrow(_stmt, "responseHeaders")
        val _columnIndexOfStorageUri: Int = getColumnIndexOrThrow(_stmt, "storageUri")
        val _columnIndexOfStorageSize: Int = getColumnIndexOrThrow(_stmt, "storageSize")
        val _columnIndexOfUncompressedSize: Int = getColumnIndexOrThrow(_stmt, "uncompressedSize")
        val _result: CacheEntry?
        if (_stmt.step()) {
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpUrl: String
          _tmpUrl = _stmt.getText(_columnIndexOfUrl)
          val _tmpMessage: String
          _tmpMessage = _stmt.getText(_columnIndexOfMessage)
          val _tmpStatusCode: Int
          _tmpStatusCode = _stmt.getLong(_columnIndexOfStatusCode).toInt()
          val _tmpCacheFlags: Int
          _tmpCacheFlags = _stmt.getLong(_columnIndexOfCacheFlags).toInt()
          val _tmpMethod: Int
          _tmpMethod = _stmt.getLong(_columnIndexOfMethod).toInt()
          val _tmpLastAccessed: Long
          _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed)
          val _tmpLastValidated: Long
          _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated)
          val _tmpIntegrity: String?
          if (_stmt.isNull(_columnIndexOfIntegrity)) {
            _tmpIntegrity = null
          } else {
            _tmpIntegrity = _stmt.getText(_columnIndexOfIntegrity)
          }
          val _tmpResponseHeaders: String
          _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders)
          val _tmpStorageUri: String
          _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri)
          val _tmpStorageSize: Long
          _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize)
          val _tmpUncompressedSize: Long
          _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize)
          _result =
              CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findEntryAndBodyByKey(key: String): CacheEntry? {
    val _sql: String = """
        |
        |        SELECT CacheEntry.*
        |          FROM CacheEntry
        |         WHERE CacheEntry.key = ?
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, key)
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfUrl: Int = getColumnIndexOrThrow(_stmt, "url")
        val _columnIndexOfMessage: Int = getColumnIndexOrThrow(_stmt, "message")
        val _columnIndexOfStatusCode: Int = getColumnIndexOrThrow(_stmt, "statusCode")
        val _columnIndexOfCacheFlags: Int = getColumnIndexOrThrow(_stmt, "cacheFlags")
        val _columnIndexOfMethod: Int = getColumnIndexOrThrow(_stmt, "method")
        val _columnIndexOfLastAccessed: Int = getColumnIndexOrThrow(_stmt, "lastAccessed")
        val _columnIndexOfLastValidated: Int = getColumnIndexOrThrow(_stmt, "lastValidated")
        val _columnIndexOfIntegrity: Int = getColumnIndexOrThrow(_stmt, "integrity")
        val _columnIndexOfResponseHeaders: Int = getColumnIndexOrThrow(_stmt, "responseHeaders")
        val _columnIndexOfStorageUri: Int = getColumnIndexOrThrow(_stmt, "storageUri")
        val _columnIndexOfStorageSize: Int = getColumnIndexOrThrow(_stmt, "storageSize")
        val _columnIndexOfUncompressedSize: Int = getColumnIndexOrThrow(_stmt, "uncompressedSize")
        val _result: CacheEntry?
        if (_stmt.step()) {
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpUrl: String
          _tmpUrl = _stmt.getText(_columnIndexOfUrl)
          val _tmpMessage: String
          _tmpMessage = _stmt.getText(_columnIndexOfMessage)
          val _tmpStatusCode: Int
          _tmpStatusCode = _stmt.getLong(_columnIndexOfStatusCode).toInt()
          val _tmpCacheFlags: Int
          _tmpCacheFlags = _stmt.getLong(_columnIndexOfCacheFlags).toInt()
          val _tmpMethod: Int
          _tmpMethod = _stmt.getLong(_columnIndexOfMethod).toInt()
          val _tmpLastAccessed: Long
          _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed)
          val _tmpLastValidated: Long
          _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated)
          val _tmpIntegrity: String?
          if (_stmt.isNull(_columnIndexOfIntegrity)) {
            _tmpIntegrity = null
          } else {
            _tmpIntegrity = _stmt.getText(_columnIndexOfIntegrity)
          }
          val _tmpResponseHeaders: String
          _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders)
          val _tmpStorageUri: String
          _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri)
          val _tmpStorageSize: Long
          _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize)
          val _tmpUncompressedSize: Long
          _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize)
          _result =
              CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByRequestBatchId(batchId: Int): List<CacheEntry> {
    val _sql: String = """
        |
        |        SELECT CacheEntry.*
        |          FROM CacheEntry
        |         WHERE CacheEntry.key IN
        |               (SELECT RequestedEntry.requestedKey
        |                  FROM RequestedEntry
        |                 WHERE RequestedEntry.batchId = ?)
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, batchId.toLong())
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfUrl: Int = getColumnIndexOrThrow(_stmt, "url")
        val _columnIndexOfMessage: Int = getColumnIndexOrThrow(_stmt, "message")
        val _columnIndexOfStatusCode: Int = getColumnIndexOrThrow(_stmt, "statusCode")
        val _columnIndexOfCacheFlags: Int = getColumnIndexOrThrow(_stmt, "cacheFlags")
        val _columnIndexOfMethod: Int = getColumnIndexOrThrow(_stmt, "method")
        val _columnIndexOfLastAccessed: Int = getColumnIndexOrThrow(_stmt, "lastAccessed")
        val _columnIndexOfLastValidated: Int = getColumnIndexOrThrow(_stmt, "lastValidated")
        val _columnIndexOfIntegrity: Int = getColumnIndexOrThrow(_stmt, "integrity")
        val _columnIndexOfResponseHeaders: Int = getColumnIndexOrThrow(_stmt, "responseHeaders")
        val _columnIndexOfStorageUri: Int = getColumnIndexOrThrow(_stmt, "storageUri")
        val _columnIndexOfStorageSize: Int = getColumnIndexOrThrow(_stmt, "storageSize")
        val _columnIndexOfUncompressedSize: Int = getColumnIndexOrThrow(_stmt, "uncompressedSize")
        val _result: MutableList<CacheEntry> = mutableListOf()
        while (_stmt.step()) {
          val _item: CacheEntry
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpUrl: String
          _tmpUrl = _stmt.getText(_columnIndexOfUrl)
          val _tmpMessage: String
          _tmpMessage = _stmt.getText(_columnIndexOfMessage)
          val _tmpStatusCode: Int
          _tmpStatusCode = _stmt.getLong(_columnIndexOfStatusCode).toInt()
          val _tmpCacheFlags: Int
          _tmpCacheFlags = _stmt.getLong(_columnIndexOfCacheFlags).toInt()
          val _tmpMethod: Int
          _tmpMethod = _stmt.getLong(_columnIndexOfMethod).toInt()
          val _tmpLastAccessed: Long
          _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed)
          val _tmpLastValidated: Long
          _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated)
          val _tmpIntegrity: String?
          if (_stmt.isNull(_columnIndexOfIntegrity)) {
            _tmpIntegrity = null
          } else {
            _tmpIntegrity = _stmt.getText(_columnIndexOfIntegrity)
          }
          val _tmpResponseHeaders: String
          _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders)
          val _tmpStorageUri: String
          _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri)
          val _tmpStorageSize: Long
          _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize)
          val _tmpUncompressedSize: Long
          _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize)
          _item =
              CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findEntriesWithLock(batchId: Int): List<String> {
    val _sql: String = """
        |
        |        SELECT RequestedEntry.requestedKey
        |          FROM RequestedEntry
        |         WHERE RequestedEntry.batchId = ?
        |           AND EXISTS(
        |               SELECT RetentionLock.lockId
        |                 FROM RetentionLock
        |                WHERE RetentionLock.lockKey = RequestedEntry.requestedKey)
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, batchId.toLong())
        val _result: MutableList<String> = mutableListOf()
        while (_stmt.step()) {
          val _item: String
          _item = _stmt.getText(0)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findEvictableEntries(batchSize: Int): List<CacheEntry> {
    val _sql: String = """
        |
        |        SELECT CacheEntry.*
        |          FROM CacheEntry
        |         WHERE NOT EXISTS(
        |               SELECT RetentionLock.lockId
        |                 FROM RetentionLock
        |                WHERE RetentionLock.lockKey = CacheEntry.key) 
        |      ORDER BY lastAccessed ASC           
        |         LIMIT ?       
        |      
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, batchSize.toLong())
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfUrl: Int = getColumnIndexOrThrow(_stmt, "url")
        val _columnIndexOfMessage: Int = getColumnIndexOrThrow(_stmt, "message")
        val _columnIndexOfStatusCode: Int = getColumnIndexOrThrow(_stmt, "statusCode")
        val _columnIndexOfCacheFlags: Int = getColumnIndexOrThrow(_stmt, "cacheFlags")
        val _columnIndexOfMethod: Int = getColumnIndexOrThrow(_stmt, "method")
        val _columnIndexOfLastAccessed: Int = getColumnIndexOrThrow(_stmt, "lastAccessed")
        val _columnIndexOfLastValidated: Int = getColumnIndexOrThrow(_stmt, "lastValidated")
        val _columnIndexOfIntegrity: Int = getColumnIndexOrThrow(_stmt, "integrity")
        val _columnIndexOfResponseHeaders: Int = getColumnIndexOrThrow(_stmt, "responseHeaders")
        val _columnIndexOfStorageUri: Int = getColumnIndexOrThrow(_stmt, "storageUri")
        val _columnIndexOfStorageSize: Int = getColumnIndexOrThrow(_stmt, "storageSize")
        val _columnIndexOfUncompressedSize: Int = getColumnIndexOrThrow(_stmt, "uncompressedSize")
        val _result: MutableList<CacheEntry> = mutableListOf()
        while (_stmt.step()) {
          val _item: CacheEntry
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpUrl: String
          _tmpUrl = _stmt.getText(_columnIndexOfUrl)
          val _tmpMessage: String
          _tmpMessage = _stmt.getText(_columnIndexOfMessage)
          val _tmpStatusCode: Int
          _tmpStatusCode = _stmt.getLong(_columnIndexOfStatusCode).toInt()
          val _tmpCacheFlags: Int
          _tmpCacheFlags = _stmt.getLong(_columnIndexOfCacheFlags).toInt()
          val _tmpMethod: Int
          _tmpMethod = _stmt.getLong(_columnIndexOfMethod).toInt()
          val _tmpLastAccessed: Long
          _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed)
          val _tmpLastValidated: Long
          _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated)
          val _tmpIntegrity: String?
          if (_stmt.isNull(_columnIndexOfIntegrity)) {
            _tmpIntegrity = null
          } else {
            _tmpIntegrity = _stmt.getText(_columnIndexOfIntegrity)
          }
          val _tmpResponseHeaders: String
          _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders)
          val _tmpStorageUri: String
          _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri)
          val _tmpStorageSize: Long
          _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize)
          val _tmpUncompressedSize: Long
          _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize)
          _item =
              CacheEntry(_tmpKey,_tmpUrl,_tmpMessage,_tmpStatusCode,_tmpCacheFlags,_tmpMethod,_tmpLastAccessed,_tmpLastValidated,_tmpIntegrity,_tmpResponseHeaders,_tmpStorageUri,_tmpStorageSize,_tmpUncompressedSize)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun totalEvictableSize(): Long {
    val _sql: String = """
        |
        |        SELECT SUM(CacheEntry.storageSize)
        |          FROM CacheEntry
        |         WHERE NOT EXISTS(
        |               SELECT RetentionLock.lockId
        |                 FROM RetentionLock
        |                WHERE RetentionLock.lockKey = CacheEntry.key)  
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _result: Long
        if (_stmt.step()) {
          val _tmp: Long
          _tmp = _stmt.getLong(0)
          _result = _tmp
        } else {
          _result = 0L
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getEntryUrlsInOrder(offset: Int, limit: Int): List<String> {
    val _sql: String = """
        |
        |        SELECT CacheEntry.url
        |          FROM CacheEntry
        |      ORDER BY CacheEntry.key 
        |         LIMIT ?
        |        OFFSET ?
        |       
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, limit.toLong())
        _argIndex = 2
        _stmt.bindLong(_argIndex, offset.toLong())
        val _result: MutableList<String> = mutableListOf()
        while (_stmt.step()) {
          val _item: String
          _item = _stmt.getText(0)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun updateLastAccessedTime(key: String, lastAccessTime: Long) {
    val _sql: String = """
        |
        |        UPDATE CacheEntry
        |           SET lastAccessed = ?
        |         WHERE key = ?  
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, lastAccessTime)
        _argIndex = 2
        _stmt.bindText(_argIndex, key)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun updateValidation(
    key: String,
    headers: String,
    lastValidated: Long,
    lastAccessed: Long,
  ) {
    val _sql: String = """
        |
        |        UPDATE CacheEntry
        |           SET responseHeaders = ?,
        |               lastValidated = ?,
        |               lastAccessed = ?
        |         WHERE key = ?      
        |    
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, headers)
        _argIndex = 2
        _stmt.bindLong(_argIndex, lastValidated)
        _argIndex = 3
        _stmt.bindLong(_argIndex, lastAccessed)
        _argIndex = 4
        _stmt.bindText(_argIndex, key)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
