/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.Name;
import androidx.compose.lint.NamesKt;
import androidx.compose.lint.PackageName;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.ui.lint.ConfigurationScreenWidthHeightDetectorKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/lint/ConfigurationScreenWidthHeightDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "filterIncident", "", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "report", "", "referencedFieldName", "", "node", "Lorg/jetbrains/uast/UElement;", "Companion", "ui-lint"})
@SourceDebugExtension(value={"SMAP\nConfigurationScreenWidthHeightDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationScreenWidthHeightDetector.kt\nandroidx/compose/ui/lint/ConfigurationScreenWidthHeightDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1747#2,3:170\n*S KotlinDebug\n*F\n+ 1 ConfigurationScreenWidthHeightDetector.kt\nandroidx/compose/ui/lint/ConfigurationScreenWidthHeightDetector\n*L\n106#1:170,3\n*E\n"})
public final class ConfigurationScreenWidthHeightDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final PackageName ResPackage = NamesKt.Package("android.content.res");
    @NotNull
    private static final Name Configuration = NamesKt.Name(ResPackage, "Configuration");
    @NotNull
    private static final String ScreenWidthDp = "screenWidthDp";
    @NotNull
    private static final String ScreenHeightDp = "screenHeightDp";
    @NotNull
    private static final Issue ConfigurationScreenWidthHeight = Issue.Companion.create("ConfigurationScreenWidthHeight", "Using Configuration.screenWidthDp/screenHeightDp instead of LocalWindowInfo.current.containerSize", "Configuration.screenWidthDp and Configuration.screenHeightDp have different insets behaviour depending on target SDK version, and are rounded to the nearest Dp. This means that using these values in composition to size a layout can result in issues, as these values do not accurately represent the actual available window size. Instead it is recommended to use WindowInfo.containerSize which accurately represents the window size.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ConfigurationScreenWidthHeightDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UQualifiedReferenceExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UQualifiedReferenceExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ ConfigurationScreenWidthHeightDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                UVariable uVariable;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.resolve();
                PsiMember psiMember = psiElement instanceof PsiMember ? (PsiMember)psiElement : null;
                if (psiMember == null) {
                    return;
                }
                PsiMember resolved = psiMember;
                String name = resolved.getName();
                if (!Intrinsics.areEqual((Object)name, (Object)"screenWidthDp") && !Intrinsics.areEqual((Object)name, (Object)"screenHeightDp")) {
                    return;
                }
                PsiClass psiClass = resolved.getContainingClass();
                if (psiClass == null) {
                    return;
                }
                PsiClass containingClass = psiClass;
                if (!Intrinsics.areEqual((Object)containingClass.getName(), (Object)ConfigurationScreenWidthHeightDetector.access$getConfiguration$cp().getShortName()) || !PsiUtilsKt.isInPackageName((PsiMember)containingClass, ConfigurationScreenWidthHeightDetector.access$getConfiguration$cp().getPackageName())) {
                    return;
                }
                if (ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
                    ConfigurationScreenWidthHeightDetector.access$report(this.this$0, name, this.$context, (UElement)node);
                    return;
                }
                UDeclaration uDeclaration = UastLintUtils.Companion.tryResolveUDeclaration((UElement)UastUtils.skipParenthesizedExprDown((UExpression)node.getReceiver()));
                UVariable uVariable2 = uVariable = uDeclaration instanceof UVariable ? (UVariable)uDeclaration : null;
                if (uVariable == null || (uDeclaration = uVariable.getUastInitializer()) == null) {
                    return;
                }
                UDeclaration configurationSource = uDeclaration;
                if (UastUtils.matchesQualified((UExpression)configurationSource, (String)"LocalConfiguration.current")) {
                    ConfigurationScreenWidthHeightDetector.access$report(this.this$0, name, this.$context, (UElement)node);
                }
            }
        };
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        return !ConfigurationScreenWidthHeightDetectorKt.access$isWearProject(context);
    }

    private final void report(String referencedFieldName, JavaContext context, UElement node) {
        boolean hasWearImport;
        Object object = UastUtils.getContainingUFile((UElement)node);
        if (object != null && (object = object.getImports()) != null) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String importString;
                        UImportStatement uImportStatement = (UImportStatement)element$iv;
                        boolean bl2 = false;
                        UElement uElement = uImportStatement.getImportReference();
                        String string = importString = uElement != null ? uElement.asSourceString() : null;
                        boolean bl3 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"androidx.wear", (boolean)false, (int)2, null) : false;
                        if (!bl3) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            v5 = bl;
        } else {
            v5 = hasWearImport = false;
        }
        if (hasWearImport) {
            return;
        }
        Incident incident = new Incident(ConfigurationScreenWidthHeight, (Object)node, context.getNameLocation(node), "Using Configuration." + referencedFieldName + " instead of LocalWindowInfo.current.containerSize");
        context.report(incident, this.map());
    }

    public static final /* synthetic */ Name access$getConfiguration$cp() {
        return Configuration;
    }

    public static final /* synthetic */ void access$report(ConfigurationScreenWidthHeightDetector $this, String referencedFieldName, JavaContext context, UElement node) {
        $this.report(referencedFieldName, context, node);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/compose/ui/lint/ConfigurationScreenWidthHeightDetector$Companion;", "", "()V", "Configuration", "Landroidx/compose/lint/Name;", "ConfigurationScreenWidthHeight", "Lcom/android/tools/lint/detector/api/Issue;", "getConfigurationScreenWidthHeight", "()Lcom/android/tools/lint/detector/api/Issue;", "ResPackage", "Landroidx/compose/lint/PackageName;", "ScreenHeightDp", "", "ScreenWidthDp", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getConfigurationScreenWidthHeight() {
            return ConfigurationScreenWidthHeight;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

