/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.viewmodel.person.list;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.paging.PagingSource;
import io.github.aakira.napier.Napier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import world.respect.datalayer.DataLoadParams;
import world.respect.datalayer.SchoolDataSource;
import world.respect.datalayer.school.PersonDataSource;
import world.respect.datalayer.school.model.composites.PersonListDetails;
import world.respect.shared.domain.account.RespectAccountManager;
import world.respect.shared.generated.resources.Res;
import world.respect.shared.generated.resources.String1_commonMainKt;
import world.respect.shared.navigation.NavCommand;
import world.respect.shared.navigation.PersonDetail;
import world.respect.shared.navigation.PersonEdit;
import world.respect.shared.resources.UiText;
import world.respect.shared.util.ext.StringResourceExtKt;
import world.respect.shared.viewmodel.RespectViewModel;
import world.respect.shared.viewmodel.app.appstate.AppUiState;
import world.respect.shared.viewmodel.app.appstate.FabUiState;
import world.respect.shared.viewmodel.person.list.PersonListUiState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020 R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lworld/respect/shared/viewmodel/person/list/PersonListViewModel;", "Lworld/respect/shared/viewmodel/RespectViewModel;", "Lorg/koin/core/component/KoinScopeComponent;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "accountManager", "Lworld/respect/shared/domain/account/RespectAccountManager;", "<init>", "(Landroidx/lifecycle/SavedStateHandle;Lworld/respect/shared/domain/account/RespectAccountManager;)V", "scope", "Lorg/koin/core/scope/Scope;", "getScope", "()Lorg/koin/core/scope/Scope;", "schoolDataSource", "Lworld/respect/datalayer/SchoolDataSource;", "getSchoolDataSource", "()Lworld/respect/datalayer/SchoolDataSource;", "schoolDataSource$delegate", "Lkotlin/Lazy;", "_uiState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lworld/respect/shared/viewmodel/person/list/PersonListUiState;", "uiState", "Lkotlinx/coroutines/flow/StateFlow;", "getUiState", "()Lkotlinx/coroutines/flow/StateFlow;", "pagingSourceFactory", "Lkotlin/Function0;", "Landroidx/paging/PagingSource;", "", "Lworld/respect/datalayer/school/model/composites/PersonListDetails;", "onClickItem", "", "person", "onClickAdd", "respect-lib-shared_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPersonListViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersonListViewModel.kt\nworld/respect/shared/viewmodel/person/list/PersonListViewModel\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,85:1\n58#2,6:86\n230#3,5:92\n230#3,5:97\n*S KotlinDebug\n*F\n+ 1 PersonListViewModel.kt\nworld/respect/shared/viewmodel/person/list/PersonListViewModel\n*L\n40#1:86,6\n54#1:92,5\n66#1:97,5\n*E\n"})
public final class PersonListViewModel
extends RespectViewModel
implements KoinScopeComponent {
    @NotNull
    private final Scope scope;
    @NotNull
    private final Lazy schoolDataSource$delegate;
    @NotNull
    private final MutableStateFlow<PersonListUiState> _uiState;
    @NotNull
    private final StateFlow<PersonListUiState> uiState;
    @NotNull
    private final Function0<PagingSource<Integer, PersonListDetails>> pagingSourceFactory;
    public static final int $stable = 8;

    public PersonListViewModel(@NotNull SavedStateHandle savedStateHandle, @NotNull RespectAccountManager accountManager) {
        UiText uiText;
        FabUiState fabUiState;
        Object it;
        Object nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        super(savedStateHandle);
        this.scope = accountManager.requireSelectedAccountScope();
        KoinComponent $this$inject_u24default$iv = (KoinComponent)this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.schoolDataSource$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<SchoolDataSource>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final SchoolDataSource invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(SchoolDataSource.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(SchoolDataSource.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this._uiState = StateFlowKt.MutableStateFlow((Object)new PersonListUiState(null, 1, null));
        this.uiState = FlowKt.asStateFlow(this._uiState);
        this.pagingSourceFactory = () -> PersonListViewModel.pagingSourceFactory$lambda$0(this);
        Object $this$update$iv = this.get_appUiState();
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (AppUiState)prevValue$iv;
            boolean bl = false;
            uiText = StringResourceExtKt.asUiText(String1_commonMainKt.getPeople(Res.string.INSTANCE));
            KFunction kFunction = (KFunction)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((PersonListViewModel)((Object)this.receiver)).onClickAdd();
                }
            };
            UiText uiText2 = StringResourceExtKt.asUiText(String1_commonMainKt.getPerson(Res.string.INSTANCE));
            FabUiState.FabIcon fabIcon = FabUiState.FabIcon.ADD;
            fabUiState = new FabUiState(true, uiText2, fabIcon, (Function0<Unit>)((Function0)kFunction));
        } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = AppUiState.copy$default((AppUiState)it, fabUiState, uiText, false, false, false, null, false, null, null, null, null, null, null, 8188, null)));
        $this$update$iv = this._uiState;
        $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (PersonListUiState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = ((PersonListUiState)it).copy(this.pagingSourceFactory)));
    }

    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    private final SchoolDataSource getSchoolDataSource() {
        Lazy lazy = this.schoolDataSource$delegate;
        return (SchoolDataSource)lazy.getValue();
    }

    @NotNull
    public final StateFlow<PersonListUiState> getUiState() {
        return this.uiState;
    }

    public final void onClickItem(@NotNull PersonListDetails person) {
        Intrinsics.checkNotNullParameter((Object)person, (String)"person");
        this.get_navCommandFlow().tryEmit((Object)new NavCommand.Navigate(new PersonDetail(person.getGuid()), false, null, null, false, 0L, 62, null));
    }

    public final void onClickAdd() {
        this.get_navCommandFlow().tryEmit((Object)new NavCommand.Navigate(new PersonEdit(null), false, null, null, false, 0L, 62, null));
    }

    @NotNull
    public Koin getKoin() {
        return KoinScopeComponent.DefaultImpls.getKoin((KoinScopeComponent)this);
    }

    private static final PagingSource pagingSourceFactory$lambda$0(PersonListViewModel this$0) {
        Napier.d$default((Napier)Napier.INSTANCE, (String)"PersonListViewModel: pagingSourceFactory invoke", null, null, (int)6, null);
        return this$0.getSchoolDataSource().getPersonDataSource().listDetailsAsPagingSource(new DataLoadParams(false, false, 3, null), new PersonDataSource.GetListParams(null, null, null, 7, null));
    }
}

