/*
 * Decompiled with CFR 0.152.
 */
package androidx.lint.kotlin.metadata.internal.metadata.jvm.deserialization;

import androidx.lint.kotlin.metadata.internal.metadata.jvm.JvmModuleProtoBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ.\u0010\u001c\u001a\u00020\u0012*\u00020\u001d2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 H\u0002J6\u0010\"\u001a\u00020\u0012*\u00020\u001d2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 2\u0006\u0010#\u001a\u00020\u001bH\u0002J$\u0010$\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0 H\u0002J \u0010%\u001a\u00020\u0012*\u00020\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0&H\u0002J\u0010\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0011\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010/\u001a\u0002002\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00101\u001a\u00020!H\u0016J\b\u00102\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\tj\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0018\u0010'\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0018\u0010*\u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)\u00a8\u00063"}, d2={"Landroidx/lint/kotlin/metadata/internal/metadata/jvm/deserialization/PackageParts;", "", "packageFqName", "", "<init>", "(Ljava/lang/String;)V", "getPackageFqName", "()Ljava/lang/String;", "packageParts", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "parts", "", "getParts", "()Ljava/util/Set;", "metadataParts", "getMetadataParts", "addPart", "", "partInternalName", "facadeInternalName", "removePart", "internalName", "addMetadataPart", "shortName", "addTo", "builder", "Landroidx/lint/kotlin/metadata/internal/metadata/jvm/JvmModuleProtoBuf$Module$Builder;", "writePartsWithinPackage", "Landroidx/lint/kotlin/metadata/internal/metadata/jvm/JvmModuleProtoBuf$PackageParts$Builder;", "", "facadeNameToId", "", "", "writePartsOutsidePackage", "packageTableBuilder", "getMultifileFacadeShortNameId", "writeMultifileFacadeNames", "", "packageName", "getPackageName", "(Ljava/lang/String;)Ljava/lang/String;", "className", "getClassName", "getMultifileFacadeName", "plusAssign", "other", "equals", "", "hashCode", "toString", "metadata.jvm"})
@SourceDebugExtension(value={"SMAP\nModuleMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapping.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n3193#2,10:303\n1485#2:313\n1510#2,3:314\n1513#2,3:324\n1485#2:327\n1510#2,3:328\n1513#2,3:338\n1485#2:341\n1510#2,3:342\n1513#2,3:352\n1053#2:362\n1863#2,2:364\n381#3,7:317\n381#3,7:331\n381#3,7:345\n381#3,7:355\n1#4:363\n*S KotlinDebug\n*F\n+ 1 ModuleMapping.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts\n*L\n186#1:303,10\n209#1:313\n209#1:314,3\n209#1:324,3\n226#1:327\n226#1:328,3\n226#1:338,3\n232#1:341\n232#1:342,3\n232#1:352,3\n258#1:362\n273#1:364,2\n209#1:317,7\n226#1:331,7\n232#1:345,7\n254#1:355,7\n*E\n"})
public final class PackageParts {
    @NotNull
    private final String packageFqName;
    @NotNull
    private final LinkedHashMap<String, String> packageParts;
    @NotNull
    private final Set<String> metadataParts;

    public PackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        this.packageFqName = packageFqName;
        this.packageParts = new LinkedHashMap();
        this.metadataParts = new LinkedHashSet();
    }

    @NotNull
    public final String getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final Set<String> getParts() {
        Set<String> set = this.packageParts.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public final Set<String> getMetadataParts() {
        return this.metadataParts;
    }

    public final void addPart(@NotNull String partInternalName, @Nullable String facadeInternalName) {
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        ((Map)this.packageParts).put(partInternalName, facadeInternalName);
    }

    public final void removePart(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        this.packageParts.remove(internalName);
    }

    public final void addMetadataPart(@NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        Set<String> set = this.metadataParts;
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
        TypeIntrinsics.asMutableSet(set).add(shortName);
    }

    /*
     * WARNING - void declaration
     */
    public final void addTo(@NotNull JvmModuleProtoBuf.Module.Builder builder) {
        JvmModuleProtoBuf.PackageParts.Builder $this$addTo_u24lambda_u241;
        JvmModuleProtoBuf.Module.Builder builder2;
        JvmModuleProtoBuf.PackageParts.Builder builder3;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!((Collection)this.getParts()).isEmpty()) {
            JvmModuleProtoBuf.PackageParts.Builder builder4 = builder3 = JvmModuleProtoBuf.PackageParts.newBuilder();
            builder2 = builder;
            boolean bl = false;
            $this$addTo_u24lambda_u241.setPackageFqName(this.packageFqName);
            String string = $this$addTo_u24lambda_u241.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageFqName(...)");
            String packageInternalName = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
            Iterable $this$partition$iv = this.getParts();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String partInternalName = (String)element$iv;
                boolean bl2 = false;
                boolean bl3 = Intrinsics.areEqual((Object)this.getPackageName(partInternalName), (Object)packageInternalName) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List partsWithinPackage = (List)pair.component1();
            List partsOutsidePackage = (List)pair.component2();
            Map facadeNameToId = new LinkedHashMap();
            Intrinsics.checkNotNull((Object)$this$addTo_u24lambda_u241);
            this.writePartsWithinPackage($this$addTo_u24lambda_u241, partsWithinPackage, facadeNameToId);
            this.writePartsOutsidePackage($this$addTo_u24lambda_u241, partsOutsidePackage, facadeNameToId, builder);
            this.writeMultifileFacadeNames($this$addTo_u24lambda_u241, facadeNameToId);
            builder2.addPackageParts(builder3);
        }
        if (!((Collection)this.metadataParts).isEmpty()) {
            void $this$addTo_u24lambda_u242;
            $this$addTo_u24lambda_u241 = builder3 = JvmModuleProtoBuf.PackageParts.newBuilder();
            builder2 = builder;
            boolean bl = false;
            $this$addTo_u24lambda_u242.setPackageFqName(this.packageFqName);
            $this$addTo_u24lambda_u242.addAllShortClassName(CollectionsKt.sorted((Iterable)this.metadataParts));
            builder2.addMetadataParts(builder3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePartsWithinPackage(JvmModuleProtoBuf.PackageParts.Builder $this$writePartsWithinPackage, List<String> parts, Map<String, Integer> facadeNameToId) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = parts;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = this.getMultifileFacadeName(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap((Map)destination$iv$iv, (Comparator)ComparisonsKt.nullsLast((Comparator)ComparisonsKt.naturalOrder()))).entrySet()) {
            String facadeInternalName = (String)entry.getKey();
            List partInternalNames = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)partInternalNames);
            for (String partInternalName : CollectionsKt.sorted((Iterable)partInternalNames)) {
                $this$writePartsWithinPackage.addShortClassName(this.getClassName(partInternalName));
                if (facadeInternalName == null) continue;
                $this$writePartsWithinPackage.addMultifileFacadeShortNameId(this.getMultifileFacadeShortNameId(facadeInternalName, facadeNameToId));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writePartsOutsidePackage(JvmModuleProtoBuf.PackageParts.Builder $this$writePartsOutsidePackage, List<String> parts, Map<String, Integer> facadeNameToId, JvmModuleProtoBuf.Module.Builder packageTableBuilder) {
        void $this$groupByTo$iv$iv;
        List packageIds = new ArrayList();
        Iterable $this$groupBy$iv = parts;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object entry2 : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)entry2;
            boolean bl = false;
            String key$iv$iv = this.getPackageName(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(entry2);
        }
        for (Map.Entry entry : ((Map)MapsKt.toSortedMap((Map)destination$iv$iv)).entrySet()) {
            void $this$groupByTo$iv$iv2;
            String packageInternalName = (String)entry.getKey();
            List partsInPackage = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)packageInternalName);
            String packageFqName = StringsKt.replace$default((String)packageInternalName, (char)'/', (char)'.', (boolean)false, (int)4, null);
            if (!packageTableBuilder.getJvmPackageNameList().contains(packageFqName)) {
                packageTableBuilder.addJvmPackageName(packageFqName);
            }
            int packageId = packageTableBuilder.getJvmPackageNameList().indexOf(packageFqName);
            Intrinsics.checkNotNull((Object)partsInPackage);
            Iterable iterable2 = partsInPackage;
            boolean $i$f$groupBy2 = false;
            Iterable bl = iterable2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                String key$iv$iv = this.getMultifileFacadeName(it);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            for (Map.Entry entry2 : ((Map)MapsKt.toSortedMap((Map)destination$iv$iv2, (Comparator)ComparisonsKt.nullsLast((Comparator)ComparisonsKt.naturalOrder()))).entrySet()) {
                String facadeInternalName = (String)entry2.getKey();
                List partInternalNames = (List)entry2.getValue();
                Intrinsics.checkNotNull((Object)partInternalNames);
                for (String partInternalName : CollectionsKt.sorted((Iterable)partInternalNames)) {
                    $this$writePartsOutsidePackage.addClassWithJvmPackageNameShortName(this.getClassName(partInternalName));
                    if (facadeInternalName != null) {
                        $this$writePartsOutsidePackage.addClassWithJvmPackageNameMultifileFacadeShortNameId(this.getMultifileFacadeShortNameId(facadeInternalName, facadeNameToId));
                    }
                    packageIds.add(packageId);
                }
            }
        }
        while (packageIds.size() > 1 && ((Number)packageIds.get(packageIds.size() - 1)).intValue() == ((Number)packageIds.get(packageIds.size() - 2)).intValue()) {
            packageIds.remove(packageIds.size() - 1);
        }
        $this$writePartsOutsidePackage.addAllClassWithJvmPackageNamePackageId(packageIds);
    }

    /*
     * WARNING - void declaration
     */
    private final int getMultifileFacadeShortNameId(String facadeInternalName, Map<String, Integer> facadeNameToId) {
        Object object;
        void $this$getOrPut$iv;
        int n = 1;
        Map<String, Integer> map = facadeNameToId;
        String key$iv = this.getClassName(facadeInternalName);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            int n2 = n;
            boolean bl = false;
            Integer n3 = facadeNameToId.size();
            n = n2;
            Integer answer$iv = n3;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return n + ((Number)object).intValue();
    }

    private final void writeMultifileFacadeNames(JvmModuleProtoBuf.PackageParts.Builder $this$writeMultifileFacadeNames, Map<String, Integer> facadeNameToId) {
        Iterable $this$sortedBy$iv = CollectionsKt.zip((Iterable)facadeNameToId.values(), (Iterable)facadeNameToId.keySet());
        boolean $i$f$sortedBy = false;
        for (Pair pair : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair p0 = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Number)p0.getFirst()).intValue());
                p0 = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((Number)p0.getFirst()).intValue()));
            }
        })) {
            boolean bl;
            int facadeId = ((Number)pair.component1()).intValue();
            String facadeName = (String)pair.component2();
            boolean bl2 = bl = facadeId == $this$writeMultifileFacadeNames.getMultifileFacadeShortNameCount();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Multifile facades are loaded incorrectly: " + facadeNameToId;
                throw new AssertionError((Object)string);
            }
            $this$writeMultifileFacadeNames.addMultifileFacadeShortName(facadeName);
        }
    }

    private final String getPackageName(String $this$packageName) {
        return StringsKt.substringBeforeLast((String)$this$packageName, (char)'/', (String)"");
    }

    private final String getClassName(String $this$className) {
        return StringsKt.substringAfterLast$default((String)$this$className, (char)'/', null, (int)2, null);
    }

    @Nullable
    public final String getMultifileFacadeName(@NotNull String partInternalName) {
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        return this.packageParts.get(partInternalName);
    }

    public final void plusAssign(@NotNull PackageParts other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (Map.Entry entry : ((Map)other.packageParts).entrySet()) {
            String partInternalName = (String)entry.getKey();
            String facadeInternalName = (String)entry.getValue();
            this.addPart(partInternalName, facadeInternalName);
        }
        Iterable $this$forEach$iv = other.metadataParts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            this.addMetadataPart(p0);
        }
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PackageParts && Intrinsics.areEqual((Object)((PackageParts)other).packageFqName, (Object)this.packageFqName) && Intrinsics.areEqual(((PackageParts)other).packageParts, this.packageParts) && Intrinsics.areEqual(((PackageParts)other).metadataParts, this.metadataParts);
    }

    public int hashCode() {
        return (this.packageFqName.hashCode() * 31 + this.packageParts.hashCode()) * 31 + ((Object)this.metadataParts).hashCode();
    }

    @NotNull
    public String toString() {
        return SetsKt.plus(this.getParts(), (Iterable)this.metadataParts).toString();
    }
}

