/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePing;
import com.ustadmobile.libcache.distributed.model.DistributedCachePong;
import com.ustadmobile.libcache.distributed.model.DistributedHashEntries;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \n2\u00020\u0001:\u0001\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "", "<init>", "()V", "httpPort", "", "getHttpPort", "()I", "toBytes", "", "Companion", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePong;", "Lcom/ustadmobile/libcache/distributed/model/DistributedHashEntries;", "respect-lib-cache_debug"})
public abstract class DistributedCachePacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DCACHE_PACKET_OVERHEAD = 5;
    public static final byte WHAT_ENTRIES = 1;
    public static final byte WHAT_PING = 2;
    public static final byte WHAT_PONG = 3;

    private DistributedCachePacket() {
    }

    public abstract int getHttpPort();

    @NotNull
    public abstract byte[] toBytes();

    public /* synthetic */ DistributedCachePacket(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket$Companion;", "", "<init>", "()V", "DCACHE_PACKET_OVERHEAD", "", "fromBytes", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "bytesArray", "", "offset", "len", "WHAT_ENTRIES", "", "WHAT_PING", "WHAT_PONG", "respect-lib-cache_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributedCachePacket fromBytes(@NotNull byte[] bytesArray, int offset, int len) {
            DistributedCachePacket distributedCachePacket;
            Intrinsics.checkNotNullParameter((Object)bytesArray, (String)"bytesArray");
            ByteBuffer buffer = ByteBuffer.wrap(bytesArray, offset, len);
            byte what = buffer.get();
            int httpPort = buffer.getInt();
            byte by = what;
            if (by == 1) {
                Intrinsics.checkNotNull((Object)buffer);
                distributedCachePacket = DistributedHashEntries.Companion.readDistributedHashEntries(buffer, httpPort);
            } else if (by == 2) {
                Intrinsics.checkNotNull((Object)buffer);
                distributedCachePacket = DistributedCachePing.Companion.readDistributedCachePing(buffer, httpPort);
            } else if (by == 3) {
                Intrinsics.checkNotNull((Object)buffer);
                distributedCachePacket = DistributedCachePong.Companion.readDistributedCachePong(buffer, httpPort);
            } else {
                throw new IllegalArgumentException("DistributedCachePacket.fromBytes: WHAT byte not recognized");
            }
            return distributedCachePacket;
        }

        public static /* synthetic */ DistributedCachePacket fromBytes$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            return companion.fromBytes(byArray, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

