package com.ustadmobile.libcache.db

import androidx.room.InvalidationTracker
import androidx.room.RoomOpenDelegate
import androidx.room.migration.AutoMigrationSpec
import androidx.room.migration.Migration
import androidx.room.util.TableInfo
import androidx.room.util.TableInfo.Companion.read
import androidx.room.util.dropFtsSyncTriggers
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.execSQL
import com.ustadmobile.libcache.db.dao.CacheEntryDao
import com.ustadmobile.libcache.db.dao.CacheEntryDao_Impl
import com.ustadmobile.libcache.db.dao.NeighborCacheDao
import com.ustadmobile.libcache.db.dao.NeighborCacheDao_Impl
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao
import com.ustadmobile.libcache.db.dao.NeighborCacheEntryDao_Impl
import com.ustadmobile.libcache.db.dao.NewCacheEntryDao
import com.ustadmobile.libcache.db.dao.NewCacheEntryDao_Impl
import com.ustadmobile.libcache.db.dao.RequestedEntryDao
import com.ustadmobile.libcache.db.dao.RequestedEntryDao_Impl
import com.ustadmobile.libcache.db.dao.RetentionLockDao
import com.ustadmobile.libcache.db.dao.RetentionLockDao_Impl
import javax.`annotation`.processing.Generated
import kotlin.Lazy
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.collections.MutableSet
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf
import kotlin.collections.mutableSetOf
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class UstadCacheDb_Impl : UstadCacheDb() {
  private val _cacheEntryDao: Lazy<CacheEntryDao> = lazy {
    CacheEntryDao_Impl(this)
  }

  public override val cacheEntryDao: CacheEntryDao
    get() = _cacheEntryDao.value

  private val _requestedEntryDao: Lazy<RequestedEntryDao> = lazy {
    RequestedEntryDao_Impl(this)
  }

  public override val requestedEntryDao: RequestedEntryDao
    get() = _requestedEntryDao.value

  private val _retentionLockDao: Lazy<RetentionLockDao> = lazy {
    RetentionLockDao_Impl(this)
  }

  public override val retentionLockDao: RetentionLockDao
    get() = _retentionLockDao.value

  private val _neighborCacheDao: Lazy<NeighborCacheDao> = lazy {
    NeighborCacheDao_Impl(this)
  }

  public override val neighborCacheDao: NeighborCacheDao
    get() = _neighborCacheDao.value

  private val _neighborCacheEntryDao: Lazy<NeighborCacheEntryDao> = lazy {
    NeighborCacheEntryDao_Impl(this)
  }

  public override val neighborCacheEntryDao: NeighborCacheEntryDao
    get() = _neighborCacheEntryDao.value

  private val _newCacheEntryDao: Lazy<NewCacheEntryDao> = lazy {
    NewCacheEntryDao_Impl(this)
  }

  public override val newCacheEntryDao: NewCacheEntryDao
    get() = _newCacheEntryDao.value

  protected override fun createOpenDelegate(): RoomOpenDelegate {
    val _openDelegate: RoomOpenDelegate = object : RoomOpenDelegate(15,
        "91e0b1ee86ebf503079a196ed9753894", "5210962fa2bf0a54e9f68c932b020124") {
      public override fun createAllTables(connection: SQLiteConnection) {
        connection.execSQL("CREATE TABLE IF NOT EXISTS `CacheEntry` (`key` TEXT NOT NULL, `url` TEXT NOT NULL, `message` TEXT NOT NULL, `statusCode` INTEGER NOT NULL, `cacheFlags` INTEGER NOT NULL, `method` INTEGER NOT NULL, `lastAccessed` INTEGER NOT NULL, `lastValidated` INTEGER NOT NULL, `integrity` TEXT, `responseHeaders` TEXT NOT NULL, `storageUri` TEXT NOT NULL, `storageSize` INTEGER NOT NULL, `uncompressedSize` INTEGER NOT NULL DEFAULT 0, PRIMARY KEY(`key`))")
        connection.execSQL("CREATE INDEX IF NOT EXISTS `idx_lastAccessed` ON `CacheEntry` (`lastAccessed`)")
        connection.execSQL("CREATE INDEX IF NOT EXISTS `index_CacheEntry_integrity` ON `CacheEntry` (`integrity`)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RequestedEntry` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `requestSha256` TEXT NOT NULL, `requestedKey` TEXT NOT NULL, `batchId` INTEGER NOT NULL)")
        connection.execSQL("CREATE INDEX IF NOT EXISTS `index_RequestedEntry_batchId` ON `RequestedEntry` (`batchId`)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RetentionLock` (`lockId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `lockKey` TEXT NOT NULL, `lockRemark` TEXT NOT NULL)")
        connection.execSQL("CREATE INDEX IF NOT EXISTS `idx_lockKey` ON `RetentionLock` (`lockKey`)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `NeighborCache` (`neighborUid` INTEGER NOT NULL, `neighborDeviceName` TEXT NOT NULL, `neighborIp` TEXT NOT NULL, `neighborUdpPort` INTEGER NOT NULL, `neighborHttpPort` INTEGER NOT NULL, `neighborDiscovered` INTEGER NOT NULL, `neighborPingTime` INTEGER NOT NULL, `neighborLastSeen` INTEGER NOT NULL, `neighborStatus` INTEGER NOT NULL, PRIMARY KEY(`neighborUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `NeighborCacheEntry` (`nceNeighborUid` INTEGER NOT NULL, `nceUrlHash` INTEGER NOT NULL, PRIMARY KEY(`nceNeighborUid`, `nceUrlHash`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `NewCacheEntry` (`cacheEntryKey` TEXT NOT NULL, `nceUrl` TEXT NOT NULL, PRIMARY KEY(`cacheEntryKey`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)")
        connection.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '91e0b1ee86ebf503079a196ed9753894')")
      }

      public override fun dropAllTables(connection: SQLiteConnection) {
        connection.execSQL("DROP TABLE IF EXISTS `CacheEntry`")
        connection.execSQL("DROP TABLE IF EXISTS `RequestedEntry`")
        connection.execSQL("DROP TABLE IF EXISTS `RetentionLock`")
        connection.execSQL("DROP TABLE IF EXISTS `NeighborCache`")
        connection.execSQL("DROP TABLE IF EXISTS `NeighborCacheEntry`")
        connection.execSQL("DROP TABLE IF EXISTS `NewCacheEntry`")
      }

      public override fun onCreate(connection: SQLiteConnection) {
      }

      public override fun onOpen(connection: SQLiteConnection) {
        internalInitInvalidationTracker(connection)
      }

      public override fun onPreMigrate(connection: SQLiteConnection) {
        dropFtsSyncTriggers(connection)
      }

      public override fun onPostMigrate(connection: SQLiteConnection) {
      }

      public override fun onValidateSchema(connection: SQLiteConnection):
          RoomOpenDelegate.ValidationResult {
        val _columnsCacheEntry: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsCacheEntry.put("key", TableInfo.Column("key", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("url", TableInfo.Column("url", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("message", TableInfo.Column("message", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("statusCode", TableInfo.Column("statusCode", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("cacheFlags", TableInfo.Column("cacheFlags", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("method", TableInfo.Column("method", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("lastAccessed", TableInfo.Column("lastAccessed", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("lastValidated", TableInfo.Column("lastValidated", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("integrity", TableInfo.Column("integrity", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("responseHeaders", TableInfo.Column("responseHeaders", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("storageUri", TableInfo.Column("storageUri", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("storageSize", TableInfo.Column("storageSize", "INTEGER", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsCacheEntry.put("uncompressedSize", TableInfo.Column("uncompressedSize", "INTEGER",
            true, 0, "0", TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysCacheEntry: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesCacheEntry: MutableSet<TableInfo.Index> = mutableSetOf()
        _indicesCacheEntry.add(TableInfo.Index("idx_lastAccessed", false, listOf("lastAccessed"),
            listOf("ASC")))
        _indicesCacheEntry.add(TableInfo.Index("index_CacheEntry_integrity", false,
            listOf("integrity"), listOf("ASC")))
        val _infoCacheEntry: TableInfo = TableInfo("CacheEntry", _columnsCacheEntry,
            _foreignKeysCacheEntry, _indicesCacheEntry)
        val _existingCacheEntry: TableInfo = read(connection, "CacheEntry")
        if (!_infoCacheEntry.equals(_existingCacheEntry)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |CacheEntry(com.ustadmobile.libcache.db.entities.CacheEntry).
              | Expected:
              |""".trimMargin() + _infoCacheEntry + """
              |
              | Found:
              |""".trimMargin() + _existingCacheEntry)
        }
        val _columnsRequestedEntry: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRequestedEntry.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRequestedEntry.put("requestSha256", TableInfo.Column("requestSha256", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsRequestedEntry.put("requestedKey", TableInfo.Column("requestedKey", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsRequestedEntry.put("batchId", TableInfo.Column("batchId", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRequestedEntry: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRequestedEntry: MutableSet<TableInfo.Index> = mutableSetOf()
        _indicesRequestedEntry.add(TableInfo.Index("index_RequestedEntry_batchId", false,
            listOf("batchId"), listOf("ASC")))
        val _infoRequestedEntry: TableInfo = TableInfo("RequestedEntry", _columnsRequestedEntry,
            _foreignKeysRequestedEntry, _indicesRequestedEntry)
        val _existingRequestedEntry: TableInfo = read(connection, "RequestedEntry")
        if (!_infoRequestedEntry.equals(_existingRequestedEntry)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RequestedEntry(com.ustadmobile.libcache.db.entities.RequestedEntry).
              | Expected:
              |""".trimMargin() + _infoRequestedEntry + """
              |
              | Found:
              |""".trimMargin() + _existingRequestedEntry)
        }
        val _columnsRetentionLock: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRetentionLock.put("lockId", TableInfo.Column("lockId", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRetentionLock.put("lockKey", TableInfo.Column("lockKey", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRetentionLock.put("lockRemark", TableInfo.Column("lockRemark", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRetentionLock: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRetentionLock: MutableSet<TableInfo.Index> = mutableSetOf()
        _indicesRetentionLock.add(TableInfo.Index("idx_lockKey", false, listOf("lockKey"),
            listOf("ASC")))
        val _infoRetentionLock: TableInfo = TableInfo("RetentionLock", _columnsRetentionLock,
            _foreignKeysRetentionLock, _indicesRetentionLock)
        val _existingRetentionLock: TableInfo = read(connection, "RetentionLock")
        if (!_infoRetentionLock.equals(_existingRetentionLock)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RetentionLock(com.ustadmobile.libcache.db.entities.RetentionLock).
              | Expected:
              |""".trimMargin() + _infoRetentionLock + """
              |
              | Found:
              |""".trimMargin() + _existingRetentionLock)
        }
        val _columnsNeighborCache: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsNeighborCache.put("neighborUid", TableInfo.Column("neighborUid", "INTEGER", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborDeviceName", TableInfo.Column("neighborDeviceName",
            "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborIp", TableInfo.Column("neighborIp", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborUdpPort", TableInfo.Column("neighborUdpPort", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborHttpPort", TableInfo.Column("neighborHttpPort",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborDiscovered", TableInfo.Column("neighborDiscovered",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborPingTime", TableInfo.Column("neighborPingTime",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborLastSeen", TableInfo.Column("neighborLastSeen",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCache.put("neighborStatus", TableInfo.Column("neighborStatus", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysNeighborCache: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesNeighborCache: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoNeighborCache: TableInfo = TableInfo("NeighborCache", _columnsNeighborCache,
            _foreignKeysNeighborCache, _indicesNeighborCache)
        val _existingNeighborCache: TableInfo = read(connection, "NeighborCache")
        if (!_infoNeighborCache.equals(_existingNeighborCache)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |NeighborCache(com.ustadmobile.libcache.db.entities.NeighborCache).
              | Expected:
              |""".trimMargin() + _infoNeighborCache + """
              |
              | Found:
              |""".trimMargin() + _existingNeighborCache)
        }
        val _columnsNeighborCacheEntry: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsNeighborCacheEntry.put("nceNeighborUid", TableInfo.Column("nceNeighborUid",
            "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNeighborCacheEntry.put("nceUrlHash", TableInfo.Column("nceUrlHash", "INTEGER", true,
            2, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysNeighborCacheEntry: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesNeighborCacheEntry: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoNeighborCacheEntry: TableInfo = TableInfo("NeighborCacheEntry",
            _columnsNeighborCacheEntry, _foreignKeysNeighborCacheEntry, _indicesNeighborCacheEntry)
        val _existingNeighborCacheEntry: TableInfo = read(connection, "NeighborCacheEntry")
        if (!_infoNeighborCacheEntry.equals(_existingNeighborCacheEntry)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |NeighborCacheEntry(com.ustadmobile.libcache.db.entities.NeighborCacheEntry).
              | Expected:
              |""".trimMargin() + _infoNeighborCacheEntry + """
              |
              | Found:
              |""".trimMargin() + _existingNeighborCacheEntry)
        }
        val _columnsNewCacheEntry: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsNewCacheEntry.put("cacheEntryKey", TableInfo.Column("cacheEntryKey", "TEXT", true,
            1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsNewCacheEntry.put("nceUrl", TableInfo.Column("nceUrl", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysNewCacheEntry: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesNewCacheEntry: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoNewCacheEntry: TableInfo = TableInfo("NewCacheEntry", _columnsNewCacheEntry,
            _foreignKeysNewCacheEntry, _indicesNewCacheEntry)
        val _existingNewCacheEntry: TableInfo = read(connection, "NewCacheEntry")
        if (!_infoNewCacheEntry.equals(_existingNewCacheEntry)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |NewCacheEntry(com.ustadmobile.libcache.db.entities.NewCacheEntry).
              | Expected:
              |""".trimMargin() + _infoNewCacheEntry + """
              |
              | Found:
              |""".trimMargin() + _existingNewCacheEntry)
        }
        return RoomOpenDelegate.ValidationResult(true, null)
      }
    }
    return _openDelegate
  }

  protected override fun createInvalidationTracker(): InvalidationTracker {
    val _shadowTablesMap: MutableMap<String, String> = mutableMapOf()
    val _viewTables: MutableMap<String, Set<String>> = mutableMapOf()
    return InvalidationTracker(this, _shadowTablesMap, _viewTables, "CacheEntry", "RequestedEntry",
        "RetentionLock", "NeighborCache", "NeighborCacheEntry", "NewCacheEntry")
  }

  protected override fun getRequiredTypeConverterClasses(): Map<KClass<*>, List<KClass<*>>> {
    val _typeConvertersMap: MutableMap<KClass<*>, List<KClass<*>>> = mutableMapOf()
    _typeConvertersMap.put(CacheEntryDao::class, CacheEntryDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RequestedEntryDao::class, RequestedEntryDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RetentionLockDao::class, RetentionLockDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(NeighborCacheDao::class, NeighborCacheDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(NeighborCacheEntryDao::class,
        NeighborCacheEntryDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(NewCacheEntryDao::class, NewCacheEntryDao_Impl.getRequiredConverters())
    return _typeConvertersMap
  }

  public override fun getRequiredAutoMigrationSpecClasses(): Set<KClass<out AutoMigrationSpec>> {
    val _autoMigrationSpecsSet: MutableSet<KClass<out AutoMigrationSpec>> = mutableSetOf()
    return _autoMigrationSpecsSet
  }

  public override
      fun createAutoMigrations(autoMigrationSpecs: Map<KClass<out AutoMigrationSpec>, AutoMigrationSpec>):
      List<Migration> {
    val _autoMigrations: MutableList<Migration> = mutableListOf()
    return _autoMigrations
  }
}
